﻿using Mall.Common.AOP;
using Mall.Common.Enum.MarketingCenter;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 会员购买表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Member_Buy
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 单号
        /// </summary>        
        public string OrderNo
        {
            get;
            set;
        }
        /// <summary>
        /// 用户id
        /// </summary>        
        public int? UserId
        {
            get;
            set;
        }
        /// <summary>
        /// 会员等级
        /// </summary>        
        public int? GradeId
        {
            get;
            set;
        }
        /// <summary>
        /// 等级名称
        /// </summary>        
        public string GradeName
        {
            get;
            set;
        }
        /// <summary>
        /// 支付金额
        /// </summary>        
        public decimal? Money
        {
            get;
            set;
        }

        /// <summary>
        /// 支付状态 0-未支付，1-已支付
        /// </summary>
        public int PayState { get; set; }
        /// <summary>
        /// 支付时间
        /// </summary>        
        public DateTime? PayTime
        {
            get;
            set;
        }
        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
    }
}
