﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Net.Http.Headers;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.WebApi.Controllers.User;
using Microsoft.AspNetCore.Mvc;

namespace Mall.WebApi.Controllers.Export
{
    /// <summary>
    /// 文件下载
    /// </summary>
    public class ExportController : BaseController
    {
        /// <summary>
        /// 文件流下载
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public FileContentResult DownLoad()
        {
            string fileName = "Test.xls";
            try
            {
                var downLoadRequest = RequestParm;//获取参数
                if (downLoadRequest.cmd != null && !string.IsNullOrEmpty(downLoadRequest.cmd))
                {
                    //商品购买力TOP排行
                    if (downLoadRequest.cmd == "getSalesGoodTop")
                    {
                        return File(new TenantController().DownLoadSalesGoods(downLoadRequest), "application/octet-stream", fileName);
                    }
                    //用户购买力TOP排行
                    if (downLoadRequest.cmd == "getSalesUserTop")
                    {
                        return File(new TenantController().DownLoadSalesUser(downLoadRequest), "application/octet-stream", fileName);
                    }
                }
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Write(ex, string.Format("DownLoad_requestData: {0}", Common.Plugin.JsonHelper.Serialize(this.RequestParm)));
            }
            return File(new byte[0], "application/octet-stream", fileName);
        }
    }
}