﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.CacheManager.User;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Extend.Point;
using Mall.Module.Education;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.Education
{

    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class AppletPointController : BaseController
    {

        private readonly PointModule pointModule = new PointModule();


        #region 点数记录

        /// <summary>
        /// 小程序获取点数记录
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetAppletUserPointDetailPageList()
        {
            var parms = RequestParm;
            var userInfo = AppletUserInfo;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_Member_PointBalance_Extend demodel = JsonConvert.DeserializeObject<RB_Member_PointBalance_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = userInfo.TenantId;
            demodel.MallBaseId = userInfo.MallBaseId;
            demodel.UserId = userInfo.UserId;
            var list = pointModule.GetUserPointDetailPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            int PointNum = pointModule.GetUserPointBalance(userInfo.UserId);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = new
            {
                PointNum,
                List = list.Select(x => new
                {
                    x.Id,
                    x.Type,
                    TypeName = x.Type.GetEnumName(),
                    x.Description,
                    x.PonitNum,
                    x.Remarks,
                    CreateDate = x.CreateDate.HasValue ? x.CreateDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : ""
                })
            };
            return ApiResult.Success("", pagelist);
        }
        #endregion


        #region 课程订单下单
        /// <summary>
        /// 保存课程分类信息
        /// </summary>
        /// <returns></returns>
        public ApiResult SetTeacherCourseOrder()
        {
            var parms = RequestParm;
            var userInfo = AppletUserInfo;
            var query = JsonConvert.DeserializeObject<RB_Point_TeacherCourseOrder_Extend>(RequestParm.msg.ToString());
            query.TenantId = userInfo.TenantId;
            query.MallBaseId = userInfo.MallBaseId;
            if (query == null)
            {
                return ApiResult.Failed("请传入课程订单信息");
            }
            else
            {
                if (query.CourseId == 0)
                {
                    return ApiResult.Failed("请选择您要购买的课程");
                }
                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;

                }
                //查询课程信息
                var courseModel = pointModule.GetTeacherCourseList(new RB_Point_TeacherCourse_Extend { TeacherId = query.TeacherId, ID = query.CourseId, TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId }).FirstOrDefault();
                var courseClassModel = pointModule.GetPointCourseClassList(new RB_Point_CourseClass_Extend { ID = query.CourseClassId, TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId }).FirstOrDefault();
                courseModel.StudyStartTime = Convert.ToDateTime(courseModel.StudyDate.ToString("yyyy-MM-dd") + " " + courseModel.StudyStartDate);


                if (courseModel.StudentNumType == Common.Enum.Point.StudentNumTypeEnum.OneToMany)//一对多的时候判断开始时间是否和课程一样
                {
                    if (courseModel.StudyDate != courseModel.StudyStartTime)
                    {
                        return ApiResult.Failed("预约时间与课程时间不一致");
                    }
                }
                else
                { //判断同一时间是否重复预约
                    var orderList = pointModule.GetPointOrderList(new RB_Point_TeacherCourseOrder_Extend { TeacherId = query.TeacherId, CourseId = query.CourseId, TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId });

                    DateTime nowOrderDate = query.StudyDate;

                    if (query.DurationUnit == Common.Enum.Point.DurationUnitEnum.Hour)
                    {

                    }
                    else
                    {
                        nowOrderDate = query.StudyDate.AddMinutes(Convert.ToDouble(query.TotalStudyDuration));
                    }

                    foreach (var item in orderList)
                    {
                        DateTime endTime = item.StudyDate;
                      
                        if (item.DurationUnit == Common.Enum.Point.DurationUnitEnum.Hour)
                        {

                        }
                        else
                        {
                            endTime = item.StudyDate.AddMinutes(Convert.ToDouble(item.TotalStudyDuration));
                        }
                        if (pointModule.GetTimeSpan(query.StudyDate, item.StudyDate.ToString("HH:mm"), endTime.ToString("HH:mm")))
                        {
                            return ApiResult.Failed("当前预约时间已预约");
                        }
                        if (pointModule.GetTimeSpan(nowOrderDate, item.StudyDate.ToString("HH:mm"), endTime.ToString("HH:mm")))
                        {
                            return ApiResult.Failed("当前预约时间已预约");
                        }
                    }
                }
                query.State = 0;
                query.UpdateDate = System.DateTime.Now;
                bool result = pointModule.SetTeacherCourseOrder(query);
                if (result)
                {
                    return ApiResult.Success("课程分类信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("课程分类信息保存失败");
                }
            }
        }

        #endregion
    }
}
