﻿using VT.FW.DB;
using Mall.Common.Enum.MarketingCenter;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 商户用户点数余额表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Member_PointBalance
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 用户id
        /// </summary>
        public int? UserId { get; set; }
        /// <summary>
        /// 类型  1增加  2减少
        /// </summary>        
        public RecordTypeEnum? Type
        {
            get;
            set;
        }
        /// <summary>
        /// 总点数
        /// </summary>        
        public int PonitNum
        {
            get;
            set;
        }

        /// <summary>
        /// 描述
        /// </summary>        
        public string Description
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号id
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remarks { get; set; }


        /// <summary>
        /// 平台类型
        /// </summary>
        public UserSourceEnum? PlatformType { get; set; }

        /// <summary>
        /// 订单id
        /// </summary>
        public int OrderId { get; set; }
    }
}
