﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Common.Enum;
using Mall.Common.Enum.TradePavilion;
using VT.FW.DB;

namespace Mall.Model.Entity.TradePavilion
{
    /// <summary>
    /// 品牌实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_CompanyBrand
    {
        public int ID { get; set; }

        /// <summary>
        /// 公司id
        /// </summary>
        public int CompanyId { get; set; }

        /// <summary>
        /// 品牌全名
        /// </summary>
        public string FullBrandName { get; set; }

        /// <summary>
        /// 品牌名称
        /// </summary>
        public string BrandName { get; set; }

        /// <summary>
        /// 店铺数量
        /// </summary>
        public int ShopNum { get; set; }

        /// <summary>
        /// 建筑面积
        /// </summary>
        public decimal BuiltUpArea { get; set; }

        /// <summary>
        /// 建筑面积
        /// </summary>
        public decimal EndBuiltUpArea { get; set; }



        /// <summary>
        /// 客户群体
        /// </summary>
        public string CustomerType { get; set; }


        /// <summary>
        /// 客户群体其他输入项
        /// </summary>
        public string CustomerOtherType { get; set; }

        /// <summary>
        /// 扩店区域
        /// </summary>
        public string StoreExpansion { get; set; }

        /// <summary>
        /// 性质
        /// </summary>
        public ProjectTypeEnum? ProjectType { get; set; }

        /// <summary>
        /// 面积要求
        /// </summary>
        public decimal AreaRequirement { get; set; }

        /// <summary>
        /// 面积要求
        /// </summary>
        public decimal EndAreaRequirement { get; set; }

        /// <summary>
        /// 商户号id
        /// </summary>
        public int TenantId { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 删除状态
        /// </summary>
        public DateStateEnum Status { get; set; }
    }
}
