﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common;
using Mall.Model.Extend.TradePavilion;
using Mall.Repository.TradePavilion;
using Mall.Repository.User;
using Newtonsoft.Json;
using VT.FW.DB;

namespace Mall.Module.TradePavilion
{
    public class AuthenticationModule
    {
        /// <summary>
        /// 载体信息仓储层对象
        /// </summary>
        private readonly RB_AuthenticationRepository authenticationRepository = new RB_AuthenticationRepository();
        /// <summary>
        /// 用户
        /// </summary>
        private readonly RB_Member_UserRepository member_UserRepository = new RB_Member_UserRepository();


        /// <summary>
        /// 新增修改认证
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetActivityDiscussInfo(RB_Authentication_Extend demodel)
        {
            if (demodel.Id > 0)
            {
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Authentication_Extend.Name),demodel.Name},
                    { nameof(RB_Authentication_Extend.CoverImage),demodel.CoverImage},
                    { nameof(RB_Authentication_Extend.Images),demodel.Images},
                    { nameof(RB_Authentication_Extend.VideoUrl),demodel.VideoUrl},
                    { nameof(RB_Authentication_Extend.Type),demodel.Type},
                    { nameof(RB_Authentication_Extend.BrandType),demodel.BrandType},
                    { nameof(RB_Authentication_Extend.OpenTime),demodel.OpenTime},
                    { nameof(RB_Authentication_Extend.Address),demodel.Address},
                    { nameof(RB_Authentication_Extend.TradingArea),demodel.TradingArea},
                    { nameof(RB_Authentication_Extend.BusinessType),demodel.BusinessType},
                    { nameof(RB_Authentication_Extend.BusinessDetail),demodel.BusinessDetail},
                    { nameof(RB_Authentication_Extend.Description),demodel.Description},
                    { nameof(RB_Authentication_Extend.County),demodel.County},
                    { nameof(RB_Authentication_Extend.Category),demodel.Category},
                    { nameof(RB_Authentication_Extend.Contact),demodel.Contact},
                    { nameof(RB_Authentication_Extend.ContactMobile),demodel.ContactMobile},
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_Authentication_Extend.Id),
                          FiledValue=demodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                return authenticationRepository.Update(keyValues, wheres);
            }
            else {
                return authenticationRepository.Insert(demodel) > 0;
            }
        }

        /// <summary>
        /// 获取认证分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Authentication_Extend> GetAuthenticationPageList(int pageIndex, int pageSize, out long count, RB_Authentication_Extend demodel)
        {
            var list = authenticationRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any()) {
                foreach (var item in list) {
                    item.ImageList = new List<string>();
                    if (!string.IsNullOrEmpty(item.Images) && item.Images != "[]") {
                        item.ImageList = JsonConvert.DeserializeObject<List<string>>(item.Images);
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 获取认证分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Authentication_Extend> GetAuthenticationPageList_V2(int pageIndex, int pageSize, out long count, RB_Authentication_Extend demodel)
        {
            var list = authenticationRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any())
            {
                string UserIds = string.Join(",", list.Select(x => x.CreateBy).Distinct());
                List<Model.Extend.User.RB_Member_User_Extend> ulist = new List<Model.Extend.User.RB_Member_User_Extend>();
                if (!string.IsNullOrEmpty(UserIds)) {
                    ulist = member_UserRepository.GetList(new Model.Extend.User.RB_Member_User_Extend() { UserIds = UserIds });
                }
                foreach (var item in list)
                {
                    item.ImageList = new List<string>();
                    if (!string.IsNullOrEmpty(item.Images) && item.Images != "[]")
                    {
                        item.ImageList = JsonConvert.DeserializeObject<List<string>>(item.Images);
                    }
                    var umodel = ulist.Where(x => x.Id == item.CreateBy).FirstOrDefault();
                    item.CreateName = umodel?.Name ?? "";
                    item.CreatePhoto = umodel?.Photo ?? "";
                }
            }
            return list;
        }

        /// <summary>
        /// 获取认证详情 
        /// </summary>
        /// <param name="authenticationId"></param>
        /// <returns></returns>
        public RB_Authentication_Extend GetAuthenticationInfo(int authenticationId)
        {
            var model = authenticationRepository.GetEntity<RB_Authentication_Extend>(authenticationId);
            if (model == null) { return null; }
            model.ImageList = new List<string>();
            if (!string.IsNullOrEmpty(model.Images) && model.Images != "[]")
            {
                model.ImageList = JsonConvert.DeserializeObject<List<string>>(model.Images);
            }
            return model;
        }

        /// <summary>
        /// 删除认证
        /// </summary>
        /// <param name="authenticationId"></param>
        /// <param name="userInfo"></param>
        /// <returns></returns>
        public bool DelAuthenticationInfo(int authenticationId, AppletUserInfo userInfo)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Authentication_Extend.Status),1}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                     FiledName=nameof(RB_Authentication_Extend.Id),
                      FiledValue=authenticationId,
                       OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                     FiledName=nameof(RB_Authentication_Extend.CreateBy),
                      FiledValue=userInfo.UserId,
                       OperatorEnum=OperatorEnum.Equal
                },
            };
            return authenticationRepository.Update(keyValues, wheres);
        }

        /// <summary>
        /// 审核
        /// </summary>
        /// <param name="authenticationId"></param>
        /// <param name="auditState"></param>
        /// <param name="auditRemark"></param>
        /// <returns></returns>
        public bool SetAuthenticationAudit(int authenticationId, int auditState, string auditRemark)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Authentication_Extend.AuditState),auditState},
                { nameof(RB_Authentication_Extend.AuditRemark),auditRemark},
                { nameof(RB_Authentication_Extend.AuditDate),DateTime.Now},
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                     FiledName=nameof(RB_Authentication_Extend.Id),
                      FiledValue=authenticationId,
                       OperatorEnum=OperatorEnum.Equal
                }
            };
            return authenticationRepository.Update(keyValues, wheres);
        }
    }
}
