﻿using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Miai;
using Mall.Model.Extend.Miai;
using System.Linq;

namespace Mall.Repository.Miai
{
    /// <summary>
    /// 相亲约会记录仓储层
    /// </summary>
    public class RB_Miai_DatingRepository : BaseRepository<RB_Miai_Dating>
    {

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Miai_Dating_Extend> GetPageList(int pageIndex, int pageSize, out long rowCount, RB_Miai_Dating_Extend dmodel)
        {
            string where = $" 1=1 and d.{nameof(RB_Miai_Dating_Extend.Status)}=0";
            if (dmodel.TenantId > 0) {
                where += $@" and d.{nameof(RB_Miai_Dating_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and d.{nameof(RB_Miai_Dating_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.UserId > 0)
            {
                where += $@" and (d.{nameof(RB_Miai_Dating_Extend.ManId)} ={dmodel.UserId} or d.{nameof(RB_Miai_Dating_Extend.WoManId)} ={dmodel.UserId})";
            }
            if (!string.IsNullOrEmpty(dmodel.UserName))
            {
                where += $@" and (u1.`Name` like '%{dmodel.UserName}%' or u2..`Name` like '%{dmodel.UserName}%')";
            }

            string sql = $@"select d.*,u1.`Name` as ManName,u1.Photo as ManPhoto,u2.`Name` as WoManName,u2.Photo as WoManPhoto from RB_Miai_Dating d
left join rb_member_user u1 on d.ManId = u1.Id
left join rb_member_user u2 on d.WoManId = u2.Id
where {where} order by d.Id desc";
            return GetPage<RB_Miai_Dating_Extend>(pageIndex, pageSize, out rowCount, sql).ToList();
        }
    }
}
