﻿using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Education
{
    public  class RB_Education_MemberCouponRepository : BaseRepository<RB_Education_MemberCoupon>
    {
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Education_MemberCoupon); } }



        /// <summary>
        /// 会员优惠券
        /// </summary>
        /// <returns></returns>
        public List<RB_Education_MemberCoupon_Extend> GetList(RB_Education_MemberCoupon_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_MemberCoupon_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_MemberCoupon_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.PlatformType > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_MemberCoupon_Extend.PlatformType)}={query.PlatformType}");
                }
                if (query.UserId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_MemberCoupon_Extend.UserId)}={query.UserId}");
                }
                if (query.CouponId > 0)
                {
                    builder.Append($" AND a.{nameof(RB_Education_MemberCoupon_Extend.CouponId)}={query.CouponId}");
                }
                if (!string.IsNullOrEmpty(query.CouponIds))
                {
                    builder.Append($" AND a.{nameof(RB_Education_MemberCoupon_Extend.CouponId)} in ({query.CouponIds})");
                }
                if (!string.IsNullOrEmpty(query.Ids))
                {
                    builder.Append($" AND a.{nameof(RB_Education_MemberCoupon_Extend.Id)} in ({query.Ids})");
                }
            }
            string sql = @$" select * FROM {TableName} AS a  where 1=1 {builder.ToString()} ";
            return Get<RB_Education_MemberCoupon_Extend>(sql).ToList();
        }
    }
}
