﻿using Mall.Model.Entity.Property;
using Mall.Model.Extend.Property;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Property
{
    /// <summary>
    /// 采购单仓储类
    /// </summary>
    public partial class RB_ProcurementRepository : BaseRepository<RB_Procurement>
    {
        /// <summary>
        /// 获取采购单分页数据
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="dmodel"></param>
        /// <param name="count"></param>
        /// <returns></returns>
        public List<RB_Procurement_Extend> GetPageList(int pageIndex, int pageSize, RB_Procurement_Extend dmodel, out long count)
        {
            string where = " where 1=1 ";
            where += string.Format(" AND p.{0}={1}", nameof(RB_Procurement_Extend.Status), 0);
            where += $@" and p.RB_Group_Id={dmodel.RB_Group_Id}";            
            if (!string.IsNullOrWhiteSpace(dmodel.GoodsName))
            {
                where += " and m." + nameof(RB_Supplies_Material_Extend.Name) + " like '%" + dmodel.GoodsName + "%'";
            }
            if (dmodel.GoodsId > 0) 
            {
                where += " and m." + nameof(RB_Supplies_Material_Extend.GoodsId) + "=" + dmodel.GoodsId;
            }
            if (dmodel.TenantId > 0)
            {
                where += " and p." + nameof(RB_Procurement_Extend.TenantId) + "=" + dmodel.TenantId;
            }
            if (dmodel.MallBaseId > 0)
            {
                where += " and p." + nameof(RB_Procurement_Extend.MallBaseId) + "=" + dmodel.MallBaseId;
            }
            if (!string.IsNullOrEmpty(dmodel.StartTime)) 
            {
                where += " and p.CreateTime >='" + dmodel.StartTime + "'";
            }
            if (!string.IsNullOrEmpty(dmodel.EndTime))
            {
                where += " and p.CreateTime <='" + dmodel.EndTime + " 23:59:59'";
            }
            if (dmodel.StockInStatus > 0)
            {
                where += " and p." + nameof(RB_Procurement_Extend.StockInStatus) + "=" + dmodel.StockInStatus;
            }

            string sql = $@" SELECT p.* FROM rb_procurement p
INNER JOIN rb_procurement_detail pd on p.Id = pd.ProcurementId
INNER JOIN rb_supplies_material m on pd.MaterialId = m.Id
{where}
GROUP BY p.Id order by p.Id desc";
            return GetPage<RB_Procurement_Extend>(pageIndex, pageSize, out count, sql).ToList();
        }

    }
}
