﻿using Mall.Education.Models;
using RabbitMQ.Client;
using RabbitMQ.Client.Events;
using System;
using System.Text;
using Newtonsoft.Json;

namespace Mall.Education.RabbitMQ
{
    /// <summary>
    /// RabbitMq消息队列
    /// </summary>
    public static class RabbiMQManager
    {
        /// <summary>
        /// 获取连接
        /// </summary>
        /// <param name="rabbitConfig">连接配置实体</param>
        /// <returns></returns>
        private static ConnectionFactory GetConnectionFactory(RabbitConfig rabbitConfig)
        {
            ConnectionFactory factory = new ConnectionFactory
            {
                HostName = rabbitConfig.HostName,
                //默认端口
                Port = rabbitConfig.Port,
                UserName = rabbitConfig.UserName,
                Password = rabbitConfig.Password
            };
            return factory;
        }

        ///// <summary>
        ///// 消费消息
        ///// </summary>
        ///// <param name="rabbitConfig"></param>
        //public static void DealWithMessage(RabbitConfig rabbitConfig)
        //{
        //    using (IConnection conn = GetConnectionFactory(rabbitConfig).CreateConnection())
        //    {
        //        using (IModel channel = conn.CreateModel())
        //        {
        //            //在MQ上定义一个持久化队列，如果名称相同不会重复创建
        //            //channel.QueueDeclare(rabbitConfig.QueenName, true, false, false, null);
        //            //输入1，那如果接收一个消息，但是没有应答，则客户端不会收到下一个消息
        //            //channel.BasicQos(0, 1, false);

        //            channel.QueueDeclare(rabbitConfig.QueenName, false, false, false, null);
        //            var consumer = new EventingBasicConsumer(channel);//消费者
        //            channel.BasicConsume(rabbitConfig.QueenName, true, consumer);//消费消息
        //            Console.WriteLine("开始");
        //            consumer.Received += (model, ea) =>
        //            {
        //                //var body = ea.Body;
        //                Console.WriteLine("123");
        //            };
        //            Console.WriteLine("结束");


        //            //在队列上定义一个消费者
        //            //EventingBasicConsumer consumer = new EventingBasicConsumer(channel);
        //            ////消费队列，并设置应答模式为程序主动应答
        //            //channel.BasicConsume(rabbitConfig.QueenName, true, consumer);

        //            //consumer.Received += (sender, e) =>
        //            //{
        //            //    Console.WriteLine("123");
        //            //    //byte[] bytes = e.Body.ToArray();
        //            //    //string message = Encoding.UTF8.GetString(bytes);
        //            //    //try
        //            //    //{
        //            //    //    Console.WriteLine(message);
        //            //    //    //序列化  操作数据
        //            //    //    //var msgModel = JsonConvert.DeserializeObject<FeaturesMQ>(message);
        //            //    //}
        //            //    //catch (Exception)
        //            //    //{

        //            //    //    throw;
        //            //    //}

        //            //    //channel.BasicAck(e.DeliveryTag, false);
        //            //};
        //        }
        //    }
        //}

        [Obsolete]
        public static void DealWithMessage(RabbitConfig rabbitConfig)
        {
            using (IConnection conn = GetConnectionFactory(rabbitConfig).CreateConnection())
            {
                using (IModel channel = conn.CreateModel())
                {
                    //在MQ上定义一个持久化队列，如果名称相同不会重复创建
                    channel.QueueDeclare(rabbitConfig.QueenName, true, false, false, null);
                    //输入1，那如果接收一个消息，但是没有应答，则客户端不会收到下一个消息
                    channel.BasicQos(0, 1, false);
                    //在队列上定义一个消费者
                    QueueingBasicConsumer consumer = new QueueingBasicConsumer(channel);
                    //消费队列，并设置应答模式为程序主动应答
                    channel.BasicConsume(rabbitConfig.QueenName, false, consumer);

                    while (true)
                    {
                        //阻塞函数，获取队列中的消息
                        BasicDeliverEventArgs ea = (BasicDeliverEventArgs)consumer.Queue.Dequeue();
                        byte[] bytes = ea.Body;
                        string msg = Encoding.UTF8.GetString(bytes);
                        try
                        {
                            var GoodsModel = JsonConvert.DeserializeObject<GoodsModel>(msg);
                            //处理
                            Console.WriteLine(msg);
                        }
                        catch (Exception ex)
                        {
                            Console.WriteLine(ex.Message);
                        }
                        //回复确认
                        channel.BasicAck(ea.DeliveryTag, false);
                    }
                }
            }
        }
    }
}
