﻿using Mall.Common;
using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Text;

namespace Mall.Common.Plugin
{
    /// <summary>
    /// 文件操作帮助类
    /// </summary>
    public class FileHelper
    {

        /// <summary>
        /// 生成图片
        /// </summary>
        /// <param name="url"></param>
        public static void CreateImage(string url)
        {
            string tempPath = GetFileUrl(url);
            string path = Environment.CurrentDirectory + tempPath;//下载到的地址+文件名                                   
            HttpWebRequest request = WebRequest.Create(url) as HttpWebRequest;
            //发送请求并获取相应回应数据
            HttpWebResponse response = request.GetResponse() as HttpWebResponse;
            //直到request.GetResponse()程序才开始向目标网页发送Post请求
            Stream responseStream = response.GetResponseStream();
            string newFilePath = path.Substring(0, path.LastIndexOf("/"));
            if (!System.IO.Directory.Exists(newFilePath))//如果不存在就创建file文件夹
            {
                System.IO.Directory.CreateDirectory(newFilePath);
            }
            //创建本地文件写入流
            Stream stream = new FileStream(path, FileMode.Create);
            byte[] bArr = new byte[1024];
            int size = responseStream.Read(bArr, 0, (int)bArr.Length);
            while (size > 0)
            {
                stream.Write(bArr, 0, size);
                size = responseStream.Read(bArr, 0, (int)bArr.Length);
            }
            stream.Close();
            responseStream.Close();
        }

        /// <summary>
        /// 获取Oss文件全路径
        /// </summary>
        /// <param name="path">文件相对路径</param>
        /// <returns></returns>
        public static string GetFileUrl(string path)
        {
            return path.Replace("http://auth-zjhejiang-com.oss-cn-hangzhou.aliyuncs.com", "")
                .Replace("https://cdnimg.iotweixin.com", "").Replace("http://img.weibaoge.cn","").Replace("http://v4test.zjhejiang.com","")
                .Replace("http://v4test1.oss-cn-hangzhou.aliyuncs.com","").Replace("https://viitto-1301420277.cos.ap-chengdu.myqcloud.com","");
        }

        /// <summary>
        /// 网站文件夹虚拟目录
        /// </summary>
        public static string VirtualDirectory = Config.VirtualDirectory;

        /// <summary>
        /// 行程特色删除指定文件夹文件
        /// </summary>
        /// <param name="filePath">文件夹路径</param>
        public static void DeleteFile(string filePath)
        {
            string newPath = AppContext.BaseDirectory + "\\" + filePath;
            DirectoryInfo theFolder = new DirectoryInfo(newPath);
            if (theFolder.Exists)
            {
                FileSystemInfo[] files = theFolder.GetFileSystemInfos();
                for (int i = 0; i < files.Length; i++)
                {
                    FileInfo file = files[i] as FileInfo;
                    //是文件
                    if (file != null)
                    {
                        file.Delete();
                    }
                }
            }
        }

        /// <summary>
        /// 删除文件扩展方法
        /// </summary>
        /// <param name="filePath"></param>
        public static void DeleteFileExt(string filePath)
        {
            string newPath = AppContext.BaseDirectory + "\\" + VirtualDirectory + filePath;
            File.Delete(newPath);
        }

        /// <summary>
        /// 根据TCID获取行程特色图片
        /// </summary>
        /// <param name="TCID"></param>
        /// <returns></returns>
        public static List<string> GetTripFileList(int TCID)
        {
            string filepath = VirtualDirectory + "/Feature/" + TCID + "/";

            List<string> fileList = new List<string>();
            DirectoryInfo theFolder = new DirectoryInfo(AppContext.BaseDirectory + "\\" + filepath);
            if (!theFolder.Exists)
            {
                theFolder.Create();
            }
            FileSystemInfo[] files = theFolder.GetFileSystemInfos();
            for (int i = 0; i < files.Length; i++)
            {
                FileInfo file = files[i] as FileInfo;
                //是文件
                if (file != null)
                {
                    fileList.Add(Config.ViewFileSiteUrl + "/Feature/" + TCID + "/" + file.Name);
                }
            }
            return fileList;
        }

        /// <summary>
        /// 批量删除文件
        /// </summary>
        /// <param name="fileList"></param>
        public static void DeleteFileList(List<string> fileList)
        {
            foreach (var item in fileList)
            {
                string newPath = AppContext.BaseDirectory + "\\" + VirtualDirectory + item;
                File.Delete(newPath);
            }
        }


        /// <summary>
        /// 文件移动
        /// </summary>
        /// <param name="filePath"></param>
        /// <param name="newFilePath"></param>
        public static void FileCopy(string filePath, string newFilePath)
        {
            string newTempFilePath = filePath.Substring(filePath.IndexOf("/")); ;
            var strPath = AppContext.BaseDirectory + "\\" + VirtualDirectory + newTempFilePath; //System.Web.HttpContext.Current.Server.MapPath("~/" + VirtualDirectory + newTempFilePath);
            string newfilePath = AppContext.BaseDirectory + "\\" + VirtualDirectory + newFilePath.Substring(0, strPath.LastIndexOf('\\') - 1); //System.Web.HttpContext.Current.Server.MapPath("~/" + VirtualDirectory) + newFilePath.Substring(0, strPath.LastIndexOf('\\') - 1);
            if (!Directory.Exists(newfilePath))
            {
                Directory.CreateDirectory(newfilePath);
            }
            string sourceFile = AppContext.BaseDirectory + "\\" + VirtualDirectory + newTempFilePath;// System.Web.HttpContext.Current.Server.MapPath("~/" + VirtualDirectory + newTempFilePath);
            string targetFile = AppContext.BaseDirectory + "\\" + VirtualDirectory + newFilePath;//System.Web.HttpContext.Current.Server.MapPath("~/" + VirtualDirectory + newFilePath);
            File.Move(sourceFile, targetFile);
        }

        /// <summary>
        /// 判断文件是否存在
        /// </summary>
        /// <param name="filePath"></param>
        /// <returns></returns>
        public static bool FileExists(string filePath)
        {
            return File.Exists(AppContext.BaseDirectory + "\\" + VirtualDirectory + filePath);
            //return File.Exists(System.Web.HttpContext.Current.Server.MapPath("~/" + VirtualDirectory + filePath));
        }

        /// <summary>
        /// 写byte[]到fileName
        /// </summary>
        /// <param name="fileName">保存至硬盘路径</param>
        /// <param name="pReadByte">byte[]</param>
        /// <returns></returns>
        public static bool WriteByteToFile(string fileName, byte[] pReadByte)
        {
            FileStream pFileStream = null;
            try
            {
                pFileStream = new FileStream(fileName, FileMode.OpenOrCreate);
                pFileStream.Write(pReadByte, 0, pReadByte.Length);
            }
            catch
            {
                return false;
            }
            finally
            {
                if (pFileStream != null)
                    pFileStream.Close();
            }
            return true;
        }
    }
}
