﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.WeChat.Common
{
    /// <summary>
    /// 微信事件接受的类
    /// </summary>
    public class WechatMessage
    {
        /// <summary>
        /// 本公众帐号
        /// </summary>
        public string ToUserName { get; set; }


        /// <summary>
        /// appid
        /// </summary>
        public string Appid { get; set; }

        /// <summary>
        /// Token 
        /// </summary>
        public string Token { get; set; }

        /// <summary>
        /// EncodingAESKey 
        /// </summary>
        public string EncodingAESKey { get; set; }
        /// <summary>
        /// 用户帐号
        /// </summary>
        public string FromUserName { get; set; }
        /// <summary>
        /// 发送时间戳
        /// </summary>
        public string CreateTime { get; set; }
        /// <summary>
        /// 发送的文本内容 
        /// </summary>
        public string Content { get; set; }
        /// <summary>
        /// 消息的类型
        /// </summary>
        public string MsgType { get; set; }
        /// <summary>
        /// 事件类型，subscribe(订阅)、unsubscribe(取消订阅)、scan（二维码扫描事件）、location（上报地理位置事件）、click（菜单点击事件）
        /// </summary>
        public string EventName { get; set; }

        /// <summary>
        /// 这两个属性会在后面的讲解中提到
        /// </summary>
        public string Ticket { get; set; }

        /// <summary>
        /// 事件KEY值，qrscene_为前缀，后面为二维码的参数值
        /// </summary>
        public string EventKey { get; set; }

     
    }
}
