﻿using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 商载通企业服务入驻申请仓储类
    /// </summary>
    public class RB_EnterpriseServicesApplyRepository : BaseRepository<RB_EnterpriseServicesApply>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_EnterpriseServicesApply); } }


        /// <summary>
        /// 企业服务申请信息列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_EnterpriseServicesApply_Extend> GetEnterpriseServicesApplyPageList(int pageIndex, int pageSize, out long rowCount, RB_EnterpriseServicesApply_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT a.*,b.ClassName from {TableName} as a LEFT JOIN rb_brandclass as b on a.CategoryId=b.ID   WHERE 1=1 ");

            builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_EnterpriseServicesApply_Extend.Status), (int)DateStateEnum.Normal);
            builder.AppendFormat(" AND b.{0}={1} ", nameof(RB_EnterpriseServicesApply_Extend.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND A.{nameof(RB_EnterpriseServicesApply_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND A.{nameof(RB_EnterpriseServicesApply_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ID > 0)
                {
                    builder.Append($" AND A.{nameof(RB_EnterpriseServicesApply_Extend.ID)}={query.ID}");
                }
                if (!string.IsNullOrEmpty(query.Name))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @Name ", nameof(RB_EnterpriseServicesApply_Extend.Name));
                    parameters.Add("Name", "%" + query.Name.Trim() + "%");
                }
                if (query.CategoryId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_EnterpriseServicesApply_Extend.CategoryId), query.CategoryId);
                }

                if (!string.IsNullOrEmpty(query.StartTime))
                {
                    builder.Append($" AND a.{nameof(RB_EnterpriseServicesApply_Extend.CreateDate)} >= '{query.StartTime}'");
                }
                if (!string.IsNullOrEmpty(query.EndTime))
                {
                    builder.Append($" AND a.{nameof(RB_EnterpriseServicesApply_Extend.CreateDate)} <= '{query.EndTime} 23:59:59'");
                }
            }
            return GetPage<RB_EnterpriseServicesApply_Extend>(pageIndex, pageSize, out rowCount, builder.ToString(), parameters).ToList();
        }


        /// <summary>
        /// 企业服务申请信息列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_EnterpriseServicesApply_Extend> GetEnterpriseServicesApplyRepository(RB_EnterpriseServicesApply_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT a.*,b.ClassName from {TableName} as a LEFT JOIN rb_brandclass as b on a.CategoryId=b.ID   WHERE 1=1 ");

            builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_EnterpriseServicesApply_Extend.Status), (int)DateStateEnum.Normal);
            builder.AppendFormat(" AND b.{0}={1} ", nameof(RB_EnterpriseServicesApply_Extend.Status), (int)DateStateEnum.Normal);
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND A.{nameof(RB_EnterpriseServicesApply_Extend.TenantId)}={query.TenantId}");
                }
                if (query.MallBaseId > 0)
                {
                    builder.Append($" AND A.{nameof(RB_EnterpriseServicesApply_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.ID > 0)
                {
                    builder.Append($" AND A.{nameof(RB_EnterpriseServicesApply_Extend.ID)}={query.ID}");
                }
                if (query.CompanyId > 0)
                {
                    builder.Append($" AND A.{nameof(RB_EnterpriseServicesApply_Extend.CompanyId)}={query.CompanyId}");
                }
                if (!string.IsNullOrEmpty(query.Name))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @Name ", nameof(RB_EnterpriseServicesApply_Extend.Name));
                    parameters.Add("Name", "%" + query.Name.Trim() + "%");
                }
                if (query.CategoryId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_EnterpriseServicesApply_Extend.CategoryId), query.CategoryId);
                }

                if (!string.IsNullOrEmpty(query.StartTime))
                {
                    builder.Append($" AND a.{nameof(RB_EnterpriseServicesApply_Extend.CreateDate)} >= '{query.StartTime}'");
                }
                if (!string.IsNullOrEmpty(query.EndTime))
                {
                    builder.Append($" AND a.{nameof(RB_EnterpriseServicesApply_Extend.CreateDate)} <= '{query.EndTime} 23:59:59'");
                }
            }
            return Get<RB_EnterpriseServicesApply_Extend>(builder.ToString(), parameters).ToList();
        }
    }
}
