﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using System.Web;
using System.Xml;
using Google.Protobuf.WellKnownTypes;
using Mall.Common;
using Mall.Common.API;
using Mall.Common.Pay.WeChatPat;
using Mall.Common.Plugin;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Mall.WeChat.Common;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json.Linq;
using Org.BouncyCastle.Crypto.Generators;

namespace Mall.WebApi.Controllers.AppletWeChat
{


    [Route("api/[controller]/[action]/{MallBaseId?}/{TenantId?}")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class WeChatNotifyController : Controller
    {
        private readonly object _lock = new object();
        private readonly UserCommonModule userCommonModule = new UserCommonModule();
        private readonly Module.MarketingCenter.RechargeModule rechargeModule = new Module.MarketingCenter.RechargeModule();
        private readonly Module.MarketingCenter.CouponModule couponModule = new Module.MarketingCenter.CouponModule();
        private readonly Module.Education.PointModule pointModule = new Module.Education.PointModule();
        private readonly Module.Education.ActivityModule activityModule = new Module.Education.ActivityModule();
        private readonly IHttpContextAccessor _accessor;

        /// <summary>
        /// 构造函数
        /// </summary>
        /// <param name="accessor"></param>
        public WeChatNotifyController(IHttpContextAccessor accessor)
        {
            _accessor = accessor;
        }
        /// <summary>
        /// 订单支付回调  作废
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public string Notify()
        {
            var req = new RequestHandler();
            App_Code.PayUtil PayUtil = new App_Code.PayUtil();
            var result = PayUtil.Notify(_accessor);
            if (result.IsSuccess)
            {
                var dic = ((Dictionary<string, string>)result.Data);
                //开始回写订单状态
                lock (_lock)
                {
                    string sOrderNo = dic["sOrderNo"];//订单号 时间挫+OrderId
                    int OrderId = Convert.ToInt32(sOrderNo[17..]);

                    decimal dPaid = Convert.ToDecimal(dic["dPrice"]) / 100;
                    string sPayerOpenID = dic["sPayerOpenID"];

                    int UserId = Convert.ToInt32(dic["bIsRecharge"]);
                    string TransactionId = dic["sTradeNo"];
                    string PayType = dic["OrderPayType"];
                    DateTime PayDate = DateTime.ParseExact(dic["PayDate"], "yyyyMMddHHmmss", System.Globalization.CultureInfo.CurrentCulture);//转换时间// Convert.ToDateTime(dic["PayDate"]);

                    #region 新增订单支付信息

                    userCommonModule.InsertOrderPayInfo(UserId, OrderId, sOrderNo, TransactionId, Common.Enum.Goods.OrderPayTypeEnum.WeChatPay, PayType, dPaid, PayDate, 0);


                    #endregion
                }
                //告诉微信我们已经处理成功，不需要再调用我们的接口了
                req.SetParameter("return_code", "SUCCESS");
                req.SetParameter("return_msg", "OK");
                var reqXml = req.ParseXml();
                return reqXml;
                //  return ApiResult.Success("", reqXml);
            }
            else
            {
                req.SetParameter("return_code", "FAIL");
                req.SetParameter("return_msg", "订单失败");
                var reqXmlFAIL = req.ParseXml();
                LogHelper.Write(null, "Notify返回信息：" + reqXmlFAIL);
                return reqXmlFAIL;
                // return ApiResult.Failed("", reqXmlFAIL);
            }
        }


        /// <summary>
        /// 订单支付回调
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public string AllNotify(int MallBaseId, int TenantId)
        {
            var req = new RequestHandler();
            App_Code.PayUtil PayUtil = new App_Code.PayUtil();
            var result = PayUtil.AllNotify(_accessor, MallBaseId, TenantId);
            if (result.IsSuccess)
            {
                var dic = ((Dictionary<string, string>)result.Data);
                //开始回写订单状态
                lock (_lock)
                {
                    string sOrderNo = dic["sOrderNo"];//订单号 时间挫+OrderId
                    int OrderId = Convert.ToInt32(sOrderNo[17..]);

                    decimal dPaid = Convert.ToDecimal(dic["dPrice"]) / 100;
                    string sPayerOpenID = dic["sPayerOpenID"];

                    int UserId = Convert.ToInt32(dic["bIsRecharge"]);
                    string TransactionId = dic["sTradeNo"];
                    string PayType = dic["OrderPayType"];
                    DateTime PayDate = DateTime.ParseExact(dic["PayDate"], "yyyyMMddHHmmss", System.Globalization.CultureInfo.CurrentCulture);//转换时间// Convert.ToDateTime(dic["PayDate"]);

                    #region 新增订单支付信息

                    userCommonModule.InsertOrderPayInfo(UserId, OrderId, sOrderNo, TransactionId, Common.Enum.Goods.OrderPayTypeEnum.WeChatPay, PayType, dPaid, PayDate, 0);


                    #endregion
                }
                //告诉微信我们已经处理成功，不需要再调用我们的接口了
                req.SetParameter("return_code", "SUCCESS");
                req.SetParameter("return_msg", "OK");
                var reqXml = req.ParseXml();
                return reqXml;
                //  return ApiResult.Success("", reqXml);
            }
            else
            {
                req.SetParameter("return_code", "FAIL");
                req.SetParameter("return_msg", "订单失败");
                var reqXmlFAIL = req.ParseXml();
                LogHelper.Write(null, "Notify返回信息：" + reqXmlFAIL);
                return reqXmlFAIL;
                // return ApiResult.Failed("", reqXmlFAIL);
            }
        }









        /// <summary>
        /// 会员点数购买回调
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public string PointNotify(int MallBaseId, int TenantId)
        {
            var req = new RequestHandler();
            App_Code.PayUtil PayUtil = new App_Code.PayUtil();
            var result = PayUtil.AllNotify(_accessor, MallBaseId, TenantId);
            if (result.IsSuccess)
            {
                var dic = ((Dictionary<string, string>)result.Data);
                //开始回写订单状态
                lock (_lock)
                {
                    string sOrderNo = dic["sOrderNo"];//订单号 时间挫+OrderId
                    int OrderId = Convert.ToInt32(sOrderNo[17..]);

                    decimal dPaid = Convert.ToDecimal(dic["dPrice"]) / 100;
                    string sPayerOpenID = dic["sPayerOpenID"];
                    int UserId = Convert.ToInt32(dic["bIsRecharge"]);
                    string TransactionId = dic["sTradeNo"];
                    string PayType = dic["OrderPayType"];
                    DateTime PayDate = DateTime.ParseExact(dic["PayDate"], "yyyyMMddHHmmss", System.Globalization.CultureInfo.CurrentCulture);//转换时间

                    #region 新增订单支付信息

                    // pointModule.UpdatePointOrder(UserId, OrderId, sOrderNo, TransactionId, Common.Enum.Goods.OrderPayTypeEnum.WeChatPay, PayType, dPaid, PayDate);
                    pointModule.UpdatePointOrder(new Model.Extend.Point.RB_Point_Order_Extend { ID = OrderId, OrderNo = sOrderNo, Income = dPaid, MerchantsNo = TransactionId, PaymentTime = PayDate });

                    #endregion
                }
                //告诉微信我们已经处理成功，不需要再调用我们的接口了
                req.SetParameter("return_code", "SUCCESS");
                req.SetParameter("return_msg", "OK");
                var reqXml = req.ParseXml();
                return reqXml;
                //  return ApiResult.Success("", reqXml);
            }
            else
            {
                req.SetParameter("return_code", "FAIL");
                req.SetParameter("return_msg", "订单失败");
                var reqXmlFAIL = req.ParseXml();
                LogHelper.Write(null, "Notify返回信息：" + reqXmlFAIL);
                return reqXmlFAIL;
                // return ApiResult.Failed("", reqXmlFAIL);
            }
        }



        /// <summary>
        /// 订单支付回调   作废
        /// </summary>
        /// <returns></returns> 
        [HttpGet]
        [HttpPost]
        public string NotifyZhouTian()
        {
            var req = new RequestHandler();
            App_Code.PayUtil PayUtil = new App_Code.PayUtil();
            var result = PayUtil.NotifyZhouTian(_accessor);
            LogHelper.WriteInfo("NotifyZhouTian返回信息进来了");
            if (result.IsSuccess)
            {
                LogHelper.WriteInfo("NotifyZhouTian回调成功：" + result.ToString());
                var dic = ((Dictionary<string, string>)result.Data);
                //开始回写订单状态
                lock (_lock)
                {
                    string sOrderNo = dic["sOrderNo"];//订单号 时间挫+OrderId
                    int OrderId = Convert.ToInt32(sOrderNo[17..]);

                    decimal dPaid = Convert.ToDecimal(dic["dPrice"]) / 100;
                    string sPayerOpenID = dic["sPayerOpenID"];
                    int UserId = Convert.ToInt32(dic["bIsRecharge"]);
                    string TransactionId = dic["sTradeNo"];
                    string PayType = dic["OrderPayType"];
                    DateTime PayDate = DateTime.ParseExact(dic["PayDate"], "yyyyMMddHHmmss", System.Globalization.CultureInfo.CurrentCulture);//转换时间// Convert.ToDateTime(dic["PayDate"]);

                    #region 新增订单支付信息
                    LogHelper.WriteInfo("NotifyZhouTian订单信息");
                    userCommonModule.InsertOrderPayInfo(UserId, OrderId, sOrderNo, TransactionId, Common.Enum.Goods.OrderPayTypeEnum.WeChatPay, PayType, dPaid, PayDate, 0);


                    #endregion
                }
                //告诉微信我们已经处理成功，不需要再调用我们的接口了
                req.SetParameter("return_code", "SUCCESS");
                req.SetParameter("return_msg", "OK");
                var reqXml = req.ParseXml();
                return reqXml;
                //  return ApiResult.Success("", reqXml);
            }
            else
            {
                req.SetParameter("return_code", "FAIL");
                req.SetParameter("return_msg", "订单失败");
                var reqXmlFAIL = req.ParseXml();
                LogHelper.Write(null, "Notify返回信息：" + reqXmlFAIL);
                return reqXmlFAIL;
                // return ApiResult.Failed("", reqXmlFAIL);
            }
        }



        /// <summary>
        /// 会员充值支付回调
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public string RechargeNotify(int MallBaseId, int TenantId)
        {
            var req = new RequestHandler();
            App_Code.PayUtil PayUtil = new App_Code.PayUtil();
            var result = PayUtil.AllNotify(_accessor, MallBaseId, TenantId);
            if (result.IsSuccess)
            {
                var dic = ((Dictionary<string, string>)result.Data);
                //开始回写订单状态
                lock (_lock)
                {
                    string sOrderNo = dic["sOrderNo"];//订单号 时间挫+OrderId
                    int OrderId = Convert.ToInt32(sOrderNo[17..]);

                    decimal dPaid = Convert.ToDecimal(dic["dPrice"]) / 100;
                    string sPayerOpenID = dic["sPayerOpenID"];
                    int UserId = Convert.ToInt32(dic["bIsRecharge"]);
                    string TransactionId = dic["sTradeNo"];
                    string PayType = dic["OrderPayType"];
                    DateTime PayDate = DateTime.ParseExact(dic["PayDate"], "yyyyMMddHHmmss", System.Globalization.CultureInfo.CurrentCulture);//转换时间

                    #region 新增订单支付信息

                    rechargeModule.UpdateBalanceRecharge(UserId, OrderId, sOrderNo, TransactionId, Common.Enum.Goods.OrderPayTypeEnum.WeChatPay, PayType, dPaid, PayDate);


                    #endregion
                }
                //告诉微信我们已经处理成功，不需要再调用我们的接口了
                req.SetParameter("return_code", "SUCCESS");
                req.SetParameter("return_msg", "OK");
                var reqXml = req.ParseXml();
                return reqXml;
                //  return ApiResult.Success("", reqXml);
            }
            else
            {
                req.SetParameter("return_code", "FAIL");
                req.SetParameter("return_msg", "订单失败");
                var reqXmlFAIL = req.ParseXml();
                LogHelper.Write(null, "Notify返回信息：" + reqXmlFAIL);
                return reqXmlFAIL;
                // return ApiResult.Failed("", reqXmlFAIL);
            }
        }



        /// <summary>
        /// 会员购买支付回调
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public string VipBuyNotify(int MallBaseId, int TenantId)
        {
            LogHelper.Write(null, "VipBuyNotify返回信息进来了");
            var req = new RequestHandler();
            App_Code.PayUtil PayUtil = new App_Code.PayUtil();
            var result = PayUtil.AllNotify(_accessor, MallBaseId, TenantId);
            if (result.IsSuccess)
            {
                var dic = ((Dictionary<string, string>)result.Data);
                //开始回写订单状态
                lock (_lock)
                {
                    string sOrderNo = dic["sOrderNo"];//订单号 时间挫+OrderId
                    int OrderId = Convert.ToInt32(sOrderNo[17..]);

                    decimal dPaid = Convert.ToDecimal(dic["dPrice"]) / 100;
                    string sPayerOpenID = dic["sPayerOpenID"];
                    int UserId = Convert.ToInt32(dic["bIsRecharge"]);
                    string TransactionId = dic["sTradeNo"];
                    string PayType = dic["OrderPayType"];
                    DateTime PayDate = DateTime.ParseExact(dic["PayDate"], "yyyyMMddHHmmss", System.Globalization.CultureInfo.CurrentCulture);//转换时间

                    #region 修改会员购买支付信息

                    userCommonModule.InsertVipBuyCommission(UserId, OrderId, sOrderNo, dPaid, PayDate);
                    #endregion
                }
                //告诉微信我们已经处理成功，不需要再调用我们的接口了
                req.SetParameter("return_code", "SUCCESS");
                req.SetParameter("return_msg", "OK");
                var reqXml = req.ParseXml();
                return reqXml;
                //  return ApiResult.Success("", reqXml);
            }
            else
            {
                req.SetParameter("return_code", "FAIL");
                req.SetParameter("return_msg", "订单失败");
                var reqXmlFAIL = req.ParseXml();
                LogHelper.Write(null, "Notify返回信息：" + reqXmlFAIL);
                return reqXmlFAIL;
                // return ApiResult.Failed("", reqXmlFAIL);
            }
        }



        /// <summary>
        /// 会员购买支付回调
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public string MemberBuyNotify(int MallBaseId, int TenantId)
        {
            var req = new RequestHandler();
            App_Code.PayUtil PayUtil = new App_Code.PayUtil();
            var result = PayUtil.AllNotify(_accessor, MallBaseId, TenantId);
            if (result.IsSuccess)
            {
                var dic = ((Dictionary<string, string>)result.Data);
                //开始回写订单状态
                lock (_lock)
                {
                    string sOrderNo = dic["sOrderNo"];//订单号 时间挫+OrderId
                    int OrderId = Convert.ToInt32(sOrderNo[17..]);

                    decimal dPaid = Convert.ToDecimal(dic["dPrice"]) / 100;
                    string sPayerOpenID = dic["sPayerOpenID"];
                    int UserId = Convert.ToInt32(dic["bIsRecharge"]);
                    string TransactionId = dic["sTradeNo"];
                    string PayType = dic["OrderPayType"];
                    DateTime PayDate = DateTime.ParseExact(dic["PayDate"], "yyyyMMddHHmmss", System.Globalization.CultureInfo.CurrentCulture);//转换时间

                    #region 修改会员购买支付信息
                    userCommonModule.UpdateMemberBuy(UserId, OrderId, sOrderNo, TransactionId, Common.Enum.Goods.OrderPayTypeEnum.WeChatPay, dPaid, PayDate);
                    #endregion
                }
                //告诉微信我们已经处理成功，不需要再调用我们的接口了
                req.SetParameter("return_code", "SUCCESS");
                req.SetParameter("return_msg", "OK");
                var reqXml = req.ParseXml();
                return reqXml;
                //  return ApiResult.Success("", reqXml);
            }
            else
            {
                req.SetParameter("return_code", "FAIL");
                req.SetParameter("return_msg", "订单失败");
                var reqXmlFAIL = req.ParseXml();
                LogHelper.Write(null, "Notify返回信息：" + reqXmlFAIL);
                return reqXmlFAIL;
                // return ApiResult.Failed("", reqXmlFAIL);
            }
        }




        /// <summary>
        /// 会员购买储值卡回调
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public string DepositBuyNotify(int MallBaseId, int TenantId)
        {
            var req = new RequestHandler();
            App_Code.PayUtil PayUtil = new App_Code.PayUtil();
            var result = PayUtil.AllNotify(_accessor, MallBaseId, TenantId);
            if (result.IsSuccess)
            {
                var dic = ((Dictionary<string, string>)result.Data);
                //开始回写订单状态
                lock (_lock)
                {
                    string sOrderNo = dic["sOrderNo"];//订单号 时间挫+OrderId
                    int OrderId = Convert.ToInt32(sOrderNo[17..]);

                    decimal dPaid = Convert.ToDecimal(dic["dPrice"]) / 100;
                    string sPayerOpenID = dic["sPayerOpenID"];
                    int UserId = Convert.ToInt32(dic["bIsRecharge"]);
                    string TransactionId = dic["sTradeNo"];
                    string PayType = dic["OrderPayType"];
                    DateTime PayDate = DateTime.ParseExact(dic["PayDate"], "yyyyMMddHHmmss", System.Globalization.CultureInfo.CurrentCulture);//转换时间

                    #region 新增订单支付信息

                    couponModule.UpdateDepositBuy(UserId, OrderId, sOrderNo, TransactionId, Common.Enum.Goods.OrderPayTypeEnum.WeChatPay, PayType, dPaid, PayDate);
                    #endregion
                }
                //告诉微信我们已经处理成功，不需要再调用我们的接口了
                req.SetParameter("return_code", "SUCCESS");
                req.SetParameter("return_msg", "OK");
                var reqXml = req.ParseXml();
                return reqXml;
                //  return ApiResult.Success("", reqXml);
            }
            else
            {
                req.SetParameter("return_code", "FAIL");
                req.SetParameter("return_msg", "订单失败");
                var reqXmlFAIL = req.ParseXml();
                LogHelper.Write(null, "DepositBuyNotify返回信息：" + reqXmlFAIL);
                return reqXmlFAIL;
                // return ApiResult.Failed("", reqXmlFAIL);
            }
        }




        /// <summary>
        /// 赞羊教育活动报名支付回调
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        public string ActivityNotify(int MallBaseId, int TenantId)
        {
            var req = new RequestHandler();
            App_Code.PayUtil PayUtil = new App_Code.PayUtil();
            var result = PayUtil.AllNotify(_accessor, MallBaseId, TenantId);
            if (result.IsSuccess)
            {
                var dic = ((Dictionary<string, string>)result.Data);
                //开始回写订单状态
                lock (_lock)
                {
                    string sOrderNo = dic["sOrderNo"];//订单号 时间挫+OrderId
                    int OrderId = Convert.ToInt32(sOrderNo[17..]);

                    decimal dPaid = Convert.ToDecimal(dic["dPrice"]) / 100;
                    string sPayerOpenID = dic["sPayerOpenID"];
                    int UserId = Convert.ToInt32(dic["bIsRecharge"]);
                    string TransactionId = dic["sTradeNo"];
                    string PayType = dic["OrderPayType"];
                    DateTime PayDate = DateTime.ParseExact(dic["PayDate"], "yyyyMMddHHmmss", System.Globalization.CultureInfo.CurrentCulture);//转换时间

                    #region 修改会员购买支付信息
                    activityModule.UpdateActivityEnroll(UserId, OrderId, sOrderNo, TransactionId, Common.Enum.Goods.OrderPayTypeEnum.WeChatPay, dPaid, PayDate);
                    #endregion
                }
                //告诉微信我们已经处理成功，不需要再调用我们的接口了
                req.SetParameter("return_code", "SUCCESS");
                req.SetParameter("return_msg", "OK");
                var reqXml = req.ParseXml();
                return reqXml;
                //  return ApiResult.Success("", reqXml);
            }
            else
            {
                req.SetParameter("return_code", "FAIL");
                req.SetParameter("return_msg", "订单失败");
                var reqXmlFAIL = req.ParseXml();
                LogHelper.Write(null, "Notify返回信息：" + reqXmlFAIL);
                return reqXmlFAIL;
                // return ApiResult.Failed("", reqXmlFAIL);
            }
        }



        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [HttpGet]
        public void EventMessageCall(int MallBaseId, int TenantId, string signature, string echostr, string timestamp, string nonce, string openid, string encrypt_type, string msg_signature)
        {
            try
            {
                int qrCodeType = 0;
                int userId = 0;
                string textpl = "";
                string content = "你好！";
                string sToken = "f87f2b2a8c474c06908b5c937068b506";
                string sAppID = "wxaeb077c07ed6f30d";
                string sEncodingAESKey = "9FgR0wMXxe6wXBB5hwgpn2mZM6sQMi3E3Vk5sxrXEAL";
                var request = _accessor.HttpContext.Request;
                // var inputStream = request.Body;
                var str = new StreamReader(request.Body);
                string postStr = str.ReadToEnd();
                LogHelper.Write("我是返回信息：" + postStr);
                lock (_lock)
                {
                    WechatMessage wx = WXBizMsgCrypt.GetWxMessage(postStr, timestamp, nonce, signature, encrypt_type, msg_signature, openid);
                    if (!string.IsNullOrWhiteSpace(wx.EventKey))// 用户未关注时，进行关注后的事件推送;事件KEY值，qrscene_为前缀，后面为二维码的参数值
                    {
                        textpl = ReceivedText(wx.FromUserName, wx.ToUserName, content);
                        if (encrypt_type.ToLower() == "aes".ToLower())//加密模式需要先解密
                        {
                            var ret = new WXBizMsgCrypt(sToken, sEncodingAESKey, sAppID);
                            int r = ret.EncryptMsg(textpl, timestamp, nonce, ref textpl);
                            if (r != 0)
                            {
                                LogHelper.WriteInfo("GetWxMessage_消息加密失败：");
                                textpl = "";
                            }
                        }
                    }

                }
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex.ToString());

            }
        }

        /// <summary>
        /// 接收消息
        /// </summary>
        /// <param name="FromUserName"></param>
        /// <param name="ToUserName"></param>
        /// <param name="Content"></param>
        /// <returns></returns>
        public static string ReceivedText(string FromUserName, string ToUserName, string Content)
        {
            string textpl = string.Empty;
            textpl = "<xml>" +
                     "<ToUserName><![CDATA[" + FromUserName + "]]></ToUserName>" +
                     "<FromUserName><![CDATA[" + ToUserName + "]]></FromUserName>" +
                     "<CreateTime>" + (int)(DateTime.Now - DateTime.Parse("1970-1-1")).TotalSeconds + "</CreateTime>" +
                     "<MsgType><![CDATA[text]]></MsgType>" +
                     "<Content><![CDATA[" + Content + "]]></Content>" +
                     "<MsgId>" + (int)(DateTime.Now - DateTime.Parse("1970-1-1")).TotalSeconds + "</MsgId>" +
                     "</xml>";
            return textpl;
        }
    }
}