﻿
using Mall.WeChat.Helper;
using Mall.Common.Pay.WeChatPat.Model;
using Mall.Common.Pay.WeChatPat;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Text;
using System.Web;
using System.Xml.Linq;
using Microsoft.AspNetCore.Http;
using Mall.Common.Plugin;
using Mall.Model.Entity.User;
using Mall.Common;
using Mall.Model.Extend.User;
using NPOI.SS.Formula.Functions;

namespace Mall.WebApi.App_Code
{
    /// <summary>
    /// 支付帮助类
    /// </summary>
    public class PayUtil
    {
        /// <summary>
        /// 商户小程序处理类
        /// </summary>
        private Module.User.MiniProgramModule programModule = new Module.User.MiniProgramModule();
        private IHttpContextAccessor _accessor;

        /// <summary>
        /// 构造函数
        /// </summary>
        public PayUtil(IHttpContextAccessor accessor)
        {
            _accessor = accessor;
        }


        public PayUtil() { }






        /// <summary>
        /// 支付
        /// </summary>
        /// <returns></returns>
        public BaseResult Notify()
        {
            try
            {
                var res = new ResponseHandler();

                var tradeType = res.GetParameter("trade_type");

                //根据订单号获取微信支付配置信息
                RB_MiniProgram model = new RB_MiniProgram();  //2020年5月26号新增逻辑还没有写完
                //if (tradeType.Equals("APP"))
                //    res.SetKey(EheMall.WeChat.Common.WeChatConfig.GetOpenKey());
                //if (tradeType.Equals("MWEB"))
                //    res.SetKey(EheMall.WeChat.Common.WeChatConfig.GetOpenKey());
                //if (tradeType.Equals("JSAPI	"))
                //    res.SetKey(EheMall.WeChat.Common.WeChatConfig.GetOpenKey());
                //else
                res.SetKey(model.WeChatApiSecret);
                //判断签名
                if (res.IsWXsign(out string error))
                {
                    #region 参数
                    var returnCode = res.GetParameter("return_code");
                    //返回信息，如非空，为错误原因签名失败参数格式校验错误
                    var returnMsg = res.GetParameter("return_msg");
                    var appid = res.GetParameter("appid");

                    //以下字段在 return_code 为 SUCCESS 的时候有返回--------------------------------
                    var mchId = res.GetParameter("mch_id");
                    var deviceInfo = res.GetParameter("device_info");
                    var nonceStr = res.GetParameter("nonce_str");
                    var resultCode = res.GetParameter("result_code");
                    var errCode = res.GetParameter("err_code");
                    var errCodeDes = res.GetParameter("err_code_des");

                    //以下字段在 return_code 和 result_code 都为 SUCCESS 的时候有返回---------------
                    var openid = res.GetParameter("openid");
                    //Y-关注，N-未关注，仅在公众账号类型支付有效
                    var isSubscribe = res.GetParameter("is_subscribe");

                    //银行类型，采用字符串类型的银行标识
                    var bankType = res.GetParameter("bank_type");
                    var totalFee = res.GetParameter("total_fee");
                    //货币类型，符合 ISO 4217 标准的三位字母代码，默认人民币：CNY
                    var feeType = res.GetParameter("fee_type");
                    //微信支付订单号
                    var transactionId = res.GetParameter("transaction_id");
                    //商户系统的订单号，与请求一致。
                    var outTradeNo = res.GetParameter("out_trade_no");
                    var attach = res.GetParameter("attach");
                    //格 式 为yyyyMMddhhmmss
                    var timeEnd = res.GetParameter("time_end");
                    #endregion
                    //支付成功
                    if (!outTradeNo.Equals("") && returnCode.Equals("SUCCESS") && resultCode.Equals("SUCCESS"))
                    {
                        //LogHelper.WriteLog("支付回调：", sbResult.ToString() + "notify > success \r\n",EnumService.LogType.Debug);
                        //在外面回写订单
                        //var returnUrl = "";
                        //if (tradeType.Equals("JSAPI"))
                        //    returnUrl = res.GetParameter("code_url");
                        //if (tradeType.Equals("MWEB"))
                        //    returnUrl = res.GetParameter("mweb_url");
                        return new BaseResult()
                        {
                            IsSuccess = true,
                            Data = new Dictionary<string, string>
                            {
                                {"sOrderNo", outTradeNo},
                                {"sTradeNo", transactionId},
                                {"dPrice", totalFee},
                                {"sPayerOpenID", openid},
                                {"bIsRecharge", attach},
                                {"OrderPayType", tradeType},
                                {"PayDate",timeEnd }
                            }
                        };
                    }
                    else
                    {
                        LogHelper.Write(null, "Notify支付回调：returnMsg-" + returnMsg);
                    }
                }
                else
                {
                    LogHelper.Write(null, "Notify签名验证失败：");
                }
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "Notify支付错误：");
            }
            return new BaseResult() { IsSuccess = false };
        }








       


        /// <summary>
        /// 获取随机字符串
        /// </summary>
        /// <returns></returns>
        public  string GetNoncestr()
        {
            var random = new Random();
            return SecurityHelper.MD5EncryptWeChat(random.Next(1000).ToString(CultureInfo.InvariantCulture), "GBK");
        }

        /// <summary>
        /// 获取时间戳
        /// </summary>
        /// <returns></returns>
        public  string GetTimestamp()
        {
            var ts = DateTime.UtcNow - new DateTime(1970, 1, 1, 0, 0, 0, 0);
            return Convert.ToInt64(ts.TotalSeconds).ToString(CultureInfo.InvariantCulture);
        }

        /// <summary>
        /// 对字符串进行URL编码
        /// </summary>
        /// <param name="instr"></param>
        /// <param name="charset">默认值：utf-8</param>
        /// <returns></returns>
        public  string UrlEncode(string instr, string charset)
        {
            if (instr == null || instr.Trim() == "")
                return "";
            var res = HttpUtility.UrlEncode(instr, !string.IsNullOrWhiteSpace(charset)
               ? Encoding.GetEncoding(charset)
               : Encoding.GetEncoding("utf-8"));
            return res;
        }
    }
}
