﻿using Mall.Model.Extend.TradePavilion;
using Mall.Repository.TradePavilion;
using System.Collections.Generic;
using System.Linq;
using VT.FW.DB;

namespace Mall.Module.TradePavilion
{
    /// <summary>
    /// 商会活动处理类
    /// </summary>
    public class CommerceActivityModule
    {
        /// <summary>
        /// 商会活动仓储层对象
        /// </summary>
        private readonly RB_Commerce_ActivityRepository commerce_ActivityRepository = new RB_Commerce_ActivityRepository();

        /// <summary>
        /// 商会活动类型表仓储层对象
        /// </summary>
        private readonly RB_Commerce_ActivityTypeRepository activityTypeRepository = new RB_Commerce_ActivityTypeRepository();

        /// <summary>
        /// 商会活动详情表仓储层对象
        /// </summary>
        private readonly RB_Commerce_DetailsRepository detailsRepository = new RB_Commerce_DetailsRepository();

        #region 商户活动管理

        /// <summary>
        /// 获取商会活动分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Commerce_Activity_Extend> GetCommerceActivityPageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Commerce_Activity_Extend query)
        {
            return commerce_ActivityRepository.GetCommerceActivityPageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 新增修改商户活动
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetCommerceActivityModule(RB_Commerce_Activity_Extend model)
        {
            bool flag;
            if (model.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Commerce_Activity_Extend.ActivityName),model.ActivityName },
                    {nameof(RB_Commerce_Activity_Extend.StartTime),model.StartTime },
                    {nameof(RB_Commerce_Activity_Extend.EndTime),model.EndTime },
                    {nameof(RB_Commerce_Activity_Extend.CoverImg),model.CoverImg },
                    {nameof(RB_Commerce_Activity_Extend.ActivityType),model.ActivityType },
                    {nameof(RB_Commerce_Activity_Extend.ActivityInfo),model.ActivityType },
                    {nameof(RB_Commerce_Activity_Extend.UpdateBy),model.UpdateBy },
                    {nameof(RB_Commerce_Activity_Extend.UpdateDate),model.UpdateDate },
                };
                flag = commerce_ActivityRepository.Update(fileds, new WhereHelper(nameof(RB_Commerce_Activity_Extend.Id), model.Id));
            }
            else
            {
                var newId = commerce_ActivityRepository.Insert(model);
                model.Id = newId;
                flag = newId > 0;
            }

            //原来的活动详情
            var oldDetailsList = GetCommerceDetailsListModule(new RB_Commerce_Details_Extend() { ActivityId = model.Id });

            //以前没有活动详情【直接新增】
            if (oldDetailsList == null || (oldDetailsList != null && oldDetailsList.Count == 0))
            {
                if (model.CommerceDetailsList != null && model.CommerceDetailsList.Count > 0)
                {
                    foreach (var item in model.CommerceDetailsList)
                    {
                        item.ActivityId = model.Id;
                        detailsRepository.Insert(item);
                    }
                }
            }
            else//以前有活动详情
            {
                //现在没有阶梯报价了【直接删除以前的阶梯报价】
                if (model.CommerceDetailsList == null || (model.CommerceDetailsList != null && model.CommerceDetailsList.Count == 0))
                {
                    detailsRepository.DeleteCommerceDetailsRepository(model.Id);
                }
                //找出差异的数据
                var deleteList = oldDetailsList.Where(qitem => !model.CommerceDetailsList.Any(oldItem => qitem.ActivityId == oldItem.ActivityId)).ToList();
                foreach (var dItem in deleteList)
                {
                    if (dItem.Id > 0)
                    {
                        detailsRepository.Delete(dItem.Id);
                    }
                }
                foreach (var priceItem in model.CommerceDetailsList)
                {
                    priceItem.ActivityId = model.Id;
                    if (priceItem.Id == 0)
                    {
                        detailsRepository.Insert(priceItem);
                    }
                    else
                    {
                        detailsRepository.Update(priceItem);
                    }
                }
            }
            return flag;
        }

        /// <summary>
        /// 获取修改商户活动详情
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public RB_Commerce_Activity_Extend GetCommerceActivityModule(object Id)
        {
            return commerce_ActivityRepository.GetEntity<RB_Commerce_Activity_Extend>(Id);
        }

        /// <summary>
        /// 更新商户活动状态
        /// </summary>
        /// <param name="Id"></param>
        /// <param name="Status"></param>
        /// <returns></returns>
        public bool RemoveCommerceActivityModule(int Id, int Status)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Commerce_Activity_Extend.Status),Status },
            };
            bool flag = commerce_ActivityRepository.Update(fileds, new WhereHelper(nameof(RB_Commerce_Activity_Extend.Id), Id));
            return flag;
        }

        #endregion

        #region 商户活动类型管理

        /// <summary>
        /// 获取商会活动类型分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Commerce_ActivityType_Extend> GetCommerceActivityTypePageListModule(int pageIndex, int pageSize, out long rowsCount, RB_Commerce_ActivityType_Extend query)
        {
            return activityTypeRepository.GetCommerceActivityTypePageListRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 新增修改商会活动类型
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetCommerceActivityTypeModule(RB_Commerce_ActivityType_Extend model)
        {
            bool flag;
            if (model.Id > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Commerce_ActivityType_Extend.TypeName),model.TypeName },
                    {nameof(RB_Commerce_ActivityType_Extend.UpdateBy),model.UpdateBy },
                    {nameof(RB_Commerce_ActivityType_Extend.UpdateDate),model.UpdateDate }
                };
                flag = activityTypeRepository.Update(fileds, new WhereHelper(nameof(RB_Commerce_ActivityType_Extend.Id), model.Id));
            }
            else
            {
                var newId = activityTypeRepository.Insert(model);
                model.Id = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 获取商会活动类型详情
        /// </summary>
        /// <param name="Id"></param>
        /// <returns></returns>
        public RB_Commerce_ActivityType_Extend GetCommerceActivityTypeModule(object Id)
        {
            return activityTypeRepository.GetEntity<RB_Commerce_ActivityType_Extend>(Id);
        }

        /// <summary>
        /// 更新商户活动类型状态
        /// </summary>
        /// <param name="Id"></param>
        /// <param name="Status"></param>
        /// <returns></returns>
        public bool RemoveCommerceActivityTypeModule(int Id, int Status)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Commerce_ActivityType_Extend.Status),Status },
            };
            bool flag = activityTypeRepository.Update(fileds, new WhereHelper(nameof(RB_Commerce_ActivityType_Extend.Id), Id));
            return flag;
        }

        #endregion

        #region 商会活动详情管理

        /// <summary>
        /// 获取商会活动详情列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Commerce_Details_Extend> GetCommerceDetailsListModule(RB_Commerce_Details_Extend query)
        {
            return detailsRepository.GetCommerceDetailsListRepository(query);
        }

        #endregion
    }
}
