﻿using VT.FW.DB;
using System;
using Mall.Common.Enum.Finance;

namespace Mall.Model.Entity.Finance
{
    /// <summary>
    /// 财务单据实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "FinanceConnection")]
    public class RB_Finance
    {

        /// <summary>
        /// 主键
        /// </summary>        
        public int FrID
        {
            get;
            set;
        }
        /// <summary>
        /// 团控编号
        /// </summary>        
        public int? TCID
        {
            get;
            set;
        }
        /// <summary>
        /// 订单编号
        /// </summary>        
        public int? OrderID
        {
            get;
            set;
        }
        /// <summary>
        /// 手续费
        /// </summary>
        public decimal? Fee
        {
            get;
            set;
        }
        /// <summary>
        /// 原币手续费
        /// </summary>
        public decimal? OriginalFee
        {
            get; set;
        }
        /// <summary>
        /// 订单来源
        /// </summary>
        public int? OrderSource
        {
            get; set;
        }
        /// <summary>
        /// 其他来源ID
        /// </summary>
        public int? SourceID
        {
            get; set;
        }
        /// <summary>
        /// 客户类型
        /// </summary>        
        public Common.Enum.Finance.ClientTypeEnum? ClientType
        {
            get;
            set;
        }
        /// <summary>
        /// 客户编号
        /// </summary>        
        public int? ClientID
        {
            get;
            set;
        }
        /// <summary>
        /// 1-收入2-支出
        /// </summary>
        public int? Type
        {
            get; set;
        }
        /// <summary>
        /// 客户ID
        /// </summary>
        public int? CustomerId
        {
            get; set;
        }
        /// <summary>
        /// 流水号
        /// </summary>
        public string AccountNumber
        {
            get; set;
        }
        /// <summary>
        /// 发起人
        /// </summary>        
        public int? CreateBy
        {
            get;
            set;
        }
        /// <summary>
        /// 发起时间
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// 集团
        /// </summary>        
        public int? RB_Group_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 公司
        /// </summary>        
        public int? RB_Branch_Id
        {
            get;
            set;
        }
        /// <summary>
        /// 部门ID
        /// </summary>
        public int? RB_Depart_Id
        {
            get;
            set;
        }
        /// <summary>
        ///见枚举
        /// </summary>        
        public FinanceAuditStatus? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 模板ID
        /// </summary>
        public int? TemplateId
        {
            get; set;
        }
        /// <summary>
        /// 模板工作流条件ID
        /// </summary>
        public int? ConditionId
        {
            get;
            set;
        }
        /// <summary>
        ///类型Type=1汇款人 Type=2则为客户名称
        /// </summary>
        public string RemitterName
        {
            get;
            set;
        }
        /// <summary>
        /// 交易日期
        /// </summary>
        public DateTime? TradeDate
        {
            get;
            set;
        }
        /// <summary>
        /// 原币金额
        /// </summary>
        public decimal? WBMoney
        {
            get; set;
        }
        /// <summary>
        /// 汇率
        /// </summary>
        public decimal? Rate
        {
            get; set;
        }
        /// <summary>
        /// 应付金额
        /// </summary>
        public decimal? Money
        {
            get;
            set;
        }
        /// <summary>
        /// 实收实付金额
        /// </summary>
        public decimal? PayMoney
        {
            get;
            set;
        }
        /// <summary>
        /// 发起备注
        /// </summary>
        public string Description
        {
            get;
            set;
        }
        /// <summary>
        /// 组价URL用于呈现单据相关信息
        /// </summary>
        public string URL { get; set; }
        /// <summary>
        /// 0-私账1-公账2-人民币现金3-外币现金
        /// </summary>
        public int? IsPublic
        {
            get; set;
        }
        /// <summary>
        /// 回调参数
        /// </summary>
        public string Callback { get; set; }
        /// <summary>
        /// 预计付款日期
        /// </summary>
        public DateTime? PayDate
        {
            get; set;
        }
        /// <summary>
        /// 出纳是否审核0-未审核1-已审核
        /// </summary>
        public int? Is_Cashier
        {
            get; set;
        }
        /// <summary>
        /// 是否自动生成0-否1-是
        /// </summary>
        public int? Is_Auto
        {
            get; set;
        }
        /// <summary>
        ///回调类型0-默认回调1-不回调
        /// </summary>
        public int? CallType
        {
            get; set;
        }
        /// <summary>
        /// 地接批量审批的唯一编码
        /// </summary>
        public string DijieOnlyCode { get; set; }

        private int? otherType = 0;
        /// <summary>
        /// 其他来源类型  1追加团款  2单机票（2019-11-20 机票管理里  只有机票不绑团，其财务单据 需要在简易报表那边排除）
        /// 3 平台   4 外交平台  （2019-12-05）ld 
        /// 5 酒店折让单 2019-12-18 ld
        /// 6 手配费收入 2019-12-30 ld
        /// 7 预付款冲抵 2019-12-30 ld
        /// 8 领队返款单据 2020-03-30 ld
        /// 9 电商单据 2020-04-01 ld
        /// 10 财务收据 2020-04-09 ld
        /// 11 赞羊返佣 2020-06-09 ld
        /// 12 赞羊已发货退货退款 2020-06-09 ld
        /// 13 赞羊成本 2020-06-09 ld
        /// 14 赞羊未发货退款 2020-06-09 ld
        /// 15 电商采购 2020-07-07 ld
        /// 16 电商出库 2020-07-09 ld
        /// 17 电商报损/报溢单 2020-07-28 ld
        /// 18 电商推荐返佣 2020-08-05 ld
        /// 19 微店返佣 2020-08-05 ld
        /// 20 直播返佣 2020-08-18 ld
        /// 21 赞羊订单其他收入 2020-08-18 ld
        /// 22 赞羊订单其他支出 2020-08-18 ld
        /// </summary>
        public int? OtherType { get => otherType; set => otherType = value; }

        /// <summary>
        /// 平台/外交平台id
        /// </summary>
        public int? PlatformAccountId { get; set; }
        /// <summary>
        /// 相关的财务单据id
        /// </summary>
        public int? ReFinanceId { get; set; }
        /// <summary>
        /// 冲抵金额  只能用于预付款冲抵，有统计 不能共用  会冲突
        /// </summary>
        public decimal? MatchMoney { get; set; }

        /// <summary>
        /// 关联信息2
        /// </summary>
        public int? ReFinanceId2 { get; set; }
    }
}
