﻿using Mall.Model.Entity.BaseSetUp;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.BaseSetUp
{
    public class RB_Logistics_ExpressRepository:BaseRepository<RB_Logistics_Express>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Logistics_Express); } }


        /// <summary>
        /// 快递公司列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Logistics_Express> GetLogisticsExpressList(RB_Logistics_Express query,string ExpressIds="")
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM {TableName} WHERE {nameof(RB_Logistics_Express.Status)}=0 ");
            if (query != null)
            {
                if (query.ID > 0)
                {
                    builder.Append($" AND {nameof(RB_Logistics_Express.ID)}={query.ID}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Logistics_Express.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Logistics_Express.MallBaseId)}={query.MallBaseId}");
                }
                if (!string.IsNullOrWhiteSpace(query.Name))
                {
                    builder.Append($" AND {nameof(RB_Logistics_Express.Name)} like '%{query.Name}%'");
                }
                if (!string.IsNullOrEmpty(ExpressIds)) {
                    builder.Append($" AND {nameof(RB_Logistics_Express.ID)} in({ExpressIds})");
                }
                
            }
            return Get<RB_Logistics_Express>(builder.ToString()).ToList();
        }
    }
}
