﻿using Mall.Model.Entity.Product;
using Mall.Model.Extend.Product;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.Product
{
    /// <summary>
    /// 拼团活动商品阶梯价格仓储层
    /// </summary>
    public class RB_Groupbuy_Activity_Step_PriceRepository : BaseRepository<RB_Groupbuy_Activity_Step_Price>
    {
        /// <summary>
        /// 获取拼团活动商品规格价格列表
        /// </summary>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Groupbuy_Activity_Step_Price_Extend> GetGroupbuyActivitySpecificationpriceListRepository(RB_Groupbuy_Activity_Step_Price_Extend dmodel)
        {
            string where = $" 1=1  ";
            if (dmodel.TenantId > 0)
            {
                where += $@" and {nameof(RB_Groupbuy_Activity_Step_Price_Extend.TenantId)}={dmodel.TenantId}";
            }
            if (dmodel.MallBaseId > 0)
            {
                where += $@" and {nameof(RB_Groupbuy_Activity_Step_Price_Extend.MallBaseId)}={dmodel.MallBaseId}";
            }
            if (dmodel.Id > 0)
            {
                where += $@" and {nameof(RB_Groupbuy_Activity_Step_Price_Extend.Id)}={dmodel.Id}";
            }
            if (dmodel.GoodId > 0)
            {
                where += $@" and {nameof(RB_Groupbuy_Activity_Step_Price_Extend.GoodId)}={dmodel.GoodId}";
            }
            if (!string.IsNullOrEmpty(dmodel.GoodsIds))
            {
                where += $@" and {nameof(RB_Groupbuy_Activity_Step_Price_Extend.GoodId)} in({dmodel.GoodsIds})";
            }
            string sql = $@"select * from RB_Groupbuy_Activity_Step_Price where {where} order by Id desc";
            return Get<RB_Groupbuy_Activity_Step_Price_Extend>(sql).ToList();
        }
    }
}
