﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;
using VT.FW.DB.Dapper;

namespace Mall.Repository.Education
{
    /// <summary>
    /// 活动周期明细仓储层
    /// </summary>
    public class RB_Activity_PeriodsDetailRepository : BaseRepository<RB_Activity_PeriodsDetail>
    {
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Activity_PeriodsDetail_ViewModel> GetList(RB_Activity_PeriodsDetail_ViewModel demodel)
        {
            string where = $@" 1=1";

            if (demodel.Group_Id > 0)
            {
                where += $@" and r.{nameof(RB_Activity_PeriodsDetail_ViewModel.Group_Id)} ={demodel.Group_Id}";
            }
            if (demodel.PeriodId > 0)
            {
                where += $@" and r.{nameof(RB_Activity_PeriodsDetail_ViewModel.PeriodId)} ={demodel.PeriodId}";
            }
            if (demodel.UserId > 0)
            {
                where += $@" and r.{nameof(RB_Activity_PeriodsDetail_ViewModel.UserId)} ={demodel.UserId}";
            }
            if (!string.IsNullOrEmpty(demodel.UserIds))
            {
                where += $@" and r.{nameof(RB_Activity_PeriodsDetail_ViewModel.UserId)} in({demodel.UserIds})";
            }
            if (demodel.ActivityId > 0)
            {
                where += $@" and r.{nameof(RB_Activity_PeriodsDetail_ViewModel.ActivityId)} ={demodel.ActivityId}";
            }
            if (demodel.OrderId > 0)
            {
                where += $@" and r.{nameof(RB_Activity_PeriodsDetail_ViewModel.OrderId)} ={demodel.OrderId}";
            }
            if (!string.IsNullOrEmpty(demodel.OrderIds))
            {
                where += $@" and r.{nameof(RB_Activity_PeriodsDetail_ViewModel.OrderId)} in({demodel.OrderIds})";
            }


            string sql = $@" select r.* from RB_Activity_PeriodsDetail r where {where} order by r.Id asc";
            return Get<RB_Activity_PeriodsDetail_ViewModel>(sql).ToList();
        }

    }
}
