﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common.Enum;
using Mall.Model.Entity.Education;
using Mall.Model.Extend.Education;
using VT.FW.DB.Dapper;

namespace Mall.Repository.Education
{
    public class RB_Education_ConsultRepository : BaseRepository<RB_Education_Consult>
    {
        /// <summary>
        /// 获取商会活动报名分页列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Education_Consult_Extend> GetCommerceConsultListRepository(RB_Education_Consult_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Education_Consult
WHERE 1=1
");
            if (query == null)
            {
                return new List<RB_Education_Consult_Extend>();
            }
            else
            {
                if (query.EnrollState > 0)
                {
                    if (query.EnrollState == 1)
                    {
                        builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Normal);
                    }
                    else if (query.EnrollState == 2)
                    {
                        builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Delete);
                    }
                }
                else
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Normal);
                }
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_Consult_Extend.TenantId), query.TenantId);
                }
                if (query.OrderStatus > -1)
                {
                    if (query.OrderStatus == 1)
                    {
                        builder.AppendFormat(" AND ({0}=1 or  {1}={2} ) ", nameof(RB_Education_Consult_Extend.OrderStatus), nameof(RB_Education_Consult_Extend.PaymentWay), (int)Common.Enum.Goods.OrderPaymentTypeEnum.OfflinePay);
                    }
                    else
                    {
                        builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_Consult_Extend.OrderStatus), query.OrderStatus);
                    }
                }
                //if (query.OrderStatus > -1)
                //{
                //    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_Consult_Extend.OrderStatus), query.OrderStatus);
                //}
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_Consult_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.LinkMan))
                {
                    builder.AppendFormat(" AND {0} LIKE @Name ", nameof(RB_Education_Consult_Extend.LinkMan));
                    parameters.Add("Name", "%" + query.LinkMan.Trim() + "%");
                }
                if (!string.IsNullOrEmpty(query.LinkTel))
                {
                    builder.AppendFormat(" AND {0} ='{1}' ", nameof(RB_Education_Consult_Extend.LinkTel), query.LinkTel.Trim());
                }
                if (query.ActivityId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_Consult_Extend.ActivityId), query.ActivityId);
                }
                if (!string.IsNullOrEmpty(query.QActivityIds))
                {
                    builder.AppendFormat(" AND {0} IN({1}) ", nameof(RB_Education_Consult_Extend.ActivityId), query.QActivityIds);
                }
                if (!string.IsNullOrEmpty(query.QUserIds))
                {
                    builder.AppendFormat(" AND {0} IN({1}) ", nameof(RB_Education_Consult_Extend.UserId), query.QUserIds);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_Consult_Extend.UserId), query.UserId);
                }
                if (query.EduStudentId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_Consult_Extend.EduStudentId), query.EduStudentId);
                }
                if (query.Id > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_Consult_Extend.Id), query.Id);
                }
            }
            return Get<RB_Education_Consult_Extend>(builder.ToString(), parameters).ToList();
        }


        /// <summary>
        /// 获取商会活动报名分页列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Education_Consult_Extend> GetCommerceConsultListRepository_V2(RB_Education_Consult_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT a.*,b.ActivityName,b.CoverImg,b.StartTime,b.EndTime,b.LocationName
FROM RB_Education_Consult a
left join rb_education_activity b on a.ActivityId = b.Id where 1=1
");
            if (query == null)
            {
                return new List<RB_Education_Consult_Extend>();
            }
            else
            {
                if (query.EnrollState > 0)
                {
                    if (query.EnrollState == 1)
                    {
                        builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Normal);
                    }
                    else if (query.EnrollState == 2)
                    {
                        builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Delete);
                    }
                }
                else
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Normal);
                }
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.TenantId), query.TenantId);
                }
                if (query.OrderStatus > -1)
                {
                    if (query.OrderStatus == 1)
                    {
                        builder.AppendFormat(" AND (a.{0}=1 or  a.{1}={2} ) ", nameof(RB_Education_Consult_Extend.OrderStatus), nameof(RB_Education_Consult_Extend.PaymentWay), (int)Common.Enum.Goods.OrderPaymentTypeEnum.OfflinePay);
                    }
                    else
                    {
                        builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.OrderStatus), query.OrderStatus);
                    }
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.LinkMan))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @Name ", nameof(RB_Education_Consult_Extend.LinkMan));
                    parameters.Add("Name", "%" + query.LinkMan.Trim() + "%");
                }

                if (!string.IsNullOrEmpty(query.ActivityName))
                {
                    builder.AppendFormat(" AND b.{0} LIKE '%{1}%' ", nameof(RB_Education_Activity_Extend.ActivityName), query.ActivityName.Trim());
                }

                if (query.ActivityId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.ActivityId), query.ActivityId);
                }

                if (!string.IsNullOrWhiteSpace(query.CreateStartTime))//报名时间
                {
                    builder.AppendFormat($" and  DATE_FORMAT(a.{ nameof(RB_Education_Consult_Extend.CreateTime)},'%Y-%m-%d' )>=DATE_FORMAT('{query.CreateStartTime}','%Y-%m-%d' ) ");
                }
                if (!string.IsNullOrWhiteSpace(query.CreateEndTime))//报名时间
                {
                    builder.AppendFormat($" and  DATE_FORMAT(a.{nameof(RB_Education_Consult_Extend.CreateTime)},'%Y-%m-%d' )<= DATE_FORMAT('{query.CreateEndTime}','%Y-%m-%d' ) ");
                }
                if (query.StartTime.HasValue)//活动开始时间
                {
                    builder.AppendFormat($" and  DATE_FORMAT(b.{ nameof(RB_Education_Activity_Extend.StartTime)},'%Y-%m-%d' )>=DATE_FORMAT('{query.StartTime.Value.ToString("yyyy-MM-dd")}','%Y-%m-%d' ) ");
                }
                if (query.EndTime.HasValue)//活动开始时间
                {
                    builder.AppendFormat($" and  DATE_FORMAT(b.{nameof(RB_Education_Consult_Extend.StartTime)},'%Y-%m-%d' )<= DATE_FORMAT('{query.EndTime.Value.ToString("yyyy-MM-dd")}','%Y-%m-%d' ) ");
                }
                if (!string.IsNullOrEmpty(query.QActivityIds))
                {
                    builder.AppendFormat(" AND a.{0} IN({1}) ", nameof(RB_Education_Consult_Extend.ActivityId), query.QActivityIds);
                }
                if (!string.IsNullOrEmpty(query.QUserIds))
                {
                    builder.AppendFormat(" AND a.{0} IN({1}) ", nameof(RB_Education_Consult_Extend.UserId), query.QUserIds);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.UserId), query.UserId);
                }
                if (query.EduUserId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.EduUserId), query.EduUserId);
                }
                if (query.Id > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.Id), query.Id);
                }
            }
            return Get<RB_Education_Consult_Extend>(builder.ToString(), parameters).ToList();
        }



        /// <summary>
        /// 获取用户的报名列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Education_Consult_Extend> GetCommerceConsultListRepository_V3(int pageIndex, int pageSize, out long rowsCount, RB_Education_Consult_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT a.*,b.ActivityName,b.CoverImg,b.StartTime,b.EndTime,b.LocationName
FROM RB_Education_Consult a
left join rb_education_activity b on a.ActivityId = b.Id where 1=1
");
            if (query == null)
            {
                rowsCount = 0;
                return new List<RB_Education_Consult_Extend>();
            }
            else
            {
                if (query.EnrollState > 0)
                {
                    if (query.EnrollState == 1)
                    {
                        builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Normal);
                    }
                    else if (query.EnrollState == 2)
                    {
                        builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Delete);
                    }
                }
                else
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Normal);
                }
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.TenantId), query.TenantId);
                }
                if (query.OrderStatus > -1)
                {
                    if (query.OrderStatus == 1)
                    {
                        builder.AppendFormat(" AND (a.{0}=1 or  a.{1}={2} ) ", nameof(RB_Education_Consult_Extend.OrderStatus), nameof(RB_Education_Consult_Extend.PaymentWay), (int)Common.Enum.Goods.OrderPaymentTypeEnum.OfflinePay);
                    }
                    else
                    {
                        builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.OrderStatus), query.OrderStatus);
                    }
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.LinkMan))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @Name ", nameof(RB_Education_Consult_Extend.LinkMan));
                    parameters.Add("Name", "%" + query.LinkMan.Trim() + "%");
                }

                if (!string.IsNullOrEmpty(query.ActivityName))
                {
                    builder.AppendFormat(" AND b.{0} LIKE '%{1}%' ", nameof(RB_Education_Activity_Extend.ActivityName), query.ActivityName.Trim());
                }

                if (query.ActivityId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.ActivityId), query.ActivityId);
                }

                if (!string.IsNullOrWhiteSpace(query.CreateStartTime))//报名时间
                {
                    builder.AppendFormat($" and  DATE_FORMAT(a.{ nameof(RB_Education_Consult_Extend.CreateTime)},'%Y-%m-%d' )>=DATE_FORMAT('{query.CreateStartTime}','%Y-%m-%d' ) ");
                }
                if (!string.IsNullOrWhiteSpace(query.CreateEndTime))//报名时间
                {
                    builder.AppendFormat($" and  DATE_FORMAT(a.{nameof(RB_Education_Consult_Extend.CreateTime)},'%Y-%m-%d' )<= DATE_FORMAT('{query.CreateEndTime}','%Y-%m-%d' ) ");
                }
                if (query.StartTime.HasValue&&query.StartTime.Value.ToString("yyyy-MM-dd")!= "0001-01-01")//活动开始时间
                {
                    builder.AppendFormat($" and  DATE_FORMAT(b.{ nameof(RB_Education_Activity_Extend.StartTime)},'%Y-%m-%d' )>=DATE_FORMAT('{query.StartTime.Value.ToString("yyyy-MM-dd")}','%Y-%m-%d' ) ");
                }
                if (query.EndTime.HasValue && query.StartTime.Value.ToString("yyyy-MM-dd") != "0001-01-01")//活动开始时间
                {
                    builder.AppendFormat($" and  DATE_FORMAT(b.{nameof(RB_Education_Consult_Extend.StartTime)},'%Y-%m-%d' )<= DATE_FORMAT('{query.EndTime.Value.ToString("yyyy-MM-dd")}','%Y-%m-%d' ) ");
                }
                if (!string.IsNullOrEmpty(query.QActivityIds))
                {
                    builder.AppendFormat(" AND a.{0} IN({1}) ", nameof(RB_Education_Consult_Extend.ActivityId), query.QActivityIds);
                }
                if (!string.IsNullOrEmpty(query.QUserIds))
                {
                    builder.AppendFormat(" AND a.{0} IN({1}) ", nameof(RB_Education_Consult_Extend.UserId), query.QUserIds);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.UserId), query.UserId);
                }
                if (query.EduUserId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.EduUserId), query.EduUserId);
                }
                if (query.Id > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.Id), query.Id);
                }
            }
            builder.AppendFormat(" order by a.Id desc");
            return GetPage<RB_Education_Consult_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 获取用户的报名列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Education_Consult_Extend> GetExportCommerceConsultList( RB_Education_Consult_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT a.*,b.ActivityName,b.CoverImg,b.StartTime,b.EndTime,b.LocationName
FROM RB_Education_Consult a
left join rb_education_activity b on a.ActivityId = b.Id where 1=1
");
            if (query == null)
            {
                return new List<RB_Education_Consult_Extend>();
            }
            else
            {
                if (query.EnrollState > 0)
                {
                    if (query.EnrollState == 1)
                    {
                        builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Normal);
                    }
                    else if (query.EnrollState == 2)
                    {
                        builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Delete);
                    }
                }
                else
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Normal);
                }
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.TenantId), query.TenantId);
                }
                if (query.OrderStatus > -1)
                {
                    if (query.OrderStatus == 1)
                    {
                        builder.AppendFormat(" AND (a.{0}=1 or  a.{1}={2} ) ", nameof(RB_Education_Consult_Extend.OrderStatus), nameof(RB_Education_Consult_Extend.PaymentWay), (int)Common.Enum.Goods.OrderPaymentTypeEnum.OfflinePay);
                    }
                    else
                    {
                        builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.OrderStatus), query.OrderStatus);
                    }
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.LinkMan))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @Name ", nameof(RB_Education_Consult_Extend.LinkMan));
                    parameters.Add("Name", "%" + query.LinkMan.Trim() + "%");
                }

                if (!string.IsNullOrEmpty(query.ActivityName))
                {
                    builder.AppendFormat(" AND b.{0} LIKE '%{1}%' ", nameof(RB_Education_Activity_Extend.ActivityName), query.ActivityName.Trim());
                }

                if (query.ActivityId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.ActivityId), query.ActivityId);
                }

                if (!string.IsNullOrWhiteSpace(query.CreateStartTime))//报名时间
                {
                    builder.AppendFormat($" and  DATE_FORMAT(a.{ nameof(RB_Education_Consult_Extend.CreateTime)},'%Y-%m-%d' )>=DATE_FORMAT('{query.CreateStartTime}','%Y-%m-%d' ) ");
                }
                if (!string.IsNullOrWhiteSpace(query.CreateEndTime))//报名时间
                {
                    builder.AppendFormat($" and  DATE_FORMAT(a.{nameof(RB_Education_Consult_Extend.CreateTime)},'%Y-%m-%d' )<= DATE_FORMAT('{query.CreateEndTime}','%Y-%m-%d' ) ");
                }
                if (query.StartTime.HasValue && query.StartTime.Value.ToString("yyyy-MM-dd") != "0001-01-01")//活动开始时间
                {
                    builder.AppendFormat($" and  DATE_FORMAT(b.{ nameof(RB_Education_Activity_Extend.StartTime)},'%Y-%m-%d' )>=DATE_FORMAT('{query.StartTime.Value.ToString("yyyy-MM-dd")}','%Y-%m-%d' ) ");
                }
                if (query.EndTime.HasValue && query.StartTime.Value.ToString("yyyy-MM-dd") != "0001-01-01")//活动开始时间
                {
                    builder.AppendFormat($" and  DATE_FORMAT(b.{nameof(RB_Education_Consult_Extend.StartTime)},'%Y-%m-%d' )<= DATE_FORMAT('{query.EndTime.Value.ToString("yyyy-MM-dd")}','%Y-%m-%d' ) ");
                }
                if (!string.IsNullOrEmpty(query.QActivityIds))
                {
                    builder.AppendFormat(" AND a.{0} IN({1}) ", nameof(RB_Education_Consult_Extend.ActivityId), query.QActivityIds);
                }
                if (!string.IsNullOrEmpty(query.QUserIds))
                {
                    builder.AppendFormat(" AND a.{0} IN({1}) ", nameof(RB_Education_Consult_Extend.UserId), query.QUserIds);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.UserId), query.UserId);
                }
                if (query.EduUserId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.EduUserId), query.EduUserId);
                }
                if (query.Id > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.Id), query.Id);
                }
            }
            builder.AppendFormat(" order by a.Id desc");
            return Get<RB_Education_Consult_Extend>( builder.ToString(), parameters).ToList();
        }


        /// <summary>
        /// 获取商会活动报名分页列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_Education_Consult_Statistics GetCommerceConsultStatistics(RB_Education_Consult_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
select SUM(CASE WHEN a.`Status` <> 1 THEN a.Money-a.RefundPrice ELSE 0 END) AS Money,
SUM(CASE WHEN a.`Status` <> 1  THEN (a.Income+a.PlatformTax) ELSE 0 END) AS Income,
SUM(CASE WHEN a.`Status` <> 1 THEN (a.Money-a.Income-a.PlatformTax-a.RefundPrice) ELSE 0 END) AS DueInMoney,
SUM(CASE WHEN a.`Status` <> 1 THEN 1 ELSE 0 END) AS GuestNum,
SUM(CASE WHEN a.Status = 1 THEN 1 ELSE 0 END) AS CancelNum
 from rb_education_consult a 
left join rb_education_activity b on a.ActivityId = b.Id where 1=1  ");
            if (query == null)
            {
                return new RB_Education_Consult_Statistics();
            }
            else
            {
                if (query.EnrollState > 0)
                {
                    if (query.EnrollState == 1)
                    {
                        builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Normal);
                    }
                    else if (query.EnrollState == 2)
                    {
                        builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Delete);
                    }
                }
                else
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Normal);
                }
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.TenantId), query.TenantId);
                }
                if (query.OrderStatus > -1)
                {
                    if (query.OrderStatus == 1)
                    {
                        builder.AppendFormat(" AND (a.{0}=1 or  a.{1}={2} ) ", nameof(RB_Education_Consult_Extend.OrderStatus), nameof(RB_Education_Consult_Extend.PaymentWay), (int)Common.Enum.Goods.OrderPaymentTypeEnum.OfflinePay);
                    }
                    else
                    {
                        builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.OrderStatus), query.OrderStatus);
                    }
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.LinkMan))
                {
                    builder.AppendFormat(" AND a.{0} LIKE @Name ", nameof(RB_Education_Consult_Extend.LinkMan));
                    parameters.Add("Name", "%" + query.LinkMan.Trim() + "%");
                }

                if (!string.IsNullOrEmpty(query.ActivityName))
                {
                    builder.AppendFormat(" AND b.{0} LIKE '%{1}%' ", nameof(RB_Education_Activity_Extend.ActivityName), query.ActivityName.Trim());
                }

                if (query.ActivityId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.ActivityId), query.ActivityId);
                }

                if (!string.IsNullOrWhiteSpace(query.CreateStartTime))//报名时间
                {
                    builder.AppendFormat($" and  DATE_FORMAT(a.{ nameof(RB_Education_Consult_Extend.CreateTime)},'%Y-%m-%d' )>=DATE_FORMAT('{query.CreateStartTime}','%Y-%m-%d' ) ");
                }
                if (!string.IsNullOrWhiteSpace(query.CreateEndTime))//报名时间
                {
                    builder.AppendFormat($" and  DATE_FORMAT(a.{nameof(RB_Education_Consult_Extend.CreateTime)},'%Y-%m-%d' )<= DATE_FORMAT('{query.CreateEndTime}','%Y-%m-%d' ) ");
                }
                if (query.StartTime.HasValue && query.StartTime.Value.ToString("yyyy-MM-dd") != "0001-01-01")//活动开始时间
                {
                    builder.AppendFormat($" and  DATE_FORMAT(b.{ nameof(RB_Education_Activity_Extend.StartTime)},'%Y-%m-%d' )>=DATE_FORMAT('{query.StartTime.Value.ToString("yyyy-MM-dd")}','%Y-%m-%d' ) ");
                }
                if (query.EndTime.HasValue && query.StartTime.Value.ToString("yyyy-MM-dd") != "0001-01-01")//活动开始时间
                {
                    builder.AppendFormat($" and  DATE_FORMAT(b.{nameof(RB_Education_Consult_Extend.StartTime)},'%Y-%m-%d' )<= DATE_FORMAT('{query.EndTime.Value.ToString("yyyy-MM-dd")}','%Y-%m-%d' ) ");
                }
                if (!string.IsNullOrEmpty(query.QActivityIds))
                {
                    builder.AppendFormat(" AND a.{0} IN({1}) ", nameof(RB_Education_Consult_Extend.ActivityId), query.QActivityIds);
                }
                if (!string.IsNullOrEmpty(query.QUserIds))
                {
                    builder.AppendFormat(" AND a.{0} IN({1}) ", nameof(RB_Education_Consult_Extend.UserId), query.QUserIds);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.UserId), query.UserId);
                }
                if (query.EduUserId > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.EduUserId), query.EduUserId);
                }
                if (query.Id > 0)
                {
                    builder.AppendFormat(" AND a.{0}={1} ", nameof(RB_Education_Consult_Extend.Id), query.Id);
                }
            }
            return Get<RB_Education_Consult_Statistics>(builder.ToString(), parameters).ToList().FirstOrDefault();
        }

        /// <summary>
        /// 获取用户的报名列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Education_Consult_Extend> GetUserJoinActivityPageList(int pageIndex, int pageSize, out long rowsCount, RB_Education_Consult_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT c.*,a.ActivityName,a.CoverImg,a.StartTime,a.EndTime,t.TypeName
FROM RB_Education_Consult c
left join rb_education_activity a on c.ActivityId = a.Id
left join rb_education_activitytype t on t.Id = a.ActivityType
WHERE 1=1
");
            if (query == null)
            {
                rowsCount = 0;
                return new List<RB_Education_Consult_Extend>();
            }
            else
            {
                if (query.EnrollState > 0)
                {
                    if (query.EnrollState == 1)
                    {
                        builder.AppendFormat(" AND c.{0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Normal);
                    }
                    else if (query.EnrollState == 2)
                    {
                        builder.AppendFormat(" AND c.{0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Delete);
                    }
                }
                else
                {
                    builder.AppendFormat(" AND c.{0}={1} ", nameof(RB_Education_Consult_Extend.Status), (int)DateStateEnum.Normal);
                }

                if (query.OrderStatus > -1)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Education_Consult_Extend.OrderStatus), query.OrderStatus);
                }
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND c.{0}={1} ", nameof(RB_Education_Consult_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND c.{0}={1} ", nameof(RB_Education_Consult_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.LinkMan))
                {
                    builder.AppendFormat(" AND c.{0} LIKE @Name ", nameof(RB_Education_Consult_Extend.LinkMan));
                    parameters.Add("Name", "%" + query.LinkMan.Trim() + "%");
                }
                if (query.ActivityId > 0)
                {
                    builder.AppendFormat(" AND c.{0}={1} ", nameof(RB_Education_Consult_Extend.ActivityId), query.ActivityId);
                }
                if (!string.IsNullOrEmpty(query.QActivityIds))
                {
                    builder.AppendFormat(" AND c.{0} IN({1}) ", nameof(RB_Education_Consult_Extend.ActivityId), query.QActivityIds);
                }
                if (!string.IsNullOrEmpty(query.QUserIds))
                {
                    builder.AppendFormat(" AND c.{0} IN({1}) ", nameof(RB_Education_Consult_Extend.UserId), query.QUserIds);
                }
                if (query.UserId > 0)
                {
                    builder.AppendFormat(" AND c.{0}={1} ", nameof(RB_Education_Consult_Extend.UserId), query.UserId);
                }
            }
            builder.AppendFormat(" order by c.Id desc");
            return GetPage<RB_Education_Consult_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 获取活动报名人数
        /// </summary>
        /// <param name="activityId"></param>
        /// <returns></returns>
        public int GetActivityEnrollNum(int activityId, int sex = 0)
        {
            string sql = $@" select count(0) from RB_Education_Consult where Status =0 and OrderStatus=1 and ActivityId ={activityId}";
            if (sex > 0)
            {
                sql += $@" and Sex ={sex}";
            }
            var obj = ExecuteScalar(sql);
            return obj == null ? 0 : Convert.ToInt32(obj);
        }

        /// <summary>
        /// 获取可发提成的订单列表
        /// </summary>
        /// <param name="month"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public List<RB_Education_Consult_Extend> GetActivityCanSendCommissionList(string month, int mallBaseId)
        {
            string sql = $@"SELECT c.*,a.ActivityName,a.StartTime,a.EndTime FROM rb_education_consult c 
INNER JOIN rb_education_activity a on c.ActivityId = a.Id
WHERE c.`Status`=0 and a.`Status`=0 and c.MallBaseId ={mallBaseId} and a.EndTime <='{month} 23:59:59' and c.OrderStatus =1 and c.UserId >0 
and c.IsRollCall =2 and c.IsCommission <>2 and (c.Income + c.PlatformTax - c.RefundPrice) =c.Money";

            return Get<RB_Education_Consult_Extend>(sql).ToList();
        }
    }
}
