﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Linq.Expressions;

namespace DapperExtensions.Lambda
{
    /// <summary>
    /// 常量提取
    /// </summary>
    public class ConstantExtractor : ExpressionVisitor
    {
        private List<object> m_constants;

        /// <summary>
        /// 构造函数
        /// </summary>
        /// <param name="exp">表达式</param>
        /// <returns></returns>
        public List<object> Extract(System.Linq.Expressions.Expression exp)
        {
            this.m_constants = new List<object>();
            this.Visit(exp);
            return this.m_constants;
        }

        /// <summary>
        /// 访问常量
        /// </summary>
        /// <param name="c">常量表达式</param>
        /// <returns></returns>
        protected override System.Linq.Expressions.Expression VisitConstant(ConstantExpression c)
        {
            this.m_constants.Add(c.Value);
            return c;
        }
    }        
}
