﻿using VT.FW.DB;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Model.Extend.BaseSetUp;

namespace Mall.Model.Extend.Product
{
    /// <summary>
    /// 商品购物车表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_ShoppingCart_Extend : RB_Goods_ShoppingCart
    {
        /// <summary>
        /// 商品名称
        /// </summary>
        public string GoodsName { get; set; }

        /// <summary>
        /// 课程评分
        /// </summary>
        public decimal? CourseScore { get; set; }

        /// <summary>
        /// 商品类型   2网课商品
        /// </summary>
        public int GoodsClassify { get; set; }

        /// <summary>
        /// 商品状态   1销售中  2下架中  3 失效
        /// </summary>        
        public int? GoodsStatus
        {
            get;
            set;
        }
        /// <summary>
        /// 轮播图  json 格式  第一张为封面图
        /// </summary>        
        public string CarouselImage
        {
            get;
            set;
        }
        /// <summary>
        /// 规格列表
        /// </summary>
        public List<string> SpecificationList { get; set; }
        /// <summary>
        /// 售价
        /// </summary>
        public decimal Price { get; set; }
        /// <summary>
        /// 默认规格名称
        /// </summary>
        public string DefaultSpecificationName { get; set; }
        /// <summary>
        /// 是否开启自定义规格
        /// </summary>
        public int? IsCustomSpecification { get; set; }
        /// <summary>
        /// 封面图
        /// </summary>
        public string CoverImage { get; set; }
        /// <summary>
        /// 是否享受会员
        /// </summary>
        public int? EnjoyMember { get; set; }
        /// <summary>
        /// 是否制定会员价格
        /// </summary>
        public int? SeparateSetMember { get; set; }
        /// <summary>
        /// 库存数量
        /// </summary>
        public int? InventoryNum { get; set; }

        /// <summary>
        /// 供应商ids  2020-08-04 Add By:W
        /// </summary>
        public string SupplierIds { get; set; }

        /// <summary>
        /// 商品分类包邮规则
        /// </summary>
        public RB_FreeShipping_Extend FreeShippingModel { get; set; }

        /// <summary>
        /// 单品满件包邮
        /// </summary>        
        public int? FullNumPinkage
        {
            get;
            set;
        }
        /// <summary>
        /// 单品满额包邮
        /// </summary>        
        public decimal? FullMoneyPinkage
        {
            get;
            set;
        }

        /// <summary>
        /// 营销标识
        /// </summary>
        public string MarketingLogo { get; set; }
    }
}
