﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common.Enum.MarketingCenter;
using Mall.Common.Plugin;
using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.MarketingCenter;
using Mall.Repository.MarketingCenter;
using VT.FW.DB;

namespace Mall.Module.MarketingCenter
{
  public  class SurveyModule
    {
        public readonly Rb_SurveyRepository surveyRepository = new Rb_SurveyRepository();

        public readonly Rb_SurveyOptionsRepository surveyOptionsRepository = new Rb_SurveyOptionsRepository();

        /// <summary>
        /// 旅客调查信息
        /// </summary>
        private Rb_GuestSurveyRepository guestSurveyRepository = new Rb_GuestSurveyRepository();


        /// <summary>
        /// 旅客调查选项信息
        /// </summary>
        private Rb_GuestSurveyDetailsRepository guestSurveyDetailsRepository = new Rb_GuestSurveyDetailsRepository();
        #region 意见调查基础信息
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<Rb_Survey_Extend> GetList(Rb_Survey_Extend where)
        {
            return surveyRepository.GetList(where);
        }


        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<Rb_Survey_Extend> GetPageList(int pageIndex, int pageSize, out long rowsCount, Rb_Survey_Extend where)
        {
            return surveyRepository.GetPageList(pageIndex, pageSize, out rowsCount, where);
        }


        /// <summary>
        /// 获取实体
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public Rb_Survey GetEntity(int id)
        {
            return surveyRepository.GetEntity(id);
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<Rb_SurveyOptions_Extend> GetSurveyOptionsList(Rb_SurveyOptions where)
        {
            return surveyOptionsRepository.GetList(where);
        }

        public bool SetSurvey(Rb_Survey_Extend model)
        {
            var trans = surveyRepository.DbTransaction;
            try
            {
                int surveyId = 0;
                if (model.ID > 0)
                {
                    surveyId = model.ID;
                    IDictionary<string, object> fileds = new Dictionary<string, object>()
                    {
                         { nameof(Rb_Survey.Title),model.Title},
                         { nameof(Rb_Survey.IsShow),model.IsShow},
                         { nameof(Rb_Survey.Sort),model.Sort},
                           { nameof(Rb_Survey.SurveyType),(int)model.SurveyType},
                         { nameof(Rb_Survey.UpdateDate),model.UpdateDate},
                    };
                    List<WhereHelper> where = new List<WhereHelper>()
                    {
                        new WhereHelper ()
                        {
                            FiledName=nameof(Rb_Survey.ID),
                            FiledValue=model.ID,
                            OperatorEnum= OperatorEnum.Equal
                        }
                    };
                    var flag = surveyRepository.Update(fileds, where, trans);
                    //查询之前的选项
                    var surveyOptionsList = surveyOptionsRepository.GetList(new Rb_SurveyOptions { SurveyID = surveyId });
                    //删除之前有现在没有的
                    List<string> surveyOptionsExcept = new List<string>();
                    if (surveyOptionsList != null && surveyOptionsList.Any() && model.SurveyOptionsList != null && model.SurveyOptionsList.Any())
                    {
                        //差集
                        surveyOptionsExcept = surveyOptionsList.Select(x => x.ID.ToString()).Except(model.SurveyOptionsList.Select(x => x.ID.ToString())).ToList();
                    }
                    else if (model.SurveyOptionsList == null || !model.SurveyOptionsList.Any())
                    {
                        flag = surveyOptionsRepository.DeleteBatch(surveyOptionsList, trans);
                    }
                    foreach (var item in surveyOptionsList.Where(x => surveyOptionsExcept.Contains(x.ID.ToString())))
                    {
                        flag = surveyOptionsRepository.Delete(item, trans) > 0;
                    }
                }
                else
                {
                    surveyId = surveyRepository.Insert(model, trans);
                }
                if (model.SurveyType != SurveyTypeEnum.Score && model.SurveyType !=SurveyTypeEnum.TheText)//新增选项
                {
                    foreach (var item in model.SurveyOptionsList)
                    {
                        if (item.ID == 0)
                        {
                            item.SurveyID = surveyId;
                            surveyOptionsRepository.Insert(item, trans);
                        }
                        else
                        {
                            surveyOptionsRepository.Update(item, trans);
                        }
                    }
                }
                surveyRepository.DBSession.Commit();
                return true;
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Write(ex, "SetSurvey");
                surveyRepository.DBSession.Rollback("SetSurvey");
                return false;
            }
        }


        /// <summary>
        /// 删除调查信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool DelSurvey(Rb_Survey_Extend model)
        {
            var trans = surveyRepository.DbTransaction;
            try
            {
                if (model.ID > 0)
                {

                    IDictionary<string, object> fileds = new Dictionary<string, object>()
                    {
                         { nameof(Rb_Survey.State),(int)Common.Enum.DateStateEnum.Delete},
                    };
                    List<WhereHelper> where = new List<WhereHelper>()
                    {
                        new WhereHelper ()
                        {
                            FiledName=nameof(Rb_Survey.ID),
                            FiledValue=model.ID,
                            OperatorEnum= OperatorEnum.Equal
                        }
                    };
                    var flag = surveyRepository.Update(fileds, where, trans);

                    if (model.SurveyOptionsList != null && model.SurveyOptionsList.Any())
                    {
                        model.SurveyOptionsList.ForEach(x => x.State = Common.Enum.DateStateEnum.Delete);
                        flag = surveyOptionsRepository.UpdateBatch(model.SurveyOptionsList, trans);
                    }
                }
                surveyRepository.DBSession.Commit();
                return true;
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Write(ex, "DelSurvey");
                surveyRepository.DBSession.Rollback("DelSurvey");
                return false;
            }
        }


        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="SurveyIDs"></param>
        /// <returns></returns>
        public List<Rb_SurveyOptions_Extend> GetList(string SurveyIDs)
        {
            return surveyOptionsRepository.GetList(SurveyIDs);
        }

        #endregion


        #region 旅客意见信息

        /// <summary>
        /// 获取实体
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public Rb_GuestSurvey GetGuestSurveyEntity(int id)
        {
            return guestSurveyRepository.GetEntity(id);
        }
      
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="SurveyIDs"></param>
        /// <returns></returns>
        public List<Rb_Survey_Extend> GetSurveyList(Rb_Survey_Extend model)
        {
            return surveyRepository.GetList(model);
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<Rb_Survey_Extend> GetAllList(Rb_Survey_Extend where)
        {
            var List = surveyRepository.GetList(where);
            if (List != null && List.Any())
            {
                var surveyOptionsList = surveyOptionsRepository.GetList(string.Join(",", List.Select(x => x.ID)));
                foreach (var item in List)
                {
                    item.SurveyOptionsList = new List<Rb_SurveyOptions_Extend>();
                    item.SurveyOptionsList = surveyOptionsList.Where(x => x.SurveyID == item.ID).OrderBy(x => x.Sort).ToList();
                    item.SurveyOptionsList.ForEach(x => x.IsCheck = "0");
                }
            }
            else
            {
                List = new List<Rb_Survey_Extend>();
            }
            return List;
        }


        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<Rb_GuestSurveyDetails> GetGuestSurveyDetailsList(Rb_GuestSurveyDetails where)
        {
            return guestSurveyDetailsRepository.GetList(where);
        }

        /// <summary>
        /// 新增会员调查信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int SetGuestSurvey(Rb_GuestSurvey_Extend model)
        {
            var trans = guestSurveyRepository.DbTransaction;
            int surveyId = 0;
            try
            {

                surveyId = guestSurveyRepository.Insert(model, trans);
                foreach (var item in model.SurveyOptionsList)
                {
                    if (item.ID == 0)
                    {
                        item.GuestSurveyId = surveyId;
                        guestSurveyDetailsRepository.Insert(item, trans);
                    }
                    else
                    {
                        guestSurveyDetailsRepository.Update(item, trans);
                    }
                }
                guestSurveyRepository.DBSession.Commit();
               
                return surveyId;
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "SetGuestSurvey");
                guestSurveyRepository.DBSession.Rollback("SetGuestSurvey");
                return 0;
            }
        }
        /// <summary>
        /// 新增会员调查信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetBbatchGuestSurvey(List<Rb_GuestSurvey_Extend> list)
        {
            var trans = guestSurveyRepository.DbTransaction;
            int surveyId = 0;
            try
            {
                foreach (var itemModel in list)
                {
                    surveyId = guestSurveyRepository.Insert(itemModel, trans);
                    foreach (var item in itemModel.SurveyOptionsList)
                    {
                        if (item.ID == 0)
                        {
                            item.GuestSurveyId = surveyId;
                            guestSurveyDetailsRepository.Insert(item, trans);
                        }
                        else
                        {
                            guestSurveyDetailsRepository.Update(item, trans);
                        }
                    }
                }
                guestSurveyRepository.DBSession.Commit();
                return true;
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "SetGuestSurvey");
                guestSurveyRepository.DBSession.Rollback("SetGuestSurvey");
                return false;
            }
        }

   
        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<Rb_GuestSurvey_Extend> GetGuestSurveyList(Rb_GuestSurvey_Extend where)
        {
            return guestSurveyRepository.GetList(where);
        }
        #endregion
    }
}
