﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.MarketingCenter;

namespace Mall.Repository.MarketingCenter
{
  public  class Rb_GuestSurveyRepository:BaseRepository<Rb_GuestSurvey>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(Rb_GuestSurvey); } }


        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<Rb_GuestSurvey_Extend> GetList(Rb_GuestSurvey_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT * from Rb_GuestSurvey  where state=0");
            if (where != null)
            {
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and MallBaseId={0}", where.MallBaseId);
                }
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and TenantId={0}", where.TenantId);
                }
                if (where.UserId > 0)
                {
                    sb.AppendFormat(" and UserId={0}", where.UserId);
                }
            }
            return Get<Rb_GuestSurvey_Extend>(sb.ToString()).ToList();
        }



        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<Rb_GuestSurvey_Extend> GetListInfo(Rb_GuestSurvey_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT a.*,  c.ScoreNum,c.ScoreCount from Rb_GuestSurvey as a 
LEFT JOIN (SELECT GuestSurveyId , SUM(ScoreNum) as ScoreNum,COUNT(GuestSurveyId) as ScoreCount   from Rb_GuestSurveydetails where ScoreNum>0 GROUP BY GuestSurveyId )  as c ON a.ID=c.GuestSurveyId
  where a.state=0");
            if (where != null)
            {
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and a.MallBaseId={0}", where.MallBaseId);
                }
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and a.TenantId={0}", where.TenantId);
                }
                if (where.UserId > 0)
                {
                    sb.AppendFormat(" and a.UserId={0}", where.UserId);
                }
            }
            return Get<Rb_GuestSurvey_Extend>(sb.ToString()).ToList();
        }


        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<Rb_GuestSurvey_Extend> GetPageList(int pageIndex, int pageSize, out long rowsCount, Rb_GuestSurvey where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT * from Rb_GuestSurvey  where state=0");
            if (where != null)
            {
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and a.MallBaseId={0}", where.MallBaseId);
                }
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and a.TenantId={0}", where.TenantId);
                }
                if (where.UserId > 0)
                {
                    sb.AppendFormat(" and a.UserId={0}", where.UserId);
                }
            }
            return GetPage<Rb_GuestSurvey_Extend>(pageIndex, pageSize, out rowsCount, sb.ToString()).ToList();
        }

    }
}
