﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.MarketingCenter;

namespace Mall.Repository.MarketingCenter
{
   public class Rb_SurveyOptionsRepository:BaseRepository<Rb_SurveyOptions>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(Rb_SurveyOptions); } }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<Rb_SurveyOptions_Extend> GetList(Rb_SurveyOptions where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT * from Rb_SurveyOptions  where state=0");
            if (where != null)
            {
                if (where.SurveyID > 0)
                {
                    sb.AppendFormat(" and SurveyID={0}", where.SurveyID);
                }
            }
            sb.Append($" ORDER BY {nameof(Rb_SurveyOptions.Sort)} ASC");
            return Get<Rb_SurveyOptions_Extend>(sb.ToString()).ToList();
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="SurveyIDs"></param>
        /// <returns></returns>
        public List<Rb_SurveyOptions_Extend> GetList(string SurveyIDs)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT * from Rb_SurveyOptions  where state=0");

            if (!string.IsNullOrWhiteSpace(SurveyIDs))
            {
                sb.AppendFormat(" and SurveyID in({0})", SurveyIDs);
            }
            sb.Append($" ORDER BY {nameof(Rb_SurveyOptions.Sort)} ASC");
            return Get<Rb_SurveyOptions_Extend>(sb.ToString()).ToList();
        }

    }
}
