﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.MarketingCenter;

namespace Mall.Repository.MarketingCenter
{
    public class Rb_SurveyRepository : BaseRepository<Rb_Survey>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(Rb_Survey); } }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<Rb_Survey_Extend> GetList(Rb_Survey_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT * from Rb_Survey  where state=0");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and MallBaseId={0}", where.MallBaseId);
                }
                if (where.IsShow > 0)
                {
                    sb.AppendFormat(" and IsShow={0}", where.IsShow);
                }
                if (string.IsNullOrWhiteSpace(where.Title))
                {
                    sb.AppendFormat(" and Title like'%{0}%'", where.Title);
                }
                if (where.SurveyType.HasValue && (int)where.SurveyType > 0)
                {
                    sb.AppendFormat(" and SurveyType={0}", (int)where.SurveyType);
                }
                if (!string.IsNullOrWhiteSpace(where.SurveyIDs))
                {
                    sb.AppendFormat(" and ID in({0})", where.SurveyIDs);
                }
            }
            sb.Append($" ORDER BY {nameof(Rb_Survey.Sort)} ASC");
            return Get<Rb_Survey_Extend>(sb.ToString()).ToList();
        }


        

        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<Rb_Survey_Extend> GetPageList(int pageIndex, int pageSize, out long rowsCount, Rb_Survey_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT * from Rb_Survey  where state=0");
            if (where != null)
            {
                if (where.IsShow > 0)
                {
                    sb.AppendFormat(" and IsShow={0}", where.IsShow);
                }
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and MallBaseId={0}", where.MallBaseId);
                }
                if (where.SurveyType.HasValue && (int)where.SurveyType > 0)
                {
                    sb.AppendFormat(" and SurveyType={0}", (int)where.SurveyType);
                }
                if (string.IsNullOrWhiteSpace(where.Title))
                {
                    sb.AppendFormat(" and Title like'%{0}%'", where.Title);
                }
            }
            sb.Append($" ORDER BY {nameof(Rb_Survey.Sort)} ASC");
            return GetPage<Rb_Survey_Extend>(pageIndex, pageSize, out rowsCount, sb.ToString()).ToList();
        }
    }
}
