﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Mall.Module.MarketingCenter;
using Mall.Common.API;
using Newtonsoft.Json;
using Mall.Model.Extend.MarketingCenter;
using Mall.Common.Plugin;
using Newtonsoft.Json.Linq;
using Mall.Model.Entity.MarketingCenter;
using Mall.Common.Enum.MarketingCenter;

namespace Mall.WebApi.Controllers.MarketingCenter
{

    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class SurveyController : BaseController
    {
        /// <summary>
        /// 处理类对象
        /// </summary>
        private SurveyModule module = new SurveyModule();



        #region 问卷调查
        /// <summary>
        /// 获取基础信息列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            Rb_Survey_Extend demodel = JsonConvert.DeserializeObject<Rb_Survey_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            var data = module.GetPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            var list = data.Select(x => new { x.ID, x.SurveyType, x.Title, x.IsShow, x.Sort, SurveyTypeStr = EnumHelper.GetEnumName(x.SurveyType), FormTypeStr = EnumHelper.GetEnumName(x.FormType) }).ToList();
            pagelist.count = int.Parse(count.ToString());
            pagelist.pageData = list;
            return ApiResult.Success("", pagelist);
        }


        /// <summary>
        /// 通过id获取信息
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetSurvey()
        {
            var parms = RequestParm;
            JObject parm = JObject.Parse(parms.msg.ToString());
            int SurveyID = parm.GetInt("SurveyID");
            Rb_Survey_Extend model = module.GetEntity(SurveyID).RefMapperTo<Rb_Survey_Extend>();
            if (model != null)
            {
                model.SurveyOptionsList = new List<Rb_SurveyOptions_Extend>();

                model.SurveyOptionsList = module.GetSurveyOptionsList(new Rb_SurveyOptions { SurveyID = model.ID });

                return ApiResult.Success("请求成功！", model);
            }
            return ApiResult.Failed("未找到此调查信息！");
        }

        /// <summary>
        /// 通过id获取信息
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelSurvey()
        {
            var parms = RequestParm;
            JObject parm = JObject.Parse(parms.msg.ToString());
            int SurveyID = parm.GetInt("SurveyID");
            Rb_Survey_Extend model = module.GetEntity(SurveyID).RefMapperTo<Rb_Survey_Extend>();
            if (model != null)
            {
                if (model.State == Common.Enum.DateStateEnum.Delete)
                {
                    return ApiResult.Failed("已删除请勿重复删除！");
                }
                model.SurveyOptionsList = new List<Rb_SurveyOptions_Extend>();

                model.SurveyOptionsList = module.GetSurveyOptionsList(new Rb_SurveyOptions { SurveyID = model.ID });

                bool result = module.DelSurvey(model);
                return ApiResult.Success("删除成功！");
            }
            return ApiResult.Failed("未找到此调查信息！");
        }

        /// <summary>
        /// 添加修改调查信息
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetSurvey()
        {
            var parms = RequestParm;
            Rb_Survey_Extend model = JsonConvert.DeserializeObject<Rb_Survey_Extend>(parms.msg.ToString());
            if (string.IsNullOrEmpty(model.Title))
            {
                return ApiResult.Failed("请填写名称！");
            }
            if (model.SurveyType == SurveyTypeEnum.MultiSelect || model.SurveyType == SurveyTypeEnum.TheRadio)
            {
                if (model.SurveyOptionsList == null || !model.SurveyOptionsList.Any())
                {
                    return ApiResult.Failed("请填写选项！");
                }
                else
                {
                    model.SurveyOptionsList.ForEach(x => x.State = Common.Enum.DateStateEnum.Normal);
                }
            }
            if (model.ID == 0)
            {
                model.TenantId = UserInfo.TenantId;
                model.MallBaseId = parms.MallBaseId;
                model.CreateDate = DateTime.Now;
            }
            model.UpdateDate = DateTime.Now;
            model.State = Common.Enum.DateStateEnum.Normal;
            bool flag = module.SetSurvey(model);
            if (flag)
                return ApiResult.Success();
            else
                return ApiResult.Failed("请求失败！");
        }

        /// <summary>
        /// 获取调查选项类型枚举列表
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetSurveyTypeEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(SurveyTypeEnum));
            return ApiResult.Success("", list.Select(x => new { Id = x.Value, Name = x.Key }));
        }


        /// <summary>
        /// 获取调查类型枚举列表
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetFormTypeEnumEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(FormTypeEnum));
            return ApiResult.Success("", list.Select(x => new { Id = x.Value, Name = x.Key }));
        }
        #endregion


    }
}
