﻿using Mall.Common.Enum;
using Mall.Model.Entity.TradePavilion;
using Mall.Model.Extend.TradePavilion;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VT.FW.DB.Dapper;

namespace Mall.Repository.TradePavilion
{
    /// <summary>
    /// 商会活动类型表仓储层
    /// </summary>
    public class RB_Commerce_ActivityTypeRepository : BaseRepository<RB_Commerce_ActivityType>
    {
        /// <summary>
        /// 获取商会活动类型分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Commerce_ActivityType_Extend> GetCommerceActivityTypePageListRepository(int pageIndex, int pageSize, out long rowsCount, RB_Commerce_ActivityType_Extend query)
        {
            rowsCount = 0;
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Commerce_ActivityType
WHERE 1=1
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_ActivityType_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_Commerce_ActivityType_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_ActivityType_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_ActivityType_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.TypeName))
                {
                    builder.AppendFormat(" AND {0} LIKE @Name ", nameof(RB_Commerce_ActivityType_Extend.TypeName));
                    parameters.Add("Name", "%" + query.TypeName.Trim() + "%");
                }
            }
            return GetPage<RB_Commerce_ActivityType_Extend>(pageIndex, pageSize, out rowsCount, builder.ToString(), parameters).ToList();
        }

        /// <summary>
        /// 获取商会活动类型列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Commerce_ActivityType_Extend> GetCommerceActivityTypeListRepository(RB_Commerce_ActivityType_Extend query)
        {
            DynamicParameters parameters = new DynamicParameters();
            StringBuilder builder = new StringBuilder();
            builder.AppendFormat(@"
SELECT * 
FROM RB_Commerce_ActivityType
WHERE 1=1
");
            builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_ActivityType_Extend.Status), (int)DateStateEnum.Normal);
            if (query == null)
            {
                return new List<RB_Commerce_ActivityType_Extend>();
            }
            else
            {
                if (query.TenantId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_ActivityType_Extend.TenantId), query.TenantId);
                }
                if (query.MallBaseId > 0)
                {
                    builder.AppendFormat(" AND {0}={1} ", nameof(RB_Commerce_ActivityType_Extend.MallBaseId), query.MallBaseId);
                }
                if (!string.IsNullOrEmpty(query.TypeName))
                {
                    builder.AppendFormat(" AND {0} LIKE @Name ", nameof(RB_Commerce_ActivityType_Extend.TypeName));
                    parameters.Add("Name", "%" + query.TypeName.Trim() + "%");
                }
                if (string.IsNullOrWhiteSpace(query.Ids))
                {
                    builder.AppendFormat($@" AND { nameof(RB_Commerce_ActivityType_Extend.Id)} in ({query.Ids}) ");
                }
            }
            return Get<RB_Commerce_ActivityType_Extend>(builder.ToString(), parameters).ToList();
        }
    }
}
