﻿using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Configuration.Json;
using Newtonsoft.Json;
using Newtonsoft.Json.Converters;
using Newtonsoft.Json.Linq;
using Mall.Common.API;
using Mall.Common.Enum;
using Mall.Common.Plugin;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Resources;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading;
using System.Threading.Tasks;
using System.Web;
using Microsoft.Extensions.Hosting;

namespace Mall.Common
{

    /// <summary>
    /// 全局配置
    /// </summary>
    public class Config
    {
        private static readonly byte[] _webapikey = { 0xF1, 0x12, 0xA3, 0xD1, 0xBA, 0x54, 0x2A, 0x88 };
        private static readonly byte[] _webapiiv = { 0x04, 0xAE, 0x57, 0x83, 0x56, 0x28, 0x66, 0xA7 };

        /// <summary>
        /// 配置文件注入
        /// </summary>
        public readonly static IConfiguration Configuration;
        static Config()
        {
            try
            {
                Configuration = new ConfigurationBuilder()
                .Add(new JsonConfigurationSource { Path = "appsettings.json", ReloadOnChange = true })
                .Build();
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Write(ex, "Config");
            }
        }

        /// <summary>
        /// WebApiKey
        /// </summary>
        static public byte[] WebApiKey
        {
            get { return _webapikey; }
        }

        /// <summary>
        /// WebService接口加密IV
        /// </summary>
        static public byte[] WebApiIV
        {
            get { return _webapiiv; }
        }

        /// <summary>
        /// 获取连接字符串
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        public static string GetConnectionString(string key)
        {
            try
            {
                return Configuration.GetConnectionString(key);
            }
            catch
            {
                return "";
            }
        }


        /// <summary>
        /// 读取配置文件key的值
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        public static string ReadConfigKey(string key, string subKey = "")
        {
            string valueStr = "";
            try
            {
                if (!string.IsNullOrWhiteSpace(subKey))
                {
                    valueStr = Configuration.GetSection(key)[subKey].ToString();
                }
                else
                {
                    valueStr = Configuration.GetSection(key).Value;
                }
            }
            catch
            {
            }
            return valueStr;
        }

        /// <summary>
        /// 超级管理员id
        /// </summary>
        /// <returns></returns>
        public static string AdminId
        {
            get
            {
                return ReadConfigKey("AdminId");
            }
        }

        /// <summary>
        /// 异常日志保存路径
        /// </summary>
        public static string LogPath
        {
            get
            {
                string logPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "log/error");
                return logPath.ToString();
            }
        }

        /// <summary>
        /// 打印日志保存路径
        /// </summary>
        public static string InofLogPath
        {
            get
            {
                string logPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "log/info");
                return logPath.ToString();
            }
        }

        /// <summary>
        /// 接口请求日志保存路径
        /// </summary>
        public static string RequestLogPath
        {
            get
            {
                string logPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "log/request");
                return logPath.ToString();
            }
        }

        /// <summary>
        /// JWT加密秘钥
        /// </summary>
        public static string JwtSecretKey
        {
            get
            {
                return ReadConfigKey("JwtSecretKey");
            }
        }

        /// <summary>
        /// 过期时间，单位为秒
        /// </summary>
        public static int JwtExpirTime
        {
            get
            {
                Int32.TryParse(ReadConfigKey("JwtExpirTime"), out int JwtExpirTime);
                return JwtExpirTime;
            }
        }

        /// <summary>
        /// 接口请求过期时间，单位为秒
        /// </summary>
        public static int ApiExpirTime
        {
            get
            {
                Int32.TryParse(ReadConfigKey("ApiExpirTime"), out int ApiExpirTime);
                return ApiExpirTime;
            }
        }

        /// <summary>
        /// 阿里云oss域名
        /// </summary>
        public static string GetOssFileUrl
        {
            get
            {
                return ReadConfigKey("ViewFileSiteUrl");
            }
        }

        public static string GetAliOssFileUrl {
            get {
                return ReadConfigKey("AliFileSiteUrl");
            }
        }

        /// <summary>
        /// 获取Oss文件全路径
        /// </summary>
        /// <param name="path">文件相对路径</param>
        /// <returns></returns>
        public static string GetFileUrl(string path)
        {
            if (string.IsNullOrWhiteSpace(path))
            {
                return null;
            }
            else
            {
                string p = @"(http|https)://(?<domain>[^(:|/]*)";
                Regex reg = new Regex(p, RegexOptions.IgnoreCase);
                string value = reg.Match(path).Value;
                if (!string.IsNullOrEmpty(value))
                {
                    return path;
                }
                else
                {
                    return GetOssFileUrl + path;
                }
            }
        }

        /// <summary>
        /// 获取Oss文件全路径
        /// </summary>
        /// <param name="path">文件相对路径</param>
        /// <returns></returns>
        public static string GetAliFileUrl(string path)
        {
            if (string.IsNullOrWhiteSpace(path))
            {
                return null;
            }
            else
            {
                string p = @"(http|https)://(?<domain>[^(:|/]*)";
                Regex reg = new Regex(p, RegexOptions.IgnoreCase);
                string value = reg.Match(path).Value;
                if (!string.IsNullOrEmpty(value))
                {
                    return path;
                }
                else
                {
                    return GetAliOssFileUrl + path;
                }
            }
        }

        /// <summary>
        /// 获取文件相对路径
        /// </summary>
        public static string GetFilePath(string path)
        {
            if (!string.IsNullOrWhiteSpace(path))
            {
                string p = @"(http|https)://(?<domain>[^(:|/]*)";
                Regex reg = new Regex(p, RegexOptions.IgnoreCase);
                string value = reg.Match(path).Value;
                if (!string.IsNullOrEmpty(value))
                {
                    Uri url = new Uri(path);
                    return url.AbsolutePath;
                }
                else
                {
                    return path;
                }
            }
            else
            {
                return path;
            }
        }

        /// <summary>
        /// 上传站点地址
        /// </summary>
        public static string UploadSiteUrl
        {
            get
            {
                return ReadConfigKey("UploadSiteUrl");
            }
        }


        /// <summary>
        /// 上传文件预览站点
        /// </summary>
        public static string ViewFileSiteUrl
        {
            get
            {
                return ReadConfigKey("ViewFileSiteUrl");
            }
        }

        /// <summary>
        /// 导出文件保存路径
        /// </summary>
        public static string FileExportPath
        {
            get
            {
                string fileExportPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "ExportFile");
                if (!Directory.Exists(fileExportPath))
                {
                    Directory.CreateDirectory(fileExportPath);
                }
                return fileExportPath;
            }
        }

        /// <summary>
        /// 获取虚拟目录
        /// </summary>
        public static string VirtualDirectory
        {
            get
            {
                return ReadConfigKey("VirtualDirectory");
            }
        }

        /// <summary>
        /// Mongo连接地址
        /// </summary>
        public static string Mongo
        {
            get
            {
                return ReadConfigKey("Mongo");
            }
        }

        /// <summary>
        /// 获取MongoDBName
        /// </summary>
        public static string MongoDBName
        {
            get
            {
                return ReadConfigKey("MongoDBName");
            }
        }

        /// <summary>
        /// 小程序发布程序路径
        /// </summary>
        public static string ProjectUrl
        {
            get
            {
                return ReadConfigKey("ProjectUrl");
            }
        }

        /// <summary>
        /// 小程序开发工具端口号
        /// </summary>
        public static string DeveloperKitsPort
        {
            get
            {
                return ReadConfigKey("DeveloperKitsPort");
            }
        }

        /// <summary>
        /// 小程序生成二维码跳转地址
        /// </summary>
        public static string FirstPage
        {
            get
            {
                return ReadConfigKey("FirstPage");
            }
        }


        /// <summary>
        /// 抖音发送消息模板
        /// </summary>
        public static string ByteDanceSendTemplate
        {
            get
            {
                return ReadConfigKey("ByteDanceSendTemplate");
            }
        }

        /// <summary>
        /// 微信支付成功接口处理地址
        /// </summary>
        public static string sTenpayNotify
        {
            get
            {
                return ReadConfigKey("sTenpayNotify");
            }
        }

        /// <summary>
        /// 微信充值支付成功接口处理地址
        /// </summary>
        public static string sTenpayRechargeNotify
        {
            get
            {
                return ReadConfigKey("sTenpayRechargeNotify");
            }
        }
        /// <summary>
        /// 微信充值支付成功接口处理地址
        /// </summary>
        public static string sTenpayPointNotify
        {
            get
            {
                return ReadConfigKey("sTenpayPointNotify");
            }
        }
        /// <summary>
        /// 微信购买支付成功接口处理地址
        /// </summary>
        public static string sTenpayMemberBuyNotify
        {
            get
            {
                return ReadConfigKey("sTenpayMemberBuyNotify");
            }
        }

        /// <summary>
        /// VIP购买会员微信购买支付成功接口处理地址
        /// </summary>
        public static string sTenpayVipBuyNotify
        {
            get
            {
                return ReadConfigKey("sTenpayVipBuyNotify");
            }
        }
        /// <summary>
        /// 储值卡购买支付成功接口处理地址
        /// </summary>
        public static string sTenpayDepositNotify
        {
            get
            {
                return ReadConfigKey("sTenpayDepositNotify");
            }
        }

        /// <summary>
        /// 赞羊教育活动报名支付成功接口处理地址
        /// </summary>
        public static string sTenpayActivityNotify
        {
            get
            {
                return ReadConfigKey("sTenpayActivityNotify");
            }
        }


        /// <summary>
        /// 网络主管的id，用于新建供应商账户的时候的创建人
        /// </summary>
        public static string NetworkDirector
        {
            get
            {
                return ReadConfigKey("NetworkDirector");
            }
        }

        /// <summary>
        /// 收款创建人的id，用于新建供应商账户的时候的创建人
        /// </summary>
        public static string IncomeDirector
        {
            get
            {
                return ReadConfigKey("IncomeDirector");
            }
        }

        /// <summary>
        /// 收款创建人公司id
        /// </summary>
        public static string IncomeBranchId
        {
            get
            {
                return ReadConfigKey("IncomeBranchId");
            }
        }

        /// <summary>
        /// 收款创建人部门
        /// </summary>
        public static string IncomeDepartment
        {
            get
            {
                return ReadConfigKey("IncomeDepartment");
            }
        }

        /// <summary>
        /// 付款创建人的id，用于新建供应商账户的时候的创建人
        /// </summary>
        public static string ExpendDirector
        {
            get
            {
                return ReadConfigKey("ExpendDirector");
            }
        }

        /// <summary>
        /// 付款创建人公司id
        /// </summary>
        public static string ExpendBranchId
        {
            get
            {
                return ReadConfigKey("ExpendBranchId");
            }
        }


        /// <summary>
        /// 付款创建人部门
        /// </summary>
        public static string ExpendDepartment
        {
            get
            {
                return ReadConfigKey("ExpendDepartment");
            }
        }

        /// <summary>
        /// 数据库地址
        /// </summary>
        public static string RebornDMC
        {
            get
            {
                return ReadConfigKey("RebornDMC");
            }
        }

        /// <summary>
        /// 公司id
        /// </summary>
        public static string RB_Branch_Id
        {
            get
            {
                return ReadConfigKey("RB_Branch_Id");
            }
        }

        /// <summary>
        /// 生成收入财务单据
        /// </summary>
        public static string IncomeFinanceApi
        {
            get
            {
                return ReadConfigKey("IncomeFinanceApi");
            }
        }

        /// <summary>
        /// 生成收入财务单据
        /// </summary>
        public static string PropertyApi
        {
            get
            {
                return ReadConfigKey("PropertyApi");
            }
        }

        /// <summary>
        /// 生成收入财务单据
        /// </summary>
        public static string IsNormalServer
        {
            get
            {
                return ReadConfigKey("IsNormalServer");
            }
        }

        /// <summary>
        /// 财务单据请求参数Key
        /// </summary>
        public static string FinanceKey
        {
            get
            {
                return ReadConfigKey("FinanceKey");
            }
        }

        /// <summary>
        /// 生成付款成本财务单据
        /// </summary>
        public static string PaymentFinanceApi
        {
            get
            {
                return ReadConfigKey("PaymentFinanceApi");
            }
        }

        /// <summary>
        /// 电商erp订单  原路退款
        /// </summary>
        public static string ZYRefundFinanceApi
        {
            get
            {
                return ReadConfigKey("ZYRefundFinanceApi");
            }
        }

        /// <summary>
        /// 微信支付结算率0.60%
        /// </summary>
        public static string SettlementRate
        {
            get
            {
                return ReadConfigKey("SettlementRate");
            }
        }

        /// <summary>
        /// 资产管理数据库
        /// </summary>
        public static string PropertyDB
        {
            get
            {
                return ReadConfigKey("PropertyDB");
            }
        }
        /// <summary>
        /// 服务获取微信支付证书路径
        /// </summary>
        public static string PayCertificateUrl
        {
            get
            {
                return ReadConfigKey("PayCertificateUrl");
            }
        }
        /// <summary>
        /// 活动收入生成财务单据
        /// </summary>
        public static string EduActivityIncomeFinanceId
        {
            get
            {
                return ReadConfigKey("EduActivityIncomeFinanceId");
            }
        }

        /// <summary>
        /// 活动退款生成财务单据
        /// </summary>
        public static string EduActivityExpendFinanceId
        {
            get
            {
                return ReadConfigKey("EduActivityExpendFinanceId");
            }
        }

    }
}