﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiFilter]
    [EnableCors("AllowCors")]
    public class PApiController : ControllerBase
    {
        /// <summary>
        /// 整理前端传递的post参数
        /// </summary>
        /// <param name="requestMsg"></param>
        /// <returns></returns>
        public RequestParm GetRequestParm()
        {
            #region 读取post参数
            var requestMsg = Request.HttpContext.Items[GlobalKey.UserPostInfo];
            var requestParm = JsonConvert.DeserializeObject<RequestParm>(requestMsg.ToString());
            var UObj = Request.HttpContext.Items[GlobalKey.TokenUserInfo];
            if (UObj != null)
            {
                JObject parms = JObject.Parse(UObj.ToString());
                requestParm.uid = parms.GetStringValue("uid");
            }
            #endregion
            //根据token 获取uid
            return requestParm;
        }
    }
}