﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Common.Plugin
{
    /// <summary>
    /// 枚举帮助类
    /// </summary>
    public class RSAHelper
    {
        //Erp公钥
        static string TargetPublicKey = @"<RSAKeyValue><Modulus>qr3Hipzvvn9dsFn1juGEM5vHiYl4whHnJ7DFqC4ZVAotL0bRCZd7vWvPl53AJY9p8u2hNgPP3J6/I5NairyCiizW++8kCPue1Lpq9qc9ueBwij1bo5Sqi1nswpJsKyd9kOD5aOzqrnuhKTLYMZN9fkHl3L4wjpuVz1xlTgpYdxc=</Modulus><Exponent>AQAB</Exponent></RSAKeyValue>";
        //小程序私钥
        //static string PublicKey = @"<RSAKeyValue><Modulus>4W8WliHbSkVE20kIze0KvCIOJgwG4PSRHHb6LNjc3smttrU952pGFi7g7dly1tj+oNUpCB5Ba5a1EUQI9vlfCXUYRICdiNneW6T78BFED5x8HZp8JUCMeatD8wFrKPVV4twaj2QtqGsTw60ZVmVFzHi/eNLVBYvfnzKCGCp0dG8=</Modulus><Exponent>AQAB</Exponent></RSAKeyValue>";
        static string PrivateKey = @"<RSAKeyValue><Modulus>4W8WliHbSkVE20kIze0KvCIOJgwG4PSRHHb6LNjc3smttrU952pGFi7g7dly1tj+oNUpCB5Ba5a1EUQI9vlfCXUYRICdiNneW6T78BFED5x8HZp8JUCMeatD8wFrKPVV4twaj2QtqGsTw60ZVmVFzHi/eNLVBYvfnzKCGCp0dG8=</Modulus><Exponent>AQAB</Exponent><P>97qvHs/ptDJiw+FGvqvNLOJX1TJPbed9sfNNEhAZe+x/XPQfnzu0IxEkIxH/BL29gVryWExH8b/ZcgQuXCpUsw==</P><Q>6PXZPVntcKdo4ZlbQAU/+VI47rAZGkNtW/w25UVGrVC31Zc3GSqCVlKZgccRe6/PLrjOUBKDRYiYd3Yj+azXVQ==</Q><DP>ciyzW3Md1jRGutrQHT7XUHF9Y8BNRW0kzGhDRCjxZeEpDjFhhaUhr+vNiPBZZdkBR2YgPbviiLQQRvFQYKAN6w==</DP><DQ>AgBSrG9AVe5qPT3nBcbFxOuK56oFnS8lGlwxUIjm0YhW+/O/mmy+D+XHwdCm+swI2Jrn0tJF5GwG+0e9iWCNvQ==</DQ><InverseQ>WsKgSM0RiMFpXGoyL8bqZi2q1MAB+iz4WXPcL/OmHKluo8wuK/Pk+zOKkyjMO91tKXhjLOd7xpVb1AIsk/fAeQ==</InverseQ><D>daiCNFd1WZ0vo/fJZZkLWke39LmgOXbL6fxa9F83X/wI82xC4+4+qENNWDZ+zo2w0AaRBNCtulaNKHbG6wgaRh15yuOHkr90oydquHHPUqCjFWnIEYx2NnX85HtyBTwowCeePajCTsEi6vMRgKlBCIFWxqc6z5To1lTgfqtKb8k=</D></RSAKeyValue>";
        static RSACryptoServiceProvider rsaProvider = new RSACryptoServiceProvider(1024);

        /// <summary>
        /// 加密
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static byte[] EncryptData(byte[] data)
        {

            RSACryptoServiceProvider rsa = new RSACryptoServiceProvider(1024);

            //将公钥导入到RSA对象中，准备加密；
            rsa.FromXmlString(TargetPublicKey);

            //对数据data进行加密，并返回加密结果；
            //第二个参数用来选择Padding的格式
            byte[] buffer = rsa.Encrypt(data, false);
            return buffer;
        }

        /// <summary>
        /// 解密
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static byte[] DecryptData(byte[] data)
        {

            RSACryptoServiceProvider rsa = new RSACryptoServiceProvider(1024);

            //将私钥导入RSA中，准备解密；
            rsa.FromXmlString(PrivateKey);

            //对数据进行解密，并返回解密结果；
            return rsa.Decrypt(data, false);

        }

    }
}
