﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Model.Extend.User;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Mall.Common.Enum.User;
using Newtonsoft.Json.Linq;
using Mall.Common;
using Mall.Module.Finance;
using Mall.Model.Extend.Finance;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Configuration.Json;
using Mall.Model.Extend.Product;
using Mall.Module.Product;

namespace Mall.WebApi.Controllers.Finance
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class ERPOrderCommissionController : ControllerBase
    {
        private readonly UserModule userModule = new UserModule();
        private readonly OrderModule orderModule = new OrderModule();

        #region erp查询分销情况

        /// <summary>
        /// 用户返佣列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetDistributionCommissionPageList(object request)
        {
            //处理数据
            //byte[] data = System.Text.ASCIIEncoding.ASCII.GetBytes(request.ToString());
            //var parms = System.Text.ASCIIEncoding.ASCII.GetString(Mall.Common.Plugin.RSAHelper.DecryptData(data));
            var requestParm = JsonConvert.DeserializeObject<RequestParm>(request.ToString());
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(requestParm.msg.ToString());
            RB_Member_User_Extend demodel = JsonConvert.DeserializeObject<RB_Member_User_Extend>(requestParm.msg.ToString());

            demodel.TenantId = Convert.ToInt32(new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("FinanceSetting")["TenantId"]);
            demodel.MallBaseId = Convert.ToInt32(new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("FinanceSetting")["MallBaseId"]);
            demodel.IsDistributor = 1;
            var list = userModule.GetDistributionCommissionPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list;
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 用户订单返佣列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetDistributionOrderCommissionPageList(object request)
        {
            //处理数据
            //byte[] data = System.Text.ASCIIEncoding.ASCII.GetBytes(request.ToString());
            //var parms = System.Text.ASCIIEncoding.ASCII.GetString(Mall.Common.Plugin.RSAHelper.DecryptData(data));
            var requestParm = JsonConvert.DeserializeObject<RequestParm>(request.ToString());
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(requestParm.msg.ToString());
            RB_Goods_OrderCommission_Extend demodel = JsonConvert.DeserializeObject<RB_Goods_OrderCommission_Extend>(requestParm.msg.ToString());
            if ((demodel.UserId ?? 0) <= 0) {
                return ApiResult.ParamIsNull("请传递用户id");
            }
            demodel.TenantId = Convert.ToInt32(new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("FinanceSetting")["TenantId"]);
            demodel.MallBaseId = Convert.ToInt32(new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("FinanceSetting")["MallBaseId"]);
            var list = orderModule.GetERPDistributionOrdersPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.OrderId,
                x.OrderNo,
                x.Grade,
                x.GradeDescription,
                DetailList = x.OrderDetailList.Select(y => new {
                    y.Id,
                    y.CoverImagePath,
                    y.OrderType,
                    OrderTypeName = y.OrderType.GetEnumName(),
                    y.GoodsName,
                    SpecificationList = JsonConvert.DeserializeObject<List<string>>(y.Specification),
                    y.ProductCode,
                    y.Final_Price,
                    y.Number
                }),
                x.UserId,
                x.UserName,
                x.Mobile,
                x.Remark,
                x.Commission,
                x.CommissionState,
                x.TenantId,
                x.MallBaseId,
                CreateDate = x.CreateDate.HasValue ? x.CreateDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : ""
            });
            return ApiResult.Success("", pagelist);
        }

        #endregion
    }
}