﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Entity.BaseSetUp;
using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Entity.User;
using Mall.Model.Extend.BaseSetUp;
using Mall.Model.Extend.MarketingCenter;
using Mall.Model.Extend.User;
using Mall.Module.BaseSetUp;
using Mall.Module.MarketingCenter;
using Mall.Module.Product;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;


namespace Mall.WebApi.Controllers.MallBase
{
    /// <summary>
    /// 小程序商城控制器
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]

    public class MallController : BaseController
    {
        /// <summary>
        /// 商户账号处理类
        /// </summary>
        private readonly Module.User.TenantModule TenantModule = new Module.User.TenantModule();

        /// <summary>
        /// 商户小程序处理类
        /// </summary>
        private readonly Module.User.MiniProgramModule programModule = new Module.User.MiniProgramModule();


        /// <summary>
        /// 自定义页面处理类
        /// </summary>
        private readonly MiniprogramPageTemplModule miniprogramPageTemplModule = new MiniprogramPageTemplModule();

        /// <summary>
        /// 自定义模板处理类
        /// </summary>
        private readonly MiniprogramTemplateModule miniprogramTemplateModule = new MiniprogramTemplateModule();

        /// <summary>
        /// 产品处理类
        /// </summary>
        private readonly ProductModule productModule = new ProductModule();

        /// <summary>
        /// 导航图标处理类
        /// </summary>
        private readonly MiniProgramNaviconModule programNaviconModule = new MiniProgramNaviconModule();

        /// <summary>
        /// 内容管理
        /// </summary>
        private readonly ContentModule contentModule = new ContentModule();

        /// <summary>
        /// 用户处理类
        /// </summary>
        private readonly UserModule userModule = new UserModule();

        /// <summary>
        /// 小程序基础配置
        /// </summary>
        private readonly MallBaseModule mallBaseModule = new MallBaseModule();

        /// <summary>
        /// 用户积分
        /// </summary>
        private readonly IntegralModule integralModule = new IntegralModule();

        /// <summary>
        /// 小程序页面处理类
        /// </summary>
        private Module.User.MiniProgramPageModule programPageModule = new Module.User.MiniProgramPageModule();

        /// <summary>
        /// 小程序首页
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetHome()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            string MiniAppId = "";
            try
            {
                //小程序Id
                MiniAppId = RequestParm.MiniAppId;
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Error("MallController_GetHome", ex);
            }
            var homePage = new object();
            //底部导航
            var navbar = new object();
            var setting = new object();
            var share_setting = new object();
            var cat_style = new object();
            //授权页面
            var auth_page = new object();
            if (MiniAppId != null && !string.IsNullOrEmpty(MiniAppId))
            {
                //获取小程序信息
                var miniProgram = programModule.GetMiniProgramModule(new Model.Extend.User.RB_MiniProgram_Extend() { MiniAppId = MiniAppId }, isGetHomeData: true, isGetNav: 1);
                if (miniProgram != null && miniProgram.MallBaseId > 0)
                {
                    //底部导航
                    navbar = new
                    {
                        //底部导航背景颜色
                        bottom_background_color = miniProgram.BottomNavBgColor,
                        //顶部导航背景颜色
                        top_background_color = miniProgram.TopNavBgColor,
                        //顶部标题文字颜色
                        top_text_color = miniProgram.TopNavWordColor,
                        //导航底部是否开启阴影效果(0-未开启，1-开启)
                        shadow = miniProgram.BottomNavIsShadow,
                        //导航栏
                        navs = miniProgram.BottomTagList.Select(qitem => new
                        {
                            active_color = qitem.CheckedColor,
                            active_icon = qitem.CheckedIcon,
                            color = qitem.DefaultColor,
                            text = qitem.TagName,
                            icon = qitem.DefaultIcon,
                            url = qitem.TagLink,
                            open_type = "redirect",
                            key = qitem.TagLink == "/pages/live/index" ? "live" : "",
                        }),
                    };
                    //授权页面热区
                    var hotspotCancel = new object();
                    var hotspotLogin = new object();
                    if (miniProgram.AuthDataList != null && miniProgram.AuthDataList.Count > 0 && miniProgram.AuthDataList.Count == 2)
                    {
                        var first = miniProgram.AuthDataList[0];
                        var second = miniProgram.AuthDataList[1];
                        if (first.open_type == "login")
                        {
                            hotspotLogin = first;
                            hotspotCancel = second;
                        }
                        else
                        {
                            hotspotLogin = second;
                            hotspotCancel = first;
                        }
                    }
                    else
                    {
                        hotspotLogin = new AuthItem()
                        {
                            width = 224,
                            height = 80,
                            left = 340,
                            top = 566,
                            defaultX = 340,
                            defaultY = 566,
                            link = "",
                            open_type = "login"
                        };
                        hotspotCancel = new AuthItem()
                        {
                            width = 224,
                            height = 80,
                            left = 84,
                            top = 566,
                            defaultX = 84,
                            defaultY = 566,
                            link = "",
                            open_type = "cancel"
                        };
                    }
                    auth_page = new
                    {
                        pic_url = miniProgram.AuthUrl,
                        hotspot = hotspotLogin,
                        hotspot_cancel = hotspotCancel
                    };

                    var selfHomePage = miniprogramPageTemplModule.GetMiniprogramPageTemplModule(new RB_Miniprogram_Page_Templ_Extend()
                    {
                        MallBaseId = miniProgram.MallBaseId,
                        TenantId = miniProgram.TenantId,
                    }, isGetHome: true);
                    List<object> list = new List<object>();
                    //自定义首页
                    if (selfHomePage != null && selfHomePage.Id > 0)
                    {
                        //获取模板编号
                        string templateIds = string.Join(",", selfHomePage.DetailsList.Select(qitem => qitem.TemplateId));
                        var templateList = miniprogramTemplateModule.GetMiniprogramTemplateListModule(new Model.Extend.MarketingCenter.RB_Miniprogram_Template_Extend()
                        {
                            MallBaseId = miniProgram.MallBaseId,
                            TenantId = miniProgram.TenantId,
                            QIds = templateIds
                        }, IsAnalyzePlus: true);
                        //解析模板
                        foreach (var item in templateList)
                        {
                            var detailsModel = selfHomePage?.DetailsList?.Where(qitem => qitem.TemplateId == item.Id)?.FirstOrDefault();
                            var templateData = new
                            {
                                id = detailsModel?.Id ?? 0,
                                name = detailsModel?.NavName ?? "",
                                data = new List<object>()
                            };
                            if (item.ComponentDataList != null && item.ComponentDataList.Count() > 0)
                            {
                                foreach (var subItem in item.ComponentDataList)
                                {
                                    templateData.data.Add(PlusDataToObject(subItem, (miniProgram?.TenantId ?? 0), miniProgram.MallBaseId));
                                }
                            }
                            var tempObj = new
                            {
                                id = item.Id,
                                name = item.TemplateName,
                                page_id = 0,
                                template_id = item.Id,
                                template = templateData
                            };
                            list.Add(tempObj);
                        }

                        homePage = new
                        {
                            id = miniProgram.MallBaseId,
                            title = miniProgram.MallName,
                            show_navs = selfHomePage.IsShowNav,
                            is_home_page = selfHomePage.IsHome,
                            navs = list
                        };
                    }
                    //自定义首页布局
                    else
                    {
                        //配置了首页
                        if (miniProgram.HomeDataList != null && miniProgram.HomeDataList.Count > 0)
                        {
                            var templateData = new
                            {
                                id = 0,
                                name = "",
                                data = new List<object>()
                            };
                            foreach (var subitem in miniProgram.HomeDataList)
                            {
                                switch (subitem.key)
                                {
                                    //搜索框
                                    case "search":
                                        templateData.data.Add(new
                                        {
                                            id = subitem.key,
                                            data = new searchItem()
                                            {
                                                color = "#FFFFFF",
                                                background = "#f2f2f2", //背景颜色
                                                radius = 4, //圆角
                                                placeholder = "搜索", //提示文字
                                                textColor = "#555555", //文字颜色
                                                textPosition = "left" //文字位置
                                            }
                                        });
                                        templateData.data.Add(new
                                        {
                                            id = "empty",
                                            data = new emptyItem()
                                            {
                                                background = "#ffffff",
                                                height = 10
                                            }
                                        });
                                        break;

                                    //轮播图
                                    case "banner":
                                        var bannerList = programModule.GetMallNavListModule(new Model.Entity.User.RB_Mall_Nav_Extend() { TenantId = miniProgram.TenantId, MallBaseId = miniProgram.MallBaseId });
                                        var detailsBannerList = new List<bannerDetailItem>();
                                        if (bannerList != null && bannerList.Count > 0)
                                        {
                                            foreach (var bItem in bannerList)
                                            {
                                                detailsBannerList.Add(new bannerDetailItem()
                                                {
                                                    url = bItem.NavLink,
                                                    picUrl = Common.Config.GetFileUrl(bItem.NavImg)
                                                });
                                            }
                                        }
                                        templateData.data.Add(new
                                        {
                                            id = subitem.key,
                                            data = new bannerItem()
                                            {
                                                style = 1, //样式
                                                fill = 1, //填充方式0-留白 1填充
                                                height = 450, //默认高度
                                                banners = detailsBannerList
                                            }
                                        });
                                        templateData.data.Add(new
                                        {
                                            id = "empty",
                                            data = new emptyItem()
                                            {
                                                background = "#ffffff",
                                                height = 10
                                            }
                                        });
                                        break;
                                    //导航图标
                                    case "home_nav":
                                        var navList = programNaviconModule.GetMiniProgramNaviconListModule(new RB_MiniProgram_Navicon_Extend()
                                        {
                                            MallBaseId = miniProgram.MallBaseId
                                        });
                                        List<navIconItem> navs = new List<navIconItem>();
                                        if (navList != null && navList.Count > 0)
                                        {
                                            foreach (var nItem in navList)
                                            {
                                                navs.Add(new navIconItem()
                                                {
                                                    icon = Common.Config.GetFileUrl(nItem.NavIconImg),
                                                    url = nItem.NavIconUrl,
                                                    key = "",
                                                    name = nItem.NavIconName,
                                                    openType = ""
                                                });
                                            }
                                        }
                                        templateData.data.Add(new
                                        {
                                            id = "nav",
                                            data = new navItem()
                                            {
                                                color = "#353535",
                                                rows = 1,//每页行数
                                                columns = subitem.row_num, //每行个数 
                                                scroll = true, //左右滑动
                                                showImg = false, //背景图片
                                                backgroundColor = "#ffffff", //背景颜色
                                                backgroundPicUrl = "", //背景链接
                                                position = 5, //图片位置
                                                mode = 1, //填充方式
                                                backgroundHeight = 100, //背景图宽
                                                backgroundWidth = 100, //背景图高
                                                navs = navs, //导航图标
                                            }
                                        });
                                        templateData.data.Add(new
                                        {
                                            id = "empty",
                                            data = new emptyItem()
                                            {
                                                background = "#ffffff",
                                                height = 10
                                            }
                                        });
                                        break;

                                    //视频插件
                                    case "video":
                                        templateData.data.Add(new
                                        {
                                            id = subitem.key,
                                            data = new videoItem()
                                            {
                                                pic_url = Common.Config.GetFileUrl(subitem.video_pic_url),
                                                url = subitem.video_url,
                                            }
                                        });
                                        templateData.data.Add(new
                                        {
                                            id = "empty",
                                            data = new emptyItem()
                                            {
                                                background = "#ffffff",
                                                height = 10
                                            }
                                        });
                                        break;
                                    //公告
                                    case "notice":
                                        templateData.data.Add(new
                                        {
                                            id = subitem.key,
                                            data = new noticeItem()
                                            {
                                                name = subitem.NoticeName, //公告名称
                                                content = subitem.NoticeContent, //公告内容
                                                icon = Common.Config.GetFileUrl(subitem.notice_url), //公告图标
                                                textColor = subitem.notice_text_color, //文字颜色
                                                background = subitem.notice_bg_color, //背景颜色
                                                headerUrl = "", //头部图片
                                                btnColor = "#ff4544", //按钮颜色
                                                btnWidth = 500, //按钮宽度 
                                                btnHeight = 80, //按钮高度 
                                                btnRadius = 40, //按钮圆角 
                                                btnText = "我知道了", //按钮文本内容
                                                btnTextColor = "#ffffff" //按钮文本颜色
                                            }
                                        });
                                        templateData.data.Add(new
                                        {
                                            id = "empty",
                                            data = new emptyItem()
                                            {
                                                background = "#ffffff",
                                                height = 10
                                            }
                                        });
                                        break;
                                    //专题
                                    case "topic":
                                        var topicSourceList = contentModule.GetTopicListModule(new Model.Entity.User.RB_Topic_Extend()
                                        {
                                            MallBaseId = miniProgram.MallBaseId,
                                            TenantId = miniProgram.TenantId,
                                        });
                                        var topic_list = new List<topicDetailsItem>();
                                        if (topicSourceList != null && topicSourceList.Count > 0)
                                        {
                                            foreach (var tItem in topicSourceList)
                                            {
                                                topic_list.Add(new topicDetailsItem()
                                                {
                                                    cover_pic = Common.Config.GetFileUrl(tItem.CoverImg),
                                                    read_count = 0,
                                                    title = tItem.Title,
                                                    id = tItem.Id,
                                                    layout = 0
                                                });
                                            }
                                        }
                                        templateData.data.Add(new
                                        {
                                            id = subitem.key,
                                            data = new topicItem()
                                            {
                                                style = "normal",
                                                count = subitem.topic_num,
                                                logo_1 = Common.Config.GetFileUrl(subitem.topic_url),
                                                logo_2 = Common.Config.GetFileUrl(subitem.topic_url_2),
                                                icon = Common.Config.GetFileUrl(subitem.label_url),
                                                cat_show = false,
                                                list = new List<topicTypeItem>(),
                                                topic_list = topic_list
                                            }
                                        });
                                        templateData.data.Add(new
                                        {
                                            id = "empty",
                                            data = new emptyItem()
                                            {
                                                background = "#ffffff",
                                                height = 10
                                            }
                                        });
                                        break;
                                    //领劵中心
                                    case "coupon":

                                        break;
                                    //商品分类
                                    case "cat":
                                        var cats = new catItem()
                                        {
                                            goodsNum = 6,
                                            id = subitem.relation_id,
                                            menuName = subitem.name,
                                            name = subitem.name,
                                            staticGoods = false,
                                            goodsList = new List<GoodsDetailsItem2>()
                                        };
                                        if (subitem.relation_id == 0)
                                        {
                                            var goodsList = productModule.GetProductGoodsPageList(1, 6, out long rowsCount, new Model.Extend.Product.RB_Goods_Extend()
                                            {
                                                TenantId = Convert.ToInt32(miniProgram.TenantId),
                                                MallBaseId = miniProgram.MallBaseId
                                            });
                                            if (goodsList != null && goodsList.Count > 0)
                                            {

                                                foreach (var gItem in goodsList)
                                                {
                                                    cats.goodsList.Add(new GoodsDetailsItem2()
                                                    {
                                                        id = gItem.Id,
                                                        price = Math.Round(gItem?.SellingPrice ?? 0, 2),
                                                        name = gItem.Name,
                                                        picUrl = Common.Config.GetFileUrl(gItem.CoverImage),
                                                        OriginalPrice = Math.Round(gItem?.OriginalPrice ?? 0, 2)
                                                    });
                                                }
                                            }
                                        }
                                        else
                                        {
                                            var goodsList = productModule.GetProductGoodsPageList(1, 6, out long rowsCount, new Model.Extend.Product.RB_Goods_Extend()
                                            {
                                                TenantId = Convert.ToInt32(miniProgram.TenantId),
                                                MallBaseId = miniProgram.MallBaseId,
                                                CategoryIds = subitem.relation_id.ToString()
                                            });
                                            if (goodsList != null && goodsList.Count > 0)
                                            {
                                                foreach (var gItem in goodsList)
                                                {
                                                    cats.goodsList.Add(new GoodsDetailsItem2()
                                                    {
                                                        id = gItem.Id,
                                                        price = Math.Round(gItem?.SellingPrice ?? 0, 2),
                                                        name = gItem.Name,
                                                        picUrl = Common.Config.GetFileUrl(gItem.CoverImage),
                                                        OriginalPrice = Math.Round(gItem?.OriginalPrice ?? 0, 2)
                                                    });
                                                }
                                            }
                                        }
                                        templateData.data.Add(new
                                        {
                                            id = "goods",
                                            data = new goodsItem()
                                            {
                                                showCat = true,
                                                catPosition = "top",
                                                catStyle = 0,
                                                addGoodsType = 0,
                                                goodsLength = 6,
                                                listStyle = 3,
                                                goodsCoverProportion = "1-1",
                                                fill = 1,
                                                goodsStyle = 1,
                                                textStyle = 1,
                                                showGoodsName = true,
                                                showGoodsPrice = true,
                                                showBuyBtn = true,
                                                buyBtn = "cart",
                                                buyBtnStyle = 1,
                                                buyBtnText = "购买",
                                                buttonColor = "#ff4544",
                                                showGoodsTag = false,
                                                customizeGoodsTag = false,
                                                goodsTagPicUrl = "",
                                                showImg = false,
                                                backgroundColor = "#fff",
                                                backgroundPicUrl = "",
                                                position = 5,
                                                mode = 1,
                                                backgroundHeight = 100,
                                                backgroundWidth = 100,
                                                list = new List<GoodsDetailsItem2>(),
                                                catList = new List<catItem>() { cats }
                                            }
                                        });
                                        templateData.data.Add(new
                                        {
                                            id = "empty",
                                            data = new emptyItem()
                                            {
                                                background = "#ffffff",
                                                height = 10
                                            }
                                        });
                                        break;
                                    //图片魔方
                                    case "block":
                                        var blockSource = programModule.GetMallMagicListModule(new Model.Entity.User.RB_Mall_Magic_Extend()
                                        {
                                            MallBaseId = miniProgram.MallBaseId,
                                            TenantId = Convert.ToInt32(miniProgram.TenantId),
                                            Id = subitem.relation_id
                                        }).FirstOrDefault();
                                        if (blockSource != null && blockSource.Id > 0)
                                        {
                                            var rubikData = new rubikItem()
                                            {
                                                style = Convert.ToInt32(blockSource.Style),
                                                space = 0,
                                                list = new List<rubikDetailItem>(),
                                            };
                                            switch (rubikData.style)
                                            {
                                                //1张图
                                                case 0:
                                                    rubikData.height = "360";
                                                    rubikData.w = "1";
                                                    rubikData.h = 1;
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 1,
                                                        h = 1,
                                                        x = 0,
                                                        y = 0,
                                                        link = new List<rubikLinkItem>() {
                                                        new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[0].Link
                                                        }
                                                        },
                                                        width = "calc(100%)",
                                                        height = "calc(100%)",
                                                        left = "0%",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    break;
                                                //两张图
                                                case 1:
                                                    rubikData.height = "360";
                                                    rubikData.w = "25";
                                                    rubikData.h = 12;
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 10,
                                                        h = 12,
                                                        x = 0,
                                                        y = 0,
                                                        link = new List<rubikLinkItem>() {
                                                        new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[0].Link
                                                        }
                                                        },
                                                        width = "calc(40%)",
                                                        height = "calc(100%)",
                                                        left = "0%",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 15,
                                                        h = 12,
                                                        x = 10,
                                                        y = 0,
                                                        link = new List<rubikLinkItem>() {
                                                         new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[1].Link
                                                        }
                                                        },
                                                        width = "calc(60%)",
                                                        height = "calc(100%)",
                                                        left = "calc(40%)",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[1].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    break;
                                                //三张图
                                                case 2:
                                                    rubikData.height = "360";
                                                    rubikData.w = "25";
                                                    rubikData.h = 12;
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 10,
                                                        h = 12,
                                                        x = 0,
                                                        y = 0,
                                                        link = new List<rubikLinkItem>()
                                                        {
                                                        new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[0].Link
                                                        }
                                                        },
                                                        width = "calc(40%)",
                                                        height = "calc(100%)",
                                                        left = "0%",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 15,
                                                        h = 6,
                                                        x = 10,
                                                        y = 0,
                                                        link = new List<rubikLinkItem>() {
                                                        new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[1].Link
                                                        }
                                                        },
                                                        width = "calc(60%)",
                                                        height = "calc(50%)",
                                                        left = "calc(40%)",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[1].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 15,
                                                        h = 6,
                                                        x = 10,
                                                        y = 6,
                                                        link = new List<rubikLinkItem>()
                                                        {
                                                         new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[2].Link
                                                        }
                                                        },
                                                        width = "calc(60%)",
                                                        height = "calc(50%)",
                                                        left = "calc(40%)",
                                                        top = "calc(50%)",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[2].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    break;
                                                //四张图
                                                case 3:
                                                    rubikData.height = "360";
                                                    rubikData.w = "50";
                                                    rubikData.h = 24;
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 20,
                                                        h = 24,
                                                        x = 0,
                                                        y = 0,
                                                        link = new List<rubikLinkItem>() {
                                                        new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[0].Link
                                                        }
                                                        },
                                                        width = "calc(40%)",
                                                        height = "calc(100%)",
                                                        left = "0%",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 30,
                                                        h = 12,
                                                        x = 20,
                                                        y = 0,
                                                        link = new List<rubikLinkItem>() {
                                                        new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[1].Link
                                                        }
                                                        },
                                                        width = "calc(60%)",
                                                        height = "calc(50%)",
                                                        left = "calc(40%)",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[1].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 15,
                                                        h = 12,
                                                        x = 20,
                                                        y = 12,
                                                        link = new List<rubikLinkItem>() {
                                                        new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[2].Link
                                                        }
                                                        },
                                                        width = "calc(30%)",
                                                        height = "calc(50%)",
                                                        left = "calc(40%)",
                                                        top = "calc(50%)",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[2].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 15,
                                                        h = 12,
                                                        x = 35,
                                                        y = 12,
                                                        link = new List<rubikLinkItem>() {
                                                        new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[3].Link
                                                        }
                                                        },
                                                        width = "calc(30%)",
                                                        height = "calc(50%)",
                                                        left = "calc(70%)",
                                                        top = "calc(50%)",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[3].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    break;
                                                //两张平分图
                                                case 4:
                                                    rubikData.height = "240";
                                                    rubikData.w = "50";
                                                    rubikData.h = 16;
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 25,
                                                        h = 16,
                                                        x = 0,
                                                        y = 0,
                                                        link = new List<rubikLinkItem>() {
                                                        new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[0].Link
                                                        }
                                                        },
                                                        width = "calc(50%)",
                                                        height = "calc(100%)",
                                                        left = "0%",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 25,
                                                        h = 16,
                                                        x = 25,
                                                        y = 0,
                                                        link = new List<rubikLinkItem>()
                                                        {
                                                             new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[1].Link
                                                        }
                                                        },
                                                        width = "calc(50%)",
                                                        height = "calc(100%)",
                                                        left = "0%",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[1].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    break;
                                                //三张平分图
                                                case 5:
                                                    rubikData.height = "240";
                                                    rubikData.w = "75";
                                                    rubikData.h = 24;
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 25,
                                                        h = 24,
                                                        x = 0,
                                                        y = 0,
                                                        link = new List<rubikLinkItem>() {
                                                        new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[0].Link
                                                        }
                                                        },
                                                        width = "calc(33.33%)",
                                                        height = "calc(100%)",
                                                        left = "0%",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 25,
                                                        h = 24,
                                                        x = 25,
                                                        y = 0,
                                                        link = new List<rubikLinkItem>()
                                                        {
                                                         new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[1].Link
                                                        }
                                                        },
                                                        width = "calc(33.33%)",
                                                        height = "calc(100%)",
                                                        left = "calc(33.33%)",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[1].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 25,
                                                        h = 24,
                                                        x = 50,
                                                        y = 6,
                                                        link = new List<rubikLinkItem>() {
                                                        new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[2].Link
                                                        }
                                                        },
                                                        width = "calc(33.34%)",
                                                        height = "calc(100%)",
                                                        left = "calc(66.66%)",
                                                        top = "calc(0%)",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[2].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    break;

                                                //四张平分
                                                case 6:
                                                    rubikData.height = "186";
                                                    rubikData.w = "4";
                                                    rubikData.h = 1;
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 1,
                                                        h = 1,
                                                        x = 0,
                                                        y = 0,
                                                        link = new List<rubikLinkItem>()
                                                        {
                                                        new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[0].Link
                                                        }
                                                        },
                                                        width = "calc(25%)",
                                                        height = "calc(100%)",
                                                        left = "0%",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 1,
                                                        h = 1,
                                                        x = 1,
                                                        y = 0,
                                                        link = new List<rubikLinkItem>() {
                                                         new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[1].Link
                                                        }
                                                        },
                                                        width = "calc(25%)",
                                                        height = "calc(100%)",
                                                        left = "calc(25%)",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[1].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 1,
                                                        h = 1,
                                                        x = 2,
                                                        y = 0,
                                                        link = new List<rubikLinkItem>()
                                                        {
                                                        new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[2].Link
                                                        }
                                                        },
                                                        width = "calc(25%)",
                                                        height = "calc(100%)",
                                                        left = "calc(50%)",
                                                        top = "calc(0%)",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[2].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 1,
                                                        h = 1,
                                                        x = 3,
                                                        y = 0,
                                                        link = new List<rubikLinkItem>()
                                                            {
                                                        new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[3].Link
                                                        }
                                                    },
                                                        width = "calc(25%)",
                                                        height = "calc(100%)",
                                                        left = "calc(75%)",
                                                        top = "calc(0%)",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[3].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    break;
                                                //四张上下平分
                                                case 7:
                                                    rubikData.height = "372";
                                                    rubikData.w = "250";
                                                    rubikData.h = 124;
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 125,
                                                        h = 62,
                                                        x = 0,
                                                        y = 0,
                                                        link = new List<rubikLinkItem>()
                                                        {
                                                         new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[0].Link
                                                        }
                                                        },
                                                        width = "calc(50%)",
                                                        height = "calc(50%)",
                                                        left = "0%",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[0].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 125,
                                                        h = 62,
                                                        x = 125,
                                                        y = 0,
                                                        link = new List<rubikLinkItem>()
                                                        {
                                                        new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[1].Link
                                                        }
                                                        },
                                                        width = "calc(50%)",
                                                        height = "calc(50%)",
                                                        left = "calc(50%)",
                                                        top = "0%",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[1].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 125,
                                                        h = 62,
                                                        x = 0,
                                                        y = 62,
                                                        link = new List<rubikLinkItem>()
                                                        {
                                                        new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[2].Link
                                                        }
                                                        },
                                                        width = "calc(50%)",
                                                        height = "calc(50%)",
                                                        left = "calc(0%)",
                                                        top = "calc(50%)",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[2].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    rubikData.list.Add(new rubikDetailItem()
                                                    {
                                                        backgroundColor = "",
                                                        numberX = 0,
                                                        numberY = 0,
                                                        w = 125,
                                                        h = 62,
                                                        x = 125,
                                                        y = 62,
                                                        link = new List<rubikLinkItem>()
                                                        {
                                                         new rubikLinkItem()
                                                        {
                                                            new_link_url = blockSource.MagicDataList[3].Link
                                                        }
                                                        },
                                                        width = "calc(50%)",
                                                        height = "calc(50%)",
                                                        left = "calc(50%)",
                                                        top = "calc(50%)",
                                                        pic_url = Common.Config.GetFileUrl(blockSource.MagicDataList[3].ImgUrl),
                                                        backgroundImage = "",
                                                        backgroundRepeat = "no-repeat",
                                                        backgroundSize = "cover",
                                                        backgroundPosition = "center"
                                                    });
                                                    break;
                                            }
                                            templateData.data.Add(new
                                            {
                                                id = "rubik",
                                                data = rubikData
                                            });
                                            templateData.data.Add(new
                                            {
                                                id = "empty",
                                                data = new emptyItem()
                                                {
                                                    background = "#ffffff",
                                                    height = 10
                                                }
                                            });
                                        }
                                        break;
                                }
                            }
                            var tempObj = new
                            {
                                id = miniProgram.MallBaseId,
                                name = "自定义首页布局",
                                page_id = miniProgram.MallBaseId,
                                template_id = miniProgram.MallBaseId,
                                template = templateData
                            };
                            list.Add(tempObj);
                            homePage = new
                            {
                                id = 0,
                                title = miniProgram.MallName,
                                show_navs = 0,
                                is_home_page = 0,
                                navs = list
                            };
                        }
                        //未配置自定义页面
                        else
                        {
                            homePage = new
                            {
                                id = miniProgram.MallBaseId,
                                title = miniProgram.MallName,
                                show_navs = 1,
                                is_home_page = 1,
                                navs = list
                            };
                        }
                    }

                    #region 基本设置
                    //基础配置 Add By:W 2020年6月1号
                    var mallBaseModel = mallBaseModule.GetListRepository(new RB_MallBase_Extend { TenantId = miniProgram.TenantId ?? 0, MallBaseId = miniProgram.MallBaseId }).FirstOrDefault();
                    //获取物流配置
                    var logisticsRules = mallBaseModule.GetLogisticsList(new RB_Logistics { TenantId = miniProgram.TenantId ?? 0, MallBaseId = miniProgram.MallBaseId }).FirstOrDefault();

                    //用户积分
                    var integralModel = integralModule.GetIntegralSettingsList(new RB_Integral_Settings { TenantId = miniProgram.TenantId ?? 0, MallBaseId = miniProgram.MallBaseId }).FirstOrDefault();

                    List<string> payment_type = new List<string>();
                    if (!string.IsNullOrWhiteSpace(mallBaseModel.PayWay))
                    {
                        foreach (var item in mallBaseModel.PayWay.Split(","))
                        {
                            switch (item)
                            {
                                case "1":
                                    payment_type.Add("online_pay");
                                    break;
                                case "2":
                                    payment_type.Add("huodao");
                                    break;
                                case "3":
                                    payment_type.Add("balance");
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                    List<string> send_type = new List<string>();
                    if (!string.IsNullOrWhiteSpace(mallBaseModel.DeliverWay))
                    {
                        foreach (var item in mallBaseModel.DeliverWay.Split(","))
                        {
                            switch (item)
                            {
                                case "1":
                                    send_type.Add("express");
                                    break;
                                case "2":
                                    send_type.Add("offline");
                                    break;
                                case "3":
                                    send_type.Add("city");
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                    List<string> good_negotiable = new List<string>();
                    if (!string.IsNullOrWhiteSpace(mallBaseModel.ConsultWay))
                    {
                        foreach (var item in mallBaseModel.ConsultWay.Split(","))
                        {
                            switch (item)
                            {
                                case "1":
                                    good_negotiable.Add("contact");
                                    break;
                                case "2":
                                    good_negotiable.Add("contact_tel");
                                    break;
                                case "3":
                                    good_negotiable.Add("contact_web");
                                    break;
                                default:
                                    break;
                            }
                        }
                    }

                    setting = new
                    {
                        contact_tel = mallBaseModel?.ContactNumber,
                        over_time = mallBaseModel?.CancelTime,
                        delivery_time = mallBaseModel?.AutoReceiving,
                        after_sale_time = mallBaseModel?.AfterTime,
                        payment_type = payment_type.ToArray(),//支付方式 
                        send_type = send_type.ToArray(),//发货方式
                        kdniao_mch_id = logisticsRules?.ExpressBirdID,//快递鸟配置
                        kdniao_api_key = logisticsRules?.ExpressBirdAPIKey,
                        member_integral = integralModel?.IntegralNum,
                        member_integral_rule = integralModel?.Explain,
                        good_negotiable = good_negotiable.ToArray(),//商品面议联系方式
                        mobile_verify = "",
                        is_small_app = mallBaseModel?.TurnMini,
                        small_app_id = mallBaseModel?.MinAppId,
                        small_app_url = mallBaseModel?.MinUrl,
                        small_app_pic = mallBaseModel?.TurnMiniIco,
                        is_customer_services = mallBaseModel?.OnlineService,
                        customer_services_pic = mallBaseModel?.OnlineServiceIco,
                        is_dial = mallBaseModel?.OneCall,
                        dial_pic = mallBaseModel?.OneCallIco,
                        is_web_service = mallBaseModel?.ServiceOutLink,
                        web_service_url = mallBaseModel?.OuterServiceLink,
                        web_service_pic = mallBaseModel?.ServiceOutLinkIco,
                        is_quick_navigation = mallBaseModel?.SuspendBtn,
                        quick_navigation_style = mallBaseModel?.SuspendStyle,
                        quick_navigation_opened_pic = mallBaseModel?.UnfoldIco,
                        quick_navigation_closed_pic = mallBaseModel?.PackUpIco,
                        is_show_stock = "",
                        is_use_stock = "",
                        sell_out_pic = "",
                        sell_out_other_pic = "",
                        is_common_user_member_price = mallBaseModel?.DetailsMemberPrice,
                        is_member_user_member_price = mallBaseModel?.DetailsVipMemberPrice,
                        is_share_price = mallBaseModel?.DetailsSharePrice,
                        is_purchase_frame = mallBaseModel?.BuySwitch,
                        purchase_num = mallBaseModel?.CarouselOrder,
                        is_comment = mallBaseModel?.DetailsComment,
                        is_sales = mallBaseModel?.DetailsBuyNum,
                        is_mobile_auth = mallBaseModel?.OtherIndexMoblie,
                        is_official_account = mallBaseModel?.OtherTencent,
                        is_manual_mobile_auth = mallBaseModel?.OtherManualMobile,
                        is_icon_members_grade = mallBaseModel?.OtherMemerLevel,
                        is_goods_video = mallBaseModel?.DetailsVideo,
                        is_quick_map = mallBaseModel?.ShortcutNavigation,
                        quick_map_pic = mallBaseModel?.ShortcutNavigationIco,
                        quick_map_address = mallBaseModel?.Address,
                        longitude = mallBaseModel?.LongAndLat.Split(",")[0],
                        latitude = mallBaseModel?.LongAndLat.Split(",")[1],
                        is_quick_home = mallBaseModel?.BackTopNavigation,
                        quick_home_pic = mallBaseModel?.BackTopNavigationIco,
                        logo = "",
                        share_title = mallBaseModel?.MinShareTitle,
                        share_pic = mallBaseModel?.MinShareIco,
                        is_add_app = mallBaseModel?.MinSwitch,
                        add_app_bg_color = mallBaseModel?.MinBackColor,
                        add_app_bg_transparency = mallBaseModel?.MinBackClarity,
                        add_app_bg_radius = mallBaseModel?.MinBackCircularBead,
                        add_app_text = mallBaseModel?.MinTips,
                        add_app_text_color = mallBaseModel?.MinTipsColor,
                        add_app_icon_color_type = mallBaseModel?.MinIcoColor,
                        is_close = "",
                        business_time_type = "",
                        business_time_custom_type = "",
                        business_time_type_day = "",
                        business_time_type_week = "",
                        auto_business = "",
                        auto_business_time = "",
                        is_icon_super_vip = "",
                        is_show_normal_vip = "",
                        is_show_super_vip = "",
                        is_required_position = mallBaseModel?.OtherMustAddress,
                        is_share_tip = mallBaseModel?.OtherApplyShare,
                        is_show_cart = mallBaseModel?.ListShopCar,
                        is_show_sales_num = mallBaseModel?.ListBuyCount,
                        is_show_goods_name = mallBaseModel?.ListName,
                        is_underline_price = mallBaseModel?.DetailsLineationPrice,
                        is_express = mallBaseModel?.DeatilsExpress,
                        is_not_share_show = mallBaseModel?.OtherNoShare,
                        is_show_cart_fly = mallBaseModel?.CarSuspendBtn,
                        is_show_score_top = mallBaseModel?.BackTopBtn,
                        express_select_type = logisticsRules?.LogisticsType,//待会儿处理
                        express_aliapy_code = logisticsRules?.AliyunAppCode,
                        is_quick_customize = mallBaseModel?.Custom,
                        quick_customize_pic = mallBaseModel?.TurnIco,
                        quick_customize_open_type = "",
                        quick_customize_params = "",
                        quick_customize_link_url = mallBaseModel?.TurnLink,
                        quick_customize_new_params = "",
                        theme_color = "",
                        latitude_longitude = mallBaseModel?.LongAndLat
                    };
                    #endregion


                    #region 分销基础信息
                    var distributorBasics = userModule.GetDistributorBasicsInfo((miniProgram.TenantId ?? 0).ToString(), miniProgram.MallBaseId);
                    if (!string.IsNullOrEmpty(distributorBasics.WithdrawWay))
                    {
                        distributorBasics.WithdrawWayList = JsonConvert.DeserializeObject<List<int>>(distributorBasics.WithdrawWay);
                    }
                    List<string> pay_type = new List<string>();
                    if (!string.IsNullOrWhiteSpace(distributorBasics.WithdrawWay))
                    {
                        foreach (var item in distributorBasics.WithdrawWayList)
                        {
                            switch (item)
                            {
                                case 1:
                                    pay_type.Add("auto");
                                    break;
                                case 2:
                                    pay_type.Add("wechat");
                                    break;
                                case 3:
                                    pay_type.Add("alipay");
                                    break;
                                case 4:
                                    pay_type.Add("bank");
                                    break;
                                case 5:
                                    pay_type.Add("balance");
                                    break;
                                default:
                                    break;
                            }
                        }
                    }

                    share_setting = new
                    {
                        level = distributorBasics?.DistributorTier,
                        is_rebate = distributorBasics?.InPurchasing,
                        price_type = distributorBasics?.DistributorCommissionType,
                        first = distributorBasics?.OneCommission,
                        second = distributorBasics?.TwoCommission,
                        third = distributorBasics?.ThreeCommission,
                        share_condition = "",
                        condition = distributorBasics?.ReferralsCondition ?? 0,
                        auto_share_val = "",
                        share_goods_status = "",
                        share_goods_warehouse_id = "",
                        pay_type = pay_type.ToArray(),
                        cash_max_day = distributorBasics?.DailyWithdrawalLimit,
                        min_money = distributorBasics?.MinimumWithdrawalLimit,
                        cash_service_charge = distributorBasics?.WithdrawFee,
                        agree = distributorBasics?.ApplicationProtocol,
                        content = distributorBasics?.UserNotes,
                        pic_url_apply = "",
                        pic_url_status = distributorBasics?.BackgroundImage,
                        pic_url_home_head = distributorBasics?.IndexImage,
                        become_condition = "",
                        cat_list = "",
                        is_show_share_level = "",
                    };
                    #endregion


                    #region share_setting_custom
                    var distributorCustom = userModule.GetDistributorCustomInfo((miniProgram.TenantId ?? 0).ToString(), miniProgram.MallBaseId);
                    var share_setting_custom = new
                    {
                        menus = new
                        {
                            money = new
                            {
                                name = distributorCustom?.DistributionCommissionName,
                                icon = distributorCustom?.DistributionCommissionImage,
                                open_type = "",
                                url = "",
                                tel = ""
                            },
                            order = new
                            {
                                name = distributorCustom?.DistributionOrderName,
                                icon = distributorCustom?.DistributionOrderImage,
                                open_type = "",
                                url = "",
                                tel = ""
                            },
                            cash = new
                            {
                                name = distributorCustom?.WithdrawDetialsName,
                                icon = distributorCustom?.WithdrawDetialsImage,
                                open_type = "",
                                url = "",
                                tel = ""
                            },
                            team = new
                            {
                                name = distributorCustom?.MyTeamName,
                                icon = distributorCustom?.MyTeamImage,
                                open_type = "",
                                url = "",
                                tel = ""
                            },
                            qrcode = new
                            {
                                name = distributorCustom?.PromoteQRCodeName,
                                icon = distributorCustom?.PromoteQRCodeImage,
                                open_type = "",
                                url = "",
                                tel = ""
                            },
                        },
                        words = new
                        {
                            can_be_presented = new { name = distributorCustom?.CommissionForWithdrawalName, defaultStr = "可提现佣金" },
                            already_presented = new { name = distributorCustom?.CommissionWithdrawnName, defaultStr = "已提现佣金" },
                            parent_name = new { name = distributorCustom?.ReferrerName, defaultStr = "推荐人" },
                            pending_money = new { name = distributorCustom?.CommissionTobePaidName, defaultStr = "待打款佣金" },
                            cash = new { name = distributorCustom?.WithdrawDepositName, defaultStr = "提现" },
                            user_instructions = new { name = distributorCustom?.UserNotesName, defaultStr = "用户须知" },
                            apply_cash = new { name = distributorCustom?.IWantToWithdrawName, defaultStr = "我要提现" },
                            cash_type = new { name = distributorCustom?.WithdrawalWayName, defaultStr = "提现方式" },
                            cash_money = new { name = distributorCustom?.WithdrawalAmountName, defaultStr = "提现金额" },
                            order_money_un = new { name = distributorCustom?.OutstandingCommissionName, defaultStr = "未结算佣金" },
                            share_name = new { name = distributorCustom?.DistributorName, defaultStr = "分销商" },
                            one_share = new { name = distributorCustom?.OneDistributionName, defaultStr = "一级分销名称" },
                            second_share = new { name = distributorCustom?.TwoDistributionName, defaultStr = "二级分销名称" },
                            three_share = new { name = distributorCustom?.ThreeDistributionName, defaultStr = "三级分销名称" },
                        },
                        apply = new
                        {
                            share_apply = new { name = distributorCustom?.DistributionApplication, defaultStr = "分销申请" },
                            share_apply_pact = new { name = distributorCustom?.ApplicationAgreement, defaultStr = "分销申请协议" },
                            apply_btn_color = distributorCustom?.ButtonTextColor,
                            apply_btn_background = distributorCustom?.ButtonColor,
                            apply_btn_title = distributorCustom?.ButtonText,
                            apply_btn_round = distributorCustom?.ButtonFilletPX,
                            apply_head_pic = distributorCustom?.HeadImage,
                            apply_end_pic = distributorCustom?.BottomImage
                        },

                    };
                    #endregion


                    #region 商品分类样式
                    var productCategoryStyle = productModule.GetProductCategoryStyleInfo(miniProgram.TenantId ?? 0, miniProgram.MallBaseId);
                    cat_style = new
                    {
                        cat_style = productCategoryStyle?.Type,
                        recommend_count = productCategoryStyle?.Style,
                        cat_goods_count = productCategoryStyle?.CategoryNum,
                        cat_goods_cols = productCategoryStyle?.RowNum
                    };
                    #endregion
                }
            }
            var user_info = new object();
            if (RequestParm.OpenId != null && !string.IsNullOrWhiteSpace(RequestParm.OpenId))
            {
                var memberModel = userModule.GetAppletUserCenterStatistics(RequestParm.OpenId);
                user_info = memberModel;
            }
            var miniPageList = programPageModule.GetMiniprogram_Page_ListExtModule(new RB_MiniProgram_Page_Extend() { MallBaseId = RequestParm.MallBaseId });
            var objResult = new
            {
                home_pages = homePage,
                navbar,
                user_info,
                setting,
                share_setting,
                cat_style,
                auth_page,//授权页面
                bar_title = miniPageList?.Select(qitem => new { name = qitem.PageName, value = qitem.PageUrl, new_name = qitem.SelfPageName }),//导航标题
            };
            return ApiResult.Success(data: objResult);
        }



        /// <summary>
        /// 解析插件数据为对象
        /// </summary>
        /// <param name="item"></param>
        /// <returns></returns>
        public object PlusDataToObject(ComponentItem subItem, int TenantId, int MallBaseId)
        {
            var obj = new object();
            switch (subItem.Id)
            {
                //背景插件
                case "background":
                    var backgroundData = subItem.data as backgroundItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = backgroundData
                    };
                    break;
                //搜索插件
                case "search":
                    var searchData = subItem.data as searchItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = searchData
                    };
                    break;
                //导航组件
                case "nav":
                    var navData = subItem.data as navItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = navData
                    };
                    break;
                //轮播广告插件
                case "banner":
                    var bannerData = subItem.data as bannerItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = bannerData
                    };
                    break;
                //公告组件
                case "notice":
                    var noticeData = subItem.data as noticeItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = noticeData
                    };
                    break;
                //专题组件
                case "topic":
                    var topicData = subItem.data as topicItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = topicData
                    };
                    break;
                //标题组件
                case "link":
                    var linkData = subItem.data as linkItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = linkData
                    };
                    break;
                //图片广告插件
                case "rubik":
                    var rubikData = subItem.data as rubikItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = rubikData
                    };
                    break;
                //视频插件
                case "video":
                    var videoData = subItem.data as videoItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = videoData
                    };
                    break;
                //商品插件
                case "goods":
                    var goodsData = subItem.data as goodsItem;
                    if (goodsData != null)
                    {
                        //显示商品分类
                        if (goodsData.showCat)
                        {
                            if (goodsData.catList != null && goodsData.catList.Count > 0)
                            {
                                foreach (var childItem in goodsData.catList)
                                {
                                    //自定义商品
                                    if (childItem.staticGoods)
                                    {
                                        if (childItem.goodsList != null && childItem.goodsList.Count > 0)
                                        {
                                            var Ids = "0," + string.Join(",", childItem.goodsList.Select(qitem => qitem.id));
                                            var tempGoodsList = productModule.GetProductGoodsList(new Model.Extend.Product.RB_Goods_Extend()
                                            {
                                                TenantId = TenantId,
                                                MallBaseId = MallBaseId,
                                                GoodsIds = Ids
                                            });
                                            foreach (var lastItem in childItem.goodsList)
                                            {
                                                var tempGood = tempGoodsList?.Where(qitem => qitem.Id == lastItem.id)?.FirstOrDefault();
                                                if (tempGood != null && tempGood.Id > 0)
                                                {
                                                    lastItem.name = tempGood?.Name ?? lastItem.name;
                                                    lastItem.price = Math.Round((tempGood?.SellingPrice ?? lastItem.price), 2);
                                                    lastItem.picUrl = tempGood?.CoverImage != null ? Common.Config.GetFileUrl(tempGood.CoverImage) : Common.Config.GetFileUrl(lastItem.picUrl);
                                                    lastItem.OriginalPrice = Math.Round((tempGood?.OriginalPrice ?? 0), 2);
                                                }
                                            }
                                        }
                                    }
                                    //自动添加商品
                                    else
                                    {
                                        childItem.goodsList = new List<GoodsDetailsItem2>();
                                        var catGoodsList = productModule.GetProductGoodsPageList(1, childItem.goodsNum, out long rowsCount, new Model.Extend.Product.RB_Goods_Extend()
                                        {
                                            TenantId = TenantId,
                                            MallBaseId = MallBaseId,
                                            CategoryIds = childItem.id.ToString()
                                        });
                                        if (catGoodsList != null && catGoodsList.Count > 0)
                                        {
                                            foreach (var gItem in catGoodsList)
                                            {
                                                childItem.goodsList.Add(new GoodsDetailsItem2()
                                                {
                                                    id = gItem.Id,
                                                    price = Math.Round((gItem?.SellingPrice ?? 0), 2),
                                                    name = gItem.Name,
                                                    picUrl = Common.Config.GetFileUrl(gItem.CoverImage),
                                                    OriginalPrice = Math.Round((gItem?.OriginalPrice ?? 0), 2)
                                                });
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        //不显示商品分类
                        else
                        {
                            //自动添加商品
                            if (goodsData.addGoodsType == 0)
                            {
                                goodsData.list = new List<GoodsDetailsItem2>();
                                var goodsList = productModule.GetProductGoodsPageList(1, goodsData.goodsLength, out long rowsCount, new Model.Extend.Product.RB_Goods_Extend()
                                {
                                    TenantId = TenantId,
                                    MallBaseId = MallBaseId
                                });
                                if (goodsList != null && goodsList.Count > 0)
                                {
                                    foreach (var gItem in goodsList)
                                    {
                                        goodsData.list.Add(new GoodsDetailsItem2()
                                        {
                                            id = gItem.Id,
                                            price = Math.Round((gItem?.SellingPrice ?? 0), 2),
                                            name = gItem.Name,
                                            picUrl = Common.Config.GetFileUrl(gItem.CoverImage),
                                            OriginalPrice = Math.Round((gItem?.OriginalPrice ?? 0), 2)
                                        });
                                    }
                                }
                            }
                            //手动添加商品
                            else
                            {
                                if (goodsData.list != null && goodsData.list.Count > 0)
                                {
                                    var Ids = "0," + string.Join(",", goodsData.list.Select(qitem => qitem.id));
                                    var tempGoodsList = productModule.GetProductGoodsList(new Model.Extend.Product.RB_Goods_Extend()
                                    {
                                        TenantId = TenantId,
                                        MallBaseId = MallBaseId,
                                        GoodsIds = Ids
                                    });
                                    foreach (var childItem in goodsData.list)
                                    {
                                        var tempGood = tempGoodsList?.Where(qitem => qitem.Id == childItem.id)?.FirstOrDefault();
                                        if (tempGood != null && tempGood.Id > 0)
                                        {
                                            childItem.name = tempGood?.Name ?? childItem.name;
                                            childItem.price = Math.Round((tempGood?.SellingPrice ?? childItem.price), 2);
                                            childItem.picUrl = tempGood?.CoverImage != null ? Common.Config.GetFileUrl(tempGood.CoverImage) : Common.Config.GetFileUrl(childItem.picUrl);
                                            childItem.OriginalPrice = Math.Round((tempGood?.OriginalPrice ?? 0), 2);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    obj = new
                    {
                        id = subItem.Id,
                        data = goodsData
                    };
                    break;
                //门店插件
                case "store":
                    var storeData = subItem.data as storeItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = storeData
                    };
                    break;
                //版权插件
                case "copyright":
                    var copyrightData = subItem.data as copyrightItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = copyrightData
                    };
                    break;
                //签到插件
                case "check-in":
                    var checkinData = subItem.data as checkinItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = checkinData
                    };
                    break;
                //用户信息插件
                case "user-info":
                    var userinfoData = subItem.data as userinfoItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = userinfoData
                    };
                    break;
                //用户订单插件
                case "user-order":
                    var userorderData = subItem.data as userorderItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = userorderData
                    };
                    break;
                //地图插件
                case "map":
                    var mapData = subItem.data as mapItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = mapData
                    };
                    break;
                //微信公众号插件
                case "mp-link":
                    var mplinkData = subItem.data as mplinkItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = mplinkData
                    };
                    break;
                //图文插件
                case "image-text":
                    var imagetextData = subItem.data as imagetextItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = imagetextData
                    };
                    break;
                //优惠券插件
                case "coupon":
                    var couponData = subItem.data as couponItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = couponData
                    };
                    break;
                //倒计时插件
                case "timer":
                    var timerData = subItem.data as timerItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = timerData
                    };
                    break;
                //拼团插件
                case "pintuan":
                    var pintuanData = subItem.data as pintuanItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = pintuanData
                    };
                    break;
                //预约插件
                case "booking":
                    var bookingData = subItem.data as bookingItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = bookingData
                    };
                    break;
                //砍价插件
                case "bargain":
                    var bargainData = subItem.data as bargainItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = bargainData
                    };
                    break;
                //积分商城插件
                case "integral-mall":
                    var integralmallData = subItem.data as integralmallItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = integralmallData
                    };
                    break;
                //抽奖插件
                case "lottery":
                    var lotteryData = subItem.data as lotteryItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = lotteryData
                    };
                    break;

                //预售
                case "advance":
                    var advanceData = subItem.data as advanceItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = advanceData
                    };
                    break;

                //超级会员卡
                case "vip-card":
                    var vipcardData = subItem.data as vipcardItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = vipcardData
                    };
                    break;
                //直播组件
                case "live":
                    var liveData = subItem.data as liveItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = liveData
                    };
                    break;


                //空组件
                case "empty":
                    var emptyData = subItem.data as emptyItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = emptyData
                    };
                    break;

                //流量主广告
                case "ad":
                    var adData = subItem.data as adItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = adData
                    };
                    break;

                //弹窗广告
                case "modal":
                    var modalData = subItem.data as modalItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = modalData
                    };
                    break;

                //弹窗广告
                case "quick-nav":
                    var quicknavData = subItem.data as quicknavItem;
                    obj = new
                    {
                        id = subItem.Id,
                        data = quicknavData
                    };
                    break;
            }
            return obj;
        }


        /// <summary>
        /// 用户中心
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetUserCenter()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            string MiniAppId = "";
            try
            {
                //小程序Id
                MiniAppId = RequestParm.MiniAppId;
            }
            catch (Exception ex)
            {
                Common.Plugin.LogHelper.Error("MallController_GetUserCenter", ex);
            }
            //获取小程序信息
            var miniProgram = programModule.GetMiniProgramModule(new Model.Extend.User.RB_MiniProgram_Extend() { MiniAppId = MiniAppId }, isGetUserCenterMenu: true);
            var user_info = new object();
            if (RequestParm.OpenId != null && !string.IsNullOrWhiteSpace(RequestParm.OpenId))
            {
                var memberModel = userModule.GetAppletUserCenterStatistics(RequestParm.OpenId);
                user_info = memberModel;                
            }

            var data = new object();
            if (miniProgram != null && miniProgram.MallBaseId > 0)
            {
                var config = new
                {
                    //顶部导航
                    title_bar = new
                    {
                        //顶部背景颜色
                        background = miniProgram.TopNavBgColor,
                        //顶部文字颜色
                        color = miniProgram.TopNavWordColor,
                    },
                    //用户中心
                    user_center = new
                    {
                        //是否显示账户栏
                        is_account_status = (miniProgram.IsShowAccountNav == 0 ? 1 : 0),
                        //是否显示菜单栏
                        is_menu_status = (miniProgram.IsShowMenuNav == 0 ? 1 : 0),
                        //是否显示菜单栏
                        is_order_bar_status = (miniProgram.IsShowOrderNav == 0 ? 1 : 0),
                        //是否显示收藏夹
                        is_foot_bar_status = (miniProgram.IsShowFavorite == 0 ? 1 : 0),
                        //菜单样式
                        menu_style = (miniProgram.MenuNavStyle == 0 ? 1 : 2),
                        //头像样式
                        top_style = (miniProgram.HeadStyle),
                        //顶部默认背景图
                        top_pic_url = miniProgram.DefaultBgImg,
                        //普通用户背景图
                        member_pic_url = miniProgram.MemberBgImg,
                        //会员中心背景图
                        member_bg_pic_url = miniProgram.VipBgImg,
                        //头像内嵌背景图[暂无]
                        style_bg_pic_url = "",

                        //账户相关菜单
                        account = miniProgram?.AccountMenuList?.Select(qitem => new
                        {
                            icon_url = qitem.MenuIcon,
                            name = qitem.MenuName.Replace("我的", "").Replace("明细", "").Replace("记录", ""),
                            is_show = 1,
                            link_url = qitem.MenuUrl.Trim(),
                        }),
                        //自定义菜单
                        menus = miniProgram?.SelfMenuList?.Select(qitem => new
                        {
                            icon_url = qitem.MenuIcon,
                            name = qitem.MenuName,
                            link_url = qitem.MenuUrl.Trim(),
                            open_type = "navigate",
                            @params = "",

                        }),
                        //订单菜单列表
                        order_bar = miniProgram?.OrderMenuList?.Select(qitem => new
                        {
                            icon_url = qitem.MenuIcon,
                            name = qitem.MenuName,
                            link_url = qitem.MenuUrl.Trim(),
                            open_type = "navigate",
                            text = "",
                        }),
                        //收藏足迹
                        foot_bar = miniProgram?.FavoriteFootMenuList?.Select(qitem => new
                        {
                            icon_url = qitem.MenuIcon,
                            name = qitem.MenuName,
                            link_url = qitem.MenuUrl.Trim(),
                            open_type = "navigate",
                        }),
                        //版权设置
                        copyright = new
                        {
                            pic_url = miniProgram.CopyRightImg,
                            description = miniProgram.CopyRightWord,
                            link_url = miniProgram.CopyRightLink.Trim(),
                        }
                    }
                };

                data = new
                {
                    mall = new
                    {
                        //商城编号
                        id = miniProgram.MallBaseId,
                        //商城名称
                        name = miniProgram.MallName,
                        //是否删除
                        is_delete = miniProgram.Status,
                        //是否回收
                        is_recycle = miniProgram.Is_Recycle,
                        //是否禁用
                        is_disable = miniProgram.Status
                    },

                    //配置信息
                    config,
                    //用户信息
                    user_info,
                };
            }
            return ApiResult.Success(data: data);
        }

        /// <summary>
        /// 获取用户信息
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetUserInfo()
        {
            if (RequestParm.OpenId != null && !string.IsNullOrWhiteSpace(RequestParm.OpenId))
            {
                var memberModel = userModule.GetAppletUserCenterStatistics(RequestParm.OpenId);
                return ApiResult.Success(data: new { user_info = memberModel });
            }
            else
            {
                return ApiResult.Failed(message: "请获取用户OpenId");
            }
        }

        /// <summary>
        /// 获取用户信息
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [HttpPost]
        [AllowAnonymous]
        public ApiResult GetWeChatOpenId()
        {
            JObject parms = JObject.Parse(RequestParm.msg.ToString());
            string code = parms.GetStringValue("Code");
            string openId = "";
            if (RequestParm.MiniAppId != null && !string.IsNullOrWhiteSpace(RequestParm.MiniAppId))
            {
                var miniProgram = programModule.GetMiniProgramModule(new Model.Extend.User.RB_MiniProgram_Extend() { MiniAppId = RequestParm.MiniAppId });
                if (miniProgram != null && miniProgram.MallBaseId > 0)
                {
                    openId = Common.Plugin.WeiXinHelper.GetWeChatOpenId(miniProgram.MiniAppId, miniProgram.MiniAppSecret, code);
                }
            }
            return ApiResult.Success(data: openId);
        }
    }
}