﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Extend.User;
using Mall.Module.User;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.User
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class SupplierController : BaseController
    {
        private readonly SupplierModule supplierModule = new SupplierModule();


        [HttpPost]
        public ApiResult GetSupplierList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_Supplier_Extend demodel = JsonConvert.DeserializeObject<RB_Supplier_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            var list = supplierModule.GetPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.CreateDate,
                x.Name,
                x.Mobile,
                x.Address,
                x.ClientBankAccount?.CardNum,
                x.ClientBankAccount?.OpenBankName,
                x.ClientBankAccount?.AccountAlias,
                x.ClientBankAccount?.AccountHolder,
                AccountClassifyStr = x.ClientBankAccount?.AccountClassify == 2 ? "银行" : (x.ClientBankAccount?.AccountClassify == 3 ? "虚拟账户" : (x.ClientBankAccount?.AccountClassify == 4 ? "微信支付宝" : "")),
            });
            return ApiResult.Success("", pagelist);
        }


        /// <summary>
        /// 添加修改
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>

        [HttpPost]
        public ApiResult SetSupplier()
        {
            var parms = RequestParm;
            RB_Supplier_Extend demodel = JsonConvert.DeserializeObject<RB_Supplier_Extend>(RequestParm.msg.ToString());

            if (string.IsNullOrEmpty(demodel.Name))
            {
                return ApiResult.Failed("请填写供应商名称");
            }

            if (string.IsNullOrEmpty(demodel.Mobile))
            {
                return ApiResult.Failed("请填写联系电话");
            }

            if (string.IsNullOrEmpty(demodel.ClientBankAccount.OpenBankName))
            {
                return ApiResult.Failed("请填写开户行！");
            }
            if (string.IsNullOrEmpty(demodel.ClientBankAccount.AccountHolder))
            {
                return ApiResult.Failed("请填写开户人！");
            }
            if (string.IsNullOrEmpty(demodel.ClientBankAccount.CardNum))
            {
                return ApiResult.Failed("请填写卡号！");
            }
            if (supplierModule.ExistsClientAccount(demodel.ClientBankAccount.ID, demodel.ClientBankAccount.CardNum, 2, Convert.ToInt32(Config.RB_Branch_Id)))
            {
                return ApiResult.Failed("卡号重复！");
            }
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            demodel.CreateDate = DateTime.Now;
            demodel.ClientBankAccount.CreateDate = DateTime.Now;
            demodel.ClientBankAccount.RB_Branch_Id = Convert.ToInt32(Config.RB_Branch_Id);
            demodel.ClientBankAccount.RB_Group_Id = 2;
            demodel.ClientBankAccount.CreateBy = Convert.ToInt32(Config.NetworkDirector);
            bool flag = supplierModule.AddOrUpdateSupplier(demodel);
            if (flag)
                return ApiResult.Success();
            else
                return ApiResult.Failed("请求失败！");
        }



        /// <summary>
        /// 获取详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetSupplierDetail()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Supplier_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var oldLogisticsModel = supplierModule.GetList(query).FirstOrDefault();
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_Supplier_Extend();
            }
            return ApiResult.Success("", oldLogisticsModel);
        }



        /// <summary>
        /// 删除优惠券
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelDiscountCoupon()
        {
            var parms = RequestParm;
            JObject parmsJob = JObject.Parse(RequestParm.msg.ToString());
            int Id = parmsJob.GetInt("Id", 0);
            int BackId = parmsJob.GetInt("BackId", 0);
            if (Id <= 0)
            {
                return ApiResult.Failed("请传递参数");
            }
            bool flag = supplierModule.RemoveSupplier(Id, BackId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }
    }
}