﻿using Mall.Common.Enum;
using Mall.Model.Extend.User;
using Mall.Repository.User;
using System.Collections.Generic;
using VT.FW.DB;
using System.Linq;

namespace Mall.Module.User
{
    /// <summary>
    /// 用户分组处理类
    /// </summary>
    public class MemberGroupModule
    {
        /// <summary>
        /// 用户分组仓储层对象
        /// </summary>
        private readonly RB_Member_GroupRepository member_GroupRepository = new RB_Member_GroupRepository();

        /// <summary>
        /// 获取用户分组分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Member_Group_Extend> GetMemberGroupPageModule(int pageIndex, int pageSize, out long rowsCount, RB_Member_Group_Extend query)
        {
            var list= member_GroupRepository.GetMemberGroupPageRepository(pageIndex, pageSize, out rowsCount, query);
            if (list != null && list.Count > 0)
            {
                string groupIds = string.Join(",", list.Select(qitem => qitem.LookGroupIds));
                List<int> idList = Common.ConvertHelper.StringToList(groupIds);
                var groupList = GetMemberGroupListModule(new RB_Member_Group_Extend()
                {
                    Q_GroupIds = string.Join(",", idList)
                });
                foreach (var item in list)
                {
                    item.LookGroupList = new List<object>();
                    if (item.GroupIdList != null && item.GroupIdList.Count > 0)
                    {
                        foreach (var sItem in item.GroupIdList)
                        {
                            var tempGroup = groupList.Where(qitem => qitem.GroupId == sItem)?.FirstOrDefault();
                            if (tempGroup != null && tempGroup.GroupId > 0)
                            {
                                item.LookGroupList.Add(new
                                {
                                    tempGroup.GroupId,
                                    tempGroup.GroupName,
                                });
                            }
                        }
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 获取用户分组列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Member_Group_Extend> GetMemberGroupListModule(RB_Member_Group_Extend query)
        {
            return member_GroupRepository.GetMemberGroupListRepository(query);
        }

        /// <summary>
        /// 新增修改用户分组
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetMemberGroupModule(RB_Member_Group_Extend model)
        {
            bool flag;
            if (model.GroupId > 0)
            {
                Dictionary<string, object> fileds = new Dictionary<string, object>()
                {
                    {nameof(RB_Member_Group_Extend.GroupName),model.GroupName },
                    {nameof(RB_Member_Group_Extend.LookGroupIds),model.LookGroupIds },
                    {nameof(RB_Member_Group_Extend.UpdateBy),model.UpdateBy },
                    {nameof(RB_Member_Group_Extend.UpdateDate),model.UpdateDate },
                };
                flag = member_GroupRepository.Update(fileds, new WhereHelper(nameof(RB_Member_Group_Extend.GroupId), model.GroupId));
            }
            else
            {
                var newId = member_GroupRepository.Insert(model);
                model.GroupId = newId;
                flag = newId > 0;
            }
            return flag;
        }

        /// <summary>
        /// 根据编号获取用户分组实体
        /// </summary>
        /// <param name="GroupId"></param>
        /// <returns></returns>
        public RB_Member_Group_Extend GetMemberGroupModule(object GroupId)
        {
            var model = member_GroupRepository.GetEntity<RB_Member_Group_Extend>(GroupId);
            return model;
        }

        /// <summary>
        /// 设置默认分组
        /// </summary>
        /// <param name="GroupId"></param>
        /// <param name="MallBaseId"></param>
        /// <returns></returns>
        public bool SetDefaultGroupModule(int GroupId,int MallBaseId)
        {
            bool flag = member_GroupRepository.UpdateIsDefaultRepository(MallBaseId);
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Member_Group_Extend.IsDefault),1 }
            };
            flag = member_GroupRepository.Update(fileds, new WhereHelper(nameof(RB_Member_Group_Extend.GroupId), GroupId));
            return flag;
        }

        /// <summary>
        /// 根据编号删除用户分组
        /// </summary>
        /// <param name="GroupId"></param>
        /// <returns></returns>
        public bool RemoveMemberGroupModule(object GroupId)
        {
            Dictionary<string, object> fileds = new Dictionary<string, object>()
            {
                {nameof(RB_Member_Group_Extend.Status),(int)DateStateEnum.Delete },
            };
            bool flag = member_GroupRepository.Update(fileds, new WhereHelper(nameof(RB_Member_Group_Extend.GroupId), GroupId));
            return flag;
        }
    }
}
