﻿using Mall.Model.Extend.User;
using Mall.Repository.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Module.User
{
   /// <summary>
   /// 用户查看微信日志处理类
   /// </summary>
   public class MemberLookModule
    {
        /// <summary>
        /// 用户查看微信日志仓储层对象
        /// </summary>
        private readonly RB_Member_LookRepository member_LookRepository = new RB_Member_LookRepository();

        /// <summary>
        /// 获取用户查看微信日志分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Member_Look_Extend> GetMemberLookPageModule(int pageIndex, int pageSize, out long rowsCount, RB_Member_Look_Extend query)
        {
            return member_LookRepository.GetMemberLookPageRepository(pageIndex, pageSize, out rowsCount, query);
        }

        /// <summary>
        /// 获取用户查看日志列表
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public List<RB_Member_Look_Extend> GetMemberLookListModule(RB_Member_Look_Extend query)
        {
            return member_LookRepository.GetMemberLookListRepository(query);
        }

        /// <summary>
        /// 新增用户查看日志
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool AddMemberLookModule(RB_Member_Look_Extend model)
        {
            var newId = member_LookRepository.Insert(model);
            model.LookId = newId;
            return newId > 0;
        }
    }
}
