﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Mall.Common.Plugin;
using Mall.CacheManager.User;
using Newtonsoft.Json.Linq;
using Mall.Common;
using Mall.AOP;
using Mall.Module.Miai;
using Mall.Model.Extend.Miai;
using Mall.Model.Extend.Point;
using Mall.Model.Extend.User;
using Mall.Module.User;

namespace Mall.WebApi.Controllers.MallBase
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class MiaiController : BaseController
    {
        private readonly MiaiModule miaiModule = new MiaiModule();
        private readonly Module.Education.PointModule pointModule = new Module.Education.PointModule();

        /// <summary>
        /// 用户查看微信日志处理类
        /// </summary>
        private readonly MemberLookModule memberLookModule = new MemberLookModule();

        #region 活动版块
        /// <summary>
        /// 获取活动版块分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetForumPageList()
        {
            var req = base.RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(req.msg.ToString());
            RB_Miai_Forum_Extend demodel = JsonConvert.DeserializeObject<RB_Miai_Forum_Extend>(req.msg.ToString());

            demodel.TenantId = Convert.ToInt32(req.uid);
            demodel.MallBaseId = req.MallBaseId;
            var list = miaiModule.GetForumPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.Name,
                x.Icon,
                x.Sort,
                x.IsShow,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm:ss")
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 设置版块
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetForumInfo()
        {
            var req = base.RequestParm;
            RB_Miai_Forum_Extend demodel = JsonConvert.DeserializeObject<RB_Miai_Forum_Extend>(req.msg.ToString());
            if (string.IsNullOrEmpty(demodel.Name))
            {
                return ApiResult.ParamIsNull("请输入版块名称");
            }
            if (string.IsNullOrEmpty(demodel.Icon))
            {
                return ApiResult.ParamIsNull("请选择版块图标");
            }

            demodel.TenantId = Convert.ToInt32(req.uid);
            demodel.MallBaseId = req.MallBaseId;
            demodel.IsShow = demodel.IsShow == 0 ? 1 : demodel.IsShow;
            demodel.Status = 0;
            demodel.CreateDate = DateTime.Now;
            demodel.UpdateDate = DateTime.Now;
            bool flag = miaiModule.SetForumInfo(demodel);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 设置版块状态
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetForumState()
        {
            var req = base.RequestParm;
            var parms = JObject.Parse(req.msg.ToString());
            int ForumId = parms.GetInt("ForumId", 0);
            int Type = parms.GetInt("Type", 1);// 类型  1显示/不显示   2删除

            bool flag = miaiModule.SetForumState(ForumId, Type);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }
        #endregion

        #region 招募贴

        /// <summary>
        /// 获取活动分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetActivityPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            RB_Miai_Activity_Extend demodel = JsonConvert.DeserializeObject<RB_Miai_Activity_Extend>(parms.msg.ToString());
            demodel.TenantId = parms.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            var list = miaiModule.GetActivityPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.ActivityTitle,
                x.UserId,
                x.UserName,
                x.Photo,
                x.Content,
                x.ImageList,
                x.ReplyNum,
                x.EnrollNum,
                x.IsOpenEnroll,
                x.Label,
                StartTime = x.StartTime.HasValue ? x.StartTime.Value.ToString("yyyy-MM-dd HH:mm") : "",
                EndTime = x.EndTime.HasValue ? x.EndTime.Value.ToString("yyyy-MM-dd HH:mm") : "",
                x.IsTieZi,
                x.ManNum,
                x.WoManNum,
                x.DianZanNum,
                x.LonLat,
                x.LocationName,
                Deadline = x.IsOpenEnroll == 1 ? x.Deadline.Value.ToString("yyyy-MM-dd HH:mm") : "",
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm:ss")
            });
            return ApiResult.Success("", pagelist);
        }


        /// <summary>
        /// 获取活动分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetActivityDianZanPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            RB_Miai_Activity_Extend demodel = JsonConvert.DeserializeObject<RB_Miai_Activity_Extend>(parms.msg.ToString());
            demodel.TenantId = parms.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            var list = miaiModule.GetActivityPageList_V3(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.ActivityTitle,
                x.UserId,
                x.UserName,
                x.Photo,
                x.Content,
                x.ImageList,
                x.ReplyNum,
                x.EnrollNum,
                x.IsOpenEnroll,
                x.Label,
                StartTime = x.StartTime.HasValue ? x.StartTime.Value.ToString("yyyy-MM-dd HH:mm") : "",
                EndTime = x.EndTime.HasValue ? x.EndTime.Value.ToString("yyyy-MM-dd HH:mm") : "",
                x.ManNum,
                x.WoManNum,
                x.LonLat,
                x.LocationName,
                x.DianZanNum,
                Deadline = x.IsOpenEnroll == 1 ? x.Deadline.Value.ToString("yyyy-MM-dd HH:mm") : "",
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm:ss")
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 获取活动信息（包含报名人数）
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetActivityInfo()
        {
            var parms = JObject.Parse(RequestParm.msg.ToString());
            int ActivityId = parms.GetInt("ActivityId", 0);
            if (ActivityId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            var obj = miaiModule.GetActivityInfo_V2(ActivityId);
            return ApiResult.Success("", obj);
        }

        /// <summary>
        /// 删除招募贴
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelActivityInfo()
        {
            var parms = JObject.Parse(RequestParm.msg.ToString());
            int ActivityId = parms.GetInt("ActivityId", 0);
            if (ActivityId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            string msg = miaiModule.DelActivityInfo_V2(ActivityId, RequestParm.EmpId, RequestParm.TenantId, RequestParm.MallBaseId);
            if (msg == "")
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed(msg);
            }
        }

        /// <summary>
        /// 获取活动评论分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetActivityDiscussPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            RB_Miai_ActivityDiscuss_Extend demodel = JsonConvert.DeserializeObject<RB_Miai_ActivityDiscuss_Extend>(parms.msg.ToString());
            if (demodel.ActivityId <= 0)
            {
                return ApiResult.ParamIsNull("请传递活动id");
            }
            demodel.TenantId = parms.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            var list = miaiModule.GetActivityDiscussPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.UserId,
                UserName = !string.IsNullOrWhiteSpace(x.CreateByUserName) ? x.CreateByUserName : x.UserName,
                x.Photo,
                x.Content,
                x.ImageList,
                ReplyList = x.ReplyList.Select(z => new
                {
                    z.Id,
                    z.UserId,
                    UserName = !string.IsNullOrWhiteSpace(z.CreateByUserName) ? z.CreateByUserName : z.UserName,
                    z.Photo,
                    z.Content,
                    z.ImageList,
                    z.ReplyUserId,
                    z.ReplyUserName,
                    CreateDate = z.CreateDate.ToString("yyyy-MM-dd HH:mm:ss")
                }),
                x.ReplyNum,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm:ss")
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 获取活动回复分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetActivityReplyPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            RB_Miai_ActivityDiscuss_Extend demodel = JsonConvert.DeserializeObject<RB_Miai_ActivityDiscuss_Extend>(parms.msg.ToString());
            if (demodel.ParentId <= 0)
            {
                return ApiResult.ParamIsNull("请传递上级id");
            }
            demodel.TenantId = parms.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            var list = miaiModule.GetActivityReplyPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.UserId,
                UserName = !string.IsNullOrWhiteSpace(x.CreateByUserName) ? x.CreateByUserName : x.UserName,
                x.Photo,
                x.Content,
                x.ImageList,
                x.ReplyUserId,
                x.ReplyUserName,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm:ss")
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 删除评论
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelActivityDiscussInfo()
        {
            var parms = JObject.Parse(RequestParm.msg.ToString());
            int DiscussId = parms.GetInt("DiscussId", 0);
            if (DiscussId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            string msg = miaiModule.DelActivityDiscussInfo_V2(DiscussId, RequestParm.EmpId, RequestParm.TenantId, RequestParm.MallBaseId);
            if (msg == "")
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed(msg);
            }
        }




        /// <summary>
        /// 设置评论
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SgetActivityDiscussInfo()
        {
            var parms = RequestParm;

            RB_Miai_ActivityDiscuss_Extend demodel = JsonConvert.DeserializeObject<RB_Miai_ActivityDiscuss_Extend>(parms.msg.ToString());
            if (demodel.ActivityId <= 0)
            {
                return ApiResult.ParamIsNull("请传递活动id");
            }
            if (string.IsNullOrEmpty(demodel.UserName))
            {
                return ApiResult.ParamIsNull("请输入用户名称");
            }

            if (string.IsNullOrEmpty(demodel.Content))
            {
                return ApiResult.ParamIsNull("请传递内容");
            }
            demodel.ImageList ??= new List<string>();
            demodel.Images = JsonConvert.SerializeObject(demodel.ImageList);
            demodel.TenantId = parms.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            demodel.Status = 0;
            // demodel.CreateDate = DateTime.Now;
            demodel.UpdateDate = DateTime.Now;
            bool flag = miaiModule.SetActivityDiscussInfo(demodel);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 获取活动报名分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetActivityEnrollPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            RB_Miai_ActivityEnroll_Extend demodel = JsonConvert.DeserializeObject<RB_Miai_ActivityEnroll_Extend>(parms.msg.ToString());
            if (demodel.ActivityId <= 0)
            {
                return ApiResult.ParamIsNull("请传递活动id");
            }
            demodel.TenantId = parms.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            var list = miaiModule.GetActivityEnrollPageList_V2(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.UserId,
                x.UserName,
                x.Photo,
                x.Name,
                x.Mobile,
                x.PeopleNum,
                x.Remark,
                x.Sex,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm:ss")
            });
            return ApiResult.Success("", pagelist);
        }

        #endregion

        #region 相亲约会

        /// <summary>
        /// 获取相亲约会分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMiaiDatingPageList()
        {
            var req = base.RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(req.msg.ToString());
            RB_Miai_Dating_Extend demodel = JsonConvert.DeserializeObject<RB_Miai_Dating_Extend>(req.msg.ToString());

            demodel.TenantId = Convert.ToInt32(req.uid);
            demodel.MallBaseId = req.MallBaseId;
            var list = miaiModule.GetMiaiDatingPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                x.ManId,
                x.ManName,
                x.ManPhoto,
                x.WoManId,
                x.WoManName,
                x.WoManPhoto,
                Time = x.Time.ToString("yyyy-MM-dd HH:mm"),
                x.Address,
                x.Remark,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm:ss")
            });
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 新增/修改相亲约会记录
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetMiaiDatingInfo()
        {
            var req = base.RequestParm;
            RB_Miai_Dating_Extend demodel = JsonConvert.DeserializeObject<RB_Miai_Dating_Extend>(req.msg.ToString());
            if (demodel.ManId <= 0)
            {
                return ApiResult.ParamIsNull("请选择男方");
            }
            if (demodel.WoManId <= 0)
            {
                return ApiResult.ParamIsNull("请选择女方");
            }
            if (string.IsNullOrEmpty(demodel.Address))
            {
                return ApiResult.ParamIsNull("请输入约见地址");
            }

            demodel.TenantId = Convert.ToInt32(req.uid);
            demodel.MallBaseId = req.MallBaseId;
            demodel.Status = 0;
            demodel.EmpId = req.EmpId;
            demodel.CreateDate = DateTime.Now;
            demodel.UpdateDate = DateTime.Now;
            bool flag = miaiModule.SetMiaiDatingInfo(demodel);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 删除相亲约会记录
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelMiaiDatingInfo()
        {
            var req = base.RequestParm;
            var parms = JObject.Parse(req.msg.ToString());
            int DatingId = parms.GetInt("DatingId", 0);
            if (DatingId <= 0)
            {
                return ApiResult.ParamIsNull();
            }

            bool flag = miaiModule.DelMiaiDatingInfo(DatingId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        #endregion

        #region 星星商品
        [HttpPost]
        public ApiResult GetStarsGoodsPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_Point_Goods_Extend demodel = JsonConvert.DeserializeObject<RB_Point_Goods_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            //demodel.TeacherStatus = -1;
            var list = pointModule.GetPointGoodsPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.ID,
                x.GivePoint,
                x.GoodsName,
                x.PonitNum,
                x.SellingPrice,
                IsGive = (x.GivePoint > 0) ? 1 : 0
            });
            return ApiResult.Success("", pagelist);
        }


        /// <summary>
        /// 获取详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetStarsGoodsModel()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Point_Goods_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var oldPointGoodsModel = pointModule.GetPointGoodsList(query).FirstOrDefault();
            if (oldPointGoodsModel == null)
            {
                oldPointGoodsModel = new RB_Point_Goods_Extend();
            }
            return ApiResult.Success("", oldPointGoodsModel);
        }


        /// <summary>
        /// 保存星星产品信息
        /// </summary>
        /// <returns></returns>
        public ApiResult SetStarsGoods()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Point_Goods_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            if (query == null)
            {
                return ApiResult.Failed("请传入星星产品信息");
            }
            else
            {
                if (string.IsNullOrWhiteSpace(query.GoodsName))
                {
                    return ApiResult.Failed("请输入产品名称");
                }
                if (query.PonitNum == 0)
                {
                    return ApiResult.Failed("请输入星星");
                }
                if (query.SellingPrice == 0)
                {
                    return ApiResult.Failed("请输入价格");
                }
                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;
                }
                query.OriginalPrice = 0;
                query.CostPrice = 0;
                query.Sort = 0;
                query.State = 0;
                query.UpdateDate = System.DateTime.Now;
                bool result = pointModule.SetPointGoods(query);
                if (result)
                {
                    return ApiResult.Success("星星产品信息保存成功");
                }
                else
                {
                    return ApiResult.Failed("星星产品信息保存失败");
                }
            }
        }



        /// <summary>
        /// 删除星星产品
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DeleteStarsGoods()
        {
            var parms = RequestParm;
            JObject parmsJob = JObject.Parse(RequestParm.msg.ToString());
            int Id = parmsJob.GetInt("Id", 0);

            if (Id == 0)
            {
                return ApiResult.Failed("请选择您要删除的星星信息");
            }
            bool flag = pointModule.DeletePointGoods(new RB_Point_Goods_Extend { ID = Id, TenantId = UserInfo.TenantId, MallBaseId = parms.MallBaseId });
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        #endregion

        #region 基础信息
        public ApiResult GetMiAiBaseIfo()
        {
            var parms = RequestParm;
            JObject parm = JObject.Parse(parms.msg.ToString());
            // var userInfo = AppletUserInfo;
            int userId = parm.GetInt("UserId");
            if (userId > 0)
            {
                var oldUserInfo = miaiModule.GetMemberUserInfo(userId);
                var oldBaseInfo = miaiModule.GetBaseInfoModel(new RB_MiAi_BaseInfo_Extend { UserId = userId, TenantId = UserInfo.TenantId, MallBaseId = UserInfo.MallBaseId });
                if (oldBaseInfo != null && oldBaseInfo.Id > 0)
                {
                    oldBaseInfo.AlbumList = new List<string>();
                    if (!string.IsNullOrWhiteSpace(oldBaseInfo.Album))
                    {
                        oldBaseInfo.AlbumList = JsonConvert.DeserializeObject<List<string>>(oldBaseInfo.Album);
                    }

                    var result = new
                    {
                        oldUserInfo.Id,
                        oldUserInfo.Name,
                        oldUserInfo.Photo,
                        WechatNo = oldBaseInfo.WechatNo ?? "",
                        Moblie = oldUserInfo.Moblie ?? "",
                        SexStr = (oldBaseInfo != null && oldBaseInfo.Id > 0) ? (oldBaseInfo.Sex == 1 ? "男" : "女") : "",
                        Birthday = oldBaseInfo.Birthday ?? "",
                        Sex = oldBaseInfo?.Sex ?? 0,
                        oldBaseInfo?.Height,
                        oldBaseInfo?.Weight,
                        EducationType = oldBaseInfo.EducationType ?? 0,
                        EducationTypeStr = (oldBaseInfo.EducationType.HasValue && oldBaseInfo.EducationType.Value > 0) ? EnumHelper.GetEnumName(oldBaseInfo.EducationType) : "",
                        SchoolInfo = oldBaseInfo.SchoolInfo ?? "",
                        Age = string.IsNullOrWhiteSpace(oldBaseInfo.Birthday) ? "" : StringHelper.GetAge(oldBaseInfo.Birthday),//年纪
                        ShenXiao = string.IsNullOrWhiteSpace(oldBaseInfo.Birthday) ? "" : StringHelper.GetShengXiao(Convert.ToDateTime((oldBaseInfo.Birthday))),//生肖
                        ConoldBaseInfostellation = string.IsNullOrWhiteSpace(oldBaseInfo.Birthday) ? "" : StringHelper.GetAtomFromBirthday(Convert.ToDateTime((oldBaseInfo.Birthday))),//星座
                        MarriageStr = (oldBaseInfo.Marriage.HasValue && oldBaseInfo.Marriage.Value > 0) ? EnumHelper.GetEnumName(oldBaseInfo.Marriage) : "",
                        Marriage = oldBaseInfo.Marriage ?? 0,
                        YearMoneyTypeStr = (oldBaseInfo.YearMoneyType.HasValue && oldBaseInfo.YearMoneyType.Value > 0) ? EnumHelper.GetEnumName(oldBaseInfo.YearMoneyType) : "",
                        YearMoneyType = oldBaseInfo.YearMoneyType ?? 0,
                        Industry = oldBaseInfo.Industry ?? "",
                        Job = oldBaseInfo.Job ?? "",
                        WorkUnit = oldBaseInfo?.WorkUnit ?? "",
                        YearMoney = oldBaseInfo?.YearMoney ?? 0,
                        CName = oldBaseInfo.CName ?? "",
                        DName = oldBaseInfo.DName ?? "",
                        PName = oldBaseInfo.PName ?? "",
                        Province = oldBaseInfo.Province ?? 0,
                        City = oldBaseInfo.City ?? 0,
                        District = oldBaseInfo.District ?? 0,
                        OtherInfo = oldBaseInfo.OtherInfo ?? "",
                        HouseInfo = oldBaseInfo.HouseInfo ?? 0,
                        CarInfo = oldBaseInfo.CarInfo ?? 0,
                        CarInfoStr = (oldBaseInfo.CarInfo.HasValue && oldBaseInfo.CarInfo.Value > 0) ? EnumHelper.GetEnumName(oldBaseInfo.CarInfo) : "",
                        HouseInfoStr = (oldBaseInfo.HouseInfo.HasValue && oldBaseInfo.HouseInfo.Value > 0) ? EnumHelper.GetEnumName(oldBaseInfo.HouseInfo) : "",
                        FamilyInfo = oldBaseInfo?.FamilyInfo ?? "",
                        Hobby = oldBaseInfo?.Hobby ?? "",
                        LikeFood = oldBaseInfo?.LikeFood ?? "",
                        LikeBook = oldBaseInfo.LikeBook ?? "",
                        LikeTV = oldBaseInfo.LikeTV ?? "",
                        LikeSong = oldBaseInfo.LikeSong ?? "",
                        IdealLove = oldBaseInfo.IdealLove ?? "",
                        LoveTalk = oldBaseInfo.LoveTalk ?? "",
                        SingleReason = oldBaseInfo.SingleReason ?? "",
                        HopeYou = oldBaseInfo.HopeYou ?? "",
                        About = oldBaseInfo.About ?? "",
                        Appointment = oldBaseInfo.Appointment ?? "",
                        AppointmentAddress = oldBaseInfo.AppointmentAddress ?? "",
                        oldBaseInfo.AlbumList,
                        IDCardNo = oldBaseInfo.IDCardNo ?? "",
                        RealName = oldBaseInfo.RealName ?? "",
                        IDCard = oldBaseInfo.IDCard ?? "",
                        IDCardBack = oldBaseInfo.IDCardBack ?? "",
                        ActivityRegion = oldBaseInfo.ActivityRegion ?? "",
                        DWCName = oldBaseInfo.DWCName ?? "",
                        DWDName = oldBaseInfo.DWDName ?? "",
                        DWPName = oldBaseInfo.DWPName ?? "",
                        DWProvince = oldBaseInfo.DWProvince ?? 0,
                        DWCity = oldBaseInfo.DWCity ?? 0,
                        DWDistrict = oldBaseInfo.DWDistrict ?? 0,
                    };
                    return ApiResult.Success("", result);
                }
                else
                {
                    return ApiResult.Failed("用户暂未认证");
                }
            }
            else
            {
                return ApiResult.Failed("用户信息不存在!");
            }
        }


        [HttpPost]
        public ApiResult GetBaseInfoPageList()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_MiAi_BaseInfo_Extend demodel = JsonConvert.DeserializeObject<RB_MiAi_BaseInfo_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            var list = miaiModule.GetBaseInfoPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Name,
                x.UserId,
                x.Id,
                x.Photo,
                SexStr = x.Sex == 1 ? "男" : (x.Sex == 2 ? "女" : ""),
                x.Birthday,
                x.Height,
                x.Weight,
                EducationType = EnumHelper.GetEnumName(x.EducationType),
                Marriage = EnumHelper.GetEnumName(x.Marriage),
                x.Album,
                AlbumList = string.IsNullOrWhiteSpace(x.Album) ? new List<string>() : JsonConvert.DeserializeObject<List<string>>(x.Album)
            });
            return ApiResult.Success("", pagelist);
        }

        #endregion

        #region 会员中心
        /// <summary>
        /// 获取用户分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMemberUserPageList()
        {
            var parms = RequestParm;
            JObject param = JObject.Parse(parms.msg.ToString());
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(parms.msg.ToString());
            Model.Extend.User.RB_Member_MiaiUser_Extend demodel = new Model.Extend.User.RB_Member_MiaiUser_Extend()
            {
                Name = param.GetStringValue("Name"),
                Source = (Common.Enum.User.UserSourceEnum)param.GetInt("Source"),
                MemberGrade = param.GetInt("MemberGrade"),
                Id = param.GetInt("Id"),
                Moblie = param.GetStringValue("Moblie"),
                StartTime = param.GetStringValue("StartTime"),
                EndTime = param.GetStringValue("EndTime"),
                CarInfo = (Common.Enum.MiAi.CarInfoEnum)param.GetInt("CarInfo"),
                HouseInfo = (Common.Enum.MiAi.HouseInfoEnum)param.GetInt("HouseInfo"),
                EducationType = (Common.Enum.MiAi.EducationTypeEnum)param.GetInt("EducationType"),
                Marriage = (Common.Enum.MiAi.MarriageEnum)param.GetInt("Marriage"),
                Age = param.GetInt("Age"),
                EndAge = param.GetInt("EndAge"),
                Height = param.GetInt("Height"),
                EndHeight = param.GetInt("EndHeight"),
                Weight = param.GetInt("Weight"),
                EndWeight = param.GetInt("EndWeight"),
                YearMoney = param.GetInt("YearMoney"),
                EndYearMoney = param.GetInt("EndYearMoney"),
            };
            var groupIds = param.GetStringValue("GroupIdList");
            if (!string.IsNullOrEmpty(groupIds))
            {
                var idList = JsonHelper.DeserializeObject<List<int>>(groupIds);
                demodel.Q_BelongGroup_Ids = idList;
            }
            demodel.TenantId = Convert.ToInt32(parms.uid);
            demodel.MallBaseId = parms.MallBaseId;
            var list = miaiModule.GetMemberUserPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                WechatNo = x.WechatNo ?? "",
                x.Id,
                x.AliasName,
                Birthday = x.Birthday ?? "",
                EducationType = x.EducationType ?? 0,
                x.Age,
                x.Height,
                x.Weight,
                MarriageStr = (x.Marriage.HasValue && x.Marriage.Value > 0) ? EnumHelper.GetEnumName(x.Marriage) : "",
                Marriage = x.Marriage ?? 0,
                YearMoney = x?.YearMoney ?? 0,
                HouseInfo = x.HouseInfo ?? 0,
                CarInfo = x.CarInfo ?? 0,
                CarInfoStr = (x.CarInfo.HasValue && x.CarInfo.Value > 0) ? EnumHelper.GetEnumName(x.CarInfo) : "",
                HouseInfoStr = (x.HouseInfo.HasValue && x.HouseInfo.Value > 0) ? EnumHelper.GetEnumName(x.HouseInfo) : "",
                EducationTypeStr = (x.EducationType.HasValue && x.EducationType.Value > 0) ? EnumHelper.GetEnumName(x.EducationType) : "",
                x.Balance,
                x.Blacklist,
                x.CardVolumeNum,
                x.ContactWay,
                x.CouponsNum,
                x.Integral,
                x.TotalConsumption,
                x.MemberGrade,
                x.MemberGradeName,
                x.Moblie,
                x.Name,
                x.OpenId,
                x.OrderNum,
                x.Photo,
                x.Remark,
                x.Source,
                SourceName = x.Source.GetEnumName(),
                x.TenantId,
                x.PostId,
                PostName = (x?.PostId ?? 0) == 1 ? "领队导游" : "",
                UserPageTypeStr = x.UserPageType.GetEnumName(),
                CreateDate = x.CreateDate.HasValue ? x.CreateDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : "",
                x.PointNum,
                x.IsFaTie,
                x.SuperiorName,
                x.SuperiorId,
                x.BaseInfoId,
                x.IsShow,
                x.LookTimes,
                x.LookGroupList,
                x.BelongGroupList,
            }); ;
            return ApiResult.Success("", pagelist);
        }

        /// <summary>
        /// 获取用户下载枚举列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMiAiUserExportList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.User.MiAiUserExportEnum));
            return ApiResult.Success("", list.Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        /// <summary>
        /// 用户信息下载
        /// </summary>
        [HttpPost]
        public FileContentResult GetMemberUserListToExcel()
        {
            var parms = RequestParm;
            RB_Member_MiaiUser_Extend demodel = JsonConvert.DeserializeObject<RB_Member_MiaiUser_Extend>(parms.msg.ToString());
            string ExcelName = "用户列表" + DateTime.Now.ToString("yyyyMMddHHmmss") + ".xls";
            List<ExcelDataSource> slist = new List<ExcelDataSource>();
            if (demodel.ExcelEnumIds == null || !demodel.ExcelEnumIds.Any())
            {
                var byteData1 = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData1, "application/octet-stream", ExcelName);
            }
            var Enumlist = EnumHelper.GetEnumList(typeof(Common.Enum.User.MiAiUserExportEnum));
            ExcelDataSource header = new ExcelDataSource()
            {
                ExcelRows = new List<ExcelColumn>(30)
                {
                    new ExcelColumn(value: "序号") { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER }
                }
            };
            foreach (var item in demodel.ExcelEnumIds)
            {
                var Name = Enumlist.Where(x => x.Value == item.ToString()).FirstOrDefault().Key ?? "";
                header.ExcelRows.Add(new ExcelColumn(value: Name) { CellWidth = 15, HAlignmentEnum = HAlignmentEnum.CENTER, VAlignmentEnum = VAlignmentEnum.CENTER });
            }

            slist.Add(header);

            try
            {
                demodel.TenantId = Convert.ToInt32(parms.uid);
                demodel.MallBaseId = parms.MallBaseId;
                var list = miaiModule.GetMiAiList(demodel);
                #region 组装数据
                int Num = 0;
                foreach (var item in list)
                {
                    Num++;
                    ExcelDataSource datarow = new ExcelDataSource()
                    {
                        ExcelRows = new List<ExcelColumn>(30) {
                            new ExcelColumn(value:Num.ToString()){ },
                        }
                    };
                    foreach (var qitem in demodel.ExcelEnumIds)
                    {
                        switch (qitem)
                        {
                            case 1:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Source.GetEnumName()) { }); break;
                            case 2:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Id.ToString()) { }); break;
                            case 3:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.OpenId) { }); break;
                            case 4:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.AliasName ?? "") != "" ? item.AliasName : item.Name) { }); break;
                            case 5:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Moblie) { }); break;
                            case 6:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.ContactWay) { }); break;
                            case 7:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.Remark) { }); break;
                            case 8:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.CreateDate.Value.ToString("yyyy-MM-dd HH:mm:ss")) { }); break;
                            case 9:
                                datarow.ExcelRows.Add(new ExcelColumn(value: item.MemberGradeName) { }); break;
                            case 10:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.Age).ToString() + "岁") { }); break;
                            case 11:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.Height).ToString() + "CM") { }); break;
                            case 12:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.Weight).ToString() + "KG") { }); break;
                            case 13:
                                datarow.ExcelRows.Add(new ExcelColumn(value: (item.YearMoney).ToString() + "万") { }); break;
                            case 14:
                                datarow.ExcelRows.Add(new ExcelColumn(value: ((item.CarInfo.HasValue && item.CarInfo.Value > 0) ? EnumHelper.GetEnumName(item.CarInfo) : "")) { }); break;
                            case 15:
                                datarow.ExcelRows.Add(new ExcelColumn(value: ((item.HouseInfo.HasValue && item.HouseInfo.Value > 0) ? EnumHelper.GetEnumName(item.HouseInfo) : "")) { }); break;
                            case 16:
                                datarow.ExcelRows.Add(new ExcelColumn(value: ((item.EducationType.HasValue && item.EducationType.Value > 0) ? EnumHelper.GetEnumName(item.EducationType) : "")) { }); break;
                            case 17:
                                datarow.ExcelRows.Add(new ExcelColumn(value: ((item.Marriage.HasValue && item.Marriage.Value > 0) ? EnumHelper.GetEnumName(item.Marriage) : "")) { }); break;
                        }
                    }
                    slist.Add(datarow);
                }
                #endregion
                var byteData = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData, "application/octet-stream", ExcelName);
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, string.Format("GetFileFromWebApi_requestData: {0}", JsonHelper.Serialize(RequestParm)));
                var byteData1 = ExcelTempLateHelper.ToExcelExtend(slist);
                return File(byteData1, "application/octet-stream", ExcelName);
            }
        }




        /// <summary>
        /// 获取教育枚举
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetEducationTypeEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.MiAi.EducationTypeEnum));
            return ApiResult.Success("", list.OrderBy(x => Convert.ToInt32(x.Value)).Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        /// <summary>
        /// 获取婚姻枚举
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMarriageEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.MiAi.MarriageEnum));
            return ApiResult.Success("", list.OrderBy(x => Convert.ToInt32(x.Value)).Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }


        /// <summary>
        /// 获取房屋枚举
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetHouseInfoEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.MiAi.HouseInfoEnum));
            return ApiResult.Success("", list.OrderBy(x => Convert.ToInt32(x.Value)).Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        /// <summary>
        /// 获取车辆枚举
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetCarInfoEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.MiAi.CarInfoEnum));
            return ApiResult.Success("", list.OrderBy(x => Convert.ToInt32(x.Value)).Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }

        /// <summary>
        /// 获取年收入枚举
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetYearMoneyTypeEnumList()
        {
            var list = EnumHelper.GetEnumList(typeof(Common.Enum.MiAi.YearMoneyTypeEnum));
            return ApiResult.Success("", list.OrderBy(x => Convert.ToInt32(x.Value)).Select(x => new
            {
                Name = x.Key,
                Id = Convert.ToInt32(x.Value)
            }));
        }


        /// <summary>
        /// 获取用户信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetMemberUserInfo()
        {
            var requestParm = RequestParm;
            var parms = JObject.Parse(requestParm.msg.ToString());
            int UserId = parms.GetInt("UserId", 0);
            if (UserId <= 0)
            {
                return ApiResult.ParamIsNull();
            }
            var model = miaiModule.GetMemberUserInfo(UserId);
            if (model.TenantId != Convert.ToInt32(requestParm.uid))
            {
                return ApiResult.ParamIsNull("未查询到该用户信息");
            }
            if (model.MallBaseId != requestParm.MallBaseId)
            {
                return ApiResult.ParamIsNull("未查询到该用户信息");
            }
            string SuperiorName = "";
            if (model.SuperiorId > 0)
            {
                SuperiorName = miaiModule.GetMemberUserInfo(model.SuperiorId ?? 0)?.Name ?? "";
            }

            //先查询当前用户是否已经有基础信息
            var oldBaseInfo = miaiModule.GetBaseInfoModel(new RB_MiAi_BaseInfo_Extend { UserId = model.Id, TenantId = model.TenantId, MallBaseId = model.MallBaseId });
            if (oldBaseInfo != null && oldBaseInfo.Id > 0)
            {
                oldBaseInfo.AlbumList = new List<string>();
                if (!string.IsNullOrWhiteSpace(oldBaseInfo.Album))
                {
                    oldBaseInfo.AlbumList = JsonConvert.DeserializeObject<List<string>>(oldBaseInfo.Album);
                }
            }
            else
            {
                oldBaseInfo = new RB_MiAi_BaseInfo_Extend
                {
                    Sex = 1,
                    EducationType = Common.Enum.MiAi.EducationTypeEnum.HighSchool,
                    Marriage = Common.Enum.MiAi.MarriageEnum.Unmarried,
                    CarInfo = Common.Enum.MiAi.CarInfoEnum.Yes,
                    HouseInfo = Common.Enum.MiAi.HouseInfoEnum.Yes,
                    AlbumList = new List<string>()
                };
            }
            return ApiResult.Success("", new
            {
                model.Id,
                WechatNo = oldBaseInfo.WechatNo ?? "",
                Photo = model.Photo ?? "",
                model.Name,
                model.AliasName,
                model.MemberGrade,
                model.SuperiorId,
                SuperiorName,
                model.Blacklist,
                model.ContactWay,
                model.Moblie,
                model.Remark,
                model.PostId,
                CreateDate = model.CreateDate.HasValue ? model.CreateDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : "",
                SexStr = (oldBaseInfo != null && oldBaseInfo.Id > 0) ? (oldBaseInfo.Sex == 1 ? "男" : "女") : "",
                Birthday = oldBaseInfo.Birthday ?? "",
                Sex = oldBaseInfo?.Sex ?? 0,
                oldBaseInfo?.Height,
                oldBaseInfo?.Weight,
                EducationType = oldBaseInfo.EducationType ?? 0,
                EducationTypeStr = (oldBaseInfo.EducationType.HasValue && oldBaseInfo.EducationType.Value > 0) ? EnumHelper.GetEnumName(oldBaseInfo.EducationType) : "",
                SchoolInfo = oldBaseInfo.SchoolInfo ?? "",
                Age = string.IsNullOrWhiteSpace(oldBaseInfo.Birthday) ? "" : StringHelper.GetAge(oldBaseInfo.Birthday),//年纪
                ShenXiao = string.IsNullOrWhiteSpace(oldBaseInfo.Birthday) ? "" : StringHelper.GetShengXiao(Convert.ToDateTime((oldBaseInfo.Birthday))),//生肖
                ConoldBaseInfostellation = string.IsNullOrWhiteSpace(oldBaseInfo.Birthday) ? "" : StringHelper.GetAtomFromBirthday(Convert.ToDateTime((oldBaseInfo.Birthday))),//星座
                MarriageStr = (oldBaseInfo.Marriage.HasValue && oldBaseInfo.Marriage.Value > 0) ? EnumHelper.GetEnumName(oldBaseInfo.Marriage) : "",
                YearMoneyTypeStr = (oldBaseInfo.YearMoneyType.HasValue && oldBaseInfo.YearMoneyType.Value > 0) ? EnumHelper.GetEnumName(oldBaseInfo.YearMoneyType) : "",
                Industry = oldBaseInfo.Industry ?? "",
                YearMoneyType = oldBaseInfo.YearMoneyType ?? 0,
                Marriage = oldBaseInfo.Marriage ?? 0,
                Job = oldBaseInfo.Job ?? "",
                WorkUnit = oldBaseInfo?.WorkUnit ?? "",
                YearMoney = oldBaseInfo?.YearMoney ?? 0,
                CName = oldBaseInfo.CName ?? "",
                DName = oldBaseInfo.DName ?? "",
                PName = oldBaseInfo.PName ?? "",
                Province = oldBaseInfo.Province ?? 0,
                City = oldBaseInfo.City ?? 0,
                District = oldBaseInfo.District ?? 0,
                OtherInfo = oldBaseInfo.OtherInfo ?? "",
                HouseInfo = oldBaseInfo.HouseInfo ?? 0,
                CarInfo = oldBaseInfo.CarInfo ?? 0,
                CarInfoStr = (oldBaseInfo.CarInfo.HasValue && oldBaseInfo.CarInfo.Value > 0) ? EnumHelper.GetEnumName(oldBaseInfo.CarInfo) : "",
                HouseInfoStr = (oldBaseInfo.HouseInfo.HasValue && oldBaseInfo.HouseInfo.Value > 0) ? EnumHelper.GetEnumName(oldBaseInfo.HouseInfo) : "",
                FamilyInfo = oldBaseInfo?.FamilyInfo ?? "",
                Hobby = oldBaseInfo?.Hobby ?? "",
                LikeFood = oldBaseInfo?.LikeFood ?? "",
                LikeBook = oldBaseInfo.LikeBook ?? "",
                LikeTV = oldBaseInfo.LikeTV ?? "",
                LikeSong = oldBaseInfo.LikeSong ?? "",
                IdealLove = oldBaseInfo.IdealLove ?? "",
                LoveTalk = oldBaseInfo.LoveTalk ?? "",
                SingleReason = oldBaseInfo.SingleReason ?? "",
                HopeYou = oldBaseInfo.HopeYou ?? "",
                About = oldBaseInfo.About ?? "",
                Appointment = oldBaseInfo.Appointment ?? "",
                AppointmentAddress = oldBaseInfo.AppointmentAddress ?? "",
                oldBaseInfo.AlbumList,
                IDCardBack = oldBaseInfo.IDCardBack ?? "",
                IDCard = oldBaseInfo.IDCard ?? "",
                IDCardNo = oldBaseInfo.IDCardNo ?? "",
                RealName = oldBaseInfo.RealName ?? "",
                ActivityRegion = oldBaseInfo.ActivityRegion ?? "",
                BaseInfoId = oldBaseInfo?.Id ?? 0,
                IsFaTie = oldBaseInfo?.IsFaTie ?? 0,
                DWCName = oldBaseInfo.DWCName ?? "",
                DWDName = oldBaseInfo.DWDName ?? "",
                DWPName = oldBaseInfo.DWPName ?? "",
                DWProvince = oldBaseInfo.DWProvince ?? 0,
                DWCity = oldBaseInfo.DWCity ?? 0,
                DWDistrict = oldBaseInfo.DWDistrict ?? 0,
                model.IsShow,
                model.BelongGroupIds,
                model.BelongGroupIdList,
                model.LookTimes,
            });
        }
 
        /// <summary>
        /// 后台更新用户信息
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetMemberUserInfoForHT()
        {
            var parms = RequestParm;
            var jobj = JObject.Parse(parms.msg.ToString());
            RB_Member_User_Extend demodel = new RB_Member_User_Extend()
            {
                Id=jobj.GetInt("Id"),
                MemberGrade=jobj.GetInt("MemberGrade"),
                SuperiorId=jobj.GetInt("SuperiorId"),
                ContactWay=jobj.GetStringValue("ContactWay"),
                Remark=jobj.GetStringValue("Remark"),
                AliasName=jobj.GetStringValue("AliasName"),
                UpdateDate=DateTime.Now,
                PostId=jobj.GetInt("PostId"),
                Name=jobj.GetStringValue("Name"),
                Photo=jobj.GetStringValue("Photo"),
                Blacklist=jobj.GetInt("Blacklist"),
                IsShow=jobj.GetInt("IsShow"),
                LookTimes=jobj.GetInt("LookTimes"),
            };
            List<int> groupIds = new List<int>();
            if (!string.IsNullOrEmpty(jobj.GetStringValue("BelongGroupIdList")))
            {
                groupIds = JsonHelper.DeserializeObject<List<int>>(jobj.GetStringValue("BelongGroupIdList"));
            }
            demodel.BelongGroupIds = string.Join(",", groupIds);

            RB_MiAi_BaseInfo_Extend baseInfo = JsonConvert.DeserializeObject<RB_MiAi_BaseInfo_Extend>(parms.msg.ToString());
            if (demodel.Id <= 0)
            {
                return ApiResult.ParamIsNull();
            }
            var umodel = miaiModule.GetMemberUserInfo(demodel.Id);
            if (umodel == null)
            {
                return ApiResult.Failed("用户不存在");
            }
            if (umodel.TenantId != Convert.ToInt32(parms.uid))
            {
                return ApiResult.ParamIsNull("未查询到该用户信息");
            }
            if (umodel.MallBaseId != parms.MallBaseId)
            {
                return ApiResult.ParamIsNull("未查询到该用户信息");
            }
            //先查询当前用户是否已经有基础信息
            var oldBaseInfo = miaiModule.GetBaseInfoModel(new RB_MiAi_BaseInfo_Extend { UserId = umodel.Id, TenantId = umodel.TenantId, MallBaseId = umodel.MallBaseId });

            if (oldBaseInfo != null && oldBaseInfo.Id > 0)
            {
                baseInfo.Id = oldBaseInfo.Id;
            }
            else
            {
                baseInfo.Id = 0;
                baseInfo.Status = 0;
                baseInfo.CreateDate = DateTime.Now;
                baseInfo.UserId = umodel.Id;
                baseInfo.TenantId = umodel.TenantId;
                baseInfo.MallBaseId = umodel.MallBaseId;
            }
            if (baseInfo.Sex == 0)
            {
                return ApiResult.Failed("请选择性别");
            }
            if (string.IsNullOrWhiteSpace(baseInfo.Birthday))
            {
                return ApiResult.Failed("请选择生日");
            }
            if (baseInfo.Weight == 0)
            {
                return ApiResult.Failed("请选择体重");
            }
            if (baseInfo.Height == 0)
            {
                return ApiResult.Failed("请选择身高");
            }
            if ((!baseInfo.DWProvince.HasValue || baseInfo.DWProvince.Value == 0) || (!baseInfo.DWCity.HasValue || baseInfo.DWCity.Value == 0) || (!baseInfo.DWDistrict.HasValue || baseInfo.DWDistrict.Value == 0))
            {
                return ApiResult.Failed("请选择定位省市区");
            }
    
            if (!baseInfo.EducationType.HasValue || (int)baseInfo.EducationType == 0)
            {
                return ApiResult.Failed("请选择学历");
            }
            if (!baseInfo.Marriage.HasValue || (int)baseInfo.Marriage == 0)
            {
                return ApiResult.Failed("请选择婚姻状况");
            }
            if (!baseInfo.CarInfo.HasValue || (int)baseInfo.CarInfo == 0)
            {
                return ApiResult.Failed("请选择车辆信息");
            }
            if (!baseInfo.HouseInfo.HasValue || (int)baseInfo.HouseInfo == 0)
            {
                return ApiResult.Failed("请选择房产信息");
            }
            if (baseInfo.AlbumList != null && baseInfo.AlbumList.Any())
            {
                if (baseInfo.AlbumList.Count() < 2)
                {
                    return ApiResult.Failed("请上传照片，至少2张");

                }
                baseInfo.Album = JsonConvert.SerializeObject(baseInfo.AlbumList);
            }
            else
            {
                return ApiResult.Failed("请上传照片，至少2张");

            }

            bool flag = miaiModule.SetMemberUserInfoForHT(demodel);
            if (flag)
            {
                miaiModule.SetMiAiBaseInfo(baseInfo);

                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }

        /// <summary>
        /// 批量修改用户分组
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult BatchSetMemberGroup()
        {
            var jobj = JObject.Parse(RequestParm.msg.ToString());
            string userIds = jobj.GetStringValue("UserIds");
            List<int> groupIds = new List<int>();
            if (!string.IsNullOrEmpty(jobj.GetStringValue("BelongGroupIdList")))
            {
                groupIds = JsonHelper.DeserializeObject<List<int>>(jobj.GetStringValue("BelongGroupIdList"));
            }
            string BelongGroupIds = string.Join(",", groupIds);
            bool flag= miaiModule.BatchSetMemberGroupModule(BelongGroupIds, userIds);
            return flag ? ApiResult.Success() : ApiResult.Failed();
        }


        /// <summary>
        /// 更新用户的发帖权限
        /// </summary>
        /// <returns></returns>
        public ApiResult UpdateFaTie()
        {
            var parms = RequestParm;
            JObject parm = JObject.Parse(parms.msg.ToString());
            // var userInfo = AppletUserInfo;
            string userIds = parm.GetStringValue("UserIds");
            int IsFaTie = parm.GetInt("IsFaTie");
            bool retult = miaiModule.UpdateFaTie(userIds, IsFaTie);
            return retult ? ApiResult.Success("发帖权限修改成功") : ApiResult.Failed("发帖权限修改失败");
        }

        /// <summary>
        /// 更新用户的点数
        /// </summary>
        /// <returns></returns>
        public ApiResult UpdatePointNum()
        {
            var parms = RequestParm;
            JObject parm = JObject.Parse(parms.msg.ToString());
            // var userInfo = AppletUserInfo;
            int userId = parm.GetInt("UserId");
            int isAdd = parm.GetInt("IsAdd");//1-新增，2-减少
            int ponitNum = parm.GetInt("PonitNum");

            if (isAdd == 2)
            {
                //判断是否够扣除部分
                var model = miaiModule.GetMemberUserInfo(userId);
                if (model.PointNum < ponitNum)
                {
                    return ApiResult.Failed("当前星星币：" + model.PointNum);
                }
            }
            bool retult = pointModule.ManageUpdatePoint(userId, ponitNum, isAdd);
            return retult ? ApiResult.Success("星星币修改成功") : ApiResult.Failed("星星币修改失败");
        }



        #endregion

        #region 用户查看微信日子处理类

        /// <summary>
        /// 获取用户分页列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult SetWechatLog()
        {
             
            JObject param = JObject.Parse(RequestParm.msg.ToString());
            var model = new RB_Member_Look_Extend()
            {

            };
          // memberLookModule.AddMemberLookModule()
            return ApiResult.Success();
        }

        #endregion

    }
}