﻿using Mall.Common.Plugin;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Mall.Common.Enum.Goods
{
    /// <summary>
    /// 订单列表导出选项枚举
    /// </summary>
    public enum OrderListExportEnum
    {
        /// <summary>
        /// 所属平台
        /// </summary>
        [EnumField("所属平台")]
        SSPT = 1,
        /// <summary>
        /// 订单号
        /// </summary>
        [EnumField("订单号")]
        DDH = 2,
        /// <summary>
        /// 商户单号
        /// </summary>
        [EnumField("商户单号")]
        SHDH = 3,
        /// <summary>
        /// 下单用户
        /// </summary>
        [EnumField("下单用户")]
        XDYH = 4,
        /// <summary>
        /// 商品名
        /// </summary>
        [EnumField("商品名")]
        SPM = 5,
        /// <summary>
        /// 副标题
        /// </summary>
        [EnumField("副标题")]
        FBT = 28,
        /// <summary>
        /// 规格
        /// </summary>
        [EnumField("规格")]
        GG = 6,
        /// <summary>
        /// 数量
        /// </summary>
        [EnumField("数量")]
        SL = 7,
        /// <summary>
        /// 货号
        /// </summary>
        [EnumField("货号")]
        HH = 8,
        /// <summary>
        /// 成本价
        /// </summary>
        [EnumField("成本价")]
        CBJ = 9,
        /// <summary>
        /// 收件人
        /// </summary>
        [EnumField("收件人")]
        SJR = 10,
        /// <summary>
        /// 收件人电话
        /// </summary>
        [EnumField("收件人电话")]
        SJRDH = 11,
        /// <summary>
        /// 收件人地址
        /// </summary>
        [EnumField("收件人地址")]
        SJRDZ = 12,
        /// <summary>
        /// 总金额
        /// </summary>
        [EnumField("总金额")]
        ZJE = 13,
        /// <summary>
        /// 实际付款
        /// </summary>
        [EnumField("实际付款")]
        SJFK = 14,
        /// <summary>
        /// 运费
        /// </summary>
        [EnumField("运费")]
        YF = 15,
        /// <summary>
        /// 下单时间
        /// </summary>
        [EnumField("下单时间")]
        XDSJ = 16,
        /// <summary>
        /// 支付方式
        /// </summary>
        [EnumField("支付方式")]
        ZFFS = 17,
        /// <summary>
        /// 订单状态
        /// </summary>
        [EnumField("订单状态")]
        DDZT = 18,
        /// <summary>
        /// 付款状态
        /// </summary>
        [EnumField("付款状态")]
        FKZT = 19,
        /// <summary>
        /// 付款时间
        /// </summary>
        [EnumField("付款时间")]
        FKSJ = 20,
        /// <summary>
        /// 发货状态
        /// </summary>
        [EnumField("发货状态")]
        FHZT = 21,
        /// <summary>
        /// 发货时间
        /// </summary>
        [EnumField("发货时间")]
        FHSJ = 22,
        /// <summary>
        /// 收货状态
        /// </summary>
        [EnumField("收货状态")]
        SHZT = 23,
        /// <summary>
        /// 收货时间
        /// </summary>
        [EnumField("收货时间")]
        SHSJ = 24,
        /// <summary>
        /// 卖家留言
        /// </summary>
        [EnumField("卖家留言")]
        MJLY = 25,
        /// <summary>
        /// 商家备注
        /// </summary>
        [EnumField("商家备注")]
        SJBZ = 26,
        /// <summary>
        /// 备注/表单
        /// </summary>
        [EnumField("备注/表单")]
        BZBD = 27
    }


    /// <summary>
    /// 司导订单列表导出选项枚举
    /// </summary>
    public enum OrderListExportForSDEnum
    {
        /// <summary>
        /// 所属平台
        /// </summary>
        [EnumField("所属平台")]
        SSPT = 1,
        /// <summary>
        /// 订单号
        /// </summary>
        [EnumField("订单号")]
        DDH = 2,
        /// <summary>
        /// 商户单号
        /// </summary>
        [EnumField("商户单号")]
        SHDH = 3,
        /// <summary>
        /// 下单用户
        /// </summary>
        [EnumField("下单用户")]
        XDYH = 4,
        /// <summary>
        /// 商品名
        /// </summary>
        [EnumField("商品名")]
        SPM = 5,
        /// <summary>
        /// 副标题
        /// </summary>
        [EnumField("副标题")]
        FBT = 28,
        /// <summary>
        /// 数量
        /// </summary>
        [EnumField("人数")]
        SL = 7,
        /// <summary>
        /// 成本价
        /// </summary>
        [EnumField("成本价")]
        CBJ = 9,
        /// <summary>
        /// 收件人
        /// </summary>
        [EnumField("客人")]
        SJR = 10,
        /// <summary>
        /// 收件人电话
        /// </summary>
        [EnumField("电话")]
        SJRDH = 11,
        /// <summary>
        /// 收件人地址
        /// </summary>
        [EnumField("接送地址")]
        SJRDZ = 12,
        /// <summary>
        /// 总金额
        /// </summary>
        [EnumField("总金额")]
        ZJE = 13,
        /// <summary>
        /// 实际付款
        /// </summary>
        [EnumField("实际付款")]
        SJFK = 14,
        /// <summary>
        /// 运费
        /// </summary>
        [EnumField("保险费用")]
        YF = 15,
        /// <summary>
        /// 下单时间
        /// </summary>
        [EnumField("下单时间")]
        XDSJ = 16,
        /// <summary>
        /// 支付方式
        /// </summary>
        [EnumField("支付方式")]
        ZFFS = 17,
        /// <summary>
        /// 订单状态
        /// </summary>
        [EnumField("订单状态")]
        DDZT = 18,
        /// <summary>
        /// 付款状态
        /// </summary>
        [EnumField("付款状态")]
        FKZT = 19,
        /// <summary>
        /// 付款时间
        /// </summary>
        [EnumField("付款时间")]
        FKSJ = 20,
        /// <summary>
        /// 发货状态
        /// </summary>
        [EnumField("确认状态")]
        FHZT = 21,
        /// <summary>
        /// 发货时间
        /// </summary>
        [EnumField("确认时间")]
        FHSJ = 22,
        /// <summary>
        /// 收货状态
        /// </summary>
        [EnumField("出行状态")]
        SHZT = 23,
        /// <summary>
        /// 收货时间
        /// </summary>
        [EnumField("出行时间")]
        SHSJ = 24,
        /// <summary>
        /// 导游名称
        /// </summary>
        [EnumField("导游")]
        DY = 29,
        /// <summary>
        /// 车辆
        /// </summary>
        [EnumField("车辆")]
        CL = 30,
        /// <summary>
        /// 车牌号
        /// </summary>
        [EnumField("车牌号")]
        CPH = 31,
        /// <summary>
        /// 服务类型
        /// </summary>
        [EnumField("服务类型")]
        FWLX = 32,
        /// <summary>
        /// 卖家留言
        /// </summary>
        [EnumField("卖家留言")]
        MJLY = 25,
        /// <summary>
        /// 商家备注
        /// </summary>
        [EnumField("商家备注")]
        SJBZ = 26,
        /// <summary>
        /// 备注/表单
        /// </summary>
        [EnumField("备注/表单")]
        BZBD = 27
    }
}
