﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.MarketingCenter;
using Mall.Model.Extend.User;
using Mall.Module.MarketingCenter;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;

namespace Mall.WebApi.Controllers.MarketingCenter
{

    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class IntegralController : BaseController
    {
        private IntegralModule IntegralModule = new IntegralModule();

        #region 积分设置
        /// <summary>
        /// 获取积分设置
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetIntegralSettingsList()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Integral_Settings>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var oldLogisticsModel = IntegralModule.GetIntegralSettingsList(query).FirstOrDefault();
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_Integral_Settings();
            }
            return ApiResult.Success("", oldLogisticsModel);
        }


        /// <summary>
        /// 保存积分设置
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult AddOrUpdateIntegralSettings()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Integral_Settings>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            if (query == null)
            {
                return ApiResult.Failed("请传入积分设置");
            }
            else
            {

                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;
                }
                query.UpdateDate = System.DateTime.Now;
                bool result = IntegralModule.AddOrUpdateIntegralSettings(query);
                if (result)
                {
                    return ApiResult.Success("积分设置保存成功");
                }
                else
                {
                    return ApiResult.Failed("积分设置保存失败");
                }
            }
        }
        #endregion


        #region 积分记录

        /// <summary>
        /// 充值方案列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetRechargeRulesPage()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_Member_Integral_Extend demodel = JsonConvert.DeserializeObject<RB_Member_Integral_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            var list = IntegralModule.GetRechargeRecordPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.Id,
                CreateDate = x.CreateDate.Value.ToString("yyyy-MM-dd HH:mm:ss"),
                x.MemberName,
                x.Integral,
                x.Description,
                x.Remarks,
                RecordTypeStr = Mall.Common.Plugin.EnumHelper.GetEnumName(x.Type)
            });
            return ApiResult.Success("", pagelist);
        }

        #endregion
    }
}