﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Mall.Common.API;
using Mall.Common.Plugin;
using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.BaseSetUp;
using Mall.Model.Extend.MarketingCenter;
using Mall.Module.MarketingCenter;
using Mall.WebApi.Filter;
using Microsoft.AspNetCore.Cors;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Mall.WebApi.Controllers.MarketingCenter
{
    [Route("api/[controller]/[action]")]
    [ApiExceptionFilter]
    [ApiController]
    [EnableCors("AllowCors")]
    public class RechargeController : BaseController
    {
        private RechargeModule rechargeModule = new RechargeModule();


        #region 充值规则设置
        /// <summary>
        /// 充值方案列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetRechargeRulesPage()
        {
            var parms = RequestParm;
            ResultPageModel pagelist = JsonConvert.DeserializeObject<ResultPageModel>(RequestParm.msg.ToString());
            RB_Recharge_Rules_Extend demodel = JsonConvert.DeserializeObject<RB_Recharge_Rules_Extend>(RequestParm.msg.ToString());
            demodel.TenantId = UserInfo.TenantId;
            demodel.MallBaseId = parms.MallBaseId;
            var list = rechargeModule.GetRechargeRulesPageList(pagelist.pageIndex, pagelist.pageSize, out long count, demodel);
            pagelist.count = Convert.ToInt32(count);
            pagelist.pageData = list.Select(x => new
            {
                x.ID,
                CreateDate = x.CreateDate.ToString("yyyy-MM-dd HH:mm:ss"),
                x.GiveIntegral,
                x.GiveMoney,
                x.Money,
                x.Name
            });
            return ApiResult.Success("", pagelist);
        }


        /// <summary>
        /// 获取详情
        /// </summary>
        /// <returns></returns>
        public ApiResult GetRechargeRules()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Recharge_Rules_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var oldLogisticsModel = rechargeModule.GetRechargeRulesList(query).FirstOrDefault();
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_Recharge_Rules_Extend();
            }
            return ApiResult.Success("", oldLogisticsModel);
        }


        /// <summary>
        /// 保存充值方案
        /// </summary>
        /// <returns></returns>
        public ApiResult AddOrUpdateRechargeRules()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Recharge_Rules_Extend>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            if (query == null)
            {
                return ApiResult.Failed("请传入充值方案");
            }
            else
            {
                if (string.IsNullOrWhiteSpace(query.Name))
                {
                    return ApiResult.Failed("请输入充值名称");
                }
                if (query.Money == 0)
                {
                    return ApiResult.Failed("请输入充值金额");
                }

                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;
                }
                query.UpdateDate = System.DateTime.Now;
                bool result = rechargeModule.AddOrUpdateRechargeRules(query);
                if (result)
                {
                    return ApiResult.Success("充值方案保存成功");
                }
                else
                {
                    return ApiResult.Failed("充值方案保存失败");
                }
            }
        }

        /// <summary>
        /// 删除充值方案
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult DelRules()
        {
            var parms = RequestParm;
            JObject parmsJob = JObject.Parse(RequestParm.msg.ToString());
            int Id = parmsJob.GetInt("Id", 0);
            if (Id <= 0)
            {
                return ApiResult.Failed("请传递参数");
            }
            bool flag = rechargeModule.DelRechargeRules(Id, UserInfo.TenantId, parms.MallBaseId);
            if (flag)
            {
                return ApiResult.Success();
            }
            else
            {
                return ApiResult.Failed();
            }
        }
        #endregion

        #region 充值设置
        /// <summary>
        /// 获取详情
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult GetRechargeSettingsList()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Recharge_Settings>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            var oldLogisticsModel = rechargeModule.GetRechargeSettingsList(query).FirstOrDefault();
            if (oldLogisticsModel == null)
            {
                oldLogisticsModel = new RB_Recharge_Settings();
            }
            return ApiResult.Success("", oldLogisticsModel);
        }


        /// <summary>
        /// 保存充值方案
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public ApiResult AddOrUpdateRechargeSettings()
        {
            var parms = RequestParm;
            var query = JsonConvert.DeserializeObject<RB_Recharge_Settings>(RequestParm.msg.ToString());
            query.TenantId = UserInfo.TenantId;
            query.MallBaseId = parms.MallBaseId;
            if (query == null)
            {
                return ApiResult.Failed("请传入充值设置");
            }
            else
            {
                if (query.ID == 0)
                {
                    query.CreateDate = System.DateTime.Now;
                }
                query.UpdateDate = System.DateTime.Now;
                bool result = rechargeModule.AddOrUpdateRechargeSettings(query);
                if (result)
                {
                    return ApiResult.Success("充值设置保存成功");
                }
                else
                {
                    return ApiResult.Failed("充值设置保存失败");
                }
            }
        }
        #endregion
    }
}