﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Common;
using Mall.Common.Plugin;
using Mall.Model.Entity.User;
using Mall.Model.Extend.User;
using Mall.Repository;
using Mall.Repository.User;
using Mall.Repository.Product;
using Mall.Model.Extend.Product;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Configuration.Json;
using Newtonsoft.Json;
using Mall.Repository.BaseSetUp;
using Mall.Common.Enum.User;
using Mall.Common.API;
using Newtonsoft.Json.Linq;
using System.Threading;

namespace Mall.Module.User
{
    /// <summary>
    /// 商户用户处理层
    /// </summary>
    public class UserModule
    {
        /// <summary>
        /// 用户管理
        /// </summary>
        private readonly RB_Member_UserRepository member_UserRepository = new RB_Member_UserRepository();
        /// <summary>
        /// 会员等级
        /// </summary>
        private readonly RB_Member_GradeRepository member_GradeRepository = new RB_Member_GradeRepository();
        /// <summary>
        /// 会员权益
        /// </summary>
        private readonly RB_Member_EquityRepository member_EquityRepository = new RB_Member_EquityRepository();
        /// <summary>
        /// 用户积分
        /// </summary>
        private readonly RB_Member_IntegralRepository member_IntegralRepository = new RB_Member_IntegralRepository();
        /// <summary>
        /// 用户余额
        /// </summary>
        private readonly RB_Member_BalanceRepository member_BalanceRepository = new RB_Member_BalanceRepository();
        /// <summary>
        /// 素材
        /// </summary>
        private readonly RB_Material_InfoRepository material_InfoRepository = new RB_Material_InfoRepository();
        /// <summary>
        /// 分销基础配置
        /// </summary>
        private readonly RB_Distributor_BasicsRepository distributor_BasicsRepository = new RB_Distributor_BasicsRepository();
        /// <summary>
        /// 分销自定义设置
        /// </summary>
        private readonly RB_Distributor_CustomRepository distributor_CustomRepository = new RB_Distributor_CustomRepository();
        /// <summary>
        /// 分销商等级
        /// </summary>
        private readonly RB_Distributor_GradeRepository distributor_GradeRepository = new RB_Distributor_GradeRepository();
        /// <summary>
        /// 分销商
        /// </summary>
        private readonly RB_Distributor_InfoRepository distributor_InfoRepository = new RB_Distributor_InfoRepository();
        /// <summary>
        /// 分销提现
        /// </summary>
        private readonly RB_Distributor_RemitRepository distributor_RemitRepository = new RB_Distributor_RemitRepository();
        /// <summary>
        /// 收货地址
        /// </summary>
        private readonly RB_Member_ShippingAddressRepository member_ShippingAddressRepository = new RB_Member_ShippingAddressRepository();
        /// <summary>
        /// 区域
        /// </summary>
        private readonly Rb_destinationRepository destinationRepository = new Rb_destinationRepository();
        /// <summary>
        /// 商品
        /// </summary>
        private readonly RB_GoodsRepository goodsRepository = new RB_GoodsRepository();
        /// <summary>
        /// 收藏表
        /// </summary>
        private readonly RB_Member_CollectionRepository member_CollectionRepository = new RB_Member_CollectionRepository();
        /// <summary>
        /// 订单返佣
        /// </summary>
        private readonly RB_Goods_OrderCommissionRepository goods_OrderCommissionRepository = new RB_Goods_OrderCommissionRepository();
        /// <summary>
        /// 订单
        /// </summary>
        private readonly RB_Goods_OrderRepository goods_OrderRepository = new RB_Goods_OrderRepository();
        /// <summary>
        /// 足迹
        /// </summary>
        private readonly RB_Member_FootmarkRepository member_FootmarkRepository = new RB_Member_FootmarkRepository();
        /// <summary>
        /// 小程序
        /// </summary>
        private readonly RB_MiniProgramRepository miniProgramRepository = new RB_MiniProgramRepository();
        /// <summary>
        /// 和平等级
        /// </summary>
        private readonly RB_Distributor_HPGradeInfoRepository distributor_HPGradeInfoRepository = new RB_Distributor_HPGradeInfoRepository();
        /// <summary>
        /// 和平返佣
        /// </summary>
        private readonly RB_Distributor_HPCommissionRepository distributor_HPCommissionRepository = new RB_Distributor_HPCommissionRepository();
        /// <summary>
        /// 和平返佣分类
        /// </summary>
        private readonly RB_Distributor_HPCategoryRepository distributor_HPCategoryRepository = new RB_Distributor_HPCategoryRepository();
        /// <summary>
        /// 和平返佣比例
        /// </summary>
        private readonly RB_Distributor_HPGradeRatioRepository distributor_HPGradeRatioRepository = new RB_Distributor_HPGradeRatioRepository();


        /// <summary>
        /// 获取用户分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetMemberUserPageList(int pageIndex, int pageSize, out long count, RB_Member_User_Extend dmodel)
        {
            var list = member_UserRepository.GetPageList(pageIndex, pageSize, out count, dmodel);
            if (list.Any())
            {
                List<RB_Member_Grade_Extend> gradeList = new List<RB_Member_Grade_Extend>();
                if (list.Where(x => x.MemberGrade > 0).Any())
                {
                    var gradeIds = string.Join(",", list.Where(x => x.MemberGrade > 0).Select(x => x.MemberGrade ?? 0));
                    gradeList = member_GradeRepository.GetList(new RB_Member_Grade_Extend() { GradeIds = gradeIds, TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId });
                }
                foreach (var item in list)
                {
                    if (item.MemberGrade > 0)
                    {
                        item.MemberGradeName = gradeList.Where(x => x.Id == item.MemberGrade).FirstOrDefault()?.Name ?? "";
                    }
                    else
                    {
                        item.MemberGradeName = "普通会员";
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 获取下拉列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetMemberUserDropDownList(int pageIndex, int pageSize, out long count, RB_Member_User_Extend demodel)
        {
            return member_UserRepository.GetMemberUserDropDownList(pageIndex, pageSize, out count, demodel);
        }

        /// <summary>
        /// 获取用户信息
        /// </summary>
        /// <param name="userId"></param>
        /// <returns></returns>
        public RB_Member_User_Extend GetMemberUserInfo(int userId)
        {
            return member_UserRepository.GetEntity(userId).RefMapperTo<RB_Member_User_Extend>();
        }

        /// <summary>
        /// 根据条件获取用户实体
        /// </summary>
        /// <param name="query"></param>
        /// <returns></returns>
        public RB_Member_User_Extend GetMemberUserEntityModule(RB_Member_User_Extend query)
        {
            return member_UserRepository.GetMemberUserEntityRepository(query);
        }

        /// <summary>
        /// 新增用户
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public int AddMemberUserInfo(RB_Member_User_Extend demodel)
        {
            return member_UserRepository.Insert(demodel);
        }

        /// <summary>
        /// 验证用户是否存在
        /// </summary>
        /// <param name="openId"></param>
        /// <param name="source"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool ValidateUserOpenId(string openId, Common.Enum.User.UserSourceEnum? source, int tenantId, int mallBaseId)
        {
            var flag = false;
            var model = member_UserRepository.GetMemberUserEntityRepository(new RB_Member_User_Extend()
            {
                OpenId = openId,
                TenantId = tenantId,
                MallBaseId = mallBaseId,
                Source = source
            });
            if (model != null && model.Id > 0)
            {
                flag = true;
            }
            return flag;
        }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetMemberUserList(RB_Member_User_Extend dmodel)
        {
            var list = member_UserRepository.GetList(dmodel);
            if (list.Any())
            {
                List<RB_Member_Grade_Extend> gradeList = new List<RB_Member_Grade_Extend>();
                if (list.Where(x => x.MemberGrade > 0).Any())
                {
                    var gradeIds = string.Join(",", list.Where(x => x.MemberGrade > 0).Select(x => x.MemberGrade ?? 0));
                    gradeList = member_GradeRepository.GetList(new RB_Member_Grade_Extend() { GradeIds = gradeIds, TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId });
                }
                foreach (var item in list)
                {
                    if (item.MemberGrade > 0)
                    {
                        item.MemberGradeName = gradeList.Where(x => x.Id == item.MemberGrade).FirstOrDefault()?.Name ?? "";
                    }
                    else
                    {
                        item.MemberGradeName = "普通会员";
                    }
                }
            }
            return list;
        }




        /// <summary>
        ///根据昵称ID手机号码 获取列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetListByPhoneOrAliasName(RB_Member_User_Extend dmodel)
        {
            return member_UserRepository.GetListByPhoneOrAliasName(dmodel);
        }


        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetPageListByKey(int pageIndex, int pageSize, out long rowCount, RB_Member_User_Extend dmodel)
        {
            return member_UserRepository.GetPageListByKey(pageIndex, pageSize, out rowCount, dmodel);
        }

        /// <summary>
        /// 获取等级分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_Grade_Extend> GetMemberGradePageList(int pageIndex, int pageSize, out long count, RB_Member_Grade_Extend dmodel)
        {
            var list = member_GradeRepository.GetPageList(pageIndex, pageSize, out count, dmodel);
            if (list.Any())
            {
                string Ids = string.Join(",", list.Select(x => x.Id));
                var elist = member_EquityRepository.GetList(new RB_Member_Equity_Extend() { GradeIds = Ids, TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId });

                List<int> MaterialIds = new List<int>();
                MaterialIds.AddRange(list.Select(x => x.Icon ?? 0).Distinct().ToList());
                MaterialIds.AddRange(list.Select(x => x.BackgroundImage ?? 0).Distinct().ToList());
                List<RB_Material_Info_Extend> mlist = new List<RB_Material_Info_Extend>();
                if (MaterialIds.Any())
                {
                    mlist = material_InfoRepository.GetList(new RB_Material_Info_Extend() { MaterialIds = string.Join(",", MaterialIds), TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId });
                }
                foreach (var item in list)
                {
                    item.EquityList = elist.Where(x => x.GradeId == item.Id).ToList();
                    item.IconPath = mlist.Where(x => x.Id == item.Icon).FirstOrDefault()?.Path ?? "";
                    item.BackgroundImagePath = mlist.Where(x => x.Id == item.BackgroundImage).FirstOrDefault()?.Path ?? "";
                }
            }
            return list;
        }

        /// <summary>
        /// 后台修改用户信息
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetMemberUserInfoForHT(RB_Member_User_Extend demodel)
        {
            Dictionary<string, object> files = new Dictionary<string, object>() {
                { nameof(RB_Member_User.MemberGrade),demodel.MemberGrade},
                { nameof(RB_Member_User.SuperiorId),demodel.SuperiorId},
                { nameof(RB_Member_User.ContactWay),demodel.ContactWay},
                { nameof(RB_Member_User.Remark),demodel.Remark},
                { nameof(RB_Member_User.AliasName),demodel.AliasName},
                { nameof(RB_Member_Grade.UpdateDate),demodel.UpdateDate}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                    FiledName=nameof(RB_Member_User.Id),
                    FiledValue=demodel.Id,
                    OperatorEnum=OperatorEnum.Equal
                }
            };
            return member_UserRepository.Update(files, wheres);
        }

        /// <summary>
        /// 获取会员等级列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_Grade_Extend> GetMemberGradeList(RB_Member_Grade_Extend dmodel)
        {
            var list = member_GradeRepository.GetList(dmodel);
            if (list.Any())
            {
                string Ids = string.Join(",", list.Select(x => x.Id));
                var elist = member_EquityRepository.GetList(new RB_Member_Equity_Extend() { GradeIds = Ids, TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId });

                List<int> MaterialIds = new List<int>();
                MaterialIds.AddRange(list.Select(x => x.Icon ?? 0).Distinct().ToList());
                MaterialIds.AddRange(list.Select(x => x.BackgroundImage ?? 0).Distinct().ToList());
                List<RB_Material_Info_Extend> mlist = new List<RB_Material_Info_Extend>();
                if (MaterialIds.Any())
                {
                    mlist = material_InfoRepository.GetList(new RB_Material_Info_Extend() { MaterialIds = string.Join(",", MaterialIds), TenantId = dmodel.TenantId, MallBaseId = dmodel.MallBaseId });
                }
                foreach (var item in list)
                {
                    item.EquityList = elist.Where(x => x.GradeId == item.Id).ToList();
                    item.IconPath = mlist.Where(x => x.Id == item.Icon).FirstOrDefault()?.Path ?? "";
                    item.BackgroundImagePath = mlist.Where(x => x.Id == item.BackgroundImage).FirstOrDefault()?.Path ?? "";
                }
            }
            return list;
        }

        /// <summary>
        /// 获取会员等级列表
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_Grade_Extend> GetMemberGrade(RB_Member_Grade_Extend dmodel)
        {
            var list = member_GradeRepository.GetGrade(dmodel);
            return list;
        }

        /// <summary>
        /// 新增会员等级
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetMemberGradeInfo(RB_Member_Grade_Extend demodel)
        {
            var trans = member_GradeRepository.DbTransaction;
            try
            {
                if (demodel.Id > 0)
                {
                    Dictionary<string, object> files = new Dictionary<string, object>() {
                        { nameof(RB_Member_Grade.BackgroundImage),demodel.BackgroundImage},
                        { nameof(RB_Member_Grade.Discount),demodel.Discount},
                        { nameof(RB_Member_Grade.Enabled),demodel.Enabled},
                        { nameof(RB_Member_Grade.Grade),demodel.Grade},
                        { nameof(RB_Member_Grade.Icon),demodel.Icon},
                        { nameof(RB_Member_Grade.IsAutoUpGrade),demodel.IsAutoUpGrade},
                        { nameof(RB_Member_Grade.IsMemberBuy),demodel.IsMemberBuy},
                        { nameof(RB_Member_Grade.MemberBuyMoney),demodel.MemberBuyMoney},
                        { nameof(RB_Member_Grade.MemberSpecification),demodel.MemberSpecification},
                        { nameof(RB_Member_Grade.Name),demodel.Name},
                        { nameof(RB_Member_Grade.UpGradeMoney),demodel.UpGradeMoney},
                        { nameof(RB_Member_Grade.UpdateDate),demodel.UpdateDate},
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                         FiledName=nameof(RB_Member_Grade.Id),
                          FiledValue=demodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    bool flag = member_GradeRepository.Update(files, wheres, trans);
                    if (flag)
                    {
                        var elist = member_EquityRepository.GetList(new RB_Member_Equity_Extend() { GradeId = demodel.Id });
                        List<RB_Member_Equity_Extend> InsertList = new List<RB_Member_Equity_Extend>();
                        List<RB_Member_Equity_Extend> UpdateList = new List<RB_Member_Equity_Extend>();
                        List<RB_Member_Equity_Extend> DeleteList = new List<RB_Member_Equity_Extend>();
                        if (demodel.EquityList != null && demodel.EquityList.Any())
                        {
                            InsertList = demodel.EquityList.Where(x => x.Id == 0).ToList();
                            UpdateList = demodel.EquityList.Where(x => elist.Select(y => y.Id).Contains(x.Id)).ToList();
                            DeleteList = elist.Where(x => !demodel.EquityList.Select(y => y.Id).Contains(x.Id)).ToList();
                        }
                        foreach (var item in InsertList)
                        {
                            member_EquityRepository.Insert(new RB_Member_Equity()
                            {
                                Content = item.Content,
                                CreateDate = demodel.CreateDate,
                                GradeId = demodel.Id,
                                Id = 0,
                                Image = item.Image,
                                MallBaseId = demodel.MallBaseId,
                                Status = 0,
                                TenantId = demodel.TenantId,
                                Title = item.Title,
                                UpdateDate = demodel.CreateDate
                            }, trans);
                        }
                        foreach (var item in UpdateList)
                        {
                            Dictionary<string, object> cols = new Dictionary<string, object>() {
                                { nameof(RB_Member_Equity.Content),item.Content},
                                { nameof(RB_Member_Equity.Image),item.Image},
                                { nameof(RB_Member_Equity.Title),item.Title},
                                { nameof(RB_Member_Equity.UpdateDate),demodel.UpdateDate},
                            };
                            List<WhereHelper> wheres1 = new List<WhereHelper>() {
                                new WhereHelper(){
                                     FiledName=nameof(RB_Member_Equity.Id),
                                      FiledValue=item.Id,
                                       OperatorEnum=OperatorEnum.Equal
                                }
                            };
                            member_EquityRepository.Update(cols, wheres1, trans);
                        }
                        foreach (var item in DeleteList)
                        {
                            Dictionary<string, object> cols = new Dictionary<string, object>() {
                                { nameof(RB_Member_Equity.Status),1},
                                { nameof(RB_Member_Equity.UpdateDate),demodel.UpdateDate},
                            };
                            List<WhereHelper> wheres1 = new List<WhereHelper>() {
                                new WhereHelper(){
                                     FiledName=nameof(RB_Member_Equity.Id),
                                      FiledValue=item.Id,
                                       OperatorEnum=OperatorEnum.Equal
                                }
                            };
                            member_EquityRepository.Update(cols, wheres1, trans);
                        }
                    }
                    member_GradeRepository.DBSession.Commit();
                    return flag;
                }
                else
                {
                    int Id = member_GradeRepository.Insert(demodel, trans);
                    bool flag = Id > 0;
                    if (flag)
                    {
                        //插入权益
                        if (demodel.EquityList != null && demodel.EquityList.Any())
                        {
                            foreach (var item in demodel.EquityList)
                            {
                                member_EquityRepository.Insert(new Model.Entity.User.RB_Member_Equity()
                                {
                                    Content = item.Content,
                                    CreateDate = demodel.CreateDate,
                                    GradeId = Id,
                                    Id = 0,
                                    Image = item.Image,
                                    MallBaseId = demodel.MallBaseId,
                                    Status = 0,
                                    TenantId = demodel.TenantId,
                                    Title = item.Title,
                                    UpdateDate = demodel.CreateDate
                                }, trans);
                            }
                        }
                    }
                    member_GradeRepository.DBSession.Commit();
                    return flag;
                }
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "SetMemberGradeInfo");
                member_GradeRepository.DBSession.Rollback();
                return false;
            }
        }

        /// <summary>
        /// 验证会员等级是否存在
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool ValidateMemberGrade(RB_Member_Grade_Extend demodel)
        {
            List<WhereHelper> whereHelpers = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Member_Grade.Grade),
                        FiledValue=demodel.Grade,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Member_Grade.TenantId),
                        FiledValue=demodel.TenantId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Member_Grade.MallBaseId),
                        FiledValue=demodel.MallBaseId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            if (demodel.Id > 0) {
                whereHelpers.Add(new WhereHelper()
                {
                    FiledName = nameof(RB_Member_Grade.Id),
                    FiledValue = demodel.Id,
                    OperatorEnum = OperatorEnum.NotEqual
                });
            }
            return member_GradeRepository.Exists(whereHelpers);
        }

        /// <summary>
        /// 获取会员等级
        /// </summary>
        /// <param name="gradeId"></param>
        /// <returns></returns>
        public RB_Member_Grade_Extend GetMemberGradeInfo(int gradeId)
        {
            var model = member_GradeRepository.GetEntity(gradeId).RefMapperTo<RB_Member_Grade_Extend>();
            if (model == null)
            {
                return new RB_Member_Grade_Extend();
            }
            model.EquityList = member_EquityRepository.GetList(new RB_Member_Equity_Extend() { GradeId = model.Id });
            model.IconPath = material_InfoRepository.GetEntity(model.Icon)?.Path ?? "";
            model.BackgroundImagePath = material_InfoRepository.GetEntity(model.BackgroundImage)?.Path ?? "";
            return model;
        }

        /// <summary>
        /// 删除会员等级
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <returns></returns>
        public bool DelMemberGradeInfo(int gradeId, string uid)
        {
            Dictionary<string, object> cols = new Dictionary<string, object>() {
                { nameof(RB_Member_Grade.Status),1},
                { nameof(RB_Member_Grade.UpdateDate),DateTime.Now},
            };
            List<WhereHelper> wheres1 = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Member_Grade.Id),
                        FiledValue=gradeId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Member_Grade.TenantId),
                        FiledValue=Convert.ToInt32(uid),
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return member_GradeRepository.Update(cols, wheres1);
        }

        /// <summary>
        /// 获取积分分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Member_Integral_Extend> GetMemberIntegralPageList(int pageIndex, int pageSize, out long count, RB_Member_Integral_Extend demodel)
        {
            return member_IntegralRepository.GetPageList(pageIndex, pageSize, out count, demodel);
        }

        /// <summary>
        /// 保存积分
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetMemberIntegralInfo(RB_Member_Integral_Extend demodel)
        {
            var umodel = member_UserRepository.GetEntity(demodel.UserId);
            int Integral;
            if ((int)demodel.Type == 1)
            {
                Integral = (umodel.Integral ?? 0) + (demodel.Integral ?? 0);
            }
            else
            {
                Integral = (umodel.Integral ?? 0) - (demodel.Integral ?? 0);
            }
            if (Integral < 0)
            {
                Integral = 0;
            }
            Dictionary<string, object> keys = new Dictionary<string, object>() {
                { nameof(RB_Member_User.Integral),Integral}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                    FiledName=nameof(RB_Member_User.Id),
                    FiledValue=demodel.UserId,
                    OperatorEnum=OperatorEnum.Equal
                }
            };
            bool flag = member_UserRepository.Update(keys, wheres);
            if (flag)
            {
                return member_IntegralRepository.Insert(demodel) > 0;
            }
            return false;
        }

        /// <summary>
        /// 获取余额分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Member_Balance_Extend> GetMemberBalancePageList(int pageIndex, int pageSize, out long count, RB_Member_Balance_Extend demodel)
        {
            return member_BalanceRepository.GetPageList(pageIndex, pageSize, out count, demodel);
        }

        /// <summary>
        /// 保存余额充值
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetMemberBalanceInfo(RB_Member_Balance_Extend demodel)
        {
            var umodel = member_UserRepository.GetEntity(demodel.UserId);
            decimal Balance;
            if ((int)demodel.Type == 1)
            {
                Balance = (umodel.Balance ?? 0) + (demodel.Balance ?? 0);
            }
            else
            {
                Balance = (umodel.Balance ?? 0) - (demodel.Balance ?? 0);
            }
            if (Balance < 0)
            {
                Balance = 0;
            }
            Dictionary<string, object> keys = new Dictionary<string, object>() {
                { nameof(RB_Member_User.Balance),Balance}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                    FiledName=nameof(RB_Member_User.Id),
                    FiledValue=demodel.UserId,
                    OperatorEnum=OperatorEnum.Equal
                }
            };
            bool flag = member_UserRepository.Update(keys, wheres);
            if (flag)
            {
                return member_BalanceRepository.Insert(demodel) > 0;
            }
            return false;
        }

        /// <summary>
        /// 设置分销基础配置
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetDistributorBasicsInfo(RB_Distributor_Basics_Extend demodel)
        {
            demodel.GradeEntranceImage = new ConfigurationBuilder().Add(new JsonConfigurationSource { Path = "appsettings.json" }).Build().GetSection("InitializeImages")["GradeEntranceImage"];
            var OModel = distributor_BasicsRepository.GetList(new RB_Distributor_Basics_Extend() { TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId }).FirstOrDefault();
            if (OModel != null)
            {
                demodel.Id = OModel.Id;
                Dictionary<string, object> keyValuePairs = new Dictionary<string, object>() {
                    { nameof(RB_Distributor_Basics.DistributorTier),demodel.DistributorTier},
                    { nameof(RB_Distributor_Basics.InPurchasing),demodel.InPurchasing},
                    { nameof(RB_Distributor_Basics.ReferralsCondition),demodel.ReferralsCondition},
                    { nameof(RB_Distributor_Basics.ApplyFor),demodel.ApplyFor},
                    { nameof(RB_Distributor_Basics.DistributorCondition),demodel.DistributorCondition},
                    { nameof(RB_Distributor_Basics.DistributorCommissionType),demodel.DistributorCommissionType},
                    { nameof(RB_Distributor_Basics.OneCommission),demodel.OneCommission},
                    { nameof(RB_Distributor_Basics.TwoCommission),demodel.TwoCommission},
                    { nameof(RB_Distributor_Basics.ThreeCommission),demodel.ThreeCommission},
                    { nameof(RB_Distributor_Basics.GradeEntrance),demodel.GradeEntrance},
                    { nameof(RB_Distributor_Basics.GradeEntranceImage),demodel.GradeEntranceImage},
                    { nameof(RB_Distributor_Basics.WithdrawWay),demodel.WithdrawWay},
                    { nameof(RB_Distributor_Basics.MinimumWithdrawalLimit),demodel.MinimumWithdrawalLimit},
                    { nameof(RB_Distributor_Basics.DailyWithdrawalLimit),demodel.DailyWithdrawalLimit},
                    { nameof(RB_Distributor_Basics.WithdrawFee),demodel.WithdrawFee},
                    { nameof(RB_Distributor_Basics.ApplicationProtocol),demodel.ApplicationProtocol},
                    { nameof(RB_Distributor_Basics.UserNotes),demodel.UserNotes},
                    { nameof(RB_Distributor_Basics.BackgroundImage),demodel.BackgroundImage},
                    { nameof(RB_Distributor_Basics.IndexImage),demodel.IndexImage},
                    { nameof(RB_Distributor_Basics.UpdateDate),demodel.UpdateDate}
                };
                List<WhereHelper> whereHelpers = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_Distributor_Basics.Id),
                          FiledValue=demodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                         FiledName=nameof(RB_Distributor_Basics.TenantId),
                          FiledValue=demodel.TenantId,
                           OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                         FiledName=nameof(RB_Distributor_Basics.MallBaseId),
                          FiledValue=demodel.MallBaseId,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                return distributor_BasicsRepository.Update(keyValuePairs, whereHelpers);
            }
            else
            {
                return distributor_BasicsRepository.Insert(demodel) > 0;
            }
        }

        /// <summary>
        /// 获取分销基础信息
        /// </summary>
        /// <param name="basicsId"></param>
        /// <returns></returns>
        public RB_Distributor_Basics_Extend GetDistributorBasicsInfo(int basicsId)
        {
            var model = distributor_BasicsRepository.GetEntity(basicsId).RefMapperTo<RB_Distributor_Basics_Extend>();
            if (model == null)
            {
                return new RB_Distributor_Basics_Extend();
            }
            model.IndexImagePath = material_InfoRepository.GetEntity(model.IndexImage)?.Path ?? "";
            model.BackgroundImagePath = material_InfoRepository.GetEntity(model.BackgroundImage)?.Path ?? "";
            return model;
        }

        /// <summary>
        /// 获取分销基础信息
        /// </summary>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public RB_Distributor_Basics_Extend GetDistributorBasicsInfo(string uid, int mallBaseId)
        {
            var model = distributor_BasicsRepository.GetList(new RB_Distributor_Basics_Extend() { TenantId = Convert.ToInt32(uid), MallBaseId = mallBaseId }).FirstOrDefault();
            if (model == null)
            {
                return new RB_Distributor_Basics_Extend();
            }
            model.IndexImagePath = material_InfoRepository.GetEntity(model.IndexImage)?.Path ?? "";
            model.BackgroundImagePath = material_InfoRepository.GetEntity(model.BackgroundImage)?.Path ?? "";
            if (!string.IsNullOrEmpty(model.WithdrawWay))
            {
                model.WithdrawWayList = JsonConvert.DeserializeObject<List<int>>(model.WithdrawWay);
            }
            return model;
        }

        /// <summary>
        /// 设置分销自定义
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetDistributorCustomInfo(RB_Distributor_Custom_Extend demodel)
        {
            var OModel = distributor_CustomRepository.GetList(new RB_Distributor_Custom_Extend() { TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId }).FirstOrDefault();
            if (OModel != null)
            {
                demodel.Id = OModel.Id;
                Dictionary<string, object> keyValuePairs = new Dictionary<string, object>() {
                    { nameof(RB_Distributor_Custom.HeadImage),demodel.HeadImage},
                    { nameof(RB_Distributor_Custom.BottomImage),demodel.BottomImage},
                    { nameof(RB_Distributor_Custom.DistributionApplication),demodel.DistributionApplication},
                    { nameof(RB_Distributor_Custom.ApplicationAgreement),demodel.ApplicationAgreement},
                    { nameof(RB_Distributor_Custom.ButtonFilletPX),demodel.ButtonFilletPX},
                    { nameof(RB_Distributor_Custom.ButtonText),demodel.ButtonText},
                    { nameof(RB_Distributor_Custom.ButtonColor),demodel.ButtonColor},
                    { nameof(RB_Distributor_Custom.ButtonTextColor),demodel.ButtonTextColor},
                    { nameof(RB_Distributor_Custom.DistributionCommissionName),demodel.DistributionCommissionName},
                    { nameof(RB_Distributor_Custom.DistributionCommissionImage),demodel.DistributionCommissionImage},
                    { nameof(RB_Distributor_Custom.DistributionOrderName),demodel.DistributionOrderName},
                    { nameof(RB_Distributor_Custom.DistributionOrderImage),demodel.DistributionOrderImage},
                    { nameof(RB_Distributor_Custom.WithdrawDetialsName),demodel.WithdrawDetialsName},
                    { nameof(RB_Distributor_Custom.WithdrawDetialsImage),demodel.WithdrawDetialsImage},
                    { nameof(RB_Distributor_Custom.MyTeamName),demodel.MyTeamName},
                    { nameof(RB_Distributor_Custom.MyTeamImage),demodel.MyTeamImage},
                    { nameof(RB_Distributor_Custom.PromoteQRCodeName),demodel.PromoteQRCodeName},
                    { nameof(RB_Distributor_Custom.PromoteQRCodeImage),demodel.PromoteQRCodeImage},
                    { nameof(RB_Distributor_Custom.ReferrerName),demodel.ReferrerName},
                    { nameof(RB_Distributor_Custom.CommissionForWithdrawalName),demodel.CommissionForWithdrawalName},
                    { nameof(RB_Distributor_Custom.WithdrawDepositName),demodel.WithdrawDepositName},
                    { nameof(RB_Distributor_Custom.CommissionWithdrawnName),demodel.CommissionWithdrawnName},
                    { nameof(RB_Distributor_Custom.OutstandingCommissionName),demodel.OutstandingCommissionName},
                    { nameof(RB_Distributor_Custom.DistributorName),demodel.DistributorName},
                    { nameof(RB_Distributor_Custom.CommissionTobePaidName),demodel.CommissionTobePaidName},
                    { nameof(RB_Distributor_Custom.UserNotesName),demodel.UserNotesName},
                    { nameof(RB_Distributor_Custom.IWantToWithdrawName),demodel.IWantToWithdrawName},
                    { nameof(RB_Distributor_Custom.WithdrawalAmountName),demodel.WithdrawalAmountName},
                    { nameof(RB_Distributor_Custom.WithdrawalWayName),demodel.WithdrawalWayName},
                    { nameof(RB_Distributor_Custom.OneDistributionName),demodel.OneDistributionName},
                    { nameof(RB_Distributor_Custom.TwoDistributionName),demodel.TwoDistributionName},
                    { nameof(RB_Distributor_Custom.ThreeDistributionName),demodel.ThreeDistributionName},
                    { nameof(RB_Distributor_Custom.UpdateDate),demodel.UpdateDate}
                };
                List<WhereHelper> whereHelpers = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_Distributor_Custom.Id),
                          FiledValue=demodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                         FiledName=nameof(RB_Distributor_Custom.TenantId),
                          FiledValue=demodel.TenantId,
                           OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper(){
                         FiledName=nameof(RB_Distributor_Custom.MallBaseId),
                          FiledValue=demodel.MallBaseId,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                return distributor_CustomRepository.Update(keyValuePairs, whereHelpers);
            }
            else
            {
                return distributor_CustomRepository.Insert(demodel) > 0;
            }
        }

        /// <summary>
        /// 获取分销自定义信息
        /// </summary>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public RB_Distributor_Custom_Extend GetDistributorCustomInfo(string uid, int mallBaseId)
        {
            var model = distributor_CustomRepository.GetList(new RB_Distributor_Custom_Extend() { TenantId = Convert.ToInt32(uid), MallBaseId = mallBaseId }).FirstOrDefault();
            if (model == null)
            {
                return new RB_Distributor_Custom_Extend();
            }
            model.BottomImagePath = material_InfoRepository.GetEntity(model.BottomImage)?.Path ?? "";
            model.DistributionCommissionImagePath = material_InfoRepository.GetEntity(model.DistributionCommissionImage)?.Path ?? "";
            model.DistributionOrderImagePath = material_InfoRepository.GetEntity(model.DistributionOrderImage)?.Path ?? "";
            model.HeadImagePath = material_InfoRepository.GetEntity(model.HeadImage)?.Path ?? "";
            model.MyTeamImagePath = material_InfoRepository.GetEntity(model.MyTeamImage)?.Path ?? "";
            model.PromoteQRCodeImagePath = material_InfoRepository.GetEntity(model.PromoteQRCodeImage)?.Path ?? "";
            model.WithdrawDetialsImagePath = material_InfoRepository.GetEntity(model.WithdrawDetialsImage)?.Path ?? "";
            return model;
        }

        /// <summary>
        /// 获取等级分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_Grade_Extend> GetDistributorGradePageList(int pageIndex, int pageSize, out long count, RB_Distributor_Grade_Extend demodel)
        {
            var list = distributor_GradeRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            //获取分销商基础
            var bmodel = GetDistributorBasicsInfo(demodel.TenantId.ToString(), demodel.MallBaseId);
            if (bmodel != null)
            {
                switch (bmodel.DistributorTier)
                {
                    case 0:
                        foreach (var item in list)
                        {
                            item.OneCommission = -1;
                            item.TwoCommission = -1;
                            item.ThreeCommission = -1;
                        }
                        break;
                    case 1:
                        foreach (var item in list)
                        {
                            item.TwoCommission = -1;
                            item.ThreeCommission = -1;
                        }
                        break;
                    case 2:
                        foreach (var item in list)
                        {
                            item.ThreeCommission = -1;
                        }
                        break;
                }
            }
            return list;
        }

        /// <summary>
        /// 新增修改分销商等级
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetDistributorGradeInfo(RB_Distributor_Grade_Extend demodel)
        {
            if (demodel.Id > 0)
            {
                var model = distributor_GradeRepository.GetEntity(demodel.Id);
                if (model == null)
                {
                    return false;
                }
                if (model.TenantId != demodel.TenantId)
                {
                    return false;
                }
                if (model.MallBaseId != demodel.MallBaseId)
                {
                    return false;
                }
                if (model.Enabled == 1 && demodel.Enabled == 2)
                {
                    //验证是否有分销商在使用该等级
                    if (ValidateDistributorGradeEnabled(model.Id))
                    {
                        return false;
                    }
                }

                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Distributor_Grade.CommissionWithdrawn),demodel.CommissionWithdrawn},
                    { nameof(RB_Distributor_Grade.DistributionCommissionType),demodel.DistributionCommissionType},
                    { nameof(RB_Distributor_Grade.Enabled),demodel.Enabled},
                    { nameof(RB_Distributor_Grade.Grade),demodel.Grade},
                    { nameof(RB_Distributor_Grade.GradeExplain),demodel.GradeExplain},
                    { nameof(RB_Distributor_Grade.IsAutoUpGrade),demodel.IsAutoUpGrade},
                    { nameof(RB_Distributor_Grade.Name),demodel.Name},
                    { nameof(RB_Distributor_Grade.OneCommission),demodel.OneCommission},
                    { nameof(RB_Distributor_Grade.ReferralsNumber),demodel.ReferralsNumber},
                    { nameof(RB_Distributor_Grade.ThreeCommission),demodel.ThreeCommission},
                    { nameof(RB_Distributor_Grade.TotalCommission),demodel.TotalCommission},
                    { nameof(RB_Distributor_Grade.TwoCommission),demodel.TwoCommission},
                    { nameof(RB_Distributor_Grade.UpGradeCondition),demodel.UpGradeCondition},
                    { nameof(RB_Distributor_Grade.UpdateDate),demodel.UpdateDate}
                };
                List<WhereHelper> whereHelpers = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_Distributor_Grade.Id),
                          FiledValue=demodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                bool flag = distributor_GradeRepository.Update(keyValues, whereHelpers);
                if (flag)
                {
                    if (model.Enabled == 1 && demodel.Enabled == 2)
                    {
                        //由启用设置为停用  需更新该等级下的用户为默认等级
                        member_UserRepository.UpdateMemberGrade(GradeId: demodel.Id, DefaultGId: 0, demodel.TenantId, demodel.MallBaseId);
                    }
                }
                return flag;
            }
            else
            {
                return distributor_GradeRepository.Insert(demodel) > 0;
            }
        }

        /// <summary>
        /// 获取分销等级下拉列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_Grade_Extend> GetDistributorGradeDropdownList(RB_Distributor_Grade_Extend demodel)
        {
            var list = distributor_GradeRepository.GetList(demodel);
            return list;
        }

        /// <summary>
        /// 删除
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool DelDistributorGradeInfo(int gradeId, string uid, int mallBaseId)
        {
            var gmodel = distributor_GradeRepository.GetEntity(gradeId);
            if (gmodel == null)
            {
                return false;
            }
            if (gmodel.TenantId != Convert.ToInt32(uid))
            {
                return false;
            }
            if (gmodel.MallBaseId != mallBaseId)
            {
                return false;
            }
            if (gmodel.Enabled == 1)
            {
                return false;
            }
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Distributor_Grade.Status),1},
                { nameof(RB_Distributor_Grade.UpdateDate),DateTime.Now}
            };
            List<WhereHelper> whereHelpers = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Distributor_Grade.Id),
                        FiledValue=gradeId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return distributor_GradeRepository.Update(keyValues, whereHelpers);
        }

        /// <summary>
        /// 验证分销商等级使用
        /// </summary>
        /// <param name="gradeId"></param>
        /// <returns></returns>
        public bool ValidateDistributorGradeEnabled(int gradeId)
        {
            List<WhereHelper> whereHelpers = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Distributor_Info.GradeId),
                        FiledValue=gradeId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Distributor_Info.Status),
                        FiledValue=0,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Distributor_Info.AuditStatus),
                        FiledValue=2,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return distributor_InfoRepository.Exists(whereHelpers);
        }

        /// <summary>
        /// 修改分销商等级启用
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public bool SetDistributorGradeEnabledStatus(RB_Distributor_Grade model)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Distributor_Grade.Enabled),model.Enabled==1?2:1},
                { nameof(RB_Distributor_Grade.UpdateDate),DateTime.Now}
            };
            List<WhereHelper> whereHelpers = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Distributor_Grade.Id),
                        FiledValue=model.Id,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return distributor_GradeRepository.Update(keyValues, whereHelpers);
        }

        /// <summary>
        /// 获取分销商等级信息
        /// </summary>
        /// <param name="gradeId"></param>
        /// <returns></returns>
        public RB_Distributor_Grade GetDistributorGradeInfo(int gradeId)
        {
            return distributor_GradeRepository.GetEntity(gradeId);
        }

        /// <summary>
        /// 获取分销商分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_Info_Extend> GetDistributorInfoPageList(int pageIndex, int pageSize, out long count, RB_Distributor_Info_Extend demodel)
        {
            var list = distributor_InfoRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any())
            {
                //查询分销商等级
                string gradeIds = string.Join(",", list.Where(x => x.GradeId > 0).Select(x => x.GradeId ?? 0).Distinct());
                List<RB_Distributor_Grade_Extend> GradeList = new List<RB_Distributor_Grade_Extend>();
                if (!string.IsNullOrEmpty(gradeIds))
                {
                    GradeList = distributor_GradeRepository.GetList(new RB_Distributor_Grade_Extend() { GradeIds = gradeIds, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                }
                //查询和平分销等级
                string hpgradeIds = string.Join(",", list.Where(x => x.HPGradeId > 0).Select(x => x.HPGradeId ?? 0).Distinct());
                List<RB_Distributor_HPGradeInfo_Extend> HPGradeList = new List<RB_Distributor_HPGradeInfo_Extend>();
                if (!string.IsNullOrEmpty(hpgradeIds))
                {
                    HPGradeList = distributor_HPGradeInfoRepository.GetList(new RB_Distributor_HPGradeInfo_Extend() { GradeIds = hpgradeIds, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                }
                //查询推荐人列表
                string tjrIds = string.Join(",", list.Where(x => x.SuperiorId > 0).Select(x => x.SuperiorId ?? 0).Distinct());
                List<RB_Member_User_Extend> UserList = new List<RB_Member_User_Extend>();
                if (!string.IsNullOrEmpty(tjrIds))
                {
                    UserList = member_UserRepository.GetList(new RB_Member_User_Extend() { UserIds = tjrIds, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                }
                //根据基础配置层级查询下级数量  暂放弃
                //var basmdoel = GetDistributorBasicsInfo(demodel.TenantId.ToString(), demodel.MallBaseId);
                //if (basmdoel != null && basmdoel.DistributorTier > 0) {
                string uids = string.Join(",", list.Select(x => x.UserId ?? 0));
                List<RB_Member_User_Extend> UserNum1List = member_UserRepository.GetDistributorReferralsNum(uids, tier: 1, tenantId: demodel.TenantId, mallBaseId: demodel.MallBaseId);//直接查询三级
                List<RB_Member_User_Extend> UserNum2List = member_UserRepository.GetDistributorReferralsNum(uids, tier: 2, tenantId: demodel.TenantId, mallBaseId: demodel.MallBaseId);//直接查询三级
                List<RB_Member_User_Extend> UserNum3List = member_UserRepository.GetDistributorReferralsNum(uids, tier: 3, tenantId: demodel.TenantId, mallBaseId: demodel.MallBaseId);//直接查询三级

                foreach (var item in list)
                {
                    if (item.GradeId == 0)
                    {
                        item.GradeName = "默认等级";
                    }
                    else if (item.GradeId > 0)
                    {
                        item.GradeName = GradeList.Where(x => x.Id == item.GradeId).FirstOrDefault()?.Name ?? "";
                    }
                    if ((item.HPGradeId ?? 0) == 0)
                    {
                        item.HPGradeName = "默认等级";
                    }
                    else if (item.HPGradeId > 0)
                    {
                        item.HPGradeName = HPGradeList.Where(x => x.Id == item.HPGradeId).FirstOrDefault()?.GradeName ?? "";
                    }


                    if (item.SuperiorId == 0)
                    {
                        item.SuperiorName = "总店";
                    }
                    else if (item.SuperiorId > 0)
                    {
                        item.SuperiorName = UserList.Where(x => x.Id == item.SuperiorId).FirstOrDefault()?.Name ?? "";
                    }
                    item.OneNum = 0;
                    if (UserNum1List.Any())
                    {
                        item.OneNum = UserNum1List.Where(x => x.SuperiorId == item.UserId).FirstOrDefault()?.ReferralsNum ?? 0;
                    }
                    item.TwoNum = 0;
                    if (UserNum1List.Any())
                    {
                        item.TwoNum = UserNum2List.Where(x => x.SuperiorId == item.UserId).FirstOrDefault()?.ReferralsNum ?? 0;
                    }
                    item.ThreeNum = 0;
                    if (UserNum1List.Any())
                    {
                        item.ThreeNum = UserNum3List.Where(x => x.SuperiorId == item.UserId).FirstOrDefault()?.ReferralsNum ?? 0;
                    }
                }

            }
            return list;
        }

        /// <summary>
        /// 新增分销商
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetDistributorInfo(RB_Distributor_Info_Extend demodel)
        {
            demodel.TotalCommission ??= 0;
            demodel.CommissionWithdrawal ??= 0;
            demodel.Name ??= "";
            demodel.GradeId ??= 0;
            demodel.AuditStatus = Common.Enum.User.DistributorAuditStatusEnum.Auditing;
            bool flag = distributor_InfoRepository.Insert(demodel) > 0;
            if (flag)
            {
                //更新手机号码
                //Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                //    { nameof(RB_Member_User.Moblie),demodel.Mobile}
                //};
                //List<WhereHelper> wheres = new List<WhereHelper>() {
                //    new WhereHelper(){
                //            FiledName=nameof(RB_Member_User.Id),
                //            FiledValue=demodel.UserId,
                //            OperatorEnum=OperatorEnum.Equal
                //    }
                //};
                //member_UserRepository.Update(keyValues, wheres);
            }
            return flag;
        }

        /// <summary>
        /// 验证分销商
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public string ValidateDistributorInfo(int? userId, int tenantId, int mallBaseId)
        {
            var model = distributor_InfoRepository.GetList(new RB_Distributor_Info_Extend() { UserId = userId, TenantId = tenantId, MallBaseId = mallBaseId }).FirstOrDefault();
            if (model == null)
            {
                return "";
            }
            if (model.AuditStatus == Common.Enum.User.DistributorAuditStatusEnum.Reject)
            {
                return "已被拒绝，无法再次申请";
            }
            else if (model.AuditStatus == Common.Enum.User.DistributorAuditStatusEnum.Auditing)
            {
                return "申请正在审核中，无法再次申请";
            }
            else if (model.AuditStatus == Common.Enum.User.DistributorAuditStatusEnum.Audited)
            {
                return "已经成为分销商，无法再次申请";
            }
            return "";
        }

        /// <summary>
        /// 获取下级用户列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetDistributorInfoReferralsPageList(RB_Distributor_Info_Extend demodel)
        {
            var list = member_UserRepository.GetDistributorReferralsPageList(demodel.UserId, demodel.ReferralsType, demodel.TenantId, demodel.MallBaseId);
            return list;
        }

        /// <summary>
        /// 分销商审核+修改等级
        /// </summary>
        /// <param name="userIds"></param>
        /// <param name="type"></param>
        /// <param name="newGradeId"></param>
        /// <param name="remark"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public string SetDistributorAudit(string userIds, int type, int newGradeId, string remark, string uid, int mallBaseId)
        {
            var trans = distributor_InfoRepository.DbTransaction;
            try
            {
                if (type == 1)
                {
                    var list = distributor_InfoRepository.GetList(new RB_Distributor_Info_Extend() { UserIds = userIds, TenantId = Convert.ToInt32(uid), MallBaseId = mallBaseId });
                    foreach (var item in list)
                    {
                        if (item.AuditStatus != Common.Enum.User.DistributorAuditStatusEnum.Auditing)
                        {
                            return "用户ID:" + item.UserId + " 不是未审核状态，无法通过";
                        }
                    }
                    //批量修改状态
                    foreach (var item in list)
                    {
                        Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                            { nameof(RB_Distributor_Info.AuditStatus),2},
                            { nameof(RB_Distributor_Info.Remark),remark},
                            { nameof(RB_Distributor_Info.AuditDate),DateTime.Now}
                        };
                        List<WhereHelper> wheres = new List<WhereHelper>() {
                            new WhereHelper(){
                                 FiledName=nameof(RB_Distributor_Info.Id),
                                  FiledValue=item.Id,
                                   OperatorEnum=OperatorEnum.Equal
                            }
                        };
                        bool flag = distributor_InfoRepository.Update(keyValues, wheres, trans);
                        if (flag)
                        {
                            //修改用户表状态
                            Dictionary<string, object> keyValues1 = new Dictionary<string, object>() {
                                { nameof(RB_Member_User.IsDistributor),1}
                            };
                            List<WhereHelper> wheres1 = new List<WhereHelper>() {
                                new WhereHelper(){
                                     FiledName=nameof(RB_Member_User.Id),
                                      FiledValue=item.UserId,
                                       OperatorEnum=OperatorEnum.Equal
                                }
                            };
                            member_UserRepository.Update(keyValues1, wheres1, trans);
                        }
                    }
                }
                else if (type == 2)
                {
                    var list = distributor_InfoRepository.GetList(new RB_Distributor_Info_Extend() { UserIds = userIds, TenantId = Convert.ToInt32(uid), MallBaseId = mallBaseId });
                    foreach (var item in list)
                    {
                        if (item.AuditStatus != Common.Enum.User.DistributorAuditStatusEnum.Auditing)
                        {
                            return "用户ID:" + item.UserId + " 不是未审核状态，无法拒绝";
                        }
                    }
                    //批量修改状态
                    foreach (var item in list)
                    {
                        Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                            { nameof(RB_Distributor_Info.AuditStatus),3},
                            { nameof(RB_Distributor_Info.Remark),remark},
                            { nameof(RB_Distributor_Info.AuditDate),DateTime.Now}
                        };
                        List<WhereHelper> wheres = new List<WhereHelper>() {
                            new WhereHelper(){
                                 FiledName=nameof(RB_Distributor_Info.Id),
                                  FiledValue=item.Id,
                                   OperatorEnum=OperatorEnum.Equal
                            }
                        };
                        bool flag = distributor_InfoRepository.Update(keyValues, wheres, trans);
                    }
                }
                else if (type == 3)
                {
                    var list = distributor_InfoRepository.GetList(new RB_Distributor_Info_Extend() { UserIds = userIds, TenantId = Convert.ToInt32(uid), MallBaseId = mallBaseId });
                    foreach (var item in list)
                    {
                        if (item.AuditStatus != Common.Enum.User.DistributorAuditStatusEnum.Audited)
                        {
                            return "用户ID:" + item.UserId + " 不是审核通过状态，无法删除";
                        }
                    }
                    //批量修改状态
                    foreach (var item in list)
                    {
                        Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                            { nameof(RB_Distributor_Info.AuditStatus),3},
                            { nameof(RB_Distributor_Info.Remark),remark},
                            { nameof(RB_Distributor_Info.UpdateDate),DateTime.Now}
                        };
                        List<WhereHelper> wheres = new List<WhereHelper>() {
                            new WhereHelper(){
                                 FiledName=nameof(RB_Distributor_Info.Id),
                                  FiledValue=item.Id,
                                   OperatorEnum=OperatorEnum.Equal
                            }
                        };
                        bool flag = distributor_InfoRepository.Update(keyValues, wheres, trans);
                        if (flag)
                        {
                            //修改用户表状态
                            Dictionary<string, object> keyValues1 = new Dictionary<string, object>() {
                                { nameof(RB_Member_User.IsDistributor),2}
                            };
                            List<WhereHelper> wheres1 = new List<WhereHelper>() {
                                new WhereHelper(){
                                     FiledName=nameof(RB_Member_User.Id),
                                      FiledValue=item.UserId,
                                       OperatorEnum=OperatorEnum.Equal
                                }
                            };
                            member_UserRepository.Update(keyValues1, wheres1, trans);
                        }
                    }
                }
                else if (type == 4)
                {
                    var list = distributor_InfoRepository.GetList(new RB_Distributor_Info_Extend() { UserIds = userIds, TenantId = Convert.ToInt32(uid), MallBaseId = mallBaseId });
                    foreach (var item in list)
                    {
                        if (item.AuditStatus != Common.Enum.User.DistributorAuditStatusEnum.Audited)
                        {
                            return "用户ID:" + item.UserId + " 不是审核通过状态，无法修改等级";
                        }
                    }
                    //批量修改状态
                    foreach (var item in list)
                    {
                        Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                            { nameof(RB_Distributor_Info.GradeId),newGradeId},
                            { nameof(RB_Distributor_Info.UpdateDate),DateTime.Now}
                        };
                        List<WhereHelper> wheres = new List<WhereHelper>() {
                            new WhereHelper(){
                                 FiledName=nameof(RB_Distributor_Info.Id),
                                  FiledValue=item.Id,
                                   OperatorEnum=OperatorEnum.Equal
                            }
                        };
                        bool flag = distributor_InfoRepository.Update(keyValues, wheres, trans);
                    }
                }
                else if (type == 5)
                {
                    var list = distributor_InfoRepository.GetList(new RB_Distributor_Info_Extend() { UserIds = userIds, TenantId = Convert.ToInt32(uid), MallBaseId = mallBaseId });
                    foreach (var item in list)
                    {
                        if (item.AuditStatus != Common.Enum.User.DistributorAuditStatusEnum.Audited)
                        {
                            return "用户ID:" + item.UserId + " 不是审核通过状态，无法修改备注";
                        }
                    }
                    //批量修改状态
                    foreach (var item in list)
                    {
                        Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                            { nameof(RB_Distributor_Info.Remark),remark},
                            { nameof(RB_Distributor_Info.UpdateDate),DateTime.Now}
                        };
                        List<WhereHelper> wheres = new List<WhereHelper>() {
                            new WhereHelper(){
                                 FiledName=nameof(RB_Distributor_Info.Id),
                                  FiledValue=item.Id,
                                   OperatorEnum=OperatorEnum.Equal
                            }
                        };
                        bool flag = distributor_InfoRepository.Update(keyValues, wheres, trans);
                    }
                }
                else if (type == 6) {
                    var list = distributor_InfoRepository.GetList(new RB_Distributor_Info_Extend() { UserIds = userIds, TenantId = Convert.ToInt32(uid), MallBaseId = mallBaseId });
                    var ulist = member_UserRepository.GetList(new RB_Member_User_Extend() { UserIds = userIds, TenantId = Convert.ToInt32(uid), MallBaseId = mallBaseId });
                    var gmodel = distributor_HPGradeInfoRepository.GetEntity(newGradeId);
                    foreach (var item in list)
                    {
                        if (item.AuditStatus != Common.Enum.User.DistributorAuditStatusEnum.Audited)
                        {
                            return "用户ID:" + item.UserId + " 不是审核通过状态，无法修改等级";
                        }
                        //验证其上级用户 
                        var umodel = ulist.Where(x => x.Id == item.UserId).FirstOrDefault();
                        if (umodel == null) {
                            return "用户不存在ID:" + item.UserId;
                        }
                        if (umodel.SuperiorId == 0)
                        {
                            //上级为0  
                            if ((gmodel?.Grade ?? 0) != 1)
                            {
                                return "用户上级不存在，只能修改为1级和平分销 ID:" + item.UserId;
                            }
                        }
                        else {
                            if ((gmodel?.Grade ?? 0) == 1)
                            {
                                return "用户上级存在，无法改为1级和平分销 ID:" + item.UserId;
                            }
                        }
                        if ((gmodel?.Grade ?? 0) > 1)
                        {
                            var pModel = distributor_InfoRepository.GetList(new RB_Distributor_Info_Extend() { UserId = umodel.SuperiorId, TenantId = Convert.ToInt32(uid), MallBaseId = mallBaseId }).FirstOrDefault();
                            if (pModel == null)
                            {
                                return "用户上级不是分销商 ID:" + item.UserId;
                            }
                            if (pModel.AuditStatus != DistributorAuditStatusEnum.Audited)
                            {
                                return "用户上级分销商不是通过状态 ID:" + item.UserId;
                            }
                            if ((pModel.HPGradeId ?? 0) <= 0)
                            {
                                return "用户上级分销商未绑定和平分销等级 ID:" + item.UserId;
                            }
                            var hpgmodel = distributor_HPGradeInfoRepository.GetEntity(pModel.HPGradeId);
                            if ((gmodel?.Grade ?? 0) == 3)
                            {
                                if (hpgmodel.Grade != 1 && hpgmodel.Grade != 2)
                                {
                                    return "用户分销等级与上级用户分销等级不是关联关系 ID:" + item.UserId;
                                }
                            }
                            else if ((gmodel?.Grade ?? 0) == 2 && hpgmodel.Grade != 1)
                            {
                                return "用户分销等级与上级用户分销等级不是上下级关系 ID:" + item.UserId;
                            }
                            else if ((gmodel?.Grade ?? 0) - (hpgmodel.Grade ?? 0) != 1)
                            {
                                return "用户分销等级与上级用户分销等级不是上下级关系 ID:" + item.UserId;
                            }
                        }
                    }
                    //批量修改状态
                    foreach (var item in list)
                    {
                        Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                            { nameof(RB_Distributor_Info.HPGradeId),newGradeId},
                            { nameof(RB_Distributor_Info.UpdateDate),DateTime.Now}
                        };
                        List<WhereHelper> wheres = new List<WhereHelper>() {
                            new WhereHelper(){
                                 FiledName=nameof(RB_Distributor_Info.Id),
                                  FiledValue=item.Id,
                                   OperatorEnum=OperatorEnum.Equal
                            }
                        };
                        bool flag = distributor_InfoRepository.Update(keyValues, wheres, trans);
                    }
                }
                else
                {
                    return "Type传递有误";
                }
                distributor_InfoRepository.DBSession.Commit();
                return "";
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "SetDistributorAudit");
                distributor_InfoRepository.DBSession.Rollback();
                return "出错了，请联系管理员";
            }
        }

        /// <summary>
        /// 获取分销提现分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_Remit_Extend> GetDistributorRemitPageList(int pageIndex, int pageSize, out long count, RB_Distributor_Remit_Extend demodel)
        {
            return distributor_RemitRepository.GetPageList(pageIndex, pageSize, out count, demodel);
        }

        /// <summary>
        /// 获取下载列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_Info_Extend> GetDistributorInfoList(RB_Distributor_Info_Extend demodel)
        {
            var list = distributor_InfoRepository.GetToExcelList(demodel);
            if (list.Any())
            {
                //查询分销商等级
                string gradeIds = string.Join(",", list.Where(x => x.GradeId > 0).Select(x => x.GradeId ?? 0).Distinct());
                List<RB_Distributor_Grade_Extend> GradeList = new List<RB_Distributor_Grade_Extend>();
                if (!string.IsNullOrEmpty(gradeIds))
                {
                    GradeList = distributor_GradeRepository.GetList(new RB_Distributor_Grade_Extend() { GradeIds = gradeIds, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                }
                //查询推荐人列表
                string tjrIds = string.Join(",", list.Where(x => x.SuperiorId > 0).Select(x => x.SuperiorId ?? 0).Distinct());
                List<RB_Member_User_Extend> UserList = new List<RB_Member_User_Extend>();
                if (!string.IsNullOrEmpty(tjrIds))
                {
                    UserList = member_UserRepository.GetList(new RB_Member_User_Extend() { UserIds = tjrIds, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                }
                //根据基础配置层级查询下级数量  暂放弃
                //var basmdoel = GetDistributorBasicsInfo(demodel.TenantId.ToString(), demodel.MallBaseId);
                //if (basmdoel != null && basmdoel.DistributorTier > 0) {
                string uids = string.Join(",", list.Select(x => x.UserId ?? 0));
                List<RB_Member_User_Extend> UserNum1List = member_UserRepository.GetDistributorReferralsNum(uids, tier: 1, tenantId: demodel.TenantId, mallBaseId: demodel.MallBaseId);//直接查询三级
                List<RB_Member_User_Extend> UserNum2List = member_UserRepository.GetDistributorReferralsNum(uids, tier: 2, tenantId: demodel.TenantId, mallBaseId: demodel.MallBaseId);//直接查询三级
                List<RB_Member_User_Extend> UserNum3List = member_UserRepository.GetDistributorReferralsNum(uids, tier: 3, tenantId: demodel.TenantId, mallBaseId: demodel.MallBaseId);//直接查询三级

                foreach (var item in list)
                {
                    if (item.GradeId == 0)
                    {
                        item.GradeName = "默认等级";
                    }
                    else if (item.GradeId > 0)
                    {
                        item.GradeName = GradeList.Where(x => x.Id == item.GradeId).FirstOrDefault()?.Name ?? "";
                    }
                    if (item.SuperiorId == 0)
                    {
                        item.SuperiorName = "总店";
                    }
                    else if (item.SuperiorId > 0)
                    {
                        item.SuperiorName = UserList.Where(x => x.Id == item.SuperiorId).FirstOrDefault()?.Name ?? "";
                    }
                    item.OneNum = 0;
                    if (UserNum1List.Any())
                    {
                        item.OneNum = UserNum1List.Where(x => x.SuperiorId == item.UserId).FirstOrDefault()?.ReferralsNum ?? 0;
                    }
                    item.TwoNum = 0;
                    if (UserNum1List.Any())
                    {
                        item.TwoNum = UserNum2List.Where(x => x.SuperiorId == item.UserId).FirstOrDefault()?.ReferralsNum ?? 0;
                    }
                    item.ThreeNum = 0;
                    if (UserNum1List.Any())
                    {
                        item.ThreeNum = UserNum3List.Where(x => x.SuperiorId == item.UserId).FirstOrDefault()?.ReferralsNum ?? 0;
                    }
                }

            }
            return list;
        }

        /// <summary>
        /// 获取分销提现实体
        /// </summary>
        /// <param name="remitId"></param>
        /// <returns></returns>
        public RB_Distributor_Remit_Extend GetDistributorEntity(int remitId) { 
            return distributor_RemitRepository.GetEntity<RB_Distributor_Remit_Extend>(remitId);
        }

        /// <summary>
        /// 获取小程序信息
        /// </summary>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public RB_MiniProgram_Extend GetMiniProgramExtend(int mallBaseId)
        {
            return miniProgramRepository.GetEntity<RB_MiniProgram_Extend>(mallBaseId);
        }

        /// <summary>
        /// 分销提现审核
        /// </summary>
        /// <param name="remitId"></param>
        /// <param name="type"></param>
        /// <param name="remark"></param>
        /// <param name="uid"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public string SetDistributorRemitAudit(int remitId, int type, string remark, string uid, int mallBaseId)
        {
            if (type == 1)
            {
                
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Distributor_Remit.AuditStatus), (int)Common.Enum.User.DistributorRemitAuditStatusEnum.ToPlayWith},
                    { nameof(RB_Distributor_Remit.AuditDate), DateTime.Now},
                    { nameof(RB_Distributor_Remit.AuditRemark), remark},
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                            FiledName=nameof(RB_Distributor_Remit.Id),
                            FiledValue=remitId,
                            OperatorEnum=OperatorEnum.Equal
                    }
                };
                distributor_RemitRepository.Update(keyValues, wheres);
            }
            else if (type == 2)
            {
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Distributor_Remit.AuditStatus), (int)Common.Enum.User.DistributorRemitAuditStatusEnum.HaveMoney},
                    { nameof(RB_Distributor_Remit.RemitDate), DateTime.Now},
                    { nameof(RB_Distributor_Remit.RemitRemark), remark},
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                            FiledName=nameof(RB_Distributor_Remit.Id),
                            FiledValue=remitId,
                            OperatorEnum=OperatorEnum.Equal
                    }
                };
                distributor_RemitRepository.Update(keyValues, wheres);
            }
            else if (type == 3)
            {                
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Distributor_Remit.AuditStatus), (int)Common.Enum.User.DistributorRemitAuditStatusEnum.Reject},
                    { nameof(RB_Distributor_Remit.RejectDate), DateTime.Now},
                    { nameof(RB_Distributor_Remit.RejectRemark), remark},
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                            FiledName=nameof(RB_Distributor_Remit.Id),
                            FiledValue=remitId,
                            OperatorEnum=OperatorEnum.Equal
                    }
                };
                distributor_RemitRepository.Update(keyValues, wheres);
            }
            else
            {
                return "type有误，请核实后再试";
            }
            return "";
        }

        /// <summary>
        /// 分销提现列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_Remit_Extend> GetDistributorRemitList(RB_Distributor_Remit_Extend demodel)
        {
            return distributor_RemitRepository.GetDistributorRemitList(demodel);
        }

        /// <summary>
        /// 分销提现申请
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public string SetDistributorRemitInfo(RB_Distributor_Remit_Extend demodel)
        {
            var dmodel = distributor_InfoRepository.GetList(new RB_Distributor_Info_Extend() { UserId = demodel.UserId, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId }).FirstOrDefault();
            if (dmodel == null || dmodel.AuditStatus != Common.Enum.User.DistributorAuditStatusEnum.Audited && dmodel.Status == 1)
            {
                return "分销商不存在或者分销商未审核通过";
            }
            if ((dmodel.CommissionWithdrawal ?? 0) < demodel.AppliedMoney)
            {
                return "分销商剩余可提现佣金金额不足";
            }
            bool flag = distributor_RemitRepository.Insert(demodel) > 0;
            if (flag)
            {
                //扣除分销可提现佣金
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Distributor_Info.CommissionWithdrawal), (dmodel.CommissionWithdrawal ?? 0) - (demodel.AppliedMoney??0)}
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                         FiledName=nameof(RB_Distributor_Info.Id),
                          FiledValue=dmodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                distributor_InfoRepository.Update(keyValues, wheres);
            }
            return flag ? "" : "操作失败";
        }

        #region 收货地址

        /// <summary>
        /// 收货地址分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Member_ShippingAddress_Extend> GetUserShippingAddressPageList(int pageIndex, int pageSize, out long count, RB_Member_ShippingAddress_Extend demodel)
        {
            var list = member_ShippingAddressRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any())
            {
                string areaIds1 = string.Join(",", list.Select(x => x.Province ?? 0).Distinct());
                string areaIds2 = string.Join(",", list.Select(x => x.City ?? 0).Distinct());
                string areaIds3 = string.Join(",", list.Select(x => x.District ?? 0).Distinct());
                string areaIds = "0";
                if (!string.IsNullOrEmpty(areaIds1))
                {
                    areaIds += "," + areaIds1;
                }
                if (!string.IsNullOrEmpty(areaIds2))
                {
                    areaIds += "," + areaIds2;
                }
                if (!string.IsNullOrEmpty(areaIds3))
                {
                    areaIds += "," + areaIds3;
                }
                var arealist = destinationRepository.GetDictvalueListForIds(areaIds);
                foreach (var item in list)
                {
                    item.DistrictAddress = (arealist.Where(x => x.ID == item.Province).FirstOrDefault()?.Name ?? "") + " " + (arealist.Where(x => x.ID == item.City).FirstOrDefault()?.Name ?? "") + " " + (arealist.Where(x => x.ID == item.District).FirstOrDefault()?.Name ?? "");
                }
            }
            return list;
        }

        /// <summary>
        /// 收货地址列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Member_ShippingAddress_Extend> GetUserShippingAddressList(RB_Member_ShippingAddress_Extend demodel)
        {
            var list = member_ShippingAddressRepository.GetList(demodel);
            if (list.Any())
            {
                string areaIds1 = string.Join(",", list.Select(x => x.Province ?? 0).Distinct());
                string areaIds2 = string.Join(",", list.Select(x => x.City ?? 0).Distinct());
                string areaIds3 = string.Join(",", list.Select(x => x.District ?? 0).Distinct());
                string areaIds = "0";
                if (!string.IsNullOrEmpty(areaIds1))
                {
                    areaIds += "," + areaIds1;
                }
                if (!string.IsNullOrEmpty(areaIds2))
                {
                    areaIds += "," + areaIds2;
                }
                if (!string.IsNullOrEmpty(areaIds3))
                {
                    areaIds += "," + areaIds3;
                }
                var arealist = destinationRepository.GetDictvalueListForIds(areaIds);
                foreach (var item in list)
                {
                    item.DistrictAddress = (arealist.Where(x => x.ID == item.Province).FirstOrDefault()?.Name ?? "") + " " + (arealist.Where(x => x.ID == item.City).FirstOrDefault()?.Name ?? "") + " " + (arealist.Where(x => x.ID == item.District).FirstOrDefault()?.Name ?? "");
                }
            }
            return list;
        }

        /// <summary>
        /// 获取收货地址详情
        /// </summary>
        /// <param name="addressId"></param>
        /// <returns></returns>
        public RB_Member_ShippingAddress_Extend GetUserShippingAddressInfo(int addressId)
        {
            var model = member_ShippingAddressRepository.GetEntity<RB_Member_ShippingAddress_Extend>(addressId);
            model.DistrictAddress = (destinationRepository.GetEntity(model.Province)?.Name ?? "") + " " + (destinationRepository.GetEntity(model.City)?.Name ?? "") + " " + (destinationRepository.GetEntity(model.District)?.Name ?? "");
            return model;
        }

        /// <summary>
        /// 新增修改
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetUserShippingAddress(RB_Member_ShippingAddress_Extend demodel)
        {
            if (demodel.Id > 0)
            {
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Member_ShippingAddress.Name),demodel.Name},
                    { nameof(RB_Member_ShippingAddress.Mobile),demodel.Mobile},
                    { nameof(RB_Member_ShippingAddress.Country),demodel.Country},
                    { nameof(RB_Member_ShippingAddress.Province),demodel.Province},
                    { nameof(RB_Member_ShippingAddress.City),demodel.City},
                    { nameof(RB_Member_ShippingAddress.District),demodel.District},
                    { nameof(RB_Member_ShippingAddress.Address),demodel.Address},
                    { nameof(RB_Member_ShippingAddress.UpdateDate),demodel.UpdateDate}
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper{
                         FiledName=nameof(RB_Member_ShippingAddress.TenantId),
                          FiledValue=demodel.TenantId,
                           OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper{
                         FiledName=nameof(RB_Member_ShippingAddress.MallBaseId),
                          FiledValue=demodel.MallBaseId,
                           OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper{
                         FiledName=nameof(RB_Member_ShippingAddress.UserId),
                          FiledValue=demodel.UserId,
                           OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper{
                         FiledName=nameof(RB_Member_ShippingAddress.Id),
                          FiledValue=demodel.Id,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                return member_ShippingAddressRepository.Update(keyValues, wheres);
            }
            else
            {
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper{
                         FiledName=nameof(RB_Member_ShippingAddress.TenantId),
                          FiledValue=demodel.TenantId,
                           OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper{
                         FiledName=nameof(RB_Member_ShippingAddress.MallBaseId),
                          FiledValue=demodel.MallBaseId,
                           OperatorEnum=OperatorEnum.Equal
                    },
                    new WhereHelper{
                         FiledName=nameof(RB_Member_ShippingAddress.UserId),
                          FiledValue=demodel.UserId,
                           OperatorEnum=OperatorEnum.Equal
                    },
                };
                if (!member_ShippingAddressRepository.Exists(wheres))
                {
                    demodel.IsDefault = 1;
                }
                return member_ShippingAddressRepository.Insert(demodel) > 0;
            }
        }

        /// <summary>
        /// 设置默认
        /// </summary>
        /// <param name="addressId"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public bool SetUserShippingAddressDefault(int addressId, int userId)
        {
            var addmodel = member_ShippingAddressRepository.GetEntity(addressId);
            int oldId = 0;
            if (addmodel.IsDefault != 1)
            {
                var defmodel = member_ShippingAddressRepository.GetList(new RB_Member_ShippingAddress_Extend() { UserId = userId, IsDefault = 1 }).FirstOrDefault();
                oldId = defmodel.Id;
            }
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Member_ShippingAddress.IsDefault),addmodel.IsDefault==1?2:1},
                { nameof(RB_Member_ShippingAddress.UpdateDate),DateTime.Now}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper{
                        FiledName=nameof(RB_Member_ShippingAddress.UserId),
                        FiledValue=userId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper{
                        FiledName=nameof(RB_Member_ShippingAddress.Id),
                        FiledValue=addressId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            bool flag = member_ShippingAddressRepository.Update(keyValues, wheres);
            if (flag)
            {
                //获取当前默认
                if (addmodel.IsDefault != 1 && oldId > 0)
                {
                    Dictionary<string, object> keyValues1 = new Dictionary<string, object>() {
                        { nameof(RB_Member_ShippingAddress.IsDefault),2},
                        { nameof(RB_Member_ShippingAddress.UpdateDate),DateTime.Now}
                    };
                    List<WhereHelper> wheres1 = new List<WhereHelper>() {
                        new WhereHelper{
                                FiledName=nameof(RB_Member_ShippingAddress.UserId),
                                FiledValue=userId,
                                OperatorEnum=OperatorEnum.Equal
                        },
                        new WhereHelper{
                                FiledName=nameof(RB_Member_ShippingAddress.Id),
                                FiledValue=oldId,
                                OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    member_ShippingAddressRepository.Update(keyValues1, wheres1);
                }
            }
            return flag;
        }

        /// <summary>
        /// 删除地址
        /// </summary>
        /// <param name="addressId"></param>
        /// <param name="userId"></param>
        /// <returns></returns>
        public bool DelUserShippingAddressDefault(int addressId, int userId)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Member_ShippingAddress.Status),1},
                { nameof(RB_Member_ShippingAddress.UpdateDate),DateTime.Now}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper{
                        FiledName=nameof(RB_Member_ShippingAddress.UserId),
                        FiledValue=userId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper{
                        FiledName=nameof(RB_Member_ShippingAddress.Id),
                        FiledValue=addressId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return member_ShippingAddressRepository.Update(keyValues, wheres);
        }

        #endregion

        #region 收藏商品

        /// <summary>
        /// 获取用户收藏商品分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Goods_Extend> GetUserCollectionPageList(int pageIndex, int pageSize, out long count, RB_Goods_Extend demodel)
        {
            var list = goodsRepository.GetMemberCollectGoodsPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any())
            {
                foreach (var item in list)
                {
                    item.CoverImage = "";
                    if (!string.IsNullOrEmpty(item.CarouselImage) && item.CarouselImage != "[]")
                    {
                        List<string> CarouselIdList = JsonConvert.DeserializeObject<List<string>>(item.CarouselImage);
                        //封面图
                        item.CoverImage = CarouselIdList[0];
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 设置用户收藏商品
        /// </summary>
        /// <param name="goodsId"></param>
        /// <param name="userId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetUserCollectionInfo(int goodsId, int userId, int tenantId, int mallBaseId)
        {
            bool flag = true;
            var list = member_CollectionRepository.GetList(new RB_Member_Collection_Extend() { UserId = userId, GoodsId = goodsId, TenantId = tenantId, MallBaseId = mallBaseId });
            if (list.Any())
            {
                //取消收藏
                foreach (var item in list)
                {
                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_Member_Collection.Status),1},
                        { nameof(RB_Member_Collection.UpdateDate),DateTime.Now}
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_Member_Collection.Id),
                              FiledValue=item.Id,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    flag = member_CollectionRepository.Update(keyValues, wheres);
                }
            }
            else
            {
                //新增收藏
                flag = member_CollectionRepository.Insert(new RB_Member_Collection()
                {
                    CreateDate = DateTime.Now,
                    GoodsId = goodsId,
                    Id = 0,
                    MallBaseId = mallBaseId,
                    Status = 0,
                    TenantId = tenantId,
                    Type = 1,
                    UpdateDate = DateTime.Now,
                    UserId = userId
                }) > 0;
            }
            return flag;
        }

        #endregion

        #region 分销中心


        /// <summary>
        /// 验证分销商
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public object GetUserDistrbutorStatus(int userId, int tenantId, int mallBaseId)
        {
            var model = distributor_InfoRepository.GetList(new RB_Distributor_Info_Extend() { UserId = userId, TenantId = tenantId, MallBaseId = mallBaseId }).FirstOrDefault();
            if (model == null)
            {
                var basicsModel = distributor_BasicsRepository.GetList(new RB_Distributor_Basics_Extend() { TenantId = tenantId, MallBaseId = mallBaseId }).FirstOrDefault();
                bool flag = true;
                if (basicsModel.DistributorCondition == DistributorConditionEnum.GMSP) {
                    //验证购买商品
                    List<WhereHelper> whereHelpers = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_Goods_Order_Extend.UserId),
                              FiledValue=userId,
                               OperatorEnum=OperatorEnum.Equal
                        },
                        new WhereHelper(){
                             FiledName=nameof(RB_Goods_Order_Extend.TenantId),
                              FiledValue=tenantId,
                               OperatorEnum=OperatorEnum.Equal
                        },
                        new WhereHelper(){
                             FiledName=nameof(RB_Goods_Order_Extend.MallBaseId),
                              FiledValue=mallBaseId,
                               OperatorEnum=OperatorEnum.Equal
                        },
                        new WhereHelper(){
                             FiledName=nameof(RB_Goods_Order_Extend.Recycled),
                              FiledValue=2,
                               OperatorEnum=OperatorEnum.Equal
                        },
                        new WhereHelper(){
                             FiledName=nameof(RB_Goods_Order_Extend.Status),
                              FiledValue=0,
                               OperatorEnum=OperatorEnum.Equal
                        },
                        new WhereHelper(){
                             FiledName=nameof(RB_Goods_Order_Extend.OrderStatus),
                              FiledValue="2,3,4,5,6",
                               OperatorEnum=OperatorEnum.IN
                        },
                    };
                    flag = goods_OrderRepository.Exists(whereHelpers);
                }
                else if(basicsModel.DistributorCondition == DistributorConditionEnum.DCXF){
                    //单次消费   充值也算  (货到付款这种怎么处理)

                }
                if (flag)
                {
                    return new
                    {
                        Status = 1,
                        Msg = "未申请成为分销商",
                        basicsModel.ApplyFor,
                        ApplyForName = basicsModel.ApplyFor.GetEnumName()
                    };
                }
                else {
                    return new
                    {
                        Status = 0,
                        Msg = "未满足申请成为分销商条件：" + basicsModel.DistributorCondition.GetEnumName()
                    };
                }
            }
            if (model.AuditStatus == Common.Enum.User.DistributorAuditStatusEnum.Reject)
            {
                return new
                {
                    Status = 4,
                    Msg = "申请已被拒绝"
                };
            }
            else if (model.AuditStatus == Common.Enum.User.DistributorAuditStatusEnum.Auditing)
            {
                return new
                {
                    Status = 2,
                    Msg = "正在审核中"
                };
            }
            else if (model.AuditStatus == Common.Enum.User.DistributorAuditStatusEnum.Audited)
            {
                return new
                {
                    Status = 3,
                    Msg = "已是分销商"
                };
            }
            return new
            {
                Status = 0,
                Msg = ""
            };
        }

        /// <summary>
        /// 获取用户申请分销商页面信息
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public object GetUserApplyForDistrbutorInfo(int userId, int tenantId, int mallBaseId)
        {
            int SuperiorId = 0;
            string SuperiorName = "总店";
            var umodel = member_UserRepository.GetEntity(userId);
            if (umodel.SuperiorId > 0)
            {
                SuperiorId = umodel.SuperiorId ?? 0;
                var upmodel = member_UserRepository.GetEntity(umodel.SuperiorId ?? 0);
                SuperiorName = upmodel?.Name ?? "";
            }
            else if (umodel.SuperiorId == 0 && umodel.IsBeDownline == 2 && umodel.WaitSuperiorId > 0) {
                SuperiorId = umodel.WaitSuperiorId ?? 0;
                var upmodel = member_UserRepository.GetEntity(umodel.WaitSuperiorId ?? 0);
                SuperiorName = upmodel?.Name ?? "";
            }
            var CustomModel = distributor_CustomRepository.GetList(new RB_Distributor_Custom_Extend() { TenantId = tenantId, MallBaseId = mallBaseId }).FirstOrDefault();
            if (CustomModel == null) {
                return "";
            }
            string HeadImage = material_InfoRepository.GetEntity(CustomModel.HeadImage)?.Path??"";
            string BottomImage = material_InfoRepository.GetEntity(CustomModel.BottomImage)?.Path??"";
            return new
            {
                CustomModel = new
                {
                    HeadImage,
                    BottomImage,
                    CustomModel.DistributionApplication,
                    CustomModel.ApplicationAgreement,
                    CustomModel.ButtonFilletPX,
                    CustomModel.ButtonText,
                    CustomModel.ButtonColor,
                    CustomModel.ButtonTextColor
                },
                ApplyForInfo = new
                {
                    SuperiorId,
                    SuperiorName
                }
            };
        }

        /// <summary>
        /// 申请成为分销商
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetUserApplyForBeDistrbutor(RB_Distributor_Info_Extend demodel)
        {
            var model = distributor_InfoRepository.GetList(new RB_Distributor_Info_Extend() { UserId = demodel.UserId, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId }).FirstOrDefault();
            if (model != null)
            {
                return false;
            }
            return distributor_InfoRepository.Insert(demodel) > 0;
        }

        /// <summary>
        /// 获取用户分销中心
        /// </summary>
        /// <param name="userInfo"></param>
        /// <returns></returns>
        public object GetDistrbutorCenter(AppletUserInfo userInfo)
        {
            var model = distributor_InfoRepository.GetList(new RB_Distributor_Info_Extend() { UserId = userInfo.UserId, TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId }).FirstOrDefault();
            if (model == null)
            {
                return "分销商不存在";
            }
            if (model.AuditStatus != Common.Enum.User.DistributorAuditStatusEnum.Audited)
            {
                return "分销商不存在";
            }
            //分销商等级
            string GradeName = "默认等级";
            if (model.GradeId > 0)
            {
                var gmodel = distributor_GradeRepository.GetEntity(model.GradeId);
                GradeName = gmodel?.Name ?? "";
            }
            //已提现佣金 //未结算佣金
            var commModel = distributor_RemitRepository.GetDistributorCommissionStatiscs(userInfo.UserId);
            //提现总额
            var remitMoney = distributor_RemitRepository.GetDistributorRemitCommission(userInfo.UserId);

            //分销订单
            decimal OrderCommission = goods_OrderCommissionRepository.GetUserOrderCommissionStatistics(userInfo.UserId);

            int SuperiorId = 0;
            string SuperiorName = "";
            var umodel = member_UserRepository.GetEntity(userInfo.UserId);
            if (umodel.SuperiorId > 0)
            {
                SuperiorId = umodel.SuperiorId ?? 0;
                var upmodel = member_UserRepository.GetEntity(umodel.SuperiorId ?? 0);
                SuperiorName = upmodel?.Name ?? "";
            }
            //下线数量
            int oneNum = member_UserRepository.GetDistributorReferralsNumTwo(umodel.Id, 1, userInfo.TenantId, userInfo.MallBaseId);
            int twoNum = member_UserRepository.GetDistributorReferralsNumTwo(umodel.Id, 1, userInfo.TenantId, userInfo.MallBaseId);
            int threeNum = member_UserRepository.GetDistributorReferralsNumTwo(umodel.Id, 1, userInfo.TenantId, userInfo.MallBaseId);

            var CustomModel = distributor_CustomRepository.GetList(new RB_Distributor_Custom_Extend() { TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId }).FirstOrDefault();
            if (CustomModel == null)
            {
                return "";
            }
            string DistributionCommissionImage = material_InfoRepository.GetEntity(CustomModel.DistributionCommissionImage)?.Path ?? "";
            string DistributionOrderImage = material_InfoRepository.GetEntity(CustomModel.DistributionOrderImage)?.Path ?? "";
            string WithdrawDetialsImage = material_InfoRepository.GetEntity(CustomModel.WithdrawDetialsImage)?.Path ?? "";
            string MyTeamImage = material_InfoRepository.GetEntity(CustomModel.MyTeamImage)?.Path ?? "";
            string PromoteQRCodeImage = material_InfoRepository.GetEntity(CustomModel.PromoteQRCodeImage)?.Path ?? "";

            var basicsModel = distributor_BasicsRepository.GetList(new RB_Distributor_Basics_Extend() { TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId }).FirstOrDefault();
            return new
            {
                CustomModel = new
                {
                    CustomModel.DistributionCommissionName,
                    DistributionCommissionImage,
                    CustomModel.DistributionOrderName,
                    DistributionOrderImage,
                    CustomModel.WithdrawDetialsName,
                    WithdrawDetialsImage,
                    CustomModel.MyTeamName,
                    MyTeamImage,
                    CustomModel.PromoteQRCodeName,
                    PromoteQRCodeImage,
                    CustomModel.ReferrerName,
                    CustomModel.CommissionForWithdrawalName,
                    CustomModel.WithdrawDepositName,
                    CustomModel.CommissionWithdrawnName,
                    CustomModel.OutstandingCommissionName,
                    CustomModel.DistributorName,
                },
                UserInfo = new
                {
                    UserId = umodel.Id,
                    UserName = umodel.Name,
                    GradeName,
                    SuperiorId,
                    SuperiorName,
                    DistributorGradeEntrance = basicsModel?.GradeEntrance ?? 2,
                    CommissionWithdrawal = model.CommissionWithdrawal ?? 0,
                    TXCommission = commModel?.TXCommission ?? 0,
                    WJSCommission = commModel?.WJSCommission ?? 0,
                    model.TotalCommission,
                    OrderCommission,
                    RemitMoney = remitMoney,
                    ReferralsNum = oneNum + twoNum + threeNum
                }
            };            
        }

        /// <summary>
        /// 获取分销商升级条件
        /// </summary>
        /// <param name="userInfo"></param>
        /// <returns></returns>
        public object GetDistrbutorUpgradeConditions(AppletUserInfo userInfo)
        {
            var model = distributor_InfoRepository.GetList(new RB_Distributor_Info_Extend() { UserId = userInfo.UserId, TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId }).FirstOrDefault();
            var gmodel = distributor_GradeRepository.GetEntity(model.GradeId);
            var upgmodel = distributor_GradeRepository.GetDistrbutorUpgrade(gmodel?.Grade ?? 0, userInfo.TenantId, userInfo.MallBaseId);
            if (upgmodel == null || upgmodel.IsAutoUpGrade != 1)
            {
                return new
                {
                    Status = 2,
                    GradeInfo = new { }
                };
            }            
            else
            {
                return new
                { 
                    Status = 1,
                    GradeInfo =new
                    {
                        upgmodel.Id,
                        upgmodel.Grade,
                        upgmodel.Name,
                        upgmodel.UpGradeCondition,
                        UpGradeConditionName = upgmodel.UpGradeCondition.GetEnumName(),
                        upgmodel.ReferralsNumber,
                        upgmodel.TotalCommission,
                        upgmodel.CommissionWithdrawn,
                        upgmodel.DistributionCommissionType,
                        upgmodel.OneCommission,
                        upgmodel.TwoCommission,
                        upgmodel.ThreeCommission,
                        upgmodel.GradeExplain
                    }
                };
            }
        }

        /// <summary>
        /// 获取提现余额
        /// </summary>
        /// <returns></returns>
        public object GetDistrbutorWithdrawDepositBalance(AppletUserInfo userInfo)
        {
            var basicsModel = distributor_BasicsRepository.GetList(new RB_Distributor_Basics_Extend() { TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId }).FirstOrDefault();
            var disModel = distributor_InfoRepository.GetList(new RB_Distributor_Info_Extend() { UserId = userInfo.UserId, TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId }).FirstOrDefault();

            decimal CanRemitMoney = -1;            
            if (basicsModel.DailyWithdrawalLimit != -1) {
                //获取当日所有用户提现金额
                decimal RemitMoney = distributor_RemitRepository.GetAllUserToDayRemitMoney(userInfo.TenantId, userInfo.MallBaseId);
                CanRemitMoney = (basicsModel.DailyWithdrawalLimit ?? 0) - RemitMoney;
                CanRemitMoney = CanRemitMoney < 0 ? 0 : CanRemitMoney;
            }
            //提现方式
            List<int> WithdrawWayids = JsonConvert.DeserializeObject<List<int>>(basicsModel.WithdrawWay);
            var list = EnumHelper.GetEnumList(typeof(DistrbutorWithdrawWayEnum));
            var WayList = list.Where(x => WithdrawWayids.Contains(Convert.ToInt32(x.Value)));

            return new
            {
                disModel.CommissionWithdrawal,                
                CanRemitMoney,
                basicsModel.MinimumWithdrawalLimit,
                basicsModel.WithdrawFee,
                WithdrawWayList = WayList.Select(x => new
                {
                    Id = Convert.ToInt32(x.Value),
                    Name = x.Key
                })
            };
        }

        /// <summary>
        /// 提现
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public string SetDistrbutorWithdrawDeposit(RB_Distributor_Remit_Extend demodel)
        {
            
            //验证金额
            var disModel = distributor_InfoRepository.GetList(new RB_Distributor_Info_Extend() { UserId = demodel.UserId, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId }).FirstOrDefault();
            if ((disModel.CommissionWithdrawal ?? 0) < (demodel.AppliedMoney ?? 0)) {
                return "账户余额不足，请刷新后再试";
            }
            var basicsModel = distributor_BasicsRepository.GetList(new RB_Distributor_Basics_Extend() { TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId }).FirstOrDefault();
            //提现方式
            List<int> WithdrawWayids = JsonConvert.DeserializeObject<List<int>>(basicsModel.WithdrawWay);
            if (!WithdrawWayids.Contains((int)(demodel.WithdrawalWay ?? DistrbutorWithdrawWayEnum.ZDDK)))
            {
                return "提现方式不正确";
            }

            if (basicsModel.DailyWithdrawalLimit != -1)
            {
                //获取当日所有用户提现金额
                decimal RemitMoney = distributor_RemitRepository.GetAllUserToDayRemitMoney(demodel.TenantId, demodel.MallBaseId);
                //今日可提
                decimal CanRemitMoney = (basicsModel.DailyWithdrawalLimit ?? 0) - RemitMoney;
                CanRemitMoney = CanRemitMoney < 0 ? 0 : CanRemitMoney;

                if (CanRemitMoney < (demodel.AppliedMoney ?? 0)) {
                    return "今日可提现余额不足";
                }
            }
            //验证手续费
            if (basicsModel.WithdrawFee > 0)
            {
                decimal fee = Math.Round((demodel.AppliedMoney ?? 0) * (basicsModel.WithdrawFee ?? 0) / 100, 2, MidpointRounding.AwayFromZero);
                if (demodel.Fee != fee)
                {
                    return "手续费计算不准确";
                }
                if (demodel.RemitMoney != (demodel.AppliedMoney ?? 0) - fee)
                {
                    return "最终金额不正确";
                }
            }
            else {
                demodel.Fee = 0;
                demodel.RemitMoney = demodel.AppliedMoney;
            }
            var trans = distributor_RemitRepository.DbTransaction;
            try
            {
                bool flag = distributor_RemitRepository.Insert(demodel, trans) > 0;
                if (flag) {
                    //扣除账户可提佣金
                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_Distributor_Info.CommissionWithdrawal),(disModel.CommissionWithdrawal ?? 0) - (demodel.AppliedMoney ?? 0)}
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_Distributor_Info.Id),
                              FiledValue=disModel.Id,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    distributor_InfoRepository.Update(keyValues, wheres, trans);
                }
                distributor_RemitRepository.DBSession.Commit();
                return "";
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "SetDistrbutorWithdrawDeposit");
                distributor_RemitRepository.DBSession.Rollback();
                return "出错了，请联系管理员";
            }
        }

        /// <summary>
        /// 获取分销佣金页面详情
        /// </summary>
        /// <param name="userInfo"></param>
        /// <returns></returns>
        public object GetDistrbutorCommissionInfo(AppletUserInfo userInfo)
        {
            var model = distributor_InfoRepository.GetList(new RB_Distributor_Info_Extend() { UserId = userInfo.UserId, TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId }).FirstOrDefault();
            if (model == null)
            {
                return "分销商不存在";
            }
            if (model.AuditStatus != Common.Enum.User.DistributorAuditStatusEnum.Audited)
            {
                return "分销商不存在";
            }
            //已提现佣金 //未结算佣金
            var commModel = distributor_RemitRepository.GetDistributorCommissionStatiscs(userInfo.UserId);
           
            var CustomModel = distributor_CustomRepository.GetList(new RB_Distributor_Custom_Extend() { TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId }).FirstOrDefault();
            if (CustomModel == null)
            {
                return "";
            }

            return new
            {
                CustomModel = new
                {
                    CustomModel.CommissionTobePaidName,
                    CustomModel.UserNotesName,                    
                    CustomModel.IWantToWithdrawName
                },
                CommissionInfo = new
                {
                    model.TotalCommission,
                    CommissionWithdrawal = model.CommissionWithdrawal ?? 0,
                    TXCommission = commModel?.TXCommission ?? 0,
                    WJSCommission = commModel?.WJSCommission ?? 0
                }
            };
        }

        /// <summary>
        /// 获取我的团队
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public object GetUserMyTeamPageList(int pageIndex, int pageSize, out long count, RB_Distributor_Info_Extend demodel)
        {            
            var list = member_UserRepository.GetDistributorReferralsPageList(pageIndex, pageSize, out count, demodel);
            List<object> RList = new List<object>();
            if (list.Any()) {
                string userIds = string.Join(",", list.Select(x => x.Id));
                //获取推广人数
                var tList = member_UserRepository.GetDistributorReferralsNum(userIds, 1, demodel.TenantId, demodel.MallBaseId);
                //获取消费金额 + 订单数量
                var oList = goods_OrderRepository.GetUserOrderNumAndMoney(userIds, demodel.TenantId, demodel.MallBaseId);

                foreach (var item in list) {
                    int tgNum = tList.Where(x => x.SuperiorId == item.Id).FirstOrDefault()?.ReferralsNum ?? 0;
                    var orderModel = oList.Where(x => x.UserId == item.Id).FirstOrDefault();
                    RList.Add(new
                    {
                        UserId = item.Id,
                        UserName = item.Name,
                        item.Photo,
                        CreateDate = item.CreateDate.HasValue ? item.CreateDate.Value.ToString("yyyy-MM-dd HH:mm:ss") : "",
                        GeneralizeNum = tgNum,
                        OrderNum = orderModel?.OrderNum ?? 0,
                        Income = orderModel?.Income ?? 0
                    });
                }
            }
            return RList;
        }

        /// <summary>
        /// 获取我的团队自定义信息
        /// </summary>
        /// <param name="userInfo"></param>
        /// <returns></returns>
        public object GetUserMyTeamCustomInfo(AppletUserInfo userInfo)
        {
            var CustomModel = distributor_CustomRepository.GetList(new RB_Distributor_Custom_Extend() { TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId }).FirstOrDefault();
            return new
            {
                CustomModel.OneDistributionName,
                CustomModel.TwoDistributionName,
                CustomModel.ThreeDistributionName
            };
        }

        #endregion

        #region 我的足迹


        /// <summary>
        /// 获取用户足迹分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Member_Footmark_Extend> GetUserFootMarkPageList(int pageIndex, int pageSize, out long count, RB_Member_Footmark_Extend demodel)
        {
            var list = member_FootmarkRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any())
            {
                //查询商品信息
                string goodsIds = string.Join(",", list.Select(x => x.GoodsId).Distinct());
                var goodsList = goodsRepository.GetList(new RB_Goods_Extend() { GoodsIds = goodsIds, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });

                foreach (var item in list)
                {
                    var goodsModel = goodsList.Where(x => x.Id == item.GoodsId).FirstOrDefault();
                    item.GoodsName = goodsModel?.Name ?? "";
                    item.Price = goodsModel?.SellingPrice ?? 0;
                    item.GoodsImgPath = "";
                    if (goodsModel != null)
                    {
                        if (!string.IsNullOrEmpty(goodsModel.CarouselImage) && goodsModel.CarouselImage != "[]")
                        {
                            List<string> CarouselIdList = JsonConvert.DeserializeObject<List<string>>(goodsModel.CarouselImage);
                            //封面图
                            item.GoodsImgPath = CarouselIdList[0];
                        }
                    }
                }
            }
            return list;
        }

        /// <summary>
        /// 新增足迹
        /// </summary>
        /// <param name="goodsId"></param>
        /// <param name="userInfo"></param>
        /// <returns></returns>
        public bool SetUserFootMarkInfo(int goodsId, AppletUserInfo userInfo)
        {
            var model = member_FootmarkRepository.GetList(new RB_Member_Footmark_Extend() { GoodsId = goodsId, UserId = userInfo.UserId, TenantId = userInfo.TenantId, MallBaseId = userInfo.MallBaseId }).FirstOrDefault();

            if (model == null)
            {
                return member_FootmarkRepository.Insert(new RB_Member_Footmark()
                {
                    Id = 0,
                    GoodsId = goodsId,
                    Status = 0,
                    UserId = userInfo.UserId,
                    CreateDate = DateTime.Now,
                    TenantId = userInfo.TenantId,
                    MallBaseId = userInfo.MallBaseId
                }) > 0;
            }
            else {
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Member_Footmark.CreateDate),DateTime.Now}
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper{
                         FiledName=nameof(RB_Member_Footmark.Id),
                          FiledValue=model.Id,
                           OperatorEnum=OperatorEnum.Equal
                    }
                };
                return member_FootmarkRepository.Update(keyValues, wheres);
            }
        }

        /// <summary>
        /// 删除足迹
        /// </summary>
        /// <param name="footMarkId"></param>
        /// <param name="userInfo"></param>
        /// <returns></returns>
        public bool DelUserFootMarkInfo(int footMarkId, AppletUserInfo userInfo)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Member_Footmark.Status),1},
                { nameof(RB_Member_Footmark.CreateDate),DateTime.Now}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper{
                        FiledName=nameof(RB_Member_Footmark.Id),
                        FiledValue=footMarkId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper{
                        FiledName=nameof(RB_Member_Footmark.UserId),
                        FiledValue=userInfo.UserId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper{
                        FiledName=nameof(RB_Member_Footmark.TenantId),
                        FiledValue=userInfo.TenantId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper{
                        FiledName=nameof(RB_Member_Footmark.MallBaseId),
                        FiledValue=userInfo.MallBaseId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return member_FootmarkRepository.Update(keyValues, wheres);
        }

        #endregion

        #region 个人中心

   

        /// <summary>
        /// 获取个人中心统计
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public object GetAppletUserCenterStatistics(string openId)
        {
            var objData = new object();
            var umodel = member_UserRepository.GetMemberUserEntityRepository(new RB_Member_User_Extend() { OpenId=openId});
            if (umodel != null && umodel.Id > 0)
            {
                //获取我的收藏
                int CollectionNum = member_CollectionRepository.GetMyCollectionNum(new RB_Member_Collection_Extend() { UserId = umodel.Id, TenantId = umodel.TenantId, MallBaseId = umodel.MallBaseId });
                //获取我的足迹
                int FootmarkNum = member_FootmarkRepository.GetMyFootmarkNum(umodel.Id, umodel.TenantId, umodel.MallBaseId);
                //订单状态
                List<RB_Goods_Order_Extend> olist = goods_OrderRepository.GetAppletGoodsOrderNumStatistics(umodel.Id, umodel.TenantId, umodel.MallBaseId);
                //待评价
                int WaitCommentNum = goods_OrderRepository.GetAppletGoodsOrderWaitCommentNum(umodel.Id, umodel.TenantId, umodel.MallBaseId);
                //售后处理中
                int AfterSaleNum = goods_OrderRepository.GetAppletGoodsOrderAfterSaleNum(umodel.Id, umodel.TenantId, umodel.MallBaseId);
                string parent_name = "";
                if (umodel.SuperiorId != null)
                {
                    if (umodel.SuperiorId == 0)
                    {
                        parent_name = "总店";
                    }
                    else if (umodel.SuperiorId > 0)
                    {
                        parent_name = member_UserRepository.GetEntity<RB_Member_User_Extend>(umodel.SuperiorId)?.Name ?? "";
                    }
                }
                objData = new {
                    //昵称
                    nickname = umodel?.Name ?? "",
                    //电话
                    mobile = umodel?.Moblie ?? "",
                    //头像
                    avatar = umodel?.Photo ?? "",
                    //积分
                    integral = umodel?.Integral ?? 0,
                    //余额
                    balance = umodel?.Balance ?? 0,
                    //选项todo
                    options = new { },
                    //收藏 todo
                    favorite = CollectionNum,
                    //足迹
                    footprint = FootmarkNum,
                    //优惠券
                    coupon = umodel.CouponsNum,
                    //卡券
                    card = umodel.CardVolumeNum,
                    //标识
                    identity = new
                    {
                        parent_name,
                        member_level=umodel.MemberGrade,
                        level_name=umodel.MemberGradeName,
                        is_admin=0,
                    },
                    MyOrder = new
                    {
                        NonPayment = olist.Where(x => x.OrderStatus == Common.Enum.Goods.OrderStatusEnum.NonPayment).FirstOrDefault()?.OrderNum ?? 0,
                        WaitSendGoods = olist.Where(x => x.OrderStatus == Common.Enum.Goods.OrderStatusEnum.WaitSendGoods).FirstOrDefault()?.OrderNum ?? 0,
                        WaitReceiving = olist.Where(x => x.OrderStatus == Common.Enum.Goods.OrderStatusEnum.WaitReceiving).FirstOrDefault()?.OrderNum ?? 0,
                        WaitCommentNum,
                        AfterSaleNum
                    }
                };
            }
            return objData;
        }

        #endregion

        #region 用户转移

        /// <summary>
        /// 更新用户微信头像
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="count"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool UpdateUserPhotoForWeiXin(int userId, int count, int tenantId, int mallBaseId)
        {
            var list = member_UserRepository.GetPageList(1, count, out long rcount, new RB_Member_User_Extend() { TenantId = tenantId, MallBaseId = mallBaseId, Id = userId, Source = UserSourceEnum.WeiXin, IsEmptyUserPhoto = 1 });

            var appletWeChatModel = miniProgramRepository.GetEntity(mallBaseId);
            string token = CacheManager.AppletWeChat.WeiXinReidsCache.Get(appletWeChatModel.MiniAppId);
            if (string.IsNullOrEmpty(token))
            {
                token = Mall.Common.Pay.WeChatPat.TokenHelper.GetLXYToken(token, appletWeChatModel.MiniAppId, appletWeChatModel.MiniAppSecret);
                System.Threading.Tasks.Task.Run(() => CacheManager.AppletWeChat.WeiXinReidsCache.Set(appletWeChatModel.MiniAppId, token));
            }
            foreach (var item in list) {
                string photo = Mall.Common.Pay.WeChatPat.TokenHelper.GetWeiXinUserPhoto(token, item.OpenId);
                if (!string.IsNullOrEmpty(photo)) {
                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_Member_User.Photo),photo}
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_Member_User.Id),
                              FiledValue=item.Id,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    member_UserRepository.Update(keyValues, wheres);
                }
            }
            return true;
        }

        /// <summary>
        /// 更新用户上下级关系
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="count"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public int UpdateUserSuperiorForWeiXin(int userId, int count, int tenantId, int mallBaseId)
        {
            string cookie = "__login_route=%2Fadmin%2Fpassport%2Flogin; __login_role=admin; search={'keyword':'','status':' - 1','sort_prop':'','sort_type':'','cats'[],'date_start':null,'date_end':null}; HJ_SESSION_ID=kmmormovvm2u9qh5drkgsbj1ta; _csrf=7a980bb65eabe0ac3d77199092030044b17ae9779de00eaed628c8095ab2fe0ca%3A2%3A%7Bi%3A0%3Bs%3A5%3A%22_csrf%22%3Bi%3A1%3Bs%3A32%3A%22rsnZWVWkZkpfvVhLBXu8sGG3px0Dgcsx%22%3B%7D";
            var list = member_UserRepository.GetPageList(1, count, out long rcount, new RB_Member_User_Extend() { TenantId = tenantId, MallBaseId = mallBaseId, MinUserId = userId, Source = UserSourceEnum.WeiXin });
            foreach (var item in list)
            {
                string data = Mall.Common.Pay.WeChatPat.TokenHelper.GetZYUserInfo(item.Id, cookie);
                if (!string.IsNullOrEmpty(data))
                {
                    var data1 = Encoding.GetEncoding("GBK").GetBytes(data);
                    data = Encoding.GetEncoding("GBK").GetString(data1);
                    var jdata = (JObject)JsonConvert.DeserializeObject(data);
                    var List = jdata["list"].ToString();
                    if (List != "" && List != "[]") {
                        //根据用户名  查询一次用户列表
                        List<Model.Query.UserSuperiorImport> UserList = JsonConvert.DeserializeObject<List<Model.Query.UserSuperiorImport>>(List);
                        foreach (var uitem in UserList) {
                            uitem.nickname = uitem.nickname.Replace("'", "\"");
                            uitem.nickname = uitem.nickname.Replace("??", "?");
                            if (uitem.nickname.Length > 20)
                            {
                                uitem.nickname = "'" + uitem.nickname[..20] + "'";
                            }
                            else {
                                uitem.nickname = "'" + uitem.nickname.Replace("'", "") + "\t'";
                            }
                        }
                        string UserNameStr = string.Join(",", UserList.Select(x => x.nickname));
                        var uList = member_UserRepository.GetList(new RB_Member_User_Extend() { UserNameStr = UserNameStr, TenantId = tenantId, MallBaseId = mallBaseId });

                        foreach (var qitem in uList) {
                            if (qitem.SuperiorId == 0)
                            {
                                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                                    { nameof(RB_Member_User.SuperiorId),item.Id}
                                };
                                List<WhereHelper> wheres = new List<WhereHelper>() {
                                    new WhereHelper(){
                                         FiledName=nameof(RB_Member_User.Id),
                                          FiledValue=qitem.Id,
                                           OperatorEnum=OperatorEnum.Equal
                                    }
                                };
                                member_UserRepository.Update(keyValues, wheres);
                            }
                        }
                    }
                }
            }
            return list.Max(x => x.Id);
        }

        #endregion

        #region 数据统计-分销排行
        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="dmodel">查询条件</param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetRankingListPage(int pageIndex, int pageSize, out long rowCount, RB_Member_User_Extend dmodel)
        {
            return member_UserRepository.GetRankingListPage(pageIndex, pageSize, out rowCount, dmodel);
        }

        /// <summary>
        /// 获取全部分销商信息
        /// </summary>
        /// <param name="dmodel"></param>
        /// <returns></returns>
        public List<RB_Member_User_Extend> GetRankingList(RB_Member_User_Extend dmodel)
        {
            return member_UserRepository.GetRankingList(dmodel);
        }
        #endregion

        #region 和平分销

        /// <summary>
        /// 获取和平分销等级分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_HPGradeInfo_Extend> GetHpDistributorGradePageList(int pageIndex, int pageSize, out long count, RB_Distributor_HPGradeInfo_Extend demodel)
        {
            return distributor_HPGradeInfoRepository.GetPageList(pageIndex, pageSize, out count, demodel);
        }

        /// <summary>
        /// 获取等级列表
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_HPGradeInfo_Extend> GetHpDistributorGradeList(RB_Distributor_HPGradeInfo_Extend demodel)
        {
            return distributor_HPGradeInfoRepository.GetList(demodel);
        }

        /// <summary>
        /// 新增修改和平等级
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetHpDistributorGradeInfo(RB_Distributor_HPGradeInfo_Extend demodel)
        {
            if (demodel.Id > 0)
            {
                Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                    { nameof(RB_Distributor_HPGradeInfo.Grade),demodel.Grade},
                    { nameof(RB_Distributor_HPGradeInfo.GradeName),demodel.GradeName},
                    { nameof(RB_Distributor_HPGradeInfo.UpdateDate),demodel.UpdateDate},
                };
                List<WhereHelper> wheres = new List<WhereHelper>() {
                    new WhereHelper(){
                        FiledName=nameof(RB_Distributor_HPGradeInfo.Id),
                         FiledValue=demodel.Id,
                          OperatorEnum=OperatorEnum.Equal
                    }
                };
                return distributor_HPGradeInfoRepository.Update(keyValues, wheres);
            }
            else {
                return distributor_HPGradeInfoRepository.Insert(demodel) > 0;
            }
        }

        /// <summary>
        /// 删除和平等级
        /// </summary>
        /// <param name="gradeId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool DelHpDistributorGradeInfo(int gradeId, int tenantId, int mallBaseId)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Distributor_HPGradeInfo.Status),1},
                { nameof(RB_Distributor_HPGradeInfo.UpdateDate),DateTime.Now},
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                    FiledName=nameof(RB_Distributor_HPGradeInfo.Id),
                        FiledValue=gradeId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                    FiledName=nameof(RB_Distributor_HPGradeInfo.TenantId),
                        FiledValue=tenantId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                    FiledName=nameof(RB_Distributor_HPGradeInfo.MallBaseId),
                        FiledValue=mallBaseId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return distributor_HPGradeInfoRepository.Update(keyValues, wheres);
        }

        /// <summary>
        /// 获取分销返佣分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="count"></param>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public List<RB_Distributor_HPCommission_Extend> GetHpDistributorPageList(int pageIndex, int pageSize, out long count, RB_Distributor_HPCommission_Extend demodel)
        {
            var list = distributor_HPCommissionRepository.GetPageList(pageIndex, pageSize, out count, demodel);
            if (list.Any()) {
                string cids = string.Join(",", list.Select(x => x.Id));
                //查询所有分类
                var clist = distributor_HPCategoryRepository.GetList(new RB_Distributor_HPCategory_Extend() { CommissionIds = cids, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                //查询所有比例
                var rlist = distributor_HPGradeRatioRepository.GetList(new RB_Distributor_HPGradeRatio_Extend() { CommissionIds = cids, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });

                foreach (var item in list) {
                    item.CategoryList = clist.Where(x => x.CommissionId == item.Id).ToList();
                    item.RatioList = rlist.Where(x => x.CommissionId == item.Id).OrderBy(x => x.Grade).ToList();
                }
            }
            return list;
        }

        /// <summary>
        /// 获取详情
        /// </summary>
        /// <param name="commissionId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public RB_Distributor_HPCommission_Extend GetHpdistributorInfo(int commissionId, int tenantId, int mallBaseId)
        {
            var model = distributor_HPCommissionRepository.GetEntity<RB_Distributor_HPCommission_Extend>(commissionId);
            model.CategoryList = distributor_HPCategoryRepository.GetList(new RB_Distributor_HPCategory_Extend() { CommissionId = commissionId, TenantId = tenantId, MallBaseId = mallBaseId });
            //查询所有比例
            model.RatioList = distributor_HPGradeRatioRepository.GetList(new RB_Distributor_HPGradeRatio_Extend() { CommissionId = commissionId, TenantId = tenantId, MallBaseId = mallBaseId });
            return model;
        }

        /// <summary>
        /// 新增修改和平分销
        /// </summary>
        /// <param name="demodel"></param>
        /// <returns></returns>
        public bool SetHpDistributorInfo(RB_Distributor_HPCommission_Extend demodel)
        {
            var trans = distributor_HPCommissionRepository.DbTransaction;
            try
            {
                if (demodel.Id > 0)
                {
                    Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                        { nameof(RB_Distributor_HPCommission.Enabled),demodel.Enabled},
                        { nameof(RB_Distributor_HPCommission.Name),demodel.Name},
                        { nameof(RB_Distributor_HPCommission.DecimalType),demodel.DecimalType},
                        { nameof(RB_Distributor_HPCommission.IsCommon),demodel.IsCommon},
                        { nameof(RB_Distributor_HPCommission.UpdateDate),demodel.UpdateDate}
                    };
                    List<WhereHelper> wheres = new List<WhereHelper>() {
                        new WhereHelper(){
                             FiledName=nameof(RB_Distributor_HPCommission.Id),
                              FiledValue=demodel.Id,
                               OperatorEnum=OperatorEnum.Equal
                        },
                        new WhereHelper(){
                             FiledName=nameof(RB_Distributor_HPCommission.TenantId),
                              FiledValue=demodel.TenantId,
                               OperatorEnum=OperatorEnum.Equal
                        },
                        new WhereHelper(){
                             FiledName=nameof(RB_Distributor_HPCommission.MallBaseId),
                              FiledValue=demodel.MallBaseId,
                               OperatorEnum=OperatorEnum.Equal
                        }
                    };
                    bool flag = distributor_HPCommissionRepository.Update(keyValues, wheres, trans);
                    if (flag) {
                        #region 验证比例是否修改
                        var rlist = distributor_HPGradeRatioRepository.GetList(new RB_Distributor_HPGradeRatio_Extend() { CommissionId = demodel.Id, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });
                        var rUpdateList = rlist.Where(x => demodel.RatioList.Select(z => z.GradeId).Contains(x.GradeId)).ToList();
                        var rDelList = rlist.Where(x => !demodel.RatioList.Select(z => z.GradeId).Contains(x.GradeId)).ToList();
                        var rInsertList = demodel.RatioList.Where(x => !rlist.Select(z => z.GradeId).Contains(x.GradeId)).ToList();
                        
                        foreach (var item in rUpdateList) {
                            var rmodel = demodel.RatioList.Where(x => x.GradeId == item.GradeId).FirstOrDefault();
                            Dictionary<string, object> keyValues1 = new Dictionary<string, object>() {
                                { nameof(RB_Distributor_HPGradeRatio.CommissionRatio),rmodel?.CommissionRatio??0}
                            };
                            List<WhereHelper> wheres1 = new List<WhereHelper>() {
                                new WhereHelper(){
                                     FiledName=nameof(RB_Distributor_HPGradeRatio.Id),
                                      FiledValue=item.Id,
                                       OperatorEnum=OperatorEnum.Equal
                                }
                            };
                            distributor_HPGradeRatioRepository.Update(keyValues1, wheres1, trans);
                        }
                        foreach (var item in rDelList) {
                            distributor_HPGradeRatioRepository.Delete(item, trans);
                        }
                        foreach (var item in rInsertList) {
                            distributor_HPGradeRatioRepository.Insert(new RB_Distributor_HPGradeRatio()
                            {
                                CommissionId = demodel.Id,
                                Id = 0,
                                CommissionRatio = item.CommissionRatio,
                                CreateDate = demodel.CreateDate,
                                GradeId = item.GradeId,
                                MallBaseId = demodel.MallBaseId,
                                TenantId = demodel.TenantId
                            }, trans);
                        }
                        #endregion

                        #region 验证分类是否修改

                        var clist = distributor_HPCategoryRepository.GetList(new RB_Distributor_HPCategory_Extend() { CommissionId = demodel.Id, TenantId = demodel.TenantId, MallBaseId = demodel.MallBaseId });                        
                        var cDelList = clist.Where(x => !demodel.CategoryList.Select(z => z.CategoryId).Contains(x.CategoryId)).ToList();
                        var cInsertList = demodel.CategoryList.Where(x => !clist.Select(z => z.CategoryId).Contains(x.CategoryId)).ToList();

                        foreach (var item in cDelList) {
                            distributor_HPCategoryRepository.Delete(item);
                        }
                        foreach (var item in cInsertList) {
                            distributor_HPCategoryRepository.Insert(new RB_Distributor_HPCategory()
                            {
                                CategoryId = item.CategoryId,
                                CommissionId = demodel.Id,
                                Id = 0,
                                CreateDate = demodel.CreateDate,
                                MallBaseId = demodel.MallBaseId,
                                TenantId = demodel.TenantId
                            }, trans);
                        }
                        #endregion

                    }
                    distributor_HPCommissionRepository.DBSession.Commit();
                    return flag;
                }
                else
                {
                    int Id = distributor_HPCommissionRepository.Insert(demodel, trans);
                    if (Id > 0) {
                        //插入比例
                        foreach (var item in demodel.RatioList) {
                            distributor_HPGradeRatioRepository.Insert(new RB_Distributor_HPGradeRatio()
                            {
                                CommissionId = Id,
                                Id = 0,
                                CommissionRatio = item.CommissionRatio,
                                CreateDate = demodel.CreateDate,
                                GradeId = item.GradeId,
                                MallBaseId = demodel.MallBaseId,
                                TenantId = demodel.TenantId
                            }, trans);
                        }
                        //插入分类
                        foreach (var item in demodel.CategoryList) {
                            distributor_HPCategoryRepository.Insert(new RB_Distributor_HPCategory()
                            {
                                CategoryId = item.CategoryId,
                                CommissionId = Id,
                                Id = 0,
                                CreateDate = demodel.CreateDate,
                                MallBaseId = demodel.MallBaseId,
                                TenantId = demodel.TenantId
                            }, trans);
                        }
                    }
                    distributor_HPCommissionRepository.DBSession.Commit();
                    return Id > 0;
                }
            }
            catch (Exception ex)
            {
                LogHelper.Write(ex, "SetHpDistributorInfo");
                distributor_HPCommissionRepository.DBSession.Rollback();
                return false;
            }            
        }

        /// <summary>
        /// 启用和平分销
        /// </summary>
        /// <param name="commissionId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool SetGetHpDistrIbutorEnabled(int commissionId, int tenantId, int mallBaseId)
        {
            var model = distributor_HPCommissionRepository.GetEntity(commissionId);
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Distributor_HPCommission.Enabled),model.Enabled==1?2:1},
                { nameof(RB_Distributor_HPCommission.UpdateDate),DateTime.Now}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Distributor_HPCommission.Id),
                        FiledValue=commissionId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Distributor_HPCommission.TenantId),
                        FiledValue=tenantId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Distributor_HPCommission.MallBaseId),
                        FiledValue=mallBaseId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return distributor_HPCommissionRepository.Update(keyValues, wheres);
        }

        /// <summary>
        /// 获取和平分销是否启用
        /// </summary>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public int GetHpDistributorIsEnabled(int tenantId, int mallBaseId)
        {
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Distributor_HPCommission.Status),
                        FiledValue=0,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Distributor_HPCommission.Enabled),
                        FiledValue=1,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Distributor_HPCommission.TenantId),
                        FiledValue=tenantId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Distributor_HPCommission.MallBaseId),
                        FiledValue=mallBaseId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return distributor_HPCommissionRepository.Exists(wheres) ? 1 : 2;
        }

        /// <summary>
        /// 删除分销
        /// </summary>
        /// <param name="commissionId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public bool DelHpDistributorInfo(int commissionId, int tenantId, int mallBaseId)
        {
            Dictionary<string, object> keyValues = new Dictionary<string, object>() {
                { nameof(RB_Distributor_HPCommission.Status),1},
                { nameof(RB_Distributor_HPCommission.UpdateDate),DateTime.Now}
            };
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Distributor_HPCommission.Id),
                        FiledValue=commissionId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Distributor_HPCommission.TenantId),
                        FiledValue=tenantId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Distributor_HPCommission.MallBaseId),
                        FiledValue=mallBaseId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            return distributor_HPCommissionRepository.Update(keyValues, wheres);
        }

        /// <summary>
        /// 获取用户和平分销信息
        /// </summary>
        /// <param name="userId"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public object GetHpUserDistributorInfo(int userId, int tenantId, int mallBaseId)
        {
            var umodel = member_UserRepository.GetEntity(userId);
            var model = distributor_InfoRepository.GetList(new RB_Distributor_Info_Extend() { UserId = userId, TenantId = tenantId, MallBaseId = mallBaseId }).FirstOrDefault();
            if (model == null) {
                return new
                {
                    Status = 3,
                    Msg = "该用户不是分销商"
                };
            }
            if (model.AuditStatus != DistributorAuditStatusEnum.Audited) {
                return new
                {
                    Status = 3,
                    Msg = "该用户不是分销商"
                };
            }
            if ((model.HPGradeId ?? 0) <= 0) {
                return new
                {
                    Status = 2,
                    Msg = "该用户不是和平分销商等级"
                };
            }
            var gmodel = distributor_HPGradeInfoRepository.GetEntity(model.HPGradeId);
            return new
            {
                Status = 1,
                UserName = umodel?.Name ?? "",
                HPGrade = gmodel.Grade,
                HPGradeName = gmodel.GradeName
            };
        }

        /// <summary>
        /// 获取商品建议价格
        /// </summary>
        /// <param name="categoryIds"></param>
        /// <param name="costPrice"></param>
        /// <param name="tenantId"></param>
        /// <param name="mallBaseId"></param>
        /// <returns></returns>
        public object GetHpGoodsSuggestPrice(string categoryIds, decimal costPrice, int tenantId, int mallBaseId)
        {
            //判断是否开启和平返佣
            List<WhereHelper> wheres = new List<WhereHelper>() {
                new WhereHelper(){
                        FiledName=nameof(RB_Distributor_HPCommission_Extend.Status),
                        FiledValue=0,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Distributor_HPCommission_Extend.Enabled),
                        FiledValue=1,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Distributor_HPCommission_Extend.TenantId),
                        FiledValue=tenantId,
                        OperatorEnum=OperatorEnum.Equal
                },
                new WhereHelper(){
                        FiledName=nameof(RB_Distributor_HPCommission_Extend.MallBaseId),
                        FiledValue=mallBaseId,
                        OperatorEnum=OperatorEnum.Equal
                }
            };
            if (!distributor_HPCommissionRepository.Exists(wheres)) {
                return new
                {
                    Status = 2,
                    MPrice = 0,
                    Msg = "未配置和平返佣"
                };
            }
            List<RB_Distributor_HPCommission_Extend> hpcList = new List<RB_Distributor_HPCommission_Extend>();
            if (string.IsNullOrEmpty(categoryIds))
            {
                hpcList = distributor_HPCommissionRepository.GetList(new RB_Distributor_HPCommission_Extend() { IsCommon = 1, TenantId = tenantId, MallBaseId = mallBaseId });
            }
            else {
                hpcList = distributor_HPCommissionRepository.GetList(new RB_Distributor_HPCommission_Extend() { CategoryIds = categoryIds, TenantId = tenantId, MallBaseId = mallBaseId });
                if (!hpcList.Any()) {
                    hpcList = distributor_HPCommissionRepository.GetList(new RB_Distributor_HPCommission_Extend() { IsCommon = 1, TenantId = tenantId, MallBaseId = mallBaseId });
                }
            }
            if (hpcList.Any()) {
                var hpcModel = hpcList.FirstOrDefault();
                //查询直客毛利率
                var gList = distributor_HPGradeRatioRepository.GetList(new RB_Distributor_HPGradeRatio_Extend() { CommissionId = hpcModel.Id, IsGuest = 1, TenantId = tenantId, MallBaseId = mallBaseId });

                var ratioModel = gList.FirstOrDefault();
                if (ratioModel != null)
                {
                    decimal MPrice = costPrice / (1 - ((ratioModel.CommissionRatio ?? 0) / 100));
                    MPrice = Math.Ceiling(MPrice);
                    return new
                    {
                        Status = 1,
                        MPrice,
                        Msg = ""
                    };
                }
            }
            return new
            {
                Status = 3,
                MPrice = 0,
                Msg = "未匹配到适用的返佣"
            };
        }

        #endregion
    }
}
