﻿using VT.FW.DB;
using Mall.Model.Entity.Finance;
using System;
using System.Collections.Generic;

namespace Mall.Model.Extend.Finance
{
    /// <summary>
    /// 财务单据扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "FinanceConnection")]
    public class RB_Finance_Extend : RB_Finance
    {
        /// <summary>
        /// 电商订单id
        /// </summary>
        public int ECOrderId { get; set; }
        /// <summary>
        /// 电商订单ids
        /// </summary>
        public string ECOrderIds { get; set; }
        /// <summary>
        /// 订单明细id
        /// </summary>
        public int ECOrderDetailId { get; set; }


        /// <summary>
        /// 订单明细id
        /// </summary>
        public string ReFinanceIds2 { get; set; }

        /// <summary>
        /// 审批人信息
        /// </summary>
        public List<AuditInfo> AuditList { get; set; }

        /// <summary>
        /// 机票总金额
        /// </summary>
        public decimal? AirTotalMoney { get; set; }
        /// <summary>
        /// 机票总手续费
        /// </summary>
        public decimal? AirTotalPayMoney { get; set; }

        /// <summary>
        /// 账户列表
        /// </summary>
        public string AccountIdStr { get; set; }


        /// <summary>
        /// 查询正常提交的订单
        /// </summary>
        public int? IsSelectNormal { get; set; }

        /// <summary>
        /// 是否跟团相关
        /// </summary>
        public int? Is_TCID { get; set; }

        /// <summary>
        /// 是否查询利润专户  1不查询  其他查询
        /// </summary>
        public int? Is_ProfitFoHF { get; set; }

        /// <summary>
        ///财务单据ID集合
        /// </summary>
        public string FrIDs { get; set; }

        /// <summary>
        /// 订单id
        /// </summary>
        public string OrderIdStr { get; set; }

        /// <summary>
        /// 学生名单ids
        /// </summary>
        public string GuestIdStr { get; set; }


        /// <summary>
        /// 审核开始时间
        /// </summary>
        public DateTime? sAduitDate { get; set; }
        /// <summary>
        /// 审核结束时间
        /// </summary>
        public DateTime? eAduitDate { get; set; }
        /// <summary>
        /// 费用类型名称
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// 交易开始日期
        /// </summary>
        public string sTradeDate { get; set; }
        /// <summary>
        /// 交易结束日期
        /// </summary>
        public string eTradeDate { get; set; }


        /// <summary>
        /// 费用类型列表
        /// </summary>
        public List<string> CostTypeList { get; set; }

        /// <summary>
        /// 单据明细
        /// </summary>
        public List<RB_FinanceDetail_Extend> detailList { get; set; }

        /// <summary>
        /// 账户列表
        /// </summary>
        public List<RB_TradeWay_Extend> BankList { get; set; }
        /// <summary>
        /// 凭证实体
        /// </summary>
        public List<RB_Voucher_Extend> vorcherInos { get; set; }
    }


    /// <summary>
    /// 审批人信息
    /// </summary>
    public class AuditInfo
    {
        /// <summary>
        /// 审批人ID
        /// </summary>
        public int? AuditEmId { get; set; }
        /// <summary>
        /// 审批日期
        /// </summary>
        public DateTime? AuditDate { get; set; }
        /// <summary>
        /// 审批人ID
        /// </summary>
        public string AuditEmName { get; set; }
    }
}
