﻿using VT.FW.DB;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 用户统计表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_User_Statistics
    {
        /// <summary>
        /// Id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 日期
        /// </summary>
        public DateTime Date { get; set; }

        /// <summary>
        /// 付款人数
        /// </summary>
        public int PeopleNum { get; set; }

        /// <summary>
        /// 订单数量
        /// </summary>
        public int OrderNum { get; set; }

        /// <summary>
        /// 付款金额
        /// </summary>
        public decimal PayMoney { get; set; }

        /// <summary>
        /// 购买数量
        /// </summary>
        public int BuyNum { get; set; }

        /// <summary>
        /// 平均每人购买单数
        /// </summary>
        public decimal AvgOrderNum { get; set; }

        /// <summary>
        /// 平均每人购买件数
        /// </summary>
        public decimal AvgBuyNum { get; set; }

        /// <summary>
        /// 平均每单单价
        /// </summary>
        public decimal AvgUnitPrice { get; set; }

        /// <summary>
        /// 平均每人购买单价
        /// </summary>
        public decimal AvgBuyPrice { get; set; }

        /// <summary>
        /// 会员累计数量
        /// </summary>
        public int MemberNum { get; set; }

        /// <summary>
        /// 累计付款人数
        /// </summary>
        public int PaymentNum { get; set; }

        /// <summary>
        /// 会员订单转换率
        /// </summary>
        public decimal MOrderRate { get; set; }

        /// <summary>
        /// 复购人数
        /// </summary>
        public int ReBuyNum { get; set; }

        /// <summary>
        /// 复购率
        /// </summary>
        public decimal ReBuyRate { get; set; }

        /// <summary>
        /// 新人下单
        /// </summary>
        public int NewPeopleNum { get; set; }

        /// <summary>
        /// 今日普象新增
        /// </summary>
        public int PXNum { get; set; }

        /// <summary>
        /// 今日VIP新增
        /// </summary>
        public int VipNum { get; set; }

        /// <summary>
        /// 今日银象新增
        /// </summary>
        public int YXNum { get; set; }

        /// <summary>
        /// 今日金象新增
        /// </summary>
        public int JXNum { get; set; }

        /// <summary>
        /// 利润
        /// </summary>
        public decimal Profit { get; set; }

        /// <summary>
        /// 利润率
        /// </summary>
        public decimal ProfitRate { get; set; }

        /// <summary>
        /// 小程序id
        /// </summary>
        public int MallBaseId { get; set; }

        /// <summary>
        /// 商户号id
        /// </summary>        
        public int TenantId { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>        
        public DateTime CreateDate { get; set; }

        /// <summary>
        /// 修改时间
        /// </summary>        
        public DateTime UpdateDate { get; set; }

        /// <summary>
        /// 普象累计
        /// </summary>
        public int PXLJNum { get; set; }

        /// <summary>
        /// VIP累计
        /// </summary>
        public int VipLJNum { get; set; }

        /// <summary>
        /// 银象累计
        /// </summary>
        public int YXLJNum { get; set; }

        /// <summary>
        /// 金象累计
        /// </summary>
        public int JXLJNum { get; set; }

        /// <summary>
        /// 取消单数
        /// </summary>
        public int CancelOrderNum { get; set; }

    }
}
