﻿using Mall.Common.AOP;
using Mall.Common.Enum.User;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Entity.User
{
    /// <summary>
    /// 财务配置表实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Finance_Configurine
    {

        /// <summary>
        /// Id
        /// </summary>        
        public int Id
        {
            get;
            set;
        }
        /// <summary>
        /// 0-私账1-公账
        /// </summary>        
        public int? IsPublic
        {
            get;
            set;
        }
        /// <summary>
        /// 1-银行账户2-平台账户3-资金池账户4-现金池账户
        /// </summary>        
        public int? AccountType
        {
            get;
            set;
        }
        /// <summary>
        /// 账户ID
        /// </summary>        
        public int? AccountId
        {
            get;
            set;
        }
        /// <summary>
        /// 类型Type=1汇款人 Type=2则为客户名称
        /// </summary>        
        public string RemitterName
        {
            get;
            set;
        }
        /// <summary>
        /// 付款需要币种
        /// </summary>        
        public int? CurrencyId
        {
            get;
            set;
        }
        /// <summary>
        /// 商品收入费用
        /// </summary>        
        public int? IncomeCostTypeId
        {
            get;
            set;
        }
        /// <summary>
        /// 运费收入费用
        /// </summary>        
        public int? FreightCostTypeId
        {
            get;
            set;
        }
        /// <summary>
        /// 退款费用
        /// </summary>        
        public int? RefundCostTypeId
        {
            get;
            set;
        }
        /// <summary>
        /// 成本费用
        /// </summary>        
        public int? CBCostTypeId
        {
            get;
            set;
        }
        /// <summary>
        /// 运杂费用id
        /// </summary>
        public int? ExpensesCostTypeId { get; set; }
        /// <summary>
        /// RemitCostTypeId
        /// </summary>        
        public int? RemitCostTypeId
        {
            get;
            set;
        }
        /// <summary>
        /// 流程id
        /// </summary>        
        public int? WorkFlowId
        {
            get;
            set;
        }
        /// <summary>
        /// 类型  1收款  2成本  3退款   4打款
        /// </summary>        
        public int? Type
        {
            get;
            set;
        }
        /// <summary>
        /// 开始时间
        /// </summary>        
        public DateTime? StartTime
        {
            get;
            set;
        }
        /// <summary>
        /// 执行周期   天数  最小1天 以开始时间为准
        /// </summary>        
        public int? IntervalDay
        {
            get;
            set;
        }
        /// <summary>
        /// 删除状态
        /// </summary>        
        public int? Status
        {
            get;
            set;
        }
        /// <summary>
        /// 商户号
        /// </summary>        
        public int TenantId
        {
            get;
            set;
        }
        /// <summary>
        /// 小程序id
        /// </summary>        
        public int MallBaseId
        {
            get;
            set;
        }
        /// <summary>
        /// CreateDate
        /// </summary>        
        public DateTime? CreateDate
        {
            get;
            set;
        }
        /// <summary>
        /// UpdateDate
        /// </summary>        
        public DateTime? UpdateDate
        {
            get;
            set;
        }
    }
}
