﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;

namespace Mall.Model.Query
{
    /// <summary>
    /// 赞羊商品轮播
    /// </summary>
    [Serializable]
    public class GoodsCarouselImport
    {
        /// <summary>
        /// id
        /// </summary>
        public int id { get; set; }
        /// <summary>
        /// 图片地址
        /// </summary>
        public string pic_url { get; set; }
    }

    /// <summary>
    /// 赞羊规格
    /// </summary>
    [Serializable]
    public class GoodsSpecificationImport
    {
        /// <summary>
        /// attr_group_id
        /// </summary>
        public int attr_group_id { get; set; }
        /// <summary>
        /// 规格名称
        /// </summary>
        public string attr_group_name { get; set; }
        /// <summary>
        /// 子集 
        /// </summary>
        public List<GoodsSpecificationValueImport> attr_list { get; set; }
    }

    /// <summary>
    /// 赞羊规格值
    /// </summary>
    [Serializable]
    public class GoodsSpecificationValueImport {
        /// <summary>
        /// attr_id
        /// </summary>
        public int attr_id { get; set; }
        /// <summary>
        /// 图片地址
        /// </summary>
        public string attr_name { get; set; }
        /// <summary>
        /// 图片地址
        /// </summary>
        public string pic_url { get; set; }
    }

    /// <summary>
    /// 赞羊规格价格
    /// </summary>
    [Serializable]
    public class GoodsSpecificationPriceImport
    {
        /// <summary>
        /// id
        /// </summary>
        public int id { get; set; }
        /// <summary>
        /// 商品id
        /// </summary>
        public int goods_id { get; set; }
        /// <summary>
        /// key
        /// </summary>
        public string sign_id { get; set; }
        /// <summary>
        /// 库存
        /// </summary>
        public int stock { get; set; }
        /// <summary>
        /// 价格
        /// </summary>
        public decimal price { get; set; }
        /// <summary>
        /// 货号
        /// </summary>
        public string no { get; set; }
        /// <summary>
        /// 重量
        /// </summary>
        public int weight { get; set; }
        /// <summary>
        /// 图片地址
        /// </summary>
        public string pic_url { get; set; }
    }

    /// <summary>
    /// 赞羊区域导入
    /// </summary>
    [Serializable]
    public class GoodsAreaListImport {
        /// <summary>
        /// 列表
        /// </summary>
        public List<GoodsAreaImport> list { get; set; }
    }

    /// <summary>
    /// 赞羊区域详情
    /// </summary>
    [Serializable]
    public class GoodsAreaImport
    {
        /// <summary>
        /// id
        /// </summary>
        public int id { get; set; }
        /// <summary>
        /// 名称
        /// </summary>
        public string name { get; set; }
    }

    /// <summary>
    /// 用户下级
    /// </summary>
    [Serializable]
    public class UserSuperiorImport
    {
        /// <summary>
        /// 昵称
        /// </summary>
        public string nickname { get; set; }
        /// <summary>
        /// 加入时间
        /// </summary>
        public string junior_at { get; set; }
    }

}
