﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mall.Model.Entity.Point;
using Mall.Model.Extend.Point;

namespace Mall.Repository.Point
{
    public class RB_Point_TeacherCourseOrderRepository:BaseRepository<RB_Point_TeacherCourseOrder>
    {
        /// <summary>
        /// 表名称
        /// </summary>
        public string TableName { get { return nameof(RB_Point_TeacherCourseOrder); } }

        /// <summary>
        /// 获取列表
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_TeacherCourseOrder_Extend> GetPointOrderList(RB_Point_TeacherCourseOrder_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT a.*, b.`Name` as UserName, t.CourseName, c.CourseClassType, d.Name as TeacherName, d.TeacherLogo, b.OpenId
from RB_Point_TeacherCourseOrder as a
Left join rb_point_teachercourse t on a.CourseId = t.ID
Left Join rb_point_courseclass c on a.CourseClassId = c.ID
Left JOin rb_education_teacher d on a.TeacherId = d.ID
LEFT JOIN rb_member_user as b  on a.UserId = b.Id
where a.state = 0");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and  a.TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and  a.MallBaseId={0}", where.MallBaseId);
                }
                if (where.CourseId > 0)
                {
                    sb.AppendFormat(" and  a.CourseId={0}", where.CourseId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and  a.MallBaseId={0}", where.MallBaseId);
                }
                if (where.ID > 0)
                {
                    sb.AppendFormat(" and  a.ID={0}", where.ID);
                }
            }
            return Get<RB_Point_TeacherCourseOrder_Extend>(sb.ToString()).ToList();
        }

        /// <summary>
        /// 获取正常订单列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_TeacherCourseOrder_Extend> GetNormalPointOrderList(RB_Point_TeacherCourseOrder_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT a.*,b.`Name` as UserName,b.Photo as UserPhoto
from RB_Point_TeacherCourseOrder as a 
LEFT JOIN rb_member_user as b  on a.UserId=b.Id 
where a.state=0 and a.OrderStaus in(2,3,4)");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and a.TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and a.MallBaseId={0}", where.MallBaseId);
                }
                if (where.ID > 0)
                {
                    sb.AppendFormat(" and a.ID={0}", where.ID);
                }
                if (where.TeacherId > 0)
                {
                    sb.AppendFormat(" and a.TeacherId={0}", where.TeacherId);
                }
                if (where.CourseId > 0)
                {
                    sb.AppendFormat(" and a.CourseId={0}", where.CourseId);
                }
                if (where.UserId > 0)
                {
                    sb.AppendFormat(" and a.UserId={0}", where.UserId);
                }
                if (!string.IsNullOrEmpty(where.StartTime))
                {
                    sb.AppendFormat(" and a.CreateDate >='{0}'", where.StartTime);
                }
                if (!string.IsNullOrEmpty(where.EndTime))
                {
                    sb.AppendFormat(" and a.CreateDate <='{0}'", where.EndTime + " 23:59:59");
                }
            }
            sb.AppendFormat(" order by a.ID desc");
            return Get<RB_Point_TeacherCourseOrder_Extend>(sb.ToString()).ToList();
        }


        /// <summary>
        /// 分页列表
        /// </summary>
        /// <param name="pageIndex"></param>
        /// <param name="pageSize"></param>
        /// <param name="rowsCount"></param>
        /// <param name="where"></param>
        /// <returns></returns>
        public List<RB_Point_TeacherCourseOrder_Extend> GetPointOrderPageList(int pageIndex, int pageSize, out long rowsCount, RB_Point_TeacherCourseOrder_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT a.*,b.`Name` as UserName , t.CourseName,c.CourseClassType, d.Name as TeacherName ,d.TeacherLogo,b.OpenId
from RB_Point_TeacherCourseOrder as a 
Left join rb_point_teachercourse t on a.CourseId = t.ID
Left Join rb_point_courseclass c on a.CourseClassId = c.ID
Left JOin rb_education_teacher d on a.TeacherId = d.ID
LEFT JOIN rb_member_user as b  on a.UserId=b.Id 
where a.state=0 ");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and a.TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and a.MallBaseId={0}", where.MallBaseId);
                }
                if (where.ID > 0)
                {
                    sb.AppendFormat(" and a.ID={0}", where.ID);
                }
                if (where.CourseId > 0)
                {
                    sb.AppendFormat(" and a.CourseId={0}", where.CourseId);
                }
                if (where.TeacherId > 0)
                {
                    sb.AppendFormat(" and a.TeacherId={0}", where.TeacherId);
                }
                if (where.OrderStaus > 0)
                {
                    sb.AppendFormat(" and a.OrderStaus={0}", where.OrderStaus);
                }
                if (where.TeacherId > 0)
                {
                    sb.AppendFormat(" and a.TeacherId={0}", where.TeacherId);
                }
                if (where.CourseId > 0)
                {
                    sb.AppendFormat(" and a.CourseId={0}", where.CourseId);
                }
                if (where.UserId > 0)
                {
                    sb.AppendFormat(" and a.UserId={0}", where.UserId);
                }
                if (!string.IsNullOrEmpty(where.StartTime))
                {
                    sb.AppendFormat(" and a.CreateDate >='{0}'", where.StartTime);
                }
                if (!string.IsNullOrEmpty(where.EndTime))
                {
                    sb.AppendFormat(" and a.CreateDate <='{0}'", where.EndTime + " 23:59:59");
                }
            }
            sb.AppendFormat(" order by a.ID desc");
            return GetPage<RB_Point_TeacherCourseOrder_Extend>(pageIndex, pageSize, out rowsCount, sb.ToString()).ToList();
        }

        /// <summary>
        /// 获取明细
        /// </summary>
        /// <param name="where"></param>
        /// <returns></returns>
        public RB_Point_TeacherCourseOrder_Extend GetPointOrderInfo(RB_Point_TeacherCourseOrder_Extend where)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append($@"SELECT a.*,b.`Name` as UserName , t.CourseName,c.CourseClassType, d.Name as TeacherName ,d.TeacherLogo
from RB_Point_TeacherCourseOrder as a 
Left join rb_point_teachercourse t on a.CourseId = t.ID
Left Join rb_point_courseclass c on a.CourseClassId = c.ID
Left JOin rb_education_teacher d on a.TeacherId = d.ID
LEFT JOIN rb_member_user as b  on a.UserId=b.Id 
where a.state=0 ");
            if (where != null)
            {
                if (where.TenantId > 0)
                {
                    sb.AppendFormat(" and a.TenantId={0}", where.TenantId);
                }
                if (where.MallBaseId > 0)
                {
                    sb.AppendFormat(" and a.MallBaseId={0}", where.MallBaseId);
                }
                if (where.ID > 0)
                {
                    sb.AppendFormat(" and a.ID={0}", where.ID);
                }
                if (where.OrderStaus > 0)
                {
                    sb.AppendFormat(" and a.OrderStaus={0}", where.OrderStaus);
                }
                if (where.TeacherId > 0)
                {
                    sb.AppendFormat(" and a.TeacherId={0}", where.TeacherId);
                }
                if (where.CourseId > 0)
                {
                    sb.AppendFormat(" and a.CourseId={0}", where.CourseId);
                }
                if (where.UserId > 0)
                {
                    sb.AppendFormat(" and a.UserId={0}", where.UserId);
                }
            }
            sb.AppendFormat(" order by a.ID desc");
            return Get<RB_Point_TeacherCourseOrder_Extend>(sb.ToString()).FirstOrDefault();
        }
    }
}
