﻿using Mall.Common.Pay.WeChatPat.Model;
using Mall.WeChat.Common;
using System.Collections.Generic;

namespace Mall.Common.Pay.WeChatPat
{
    /// <summary>
    /// 微信帮助类
    /// </summary>
    public class WeChatHelper
    {

        /// <summary>
        /// 根据Code获取openid失败
        /// </summary>
        /// <param name="sCode"></param>
        /// <returns></returns>
        public static UserInfoResult GetUserInfoByCode(string sCode)
        {
            var dic = GetOauth2AccessToken(sCode);
            if (dic.ContainsKey("openid"))
            {
                var result = HttpHelper.Get<UserInfoResult>(ApiList.GetUserInfo, new
                {
                    access_token = TokenHelper.GetAccessToken().access_token,
                    openid = dic["openid"],
                    lang = "zh_CN"
                });
                return result;
            }
            Plugin.LogHelper.Write(null, "GetUserInfoByCode");
            return null;
        }


        /// <summary>
        /// 根据Code获取用户授权信息
        /// </summary>
        /// <param name="sCode"></param>
        /// <returns></returns>
        public static Dictionary<string, string> GetOauth2AccessToken(string sCode)
        {
            var param2 = new
            {
                appid = "", //WeChatConfig.GetAppId(),
                secret = "",// WeChatConfig.GetSecret(),
                code = sCode,
                grant_type = "authorization_code"
            };
            var dic = HttpHelper.Get<Dictionary<string, string>>(ApiList.GetOauth2AccessTokenUrl, param2);
            return dic;
        }
    }
}
