﻿using Mall.Common.AOP;
using System;
using System.Collections.Generic;
using System.Text;
using Mall.Model.Entity.Product;
using Mall.Common.Enum.Goods;

namespace Mall.Model.Extend.Product
{
    /// <summary>
    /// 商品订单表扩展实体
    /// </summary>
    [Serializable]
    [DB(ConnectionName = "DefaultConnection")]
    public class RB_Goods_Order_Extend : RB_Goods_Order
    {
        /// <summary>
        /// 订单ids
        /// </summary>
        public string OrderIds { get; set; }
        /// <summary>
        /// 订单号s
        /// </summary>
        public string orderNos { get; set; }
        /// <summary>
        /// 是否来自购物车  1是  2否
        /// </summary>
        public int? IsFormShoppingCart { get; set; }
        /// <summary>
        /// 购物车ids
        /// </summary>
        public List<int> ShoppingCartIdList { get; set; }
        /// <summary>
        /// 收货地址id
        /// </summary>
        public int? ShoppingAddressId { get; set; }
        /// <summary>
        /// 商品id
        /// </summary>
        public int? GoodsId { get; set; }
        /// <summary>
        /// 商品订单数量
        /// </summary>
        public int? OrderNum { get; set; }
        /// <summary>
        /// 开始时间
        /// </summary>
        public string StartTime { get; set; }
        /// <summary>
        /// 结束时间
        /// </summary>
        public string EndTime { get; set; }
        /// <summary>
        /// 用户名称
        /// </summary>
        public string UserName { get; set; }
        /// <summary>
        /// 商品名称
        /// </summary>
        public string GoodsName { get; set; }

        /// <summary>
        /// 订单对应的总件数
        /// </summary>
        public int GoodsTotalNum { get; set; }

        /// <summary>
        /// 货号
        /// </summary>
        public string ProductCode { get; set; }
        /// <summary>
        /// 订单类型
        /// </summary>
        public int? OrderType { get; set; }
        /// <summary>
        /// 多个状态查询
        /// </summary>
        public string OrderStatusIds { get; set; }
        /// <summary>
        /// 明细列表
        /// </summary>
        public List<RB_Goods_OrderDetail_Extend> DetailList { get; set; }
        /// <summary>
        /// 订单返佣列表
        /// </summary>
        public List<RB_Goods_OrderCommission_Extend> OrderCommissionList { get; set; }
        /// <summary>
        /// 是否发放佣金   1是  2否
        /// </summary>
        public int? IsOrderCommission { get; set; }
        /// <summary>
        /// 导出选项
        /// </summary>
        public List<int> ExcelEnumIds { get; set; }
        /// <summary>
        /// 区域地址
        /// </summary>
        public string DistrictAddress { get; set; }
        /// <summary>
        /// 收货地址id
        /// </summary>
        public int? AddressId { get; set; }
        /// <summary>
        /// 使用积分
        /// </summary>
        public int? Use_Integral { get; set; }
        /// <summary>
        /// 使用优惠卷id
        /// </summary>
        public int? User_Coupon_Id { get; set; }


        /// <summary>
        /// 支付方式
        /// </summary>
        public OrderPayTypeEnum? OrderPayType { get; set; }

        /// <summary>
        /// 唯一识别码
        /// </summary>        
        public string OpenId
        {
            get;
            set;
        }

        #region 订单导入

        /// <summary>
        /// 平台名称
        /// </summary>
        public string PlatformNameImport { get; set; }
        /// <summary>
        /// 规格导入
        /// </summary>
        public string SpecificationImport { get; set; }
        /// <summary>
        /// 成本价
        /// </summary>
        public decimal CostMoneyImport { get; set; } 
        /// <summary>
        /// 支付方式
        /// </summary>
        public string PaymentWayImport { get; set; }
        /// <summary>
        /// 订单状态
        /// </summary>
        public string OrderStatusImport { get; set; }
        /// <summary>
        /// 付款状态
        /// </summary>
        public string PaymentStatusImport { get; set; }
        /// <summary>
        /// 售价
        /// </summary>
        public decimal SellMoneyImport { get; set; }
        /// <summary>
        /// 原价
        /// </summary>
        public decimal OriginalMoneyImport { get; set; }
        /// <summary>
        /// 省
        /// </summary>
        public string PName { get; set; }
        /// <summary>
        /// 市
        /// </summary>
        public string CName { get; set; }
        /// <summary>
        /// 区
        /// </summary>
        public string DName { get; set; }

        #endregion
>>>>>>> 61e2df8d6e7f6e7b0ef4482885c6e6b79d1870e7
    }

    /// <summary>
    /// 订单优惠金额
    /// </summary>
    public class RB_Goods_CouponModel
    {
        /// <summary>
        /// 商品id
        /// </summary>
        public int GoodsId { get; set; }
        /// <summary>
        /// key
        /// </summary>
        public string Key { get; set; }
        /// <summary>
        /// 商品总价格(包含减积分)
        /// </summary>
        public decimal TotalMoney { get; set; }
        /// <summary>
        /// 优惠券金额
        /// </summary>
        public decimal CouponMoney { get; set; }

    }
}
