﻿using Mall.Model.Entity.MarketingCenter;
using Mall.Model.Extend.MarketingCenter;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mall.Repository.MarketingCenter
{
    /// <summary>
    /// 小程序模板仓储层
    /// </summary>
    public class RB_Miniprogram_TemplateRepository : RepositoryBase<RB_Miniprogram_Template>
    {
        /// <summary>
        /// 小程序模板分页列表
        /// </summary>
        /// <param name="pageIndex">页码</param>
        /// <param name="pageSize">每页显示条数</param>
        /// <param name="rowCount">总条数</param>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Miniprogram_Template_Extend> GetMiniprogramTemplatePageListRepository(int pageIndex, int pageSize, out long rowCount, RB_Miniprogram_Template_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM RB_Miniprogram_Template WHERE Status=0 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Miniprogram_Template_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Miniprogram_Template_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.TemplateName != null && !string.IsNullOrWhiteSpace(query.TemplateName))
                {
                    builder.Append($" AND {nameof(RB_Miniprogram_Template_Extend.TemplateName)} like '%{query.TemplateName.Trim()}%'");
                }
            }
            return GetPage<RB_Miniprogram_Template_Extend>(pageIndex, pageSize, out rowCount, builder.ToString()).ToList();
        }


        /// <summary>
        /// 小程序模板列表
        /// </summary>
        /// <param name="query">查询条件</param>
        /// <returns></returns>
        public List<RB_Miniprogram_Template_Extend> GetMiniprogramTemplateListRepository(RB_Miniprogram_Template_Extend query)
        {
            StringBuilder builder = new StringBuilder();
            builder.Append($" SELECT * FROM RB_Miniprogram_Template WHERE Status=0 ");
            if (query != null)
            {
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Miniprogram_Template_Extend.TenantId)}={query.TenantId}");
                }
                if (query.TenantId > 0)
                {
                    builder.Append($" AND {nameof(RB_Miniprogram_Template_Extend.MallBaseId)}={query.MallBaseId}");
                }
                if (query.TemplateName != null && !string.IsNullOrWhiteSpace(query.TemplateName))
                {
                    builder.Append($" AND {nameof(RB_Miniprogram_Template_Extend.TemplateName)} like '%{query.TemplateName.Trim()}%'");
                }
                if (query.QIds != null && !string.IsNullOrEmpty(query.QIds.Trim()))
                {
                    builder.AppendFormat(" AND {0} IN({1}) ",nameof(RB_Miniprogram_Template_Extend.Id), query.QIds);
                }
            }
            return Get<RB_Miniprogram_Template_Extend>(builder.ToString()).ToList();
        }
    }
}
